/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExternalTxtDataWriter
implements IExternalDataWriter {
    private static Logger logger = Logger.getLogger(ExternalTxtDataWriter.class);
    private String _fileName = null;
    private OutputStreamWriter fw = null;
    private BufferedWriter bw = null;
    private String delimeter = ",";
    private ExternalStructInfo structInfo = null;
    private List<FieldPropertyInfo> fieldsArray = null;
    private Locale locale = null;
    private boolean isExportTemplate = false;
    private List<SimpleDateFormat> longDateParses = new ArrayList<SimpleDateFormat>();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ExternalTxtDataWriter() {
        String[] longDateFormats;
        for (String format : longDateFormats = new String[]{"yyyy-MM-dd HH:mm:ss.S", "yyyy/MM/dd HH:mm:ss.S", "MM/dd/yyyy HH:mm:ss.S"}) {
            this.longDateParses.add(new SimpleDateFormat(format));
        }
    }

    @Override
    public void writeStruct(ExternalStructInfo structInfo) {
        this.structInfo = structInfo;
        StringBuffer sb = new StringBuffer();
        sb.append(structInfo.getProductName()).append(this.delimeter).append(structInfo.getVersion());
        this.writeOneLine(sb.toString());
        sb.setLength(0);
        sb.append(structInfo.getObjectName()).append(this.delimeter).append(structInfo.getObjectDesc());
        this.writeOneLine(sb.toString());
        sb.setLength(0);
        ArrayList<FieldPropertyInfo> fields = structInfo.getFieldCollection();
        this.orderByColNumber(fields);
        this.fieldsArray = fields;
        int size = fields.size();
        StringBuffer sb1 = new StringBuffer();
        String fieldDesc = "";
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo fpi = (FieldPropertyInfo)fields.get(i);
            sb.append(fpi.getFieldName());
            fieldDesc = fpi.getFieldDesc();
            logger.info((Object)("field description:" + fieldDesc));
            if (fpi.getIsNecessary()) {
                fieldDesc = "*" + fieldDesc;
            }
            sb1.append(fieldDesc);
            if (i == size - 1) continue;
            sb.append(this.delimeter);
            sb1.append(this.delimeter);
        }
        this.writeOneLine(sb.toString());
        this.writeOneLine(sb1.toString());
        if (structInfo.getComment() != null && !structInfo.getComment().equals("")) {
            this.writeOneLine("/*****");
            this.writeOneLine(structInfo.getComment());
            this.writeOneLine("//*****");
        }
    }

    private void orderByColNumber(List<FieldPropertyInfo> fields) {
        if (fields == null || fields.size() <= 1) {
            return;
        }
        int size = fields.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                FieldPropertyInfo fpii = fields.get(i);
                FieldPropertyInfo fpij = fields.get(j);
                if (fpii.getFieldColNumber() <= fpij.getFieldColNumber()) continue;
                fields.set(i, fpij);
                fields.set(j, fpii);
            }
        }
    }

    private void writeOneLine(String str) {
        try {
            this.bw.write(str);
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeLine(Map data) {
        if (data == null || data.size() <= 0) {
            this.writeOneLine("");
            return;
        }
        int size = this.fieldsArray.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            FieldPropertyInfo fpi = this.fieldsArray.get(i);
            String fieldName = fpi.getFieldName();
            if (data.containsKey(fieldName)) {
                Object o = data.get(fieldName);
                String oneValue = this.toString(o);
                if (oneValue.startsWith("=") || oneValue.startsWith("@") || oneValue.startsWith("+") || oneValue.startsWith("-")) {
                    oneValue = "'" + oneValue;
                }
                sb.append(this.convertDelimeter(oneValue)).append(this.delimeter);
                continue;
            }
            sb.append(this.convertDelimeter("")).append(this.delimeter);
        }
        this.writeOneLine(sb.toString());
    }

    private String toString(Object o) {
        if (o instanceof Date) {
            return this.formatDate((Date)o);
        }
        if (o instanceof Calendar) {
            return this.formatDate((Calendar)o);
        }
        Date date = this.tryParseLongDate(o.toString());
        if (date != null) {
            return this.dateFormat.format(date);
        }
        return o.toString();
    }

    private String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    private String formatDate(Calendar calendar) {
        return this.formatDate(calendar.getTime());
    }

    private Date tryParseLongDate(String str) {
        for (SimpleDateFormat simpleDateFormat : this.longDateParses) {
            try {
                Date date = simpleDateFormat.parse(str);
                if (date == null) continue;
                return date;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private String convertDelimeter(String value) {
        if (value == null) {
            return "";
        }
        int dD = value.indexOf(",");
        if (dD == -1) {
            return value;
        }
        if (dD != -1) {
            value = "\"" + value + "\"";
            return value;
        }
        return value;
    }

    public boolean isExportTemplate() {
        return this.isExportTemplate;
    }

    public void setExportTemplate(boolean isExportTemplate) {
        this.isExportTemplate = isExportTemplate;
    }

    @Override
    public void setFileName(String fileName) {
        this._fileName = this.isExportTemplate ? fileName : GlobalFunction.getFilePathForServer() + File.separator + fileName;
    }

    @Override
    public String getFileName() {
        return this._fileName;
    }

    @Override
    public void openWriter() throws TaskRunnerException {
        File f = new File(this._fileName);
        FileOutputStream fop = null;
        try {
            if (f.exists()) {
                f.delete();
            }
            fop = new FileOutputStream(f);
            this.fw = new OutputStreamWriter((OutputStream)fop, this.getCharsetName());
            this.bw = new BufferedWriter(this.fw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getCharsetName() {
        return "gbk";
    }

    @Override
    public void closeWriter() throws TaskRunnerException {
        if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fw = null;
        }
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bw = null;
        }
    }

    @Override
    public void setLocacle(Locale l) {
        this.locale = l;
    }

    @Override
    public Locale getLocacle() {
        return this.locale;
    }
}

