/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.log;

import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class TaskLog
implements ILog,
Serializable {
    private static final long serialVersionUID = -1729503341054034425L;
    private String uuid;
    private ArrayList errorSubject = new ArrayList();
    private ArrayList errorDetail = new ArrayList();
    private ArrayList errorRowNum = new ArrayList();
    private ArrayList blockBeginRowNum = new ArrayList();
    private int rowNumOfRecordStart;
    private int recordCount;
    private int successRecordCount;
    private int failRecordCount;
    private boolean isSuccess = true;
    private TaskStateEnum taskState = TaskStateEnum.SUCCESSEND;
    private boolean supportEntryErrorReason;
    private ArrayList exceptionList = new ArrayList();
    public static final String IMPORTLOG = "importlog";
    public static final String EXPORTLOG = "exportlog";
    private String logType = "importlog";

    public TaskLog(int recordCount) {
        this.recordCount = recordCount;
    }

    public TaskLog() {
    }

    @Override
    public String getLogUuID() {
        return this.uuid;
    }

    public void setLogUuID(String uuid) {
        this.uuid = uuid;
    }

    public int getRowNumOfRecordStart() {
        return this.rowNumOfRecordStart;
    }

    public void setRowNumOfRecordStart(int rowNumOfRecordStart) {
        this.rowNumOfRecordStart = rowNumOfRecordStart;
    }

    public void setSuccessRecordCount(int successRecordCount) {
        this.successRecordCount = successRecordCount;
    }

    public int getSuccessRecordCount() {
        return this.successRecordCount;
    }

    public void setFailRecordCount(int failRecordCount) {
        this.failRecordCount = failRecordCount;
    }

    public int getFailRecordCount() {
        return this.failRecordCount;
    }

    public void setTaskState(TaskStateEnum state) {
        this.taskState = state;
    }

    public TaskStateEnum getTaskState() {
        return this.taskState;
    }

    public boolean isSupportEntryErrorReason() {
        return this.supportEntryErrorReason;
    }

    public void setSupportEntryErrorReason(boolean supportEntryErrorReason) {
        this.supportEntryErrorReason = supportEntryErrorReason;
    }

    public void addException(String subject, Throwable e, Integer rowNum) {
        this.exceptionList.add(e);
        this.errorSubject.add(subject);
        if (rowNum != null) {
            this.errorRowNum.add(rowNum);
        }
        String errDetail = subject;
        if (e.getMessage() != null) {
            errDetail = e instanceof TaskRunnerException ? this.getErrorDetail(((TaskRunnerException)((Object)e)).getOriginalMessage()) : this.getErrorDetail(e.getMessage());
        } else {
            errDetail = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"87_TaskLog");
            errDetail = errDetail + TaskLog.getStackMsg(e);
        }
        this.errorDetail.add(errDetail);
    }

    public void addExceptionForBatch(String subject, Throwable e, Integer rowNum, Integer beginRowNum) {
        this.exceptionList.add(e);
        this.errorSubject.add(subject);
        if (rowNum != null) {
            this.errorRowNum.add(rowNum);
        }
        String errDetail = subject;
        if (!StringUtils.isEmpty((String)e.getMessage())) {
            errDetail = e instanceof TaskRunnerException ? this.getErrorDetail(((TaskRunnerException)((Object)e)).getOriginalMessage()) : this.getErrorDetail(e.getMessage());
        } else {
            errDetail = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"87_TaskLog");
            errDetail = errDetail + TaskLog.getStackMsg(e);
        }
        this.errorDetail.add(errDetail);
        this.blockBeginRowNum.add(beginRowNum);
    }

    public void addExceptionForBlock(String subject, Throwable e, Integer startRowNum, Integer endRowNum) {
        MessageFormat mf = new MessageFormat(subject);
        for (int i = startRowNum.intValue(); i <= endRowNum; ++i) {
            this.exceptionList.add(e);
            this.errorSubject.add(subject);
            this.errorRowNum.add(i);
            String errDetail = subject;
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errDetail = e instanceof TaskRunnerException ? this.getErrorDetail(((TaskRunnerException)((Object)e)).getOriginalMessage()) : this.getErrorDetail(e.getMessage());
            } else {
                errDetail = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"87_TaskLog");
                errDetail = errDetail + TaskLog.getStackMsg(e);
            }
            if (i == startRowNum) {
                this.errorDetail.add(errDetail);
                continue;
            }
            this.errorDetail.add("");
        }
    }

    private String getErrorDetail(String message) {
        return message.replaceAll(this.getReplacedStr(), "").replaceAll("Client -- String Serialize", "").replace('[', ' ').replace(']', ' ');
    }

    public void addTaskLog(TaskLog log) {
        this.setSuccessRecordCount(this.getSuccessRecordCount() + log.getSuccessRecordCount());
        this.setFailRecordCount(this.getFailRecordCount() + log.getFailRecordCount());
        if (this.getTaskState().equals((Object)TaskStateEnum.FAILEND) || log.getTaskState().equals((Object)TaskStateEnum.FAILEND)) {
            this.setTaskState(TaskStateEnum.FAILEND);
        } else if (this.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND) && log.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
            this.setTaskState(TaskStateEnum.SUCCESSEND);
        }
        int size = log.getErrorDetailCount();
        for (int i = 0; i < size; ++i) {
            this.addException(log.getErrorSubject(i), log.getThrowable(i), log.getErrorRowNum(i));
        }
    }

    public String getException(int i) {
        return ((Throwable)this.exceptionList.get(i)).getMessage();
    }

    public Throwable getThrowable(int i) {
        return (Throwable)this.exceptionList.get(i);
    }

    public String getExceptionStack(int i) {
        Throwable t = (Throwable)this.exceptionList.get(i);
        if (t instanceof BaseException) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                MyPrintStream ps = new MyPrintStream(os);
                t.printStackTrace(ps);
                return ps.toString();
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        return ExceptionUtil.getExcLinkStackTrace((Throwable)t);
    }

    public String getErrorSubject(int i) {
        return (String)this.errorSubject.get(i);
    }

    public void setErrorSubject(int i, String subject) {
        this.errorSubject.set(i, subject);
    }

    public int getErrorRowNum(int i) {
        if (this.errorRowNum.size() > i) {
            return (Integer)this.errorRowNum.get(i);
        }
        return 0;
    }

    public void setErrorRowNum(int i, int rowNum) {
        this.errorRowNum.set(i, rowNum);
    }

    public String getErrorDetail(int i) {
        return (String)this.errorDetail.get(i);
    }

    public int getErrorDetailCount() {
        return this.errorDetail.size();
    }

    public int getBlockBeginorRowNum(int i) {
        return (Integer)this.blockBeginRowNum.get(i);
    }

    public void setBlockBeginRowNum(int i, int rowNum) {
        this.blockBeginRowNum.set(i, rowNum);
    }

    public boolean isBatchLog() {
        return this.blockBeginRowNum.size() != 0;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    @Override
    public String getLogType() {
        return this.logType;
    }

    private String getReplacedStr() {
        return "Caused exception message is: ";
    }

    private static String getStackMsg(Throwable e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length && i <= 5; ++i) {
            sb.append(stackArray[i].toString() + "\n");
        }
        return sb.toString();
    }

    @Override
    public String getFileUuID() {
        return null;
    }

    private static class MyPrintStream
    extends PrintStream {
        private ByteArrayOutputStream os = null;

        public MyPrintStream(ByteArrayOutputStream os) throws UnsupportedEncodingException {
            super((OutputStream)os, false, "UTF8");
            os.reset();
            this.os = os;
        }

        private MyPrintStream() {
            super((OutputStream)null);
        }

        public String toString() {
            try {
                return this.os.toString("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    }
}

