/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.task.FileUtil;
import com.kingdee.eas.tools.datatask.task.ReaderUtil;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BlockDataReader {
    private AbstractExternalDataReader reader = null;
    private InputStream file = null;
    private TaskExternalCode taskCode = null;
    private static Logger logger = SysLog.getLogger(BlockDataReader.class);
    private int nCurCount = 0;
    private BlockDataTransmission blockTrans;
    IRecord lastRec = null;
    int blockSize = 50;

    public BlockDataReader(TaskExternalCode taskCode, Locale l) throws Exception {
        this.buildReader(taskCode, l);
    }

    public BlockDataReader(TaskExternalCode task, BlockDataTransmission trans, Locale l) throws Exception {
        this.blockTrans = trans;
        this.buildReader(task, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReader(TaskExternalCode taskCode, Locale l) throws Exception {
        try (InputStream file = null;){
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            String fileType = dp.getFileType();
            file = FileUtil.getServerTmpFileStream(dp.getOpenFileName());
            this.reader = ReaderUtil.buildReader(fileType, dp.getOpenFileName(), l, dp.alias, file, taskCode.getExternalStructInfo());
            this.setBlockSize(taskCode.getDIETemplateInfo().getCountEachTime() <= 0 ? 1 : (int)taskCode.getDIETemplateInfo().getCountEachTime());
            this.taskCode = taskCode;
        }
    }

    public boolean hasNextBlock() throws TaskRunnerException {
        return this.reader.hasNextRecord();
    }

    public RecordCollection getNextBlock() throws TaskRunnerException {
        RecordCollection coll = new RecordCollection();
        int count = 0;
        boolean isFinishSameBlock = true;
        while (count < this.getBlockSize() || isFinishSameBlock) {
            if (count == 0 && this.lastRec != null && !this.lastRec.getMap().isEmpty()) {
                coll.add(this.lastRec);
            }
            IRecord rec = null;
            if (this.lastRec == null) {
                rec = this.reader.getNextRecord();
                this.nCurCount = rec.getRowNum();
                ++count;
                this.lastRec = rec;
            } else {
                if (!this.reader.hasNextRecord()) break;
                rec = this.reader.getNextRecord();
                ++count;
                if (rec != null) {
                    this.nCurCount = rec.getRowNum();
                    boolean isSameBlock = this.blockTrans.isSameBlock(this.lastRec.getMap(), rec.getMap());
                    isFinishSameBlock = isSameBlock;
                    this.lastRec = rec;
                }
            }
            if (rec == null || rec.getMap().isEmpty() || count >= this.getBlockSize() && (count < this.getBlockSize() || !isFinishSameBlock)) continue;
            coll.add(rec);
        }
        return coll;
    }

    private Hashtable map2Hashtable(Map map) {
        Hashtable hashtable = new Hashtable();
        if (map == null) {
            return hashtable;
        }
        hashtable.putAll(map);
        return hashtable;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            this.file = null;
        }
        DatataskParameter dp = (DatataskParameter)this.taskCode.getTaskParameter();
        FileUtil.removeFile(dp.getOpenFileName());
    }

    public int getnCurCount() {
        return this.nCurCount;
    }

    public AbstractExternalDataReader getDataReader() {
        return this.reader;
    }
}

