/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class ExcelXUtil {
    public static boolean isBlankRow(XSSFCell[] cells) {
        if (cells == null || cells.length <= 0) {
            return true;
        }
        for (int i = 0; i < cells.length; ++i) {
            if (StringUtils.isEmpty((String)ExcelXUtil.getCellValue(cells[i]))) continue;
            return false;
        }
        return true;
    }

    public static String getCellValue(XSSFCell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                if (XSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date cal = XSSFDateUtil.getJavaDate((double)d);
                    return ExcelXUtil.getStringByDate(cal);
                }
                BigDecimal bd = new BigDecimal(new Double(d).toString());
                String s = bd.toString();
                if (s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                return s;
            }
            case FORMULA: {
                String valueStr = null;
                valueStr = cell.getStringCellValue();
                if (valueStr != null && valueStr.trim().length() > 0) {
                    return valueStr.trim();
                }
                double value = cell.getNumericCellValue();
                BigDecimal bd = new BigDecimal(new Double(value).toString());
                valueStr = bd.toString();
                if (valueStr.endsWith(".0")) {
                    valueStr = valueStr.substring(0, valueStr.length() - 2);
                }
                return valueStr;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
        }
        return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
    }

    private static String getStringByDate(Date d) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        String fix = "-";
        StringBuffer dateStr = new StringBuffer();
        dateStr.append(cl.get(1));
        dateStr.append(fix);
        int month = cl.get(2) + 1;
        if (month < 10) {
            dateStr.append("0");
        }
        dateStr.append(month);
        dateStr.append(fix);
        int day = cl.get(5);
        if (day < 10) {
            dateStr.append("0");
        }
        dateStr.append(day);
        return dateStr.toString();
    }

    public static class XSSFDateUtil
    extends DateUtil {
        protected static int absoluteDay(Calendar cal, boolean use1904windowing) {
            return DateUtil.absoluteDay((Calendar)cal, (boolean)use1904windowing);
        }
    }
}

