/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExternalStructInfo
implements Serializable {
    private Locale locale = null;
    private String _sheetName = "";
    private String _fileName = "";
    private String _fileType = "";
    private String _version = "";
    private Map<String, FieldPropertyInfo> _hashFields = new HashMap<String, FieldPropertyInfo>();
    private List<FieldPropertyInfo> _arrayFields = new ArrayList<FieldPropertyInfo>();
    private String _productName = "";
    private String _objectName = "";
    private String _objectDesc = "";
    private String _comment = "";

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    public void setSheetName(String sheetName) {
        this._sheetName = sheetName;
    }

    public String getFileType() {
        return this._fileType;
    }

    public String getProductName() {
        return this._productName;
    }

    public void setProductName(String productName) {
        this._productName = productName;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setObjectName(String objectName) {
        this._objectName = objectName;
    }

    public String getObjectName() {
        return this._objectName;
    }

    public void setObjectDesc(String objectDesc) {
        this._objectDesc = objectDesc;
    }

    public String getObjectDesc() {
        return this._objectDesc;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public String getComment() {
        return this._comment;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ArrayList<FieldPropertyInfo> getFieldCollection() {
        return (ArrayList)this._arrayFields;
    }

    public Map<String, FieldPropertyInfo> getFields() {
        return this._hashFields;
    }

    public void addField(FieldPropertyInfo field) {
        if (field == null || field.getFieldName() == null) {
            return;
        }
        this._hashFields.put(field.getFieldName().trim(), field);
        this._arrayFields.add(field);
    }

    public boolean isSelfStandard(ExternalStructInfo standardStructInfo) throws FileFormatNotStandardException {
        FieldPropertyInfo fpInfo;
        int i;
        int standardSize = standardStructInfo.getFieldCollection().size();
        int sourceFieldsize = this._arrayFields.size();
        Map<String, FieldPropertyInfo> fields = standardStructInfo.getFields();
        for (i = 0; i < sourceFieldsize; ++i) {
            fpInfo = this._arrayFields.get(i);
            if (fpInfo == null || fields == null || fields.containsKey(fpInfo.getFieldName().trim())) continue;
            String msg = EASResourceJoinUtil.getServerString("file_notExsit_field", new String[]{fpInfo.getFieldName()}, this.locale);
            throw new FileFormatNotStandardException(msg);
        }
        if (this._arrayFields == null || this._arrayFields.size() != standardSize) {
            for (i = 0; i < standardSize; ++i) {
                fpInfo = standardStructInfo.getFieldCollection().get(i);
                if (fpInfo == null || this._hashFields == null || this._hashFields.size() <= 0 || this._hashFields.containsKey(fpInfo.getFieldName().trim())) continue;
                String msg = EASResourceJoinUtil.getServerString("file_notExsit_field", new String[]{fpInfo.getFieldName()}, this.locale);
                throw new FileFormatNotStandardException(msg);
            }
        }
        return true;
    }

    public Element store() {
        Element elmSheetData = new Element("taskTemplateData");
        try {
            elmSheetData.setAttribute("sheetName", this._sheetName);
            elmSheetData.setAttribute("productName", this._productName);
            elmSheetData.setAttribute("productVersion", this._version);
            elmSheetData.setAttribute("fileName", this._fileName);
            elmSheetData.setAttribute("objectName", this._objectName);
            elmSheetData.setAttribute("objectDesc", this._objectDesc);
            Element elmMapExcelFields = new Element("mapFields");
            elmSheetData.addContent((Content)elmMapExcelFields);
            Iterator<FieldPropertyInfo> itExcelFields = this._hashFields.values().iterator();
            int size = this._hashFields.size();
            for (int i = 0; i < size; ++i) {
                FieldPropertyInfo eField = itExcelFields.next();
                elmMapExcelFields.addContent((Content)eField.store());
            }
        }
        catch (Exception err) {
            MsgBox.showWarning((String)err.getMessage());
        }
        return elmSheetData;
    }

    public void load(Element elmData) {
        this._hashFields = new HashMap<String, FieldPropertyInfo>();
        try {
            this._fileName = elmData.getAttribute("fileName").getValue();
            this._sheetName = elmData.getAttribute("sheetName").getValue();
            this._productName = elmData.getAttribute("productName").getValue();
            this._version = elmData.getAttribute("productVersion").getValue();
            if (elmData.getAttribute("objectName") != null) {
                this._objectName = elmData.getAttribute("objectName").getValue();
            }
            if (elmData.getAttribute("objectDesc") != null) {
                this._objectDesc = elmData.getAttribute("objectDesc").getValue();
            }
            List lsExcelFields = elmData.getChild("mapFields").getChildren("mapField");
            Iterator itExcelFields = lsExcelFields.iterator();
            int size = lsExcelFields.size();
            for (int i = 0; i < size; ++i) {
                Element elmExcelField = (Element)itExcelFields.next();
                FieldPropertyInfo eField = new FieldPropertyInfo();
                eField.load(elmExcelField);
                this._hashFields.put(eField.getFieldName(), eField);
                this._arrayFields.add(eField);
            }
        }
        catch (Exception err) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"Serializable_error"));
        }
    }

    public Object clone() {
        try {
            return ObjectUtils.createCopy((Object)this);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }
}

