/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataRowInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class ExternalTextDataReader
extends AbstractExternalDataReader {
    private CSVParser rf = null;
    private String delimiter = ",";
    private int curNumber = -1;
    private CSVRecord curLineStr = null;
    private int rowCount = -1;
    private boolean isReadFirstData = false;
    Iterator<CSVRecord> itRecord = null;

    @Override
    public void openFile(InputStream file) throws FileFormatNotStandardException, IOException {
        this.initExcelCSVParser(file);
        this.initParserFileStruct(true, file);
        this.reSetFileStartFromData(file);
    }

    @Override
    public void openFile(String fileName) throws FileFormatNotStandardException {
        File f = new File(fileName);
        this.openFile(f);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            this.reOpenFileStartFromData(fis);
        }
        catch (IOException e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "readFileError", this.locale));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void openFile(File file) throws FileFormatNotStandardException {
        FileInputStream fis = null;
        try {
            this.initExcelCSVParser(file);
            this.initParserFileStruct(false, null);
            fis = new FileInputStream(file);
            this.reOpenFileStartFromData(fis);
        }
        catch (FileNotFoundException e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fileNotFound", this.locale));
        }
        catch (IOException e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "readFileError", this.locale));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExcelCSVParser(File file) throws FileNotFoundException, IOException {
        FileInputStream fs = null;
        InputStreamReader fr = null;
        try {
            fs = new FileInputStream(file);
            fr = new InputStreamReader((InputStream)fs, this.getCharsetName());
            this.rf = CSVFormat.EXCEL.parse((Reader)fr);
            this.itRecord = this.rf.iterator();
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void initExcelCSVParser(InputStream file) throws IOException {
        InputStreamReader fr = null;
        try {
            fr = new InputStreamReader(file, this.getCharsetName());
        }
        catch (UnsupportedEncodingException e) {
            fr = new InputStreamReader(file);
        }
        this.rf = CSVFormat.EXCEL.parse((Reader)fr);
        this.itRecord = this.rf.iterator();
    }

    private void initParserFileStruct(boolean isStream, InputStream file) throws FileFormatNotStandardException {
        block16: {
            try {
                int row = -1;
                String[] tmp = null;
                if (isStream) {
                    file.mark(0);
                }
                if (!this.hasNextSkipBlankLine()) {
                    throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templateError", this.locale));
                }
                tmp = this.getNextLine();
                this.getProductAndVersion(tmp);
                this.rowInfo.setRowOfVersion(this.curNumber);
                if (this.info.getProductName() == null || this.info.getVersion() == null) {
                    throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templateError", this.locale));
                }
                if (this.hasNextSkipBlankLine()) {
                    tmp = this.getNextLine();
                    this.getObject(tmp);
                    this.rowInfo.setRowOfObject(this.curNumber);
                }
                if (this.info.getObjectName() == null || this.info.getObjectDesc() == null) {
                    // empty if block
                }
                if (!this.hasNextSkipBlankLine()) {
                    throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fieldError", this.locale));
                }
                tmp = this.getNextLine();
                this.getFieldName(tmp);
                this.rowInfo.setRowOfFieldName(this.curNumber);
                if (this.info.getFieldCollection().size() <= 0) {
                    throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fieldError", this.locale));
                }
                if (!this.hasNextSkipBlankLine()) {
                    throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fieldDescriptionError", this.locale));
                }
                tmp = this.getNextLine();
                this.getFieldDesc(tmp);
                this.rowInfo.setRowOfFieldDesc(this.curNumber);
                if (this.hasNextSkipBlankLine()) {
                    tmp = this.getNextLine();
                    this.getRowOfCommentStart(tmp);
                }
                if (this.rowInfo.getRowOfCommentStart() <= 0) break block16;
                this.hasNextSkipBlankLine();
                tmp = this.getNextLine();
                while (this.rowInfo.getRowOfCommentEnd() == -1) {
                    if (tmp == null) {
                        this.rowInfo.setRowOfCommentEnd(-1);
                        break;
                    }
                    this.getRowOfCommentEnd(tmp);
                    if (this.rowInfo.getRowOfCommentEnd() != -1) continue;
                    this.hasNextSkipBlankLine();
                    tmp = this.getNextLine();
                }
            }
            catch (TaskRunnerException e) {
                e.printStackTrace();
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "readFileContentError", this.locale));
            }
        }
        if (this.rowInfo.getRowOfCommentStart() > this.rowInfo.getRowOfCommentEnd()) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "commentError", this.locale));
        }
        if (this.rowInfo.getRowOfCommentEnd() == -1) {
            this.rowInfo.setRowOfDataStart(this.rowInfo.getRowOfFieldDesc() + 1);
        } else {
            this.rowInfo.setRowOfDataStart(this.rowInfo.getRowOfCommentEnd() + 1);
        }
        this.info.setSheetName("");
    }

    private void reSetFileStartFromData(InputStream file) throws FileFormatNotStandardException {
        this.isReadFirstData = true;
    }

    protected String getCharsetName() {
        return "gbk";
    }

    private void reOpenFileStartFromData(InputStream file) throws FileFormatNotStandardException, IOException {
        if (this.rf != null) {
            try {
                this.rf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rf = null;
        }
        InputStreamReader fr = null;
        try {
            fr = new InputStreamReader(file, this.getCharsetName());
        }
        catch (UnsupportedEncodingException e1) {
            fr = new InputStreamReader(file);
            e1.printStackTrace();
        }
        this.rf = CSVFormat.EXCEL.parse((Reader)fr);
        this.curLineStr = null;
        this.curNumber = -1;
        int dataStartNumber = this.rowInfo.getRowOfDataStart();
        try {
            while (this.curNumber < dataStartNumber - 1) {
                this.hasNextSkipBlankLine();
            }
        }
        catch (TaskRunnerException e) {
            throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "readFileError", this.locale));
        }
    }

    private void getProductAndVersion(String[] aline) {
        if (aline != null && aline.length > 0) {
            int i;
            if (!this.isNull(this.info.getProductName()) && !this.isNull(this.info.getVersion())) {
                return;
            }
            int pnPosition = -1;
            if (this.isNull(this.info.getProductName())) {
                for (i = 0; i < aline.length; ++i) {
                    if (this.isNull(aline[i])) continue;
                    this.info.setProductName(aline[i]);
                    pnPosition = i;
                    break;
                }
            }
            if (this.isNull(this.info.getVersion())) {
                for (i = pnPosition + 1; i < aline.length; ++i) {
                    if (this.isNull(aline[i])) continue;
                    this.info.setVersion(aline[i]);
                    break;
                }
            }
        }
    }

    private void getObject(String[] aline) {
        if (aline != null && aline.length > 0) {
            int i;
            if (!this.isNull(this.info.getObjectName()) && !this.isNull(this.info.getObjectDesc())) {
                return;
            }
            int pnPosition = -1;
            if (this.isNull(this.info.getObjectName())) {
                for (i = 0; i < aline.length; ++i) {
                    if (this.isNull(aline[i])) continue;
                    this.info.setObjectName(aline[i]);
                    pnPosition = i;
                    break;
                }
            }
            if (this.isNull(this.info.getObjectDesc())) {
                for (i = pnPosition + 1; i < aline.length; ++i) {
                    if (this.isNull(aline[i])) continue;
                    this.info.setObjectDesc(aline[i]);
                    break;
                }
            }
        }
    }

    private void getFieldName(String[] aline) throws FileFormatNotStandardException {
        for (int i = 0; i < aline.length; ++i) {
            String tmp = aline[i];
            if (tmp == null || tmp.equals("")) {
                boolean isFinished = true;
                for (int j = i + 1; j < aline.length; ++j) {
                    tmp = aline[j];
                    if (tmp == null || tmp.length() <= 0) continue;
                    isFinished = false;
                    break;
                }
                if (isFinished) {
                    return;
                }
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "emptyField", this.locale));
            }
            FieldPropertyInfo fi = new FieldPropertyInfo();
            String tmpName = null;
            if (tmp.startsWith("*")) {
                tmpName = tmp.substring(1);
                fi.setFieldName(tmpName);
                fi.setIsNecessary(true);
            } else {
                tmpName = tmp;
                fi.setFieldName(tmpName);
                fi.setIsNecessary(false);
            }
            fi.setFieldColNumber(i);
            if (this.info.getFields() != null && this.info.getFields().containsKey(tmpName)) {
                throw new FileFormatNotStandardException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "field", this.locale) + tmp + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "definitionRepeat", this.locale));
            }
            this.info.addField(fi);
        }
    }

    private void getFieldDesc(String[] aline) {
        for (int i = 0; i < aline.length; ++i) {
            String tmp = aline[i];
            FieldPropertyInfo fi = this.getFieldByCol(i);
            if (fi == null) continue;
            if (tmp.indexOf("*") == 0) {
                fi.setFieldDesc(tmp.substring(1));
                fi.setIsNecessary(true);
                continue;
            }
            fi.setFieldDesc(tmp);
            fi.setIsNecessary(false);
        }
    }

    private FieldPropertyInfo getFieldByCol(int col) {
        ArrayList<FieldPropertyInfo> fields = this.info.getFieldCollection();
        if (fields != null && fields.size() > 0) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                FieldPropertyInfo info = (FieldPropertyInfo)fields.get(i);
                if (info.getFieldColNumber() != col) continue;
                return info;
            }
        }
        return null;
    }

    private void getRowOfCommentStart(String[] aline) {
        for (int i = 0; i < aline.length; ++i) {
            String tmp = aline[i];
            if (tmp != null && tmp.equals("/*****")) {
                this.rowInfo.setRowOfCommentStart(this.curNumber);
                break;
            }
            this.rowInfo.setRowOfCommentStart(-1);
        }
    }

    private void getRowOfCommentEnd(String[] aline) throws TaskRunnerException {
        for (int i = 0; i < aline.length; ++i) {
            String tmp = aline[i];
            if (tmp != null && tmp.equals("//*****")) {
                this.rowInfo.setRowOfCommentEnd(this.curNumber);
                this.rowInfo.setRowOfDataStart(this.curNumber + 1);
                this.hasNextSkipBlankLine();
                break;
            }
            this.rowInfo.setRowOfCommentEnd(-1);
        }
    }

    private boolean isNull(String str) {
        return str == null || str.equals("");
    }

    private String[] getNextLine() {
        return this.curLineStr.toList().toArray(new String[this.curLineStr.size()]);
    }

    @Override
    public ExternalStructInfo getExternalStructInfo() {
        return this.info;
    }

    @Override
    public ExternalDataRowInfo getExternalDataRowInfo() {
        return this.rowInfo;
    }

    @Override
    public boolean hasNext() throws TaskRunnerException {
        if (this.rf != null) {
            if (this.isReadFirstData) {
                this.isReadFirstData = false;
                return this.curLineStr != null;
            }
            if (this.itRecord.hasNext()) {
                this.curLineStr = this.itRecord.next();
                ++this.curNumber;
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasNextSkipBlankLine() throws TaskRunnerException {
        if (this.rf != null) {
            if (this.itRecord.hasNext()) {
                this.curLineStr = this.itRecord.next();
                ++this.curNumber;
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isNull(String[] aline) {
        if (aline == null) {
            return true;
        }
        int length = aline.length;
        int blankCount = 0;
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.isEmpty((String)aline[i])) continue;
            ++blankCount;
        }
        return blankCount == length;
    }

    @Override
    public Map getNext() throws TaskRunnerException {
        String[] lineStr = this.getNextLine();
        if (lineStr == null) {
            return null;
        }
        HashMap<String, DataToken> result = new HashMap<String, DataToken>();
        if (this.isNull(lineStr)) {
            return result;
        }
        int length = lineStr.length;
        String contents = null;
        for (int i = 0; i < length; ++i) {
            contents = lineStr[i].trim();
            FieldPropertyInfo fpi = this.getFieldNameByColNumber(i);
            if (fpi == null) continue;
            String fieldName = fpi.getFieldName();
            if (fpi.getIsNecessary() && (contents == null || contents.equals(""))) {
                throw new TaskRunnerException(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "line", this.locale) + (this.curNumber + 1) + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "among", this.locale) + fieldName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "noValue", this.locale));
            }
            DataToken value = new DataToken();
            value.name = fieldName;
            value.desc = fpi.getFieldDesc();
            value.data = contents;
            value.type = "Label";
            result.put(fieldName, value);
        }
        ArrayList<FieldPropertyInfo> fields = this.info.getFieldCollection();
        if (result.size() != fields.size()) {
            int standardFieldsSize = fields.size();
            for (int k = 0; k < standardFieldsSize; ++k) {
                FieldPropertyInfo fpiTmp = (FieldPropertyInfo)fields.get(k);
                if (fpiTmp == null || result.containsKey(fpiTmp.getFieldName())) continue;
                DataToken value = new DataToken();
                value.name = fpiTmp.getFieldName();
                value.data = "";
                value.type = "Label";
                result.put(fpiTmp.getFieldName(), value);
            }
        }
        return result;
    }

    private FieldPropertyInfo getFieldNameByColNumber(int col) {
        ArrayList<FieldPropertyInfo> fields = this.info.getFieldCollection();
        if (fields == null || fields.size() <= 0) {
            return null;
        }
        int size = fields.size();
        FieldPropertyInfo fpiTmp = null;
        for (int i = 0; i < size; ++i) {
            fpiTmp = (FieldPropertyInfo)fields.get(i);
            if (fpiTmp == null || fpiTmp.getFieldColNumber() != col) continue;
            return fpiTmp;
        }
        return null;
    }

    @Override
    public int getCurrentRow() {
        return this.curNumber;
    }

    @Override
    public int getRowOfCurrentData() {
        return 0;
    }

    @Override
    public void close() {
        if (this.rf != null) {
            try {
                this.rf.close();
                this.rf = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasNextRecord() throws TaskRunnerException {
        return this.hasNext();
    }

    @Override
    public IRecord getNextRecord() throws TaskRunnerException {
        Map data = this.getNext();
        return this.convertToRecord(data);
    }

    private IRecord convertToRecord(Map data) {
        SimpleRecord rec = new SimpleRecord();
        rec.setRowNum(this.curNumber);
        Set keys = data.keySet();
        for (String key : keys) {
            rec.put(key, (DataToken)data.get(key));
        }
        return rec;
    }
}

