/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.export.ExternalExcelSheetWriter;
import com.kingdee.eas.tools.datatask.export.IExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiTempletExportRunner {
    private static final Logger logger = Logger.getLogger(MultiTempletExportRunner.class);
    private Excel2007Writer excelWriter;
    private List<ExternalStructInfo> structs;
    private IExternalExcelDataWriter sheetWriter;

    public MultiTempletExportRunner(List<ExternalStructInfo> structs, String fileUuId) {
        this.excelWriter = new Excel2007Writer(GlobalFunction.getFilePathForServer() + fileUuId);
        this.excelWriter.initWb();
        this.structs = structs;
    }

    public void writeExcel() {
        try {
            this.writeSheet();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                this.closeSheet();
                this.excelWriter.processFile();
            }
            catch (TaskRunnerException e) {
                logger.error((Object)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void writeSheet() throws TaskRunnerException {
        for (ExternalStructInfo struct : this.structs) {
            this.closeSheet();
            this.sheetWriter = new ExternalExcelSheetWriter(this.excelWriter);
            String sheetName = struct.getSheetName();
            this.sheetWriter.setSheetName(sheetName);
            this.sheetWriter.openWriter();
            this.sheetWriter.setDimension(4, struct.getFieldCollection().size());
            this.sheetWriter.writeStruct(struct);
        }
    }

    private void closeSheet() throws TaskRunnerException {
        if (this.sheetWriter != null) {
            this.sheetWriter.closeWriter();
        }
    }
}

