/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ImpExpParam;
import com.kingdee.eas.tools.datatask.task.MultitaskExcelSchedule;
import com.kingdee.eas.tools.datatask.task.MultitaskExportExcelRunner;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.ZipUtilForServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MultitaskExportParse
implements Callable<Boolean> {
    private static Logger logger = SysLog.getLogger(MultitaskExportParse.class);
    private Context ctx;
    private Map ctxParam;
    private String taskUuId;
    private Map<String, ITask> taskMap = new HashMap<String, ITask>();
    private List<ImpExpParam> exportParam;
    private Map<String, Future<TaskResult>> fExportMap = new HashMap<String, Future<TaskResult>>();
    private CompletionService<TaskResult> esc;

    public MultitaskExportParse(String taskUuId, List<ImpExpParam> exportParam, Map ctxParam, Context ctx) {
        this.ctx = ctx;
        this.ctxParam = ctxParam;
        this.taskUuId = taskUuId;
        this.exportParam = exportParam;
        this.esc = MultitaskExcelSchedule.getCompletionSrv();
        this.initBizParam();
    }

    private void initBizParam() {
        try {
            for (ImpExpParam exp : this.exportParam) {
                String solu = exp.getSolu();
                TaskExternalCode task = TaskTemplateAdapter.getTaskExternalCode(solu, this.ctx);
                DatataskParameter taskparam = new DatataskParameter();
                String fileUuId = GlobalFunction.getUuID();
                taskparam.setFileUuId(fileUuId);
                taskparam.setFileName(exp.getSoluName());
                taskparam.setSolutionName(solu);
                taskparam.setAlias(exp.getSoluName());
                taskparam.setFileType("xlsx");
                Map bizmap = (Map)this.ctxParam.get(solu);
                taskparam.setContextParam(bizmap);
                task.setTaskParameter(taskparam);
                task.setTaskUuID(this.taskUuId);
                this.taskMap.put(solu, task);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseTask() throws TaskRunnerException {
        try {
            for (ImpExpParam exp : this.exportParam) {
                String solu = exp.getSolu();
                ITask task = this.taskMap.get(solu);
                MultitaskExportExcelRunner taskRunner = new MultitaskExportExcelRunner(task, this.ctx);
                taskRunner.setTaskRsKey(solu);
                Future<TaskResult> fexport = this.esc.submit(taskRunner);
                this.fExportMap.put(solu, fexport);
            }
            this.taskRsDeal();
        }
        catch (Exception e) {
            logger.error((Object)e, e.getCause());
        }
        finally {
            this.processZipFile();
        }
    }

    private void taskRsDeal() throws TaskRunnerException {
        try {
            int size = this.fExportMap.size();
            for (int i = 0; i < size; ++i) {
                Future<TaskResult> fu = this.esc.take();
                TaskResult rs = fu.get();
                String solu = rs.getKey();
                if (!rs.isSucced()) {
                    this.taskMap.remove(solu);
                }
                this.fExportMap.remove(solu);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
        }
    }

    private void processZipFile() {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        for (Map.Entry<String, ITask> entry : this.taskMap.entrySet()) {
            String fileName = entry.getValue().getTaskParameter().getFileUuId();
            String alias = entry.getValue().getTaskParameter().getFileName();
            String fileType = entry.getValue().getTaskParameter().getFileType();
            fileMap.put(fileName, alias + "." + fileType);
        }
        ZipUtilForServer.compressFiles2Zip(fileMap, GlobalFunction.getFilePathForServer() + this.getZipFileName());
    }

    public String getZipFileName() {
        return this.taskUuId;
    }

    @Override
    public Boolean call() throws Exception {
        boolean rs = true;
        try {
            this.parseTask();
        }
        catch (TaskRunnerException e) {
            logger.error((Object)e);
        }
        finally {
            MultitaskExcelSchedule.putDonemap(this.taskUuId, true);
        }
        return rs;
    }
}

