/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.BlockDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelXErrorDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskIERunner;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaskBlockDataRunner
extends TaskIERunner {
    private static Logger logger = SysLog.getLogger(TaskBlockDataRunner.class);
    private BlockDataTransmission blockTrans = null;
    private BlockDataReader reader = null;
    private ExcelXErrorDataWriter errDataWriter;
    private AbstractExternalDataReader dataReader;
    private RecordCollection coll = null;
    private boolean hasErrorFile = false;
    private int blockSize = 0;
    private boolean needSetRowStartNumber = true;

    public TaskBlockDataRunner(TaskExternalCode task) throws Exception {
        this(task, new Context());
    }

    public TaskBlockDataRunner(TaskExternalCode task, Context ctx) throws Exception {
        this(task, null, ctx);
    }

    public TaskBlockDataRunner(TaskExternalCode task, BlockDataTransmission trans, Context ctx) throws Exception {
        super(task, ctx);
        this.blockTrans = trans;
        this.reader = new BlockDataReader(task, trans, ctx.getLocale());
        this.dataReader = this.reader.getDataReader();
    }

    @Override
    protected boolean hasMoreRecord() throws TaskRunnerException {
        return this.reader.hasNextBlock();
    }

    @Override
    protected void onInitResources() throws TaskRunnerException {
        ErrorHandleModeEnum errorHandleMode;
        super.onInitResources();
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        if (this.dataReader instanceof ExternalExcelXDataReader && (errorHandleMode = (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode"))) == ErrorHandleModeEnum.ReturnWhenFinish) {
            this.hasErrorFile = true;
            this.errDataWriter = new ExcelXErrorDataWriter();
            this.errDataWriter.setLocacle(this.locale);
            this.errDataWriter.setFileName(dp.getErrDataFileName());
            this.errDataWriter.setSheetName(dp.alias);
            this.errDataWriter.openWriter();
            this.errDataWriter.writeStruct(taskCode.getExternalStructInfo());
        }
    }

    @Override
    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        super.onBeforeEachRunningLoop();
    }

    @Override
    protected void onEachRunningLoop() throws Exception {
        int failRecCount = this.tl.getFailRecordCount();
        this.coll = this.reader.getNextBlock();
        this.blockSize = this.coll.size();
        Object o = this.blockTrans.transform(this.ctx, this.coll);
        this.blockTrans.verifyBlockData(this.ctx, o);
        this.blockTrans.beforeSubmitBlockData(this.ctx, o);
        this.blockTrans.submitBlock(this.ctx, o);
        int blockFailCount = this.tl.getFailRecordCount() - failRecCount;
        this.nSuccessCount = this.nSuccessCount + this.blockSize - blockFailCount;
        this.tl.setSuccessRecordCount(this.nSuccessCount);
    }

    @Override
    protected void onRecordProcess() throws TaskRunnerException {
        while (this.hasMoreRecord() && this.continueCondition) {
            this.nCurCount += this.blockSize;
            try {
                this.onEachRunningLoop();
                if (this.nSuccessCount / 100 != 0) continue;
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            catch (Throwable ex) {
                if (ex.getMessage().equalsIgnoreCase("NEWBLOCK")) {
                    this.dataErrorHandle(ex);
                    continue;
                }
                this.nFailCount += this.blockSize;
                this.tl.setFailRecordCount(this.nFailCount);
                this.nCurCount = this.reader.getnCurCount();
                this.onDataError(ex);
            }
        }
        if (this.nSuccessCount / 100 != 0) {
            this.tl.setSuccessRecordCount(this.nSuccessCount);
        }
        if (this.tl.getFailRecordCount() <= 0) {
            this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        TaskLogUtil.putLog(this.tl);
    }

    @Override
    protected void onFinishingRunning() throws TaskRunnerException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.hasErrorFile && this.errDataWriter != null) {
            this.errDataWriter.closeWriter();
        }
    }

    @Override
    protected String getMsgOnDataErr() {
        int rowNumOfDataStart = this.reader.getDataReader().getExternalDataRowInfo().getRowOfDataStart();
        String rowNumber = String.valueOf(this.nCurCount + rowNumOfDataStart);
        if (this.coll != null) {
            if (this.blockSize > 1) {
                int startRow = this.coll.get(0).getRowNum();
                int endRow = this.coll.get(this.blockSize - 1).getRowNum();
                rowNumber = String.valueOf(startRow + "-" + endRow);
            } else {
                int startRow = this.coll.get(0).getRowNum();
                rowNumber = String.valueOf(startRow);
            }
        }
        return EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "importNo", this.locale) + rowNumber + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "lineData", this.locale);
    }

    @Override
    protected void onDataError(Throwable ex) throws TaskRunnerException {
        if (this.needSetRowStartNumber) {
            this.needSetRowStartNumber = false;
            int rowOfDataStart = this.reader.getDataReader().getExternalDataRowInfo().getRowOfDataStart();
            rowOfDataStart = rowOfDataStart < 0 ? 0 : rowOfDataStart;
            this.tl.setRowNumOfRecordStart(rowOfDataStart);
        }
        if (ex != null && ex instanceof TaskRunnerException && ((TaskRunnerException)((Object)ex)).getExceptionCode() == 4) {
            throw (TaskRunnerException)((Object)ex);
        }
        String errMsg = this.getMsgOnDataErr();
        if (this.coll != null) {
            int startRowNum = this.coll.get(0).getRowNum();
            int endRowNum = this.coll.get(this.blockSize - 1).getRowNum();
            Map<Object, Object> entryErrorReasons = new LinkedHashMap();
            if (ex instanceof TaskExternalException) {
                TaskExternalException tex = (TaskExternalException)((Object)ex);
                entryErrorReasons = tex.getEntryErrorReasons();
            }
            if (!entryErrorReasons.isEmpty()) {
                this.tl.setSupportEntryErrorReason(true);
                for (int i = startRowNum; i <= endRowNum; ++i) {
                    int entryIndex = i - startRowNum;
                    String errorReason = (String)entryErrorReasons.get(entryIndex);
                    errorReason = errorReason == null ? "" : errorReason;
                    this.tl.addException(errMsg, new Exception(errorReason), i);
                }
            } else {
                this.tl.addExceptionForBlock(errMsg, ex, startRowNum, endRowNum);
            }
        } else {
            this.tl.addException(errMsg, ex, this.nCurCount);
        }
        this.tl.setFailRecordCount(this.nFailCount);
        TaskLogUtil.putLog(this.tl);
        this.dataErrorHandle(ex);
    }

    @Override
    protected String getFatalError() {
        String sheetName = "";
        return sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", this.locale);
    }

    @Override
    protected void onDataErrorSkip(Throwable ex) {
        super.onDataErrorSkip(ex);
        if (this.dataReader instanceof ExternalExcelXDataReader && this.hasErrorFile) {
            String errFieldDesc;
            DataToken value = new DataToken();
            value.name = "ErrorReason";
            value.desc = errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason");
            try {
                HashMap<String, DataToken> hsData = new HashMap<String, DataToken>();
                IRecord rec = null;
                String cellValue = null;
                int errRowNum = 0;
                for (int i = 0; i < this.tl.getErrorDetailCount(); ++i) {
                    errRowNum = this.tl.getErrorRowNum(i) - 1;
                    rec = this.coll.get(errRowNum - 4);
                    cellValue = this.tl.getErrorDetail(i);
                    value.data = cellValue == null ? "" : cellValue.trim();
                    hsData.putAll(rec.getMap());
                    hsData.put("ErrorReason", value);
                    this.errDataWriter.writeLine(hsData);
                }
            }
            catch (TaskRunnerException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void onDataErrorStop(Throwable ex) {
        super.onDataErrorStop(ex);
        if (this.dataReader instanceof ExternalExcelXDataReader) {
            ((ExternalExcelXDataReader)this.dataReader).interruptExcelXParseThread();
        }
    }
}

