/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.AbstractCoreBillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DefaultDataTransmission;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelXErrorDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.task.BlockDataInfo;
import com.kingdee.eas.tools.datatask.task.FileUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.InspectorCreatorWithCache;
import com.kingdee.eas.tools.datatask.task.ReaderUtil;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskIERunner;
import com.kingdee.eas.tools.datatask.task.TaskUtil;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaskExternalCodeRunner
extends TaskIERunner {
    private static Logger logger = SysLog.getLogger(TaskExternalCodeRunner.class);
    private static final String ERROR_REASON = "ErrorReason";
    private AbstractExternalDataReader reader;
    private ExcelXErrorDataWriter errDataWriter;
    private boolean hasErrorFile = false;
    private Map hsData;
    private IDataTransmission iDataTrans;
    private InputStream file;
    private boolean isCodeImplementTrans = true;
    private boolean isUserDefineTrans = false;
    private boolean isScriptTrans = false;
    private DefaultDataTransmission defaultTrans = null;
    private BlockDataInfo bdInfo = null;
    private int submittype = 0;
    private int currentSeqFor_SUMITSINGLERECTYPE = 0;
    private Map previousData = null;
    private boolean needSetRowStartNumber = true;
    private InspectorCreatorWithCache inspectorCreator = new InspectorCreatorWithCache();
    private String entryName = null;
    public static final String SEQ_KEY = "FSeq";
    private List ids = new ArrayList();
    private HashMap map = new HashMap();

    public TaskExternalCodeRunner(ITask task) {
        super(task, null);
    }

    public TaskExternalCodeRunner(ITask task, Context ctx) {
        super(task, ctx);
    }

    @Override
    protected void onInitResources() throws TaskRunnerException {
        ErrorHandleModeEnum errorHandleMode;
        super.onInitResources();
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        String fileType = dp.getFileType();
        try {
            this.file = FileUtil.getServerTmpFileStream(dp.getOpenFileName());
            this.reader = ReaderUtil.buildReader(fileType, dp.getOpenFileName(), this.ctx.getLocale(), dp.alias, this.file, taskCode.getExternalStructInfo());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            String errorMsg = ex.getMessage();
            if (errorMsg == null || errorMsg.trim().length() == 0) {
                errorMsg = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notstandardtemplate", this.locale);
            }
            throw new TaskRunnerException(4, errorMsg, ex);
        }
        if (this.reader instanceof ExternalExcelXDataReader && (errorHandleMode = (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode"))) == ErrorHandleModeEnum.ReturnWhenFinish) {
            this.hasErrorFile = true;
            this.errDataWriter = new ExcelXErrorDataWriter();
            this.errDataWriter.setLocacle(this.locale);
            this.errDataWriter.setFileName(dp.getErrDataFileName());
            this.errDataWriter.setSheetName(dp.alias);
            this.errDataWriter.openWriter();
            this.errDataWriter.writeStruct(taskCode.getExternalStructInfo());
        }
    }

    @Override
    protected void onRecordProcess() throws TaskRunnerException {
        if (this.submittype == 0) {
            super.onRecordProcess();
        } else if (this.submittype == 1) {
            BlockDataInfo preDataBlock = new BlockDataInfo();
            BlockDataInfo curDataBlock = new BlockDataInfo();
            int blockSize = 0;
            while (this.continueCondition) {
                try {
                    if (preDataBlock != null && preDataBlock.getData().size() > 0) {
                        this.bdInfo = preDataBlock;
                        blockSize = preDataBlock.getData().size();
                        this.submitBlock(preDataBlock.getData());
                        preDataBlock.init();
                        this.bdInfo = null;
                    }
                    if (curDataBlock == null) {
                        curDataBlock = new BlockDataInfo();
                    }
                    this.Block(preDataBlock, curDataBlock);
                    if (this.nSuccessCount / 100 != 0) continue;
                    this.tl.setSuccessRecordCount(this.nSuccessCount);
                }
                catch (Throwable ex) {
                    logger.error((Object)this.emptyIfNull(ex.getMessage()), ex);
                    this.nFailCount += blockSize;
                    this.onDataError(ex);
                    this.Block(preDataBlock, curDataBlock);
                }
            }
            if (!this.stopOnDataErr) {
                try {
                    if (preDataBlock != null && preDataBlock.getData().size() > 0 && curDataBlock != null && curDataBlock.getData().size() <= 0) {
                        this.bdInfo = preDataBlock;
                        blockSize = preDataBlock.getData().size();
                        this.submitBlock(preDataBlock.getData());
                        if (this.nSuccessCount / 100 == 0) {
                            this.tl.setSuccessRecordCount(this.nSuccessCount);
                        }
                        this.bdInfo = null;
                    } else if (curDataBlock != null && curDataBlock.getData().size() > 0) {
                        this.bdInfo = curDataBlock;
                        blockSize = curDataBlock.getData().size();
                        this.submitBlock(curDataBlock.getData());
                        if (this.nSuccessCount / 100 == 0) {
                            this.tl.setSuccessRecordCount(this.nSuccessCount);
                        }
                        this.bdInfo = null;
                    }
                }
                catch (Throwable ex) {
                    this.nFailCount += blockSize;
                    this.onDataError(ex);
                }
            }
            if (this.nSuccessCount / 100 != 0) {
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            if (this.nFailCount <= 0) {
                this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
            } else {
                this.tl.setTaskState(TaskStateEnum.FAILEND);
            }
            TaskLogUtil.putLog(this.tl);
        }
    }

    private void setSeq(Map blockData) {
        for (int seq = 0; seq < blockData.size(); ++seq) {
            if (!(blockData.get(seq) instanceof Map)) continue;
            Map entry = (Map)blockData.get(seq);
            if (seq == 0 && entry.containsKey(SEQ_KEY)) {
                return;
            }
            entry.put(SEQ_KEY, seq + 1);
        }
    }

    private int getCoreBaseInfoEntryIndexBySEQ(CoreBaseInfo coreBaseInfo, Map entry) {
        if (coreBaseInfo == null) {
            return -1;
        }
        Object entriesObj = coreBaseInfo.get(this.entryName);
        if (entriesObj == null || !(entriesObj instanceof AbstractBaseObjectCollection)) {
            return -1;
        }
        AbstractBaseObjectCollection collection = (AbstractBaseObjectCollection)coreBaseInfo.get(this.entryName);
        if (collection != null && collection.size() > 0) {
            Integer tempSeq = -1;
            try {
                Object seq = entry.get(SEQ_KEY);
                if (seq != null) {
                    tempSeq = seq instanceof DataToken ? (Integer)((DataToken)seq).data : (Integer)seq;
                }
            }
            catch (Exception e) {
                Log.error((Object)"TaskExternalCodeRunner can not get correct Fseq");
            }
            for (int i = 0; i < collection.size(); ++i) {
                AbstractCoreBillEntryBaseInfo entryInfo;
                IObjectValue obj = collection.getObject(i);
                if (!(obj instanceof AbstractCoreBillEntryBaseInfo) || (entryInfo = (AbstractCoreBillEntryBaseInfo)obj).getSeq() != tempSeq.intValue()) continue;
                return i;
            }
        }
        return -1;
    }

    protected void submitBlock(Map blockData) throws TaskRunnerException {
        this.setSeq(blockData);
        CoreBaseInfo coreBaseInfo = null;
        if (this.isCodeImplementTrans) {
            coreBaseInfo = this.iDataTrans.transmit(blockData, this.ctx);
            coreBaseInfo = this.inspectorCreator.attachCreator(coreBaseInfo, (Map)blockData.get(new Integer(0)), this.ctx);
        }
        if (this.isUserDefineTrans && this.isCodeImplementTrans) {
            int blockSize = blockData.size();
            for (int i = 0; i < blockSize; ++i) {
                Map entry = (Map)blockData.get(new Integer(i));
                int tempIndex = this.getCoreBaseInfoEntryIndexBySEQ(coreBaseInfo, entry);
                if (tempIndex != -1) {
                    this.defaultTrans.setCurrentEntryRowIndex(tempIndex);
                } else {
                    this.defaultTrans.setCurrentEntryRowIndex(i);
                }
                coreBaseInfo = this.defaultTrans.transmit(entry, coreBaseInfo);
            }
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        } else if (this.isUserDefineTrans && !this.isCodeImplementTrans) {
            int blockSize = blockData.size();
            for (int i = 0; i < blockSize; ++i) {
                this.defaultTrans.setCurrentEntryRowIndex(i);
                coreBaseInfo = this.defaultTrans.transmit((Map)blockData.get(new Integer(i)), coreBaseInfo);
            }
            this.defaultTrans.submit(coreBaseInfo, this.ctx);
        } else if (!this.isUserDefineTrans && this.isCodeImplementTrans) {
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        }
        if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
            this.ids.add(coreBaseInfo.getId().toString());
        }
        this.nSuccessCount += blockData.size();
    }

    protected int getSubmitType() {
        if (this.iDataTrans != null) {
            return this.iDataTrans.getSubmitType();
        }
        if (this.defaultTrans != null) {
            return this.defaultTrans.getSubmitType();
        }
        return 0;
    }

    protected String getEntryName() {
        if (this.iDataTrans != null) {
            return this.iDataTrans.getEntryName();
        }
        if (this.defaultTrans != null) {
            return this.defaultTrans.getEntryName();
        }
        return "entries";
    }

    protected void Block(BlockDataInfo preDataBlock, BlockDataInfo curDataBlock) throws TaskRunnerException {
        int i = 0;
        if (curDataBlock != null && curDataBlock.getData().size() > 0) {
            preDataBlock.init();
            preDataBlock.getData().putAll(curDataBlock.getData());
            preDataBlock.setStardRow(curDataBlock.getStardRow());
            preDataBlock.setEndRow(curDataBlock.getEndRow());
            if (curDataBlock.getData() != null) {
                i += curDataBlock.getData().size();
            }
            curDataBlock.init();
        }
        while (this.hasMoreRecord() && this.continueCondition) {
            ++this.nCurCount;
            this.hsData = this.reader.getNext();
            if (this.hsData == null) {
                this.continueCondition = false;
                return;
            }
            if (this.hsData.size() == 0) {
                ++this.nBlankCount;
                continue;
            }
            if (preDataBlock.getData().size() <= 0) {
                preDataBlock.setStardRow(this.nCurCount);
                preDataBlock.setEndRow(this.nCurCount);
                preDataBlock.getData().put(new Integer(i++), this.hsData);
                continue;
            }
            if (this.isSameBlock((Map)preDataBlock.getData().get(new Integer(0)), this.hsData)) {
                preDataBlock.setEndRow(this.nCurCount);
                preDataBlock.getData().put(new Integer(i++), this.hsData);
                continue;
            }
            preDataBlock.setEndRow(this.nCurCount - 1);
            curDataBlock.setStardRow(this.nCurCount);
            curDataBlock.setEndRow(this.nCurCount);
            curDataBlock.getData().put(new Integer(0), this.hsData);
            return;
        }
        this.continueCondition = false;
    }

    private boolean isSameBlock(Map firstRecordData, Map currentRecordData) {
        if (this.iDataTrans != null) {
            return this.iDataTrans.isSameBlock(firstRecordData, currentRecordData);
        }
        if (this.defaultTrans != null) {
            return this.defaultTrans.isSameBlock(firstRecordData, currentRecordData);
        }
        return false;
    }

    @Override
    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        super.onBeforeEachRunningLoop();
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        this.isCodeImplementTrans = TaskUtil.isCodeImplementTrans(taskCode);
        this.isUserDefineTrans = TaskUtil.isUserDefineTrans(taskCode);
        this.isScriptTrans = TaskUtil.isScriptTrans(taskCode);
        if (this.isCodeImplementTrans) {
            this.iDataTrans = this.createDataTransmissionObject();
        }
        this.defaultTrans = new DefaultDataTransmission(this.ctx);
        this.defaultTrans.setDIETemplateInfo(taskCode.getDIETemplateInfo());
        this.defaultTrans.setContext(this.ctx);
        this.defaultTrans.setCodeImplementTrans(this.isCodeImplementTrans);
        this.defaultTrans.setUserDefineTrans(this.isUserDefineTrans);
        HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Map myParam = dp.getContextParam();
        if (myParam != null) {
            contextParam.putAll(myParam);
        }
        contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
        this.defaultTrans.setContextParameter(contextParam);
        this.submittype = this.getSubmitType();
        this.entryName = this.getEntryName();
    }

    @Override
    protected void onFinishingRunning() throws TaskRunnerException {
        if (this.iDataTrans != null) {
            this.map.put("eas_task_import_ids", this.ids);
            this.iDataTrans.importOnFinished(this.ctx, this.map);
            this.ids.clear();
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.hasErrorFile && this.errDataWriter != null) {
            this.errDataWriter.closeWriter();
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            this.file = null;
        }
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        if (!this.isMultiSheetImport()) {
            FileUtil.removeFile(dp.getOpenFileName());
        }
    }

    protected boolean isMultiSheetImport() {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Object o = dp.getContextParam().get("isMultiSheetImport");
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    private IDataTransmission createDataTransmissionObject() throws TaskRunnerException {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        IDataTransmission iObject = null;
        try {
            Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
            iObject = (IDataTransmission)classDefinition.newInstance();
            HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
            iObject.setContextParameter(contextParam);
        }
        catch (Exception e) {
            logger.error((Object)this.emptyIfNull(e.getMessage()), (Throwable)e);
            String detail = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"create") + taskCode.getDataTransmissionClassName() + EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"createException");
            detail = detail + e.getMessage();
            throw new TaskRunnerException(4, detail, e);
        }
        return iObject;
    }

    @Override
    protected void onEachRunningLoop() throws TaskRunnerException {
        this.hsData = this.reader.getNext();
        if (this.hsData == null || this.hsData.isEmpty()) {
            return;
        }
        if (this.previousData == null) {
            this.previousData = this.hsData;
            this.currentSeqFor_SUMITSINGLERECTYPE = 1;
        } else if (this.isSameBlock(this.previousData, this.hsData)) {
            ++this.currentSeqFor_SUMITSINGLERECTYPE;
        } else {
            this.previousData = this.hsData;
            this.currentSeqFor_SUMITSINGLERECTYPE = 1;
        }
        Object seqObj = this.hsData.get(SEQ_KEY);
        if (seqObj != null) {
            try {
                int seq;
                this.currentSeqFor_SUMITSINGLERECTYPE = seq = Integer.parseInt(seqObj.toString());
            }
            catch (Exception seq) {
                // empty catch block
            }
        }
        CoreBaseInfo coreBaseInfo = null;
        if (this.isCodeImplementTrans) {
            coreBaseInfo = this.iDataTrans.transmit(this.hsData, this.ctx);
            coreBaseInfo = this.inspectorCreator.attachCreator(coreBaseInfo, this.hsData, this.ctx);
        }
        if (coreBaseInfo != null && coreBaseInfo.get(this.entryName) != null) {
            int entryRowIndex = this.getCoreBaseInfoEntryIndexBySEQ(coreBaseInfo, this.hsData);
            if (entryRowIndex != -1) {
                this.defaultTrans.setCurrentEntryRowIndex(entryRowIndex);
            } else {
                this.defaultTrans.setCurrentEntryRowIndex(this.currentSeqFor_SUMITSINGLERECTYPE - 1);
            }
        }
        if (this.isUserDefineTrans && this.isCodeImplementTrans) {
            coreBaseInfo = this.defaultTrans.transmit(this.hsData, coreBaseInfo);
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        } else if (this.isUserDefineTrans && !this.isCodeImplementTrans) {
            coreBaseInfo = this.defaultTrans.transmit(this.hsData, coreBaseInfo);
            this.defaultTrans.submit(coreBaseInfo, this.ctx);
        } else if (!this.isUserDefineTrans && this.isCodeImplementTrans) {
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        }
        ++this.nSuccessCount;
    }

    @Override
    protected String getMsgOnDataErr() {
        String sheetName = "";
        if (this.isMultiSheetImport()) {
            sheetName = this.getSheetName();
        }
        int rowNumOfDataStart = this.reader.getExternalDataRowInfo().getRowOfDataStart();
        String rowNumber = String.valueOf(this.nCurCount + rowNumOfDataStart);
        if (this.bdInfo != null) {
            if (this.bdInfo.getStardRow() != this.bdInfo.getEndRow()) {
                int startRow = this.bdInfo.getStardRow() + rowNumOfDataStart;
                int endRow = this.bdInfo.getEndRow() + rowNumOfDataStart;
                rowNumber = String.valueOf(startRow + "-" + endRow);
            } else {
                int startRow = this.bdInfo.getStardRow() + rowNumOfDataStart;
                rowNumber = String.valueOf(startRow);
            }
        }
        return sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "importNo", this.locale) + rowNumber + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "lineData", this.locale);
    }

    private String getSheetName() {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        return new StringBuffer(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "whenimportfile", this.locale)).append(dp.alias).append(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "somesheet", this.locale)).toString();
    }

    @Override
    protected String getFatalError() {
        String sheetName = "";
        if (this.isMultiSheetImport()) {
            sheetName = this.getSheetName();
        }
        return sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", this.locale);
    }

    @Override
    protected boolean hasMoreRecord() throws TaskRunnerException {
        return this.reader.hasNext();
    }

    @Override
    protected void onDataError(Throwable ex) throws TaskRunnerException {
        if (this.needSetRowStartNumber) {
            this.needSetRowStartNumber = false;
            int rowOfDataStart = this.reader.getExternalDataRowInfo().getRowOfDataStart();
            rowOfDataStart = rowOfDataStart < 0 ? 0 : rowOfDataStart;
            this.tl.setRowNumOfRecordStart(rowOfDataStart);
        }
        if (ex instanceof TaskRunnerException && ((TaskRunnerException)((Object)ex)).getExceptionCode() == 4) {
            throw (TaskRunnerException)((Object)ex);
        }
        String errMsg = this.getMsgOnDataErr();
        if (this.submittype == 1) {
            if (this.bdInfo != null) {
                int startRowNum = this.bdInfo.getStardRow();
                int endRowNum = this.bdInfo.getEndRow();
                Map<Object, Object> entryErrorReasons = new LinkedHashMap();
                if (ex instanceof TaskExternalException) {
                    TaskExternalException tex = (TaskExternalException)((Object)ex);
                    entryErrorReasons = tex.getEntryErrorReasons();
                }
                if (!entryErrorReasons.isEmpty()) {
                    this.tl.setSupportEntryErrorReason(true);
                    for (int i = startRowNum; i <= endRowNum; ++i) {
                        int entryIndex = i - startRowNum;
                        String errorReason = (String)entryErrorReasons.get(entryIndex);
                        errorReason = errorReason == null ? "" : errorReason;
                        this.tl.addException(errMsg, new Exception(errorReason), i);
                    }
                } else {
                    this.tl.addExceptionForBlock(errMsg, ex, startRowNum, endRowNum);
                }
            } else {
                this.tl.addException(errMsg, ex, this.nCurCount);
                ++this.nFailCount;
            }
        } else {
            this.tl.addException(errMsg, ex, this.nCurCount);
        }
        this.tl.setFailRecordCount(this.nFailCount);
        TaskLogUtil.putLog(this.tl);
        this.dataErrorHandle(ex);
    }

    @Override
    protected void onDataErrorStop(Throwable ex) {
        super.onDataErrorStop(ex);
        if (this.reader instanceof ExternalExcelXDataReader) {
            ((ExternalExcelXDataReader)this.reader).interruptExcelXParseThread();
        }
    }

    @Override
    protected void onDataErrorSkip(Throwable ex) {
        super.onDataErrorSkip(ex);
        if (this.reader instanceof ExternalExcelXDataReader && this.hasErrorFile) {
            String errFieldDesc;
            DataToken value = new DataToken();
            value.name = ERROR_REASON;
            value.desc = errFieldDesc = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "errorReason", this.locale);
            try {
                if (this.submittype == 1) {
                    Map<Object, Object> entryErrorReasons = new LinkedHashMap();
                    if (ex instanceof TaskExternalException) {
                        TaskExternalException tex = (TaskExternalException)((Object)ex);
                        entryErrorReasons = tex.getEntryErrorReasons();
                    }
                    for (int i = 0; i < this.bdInfo.getData().size(); ++i) {
                        String cellValue;
                        Map hsData = (Map)this.bdInfo.getData().get(i);
                        if (entryErrorReasons.isEmpty()) {
                            cellValue = ex.getMessage();
                            value.data = cellValue == null ? "" : cellValue.trim();
                            hsData.put(ERROR_REASON, value);
                        } else {
                            cellValue = (String)entryErrorReasons.get(i);
                            value.data = cellValue == null ? "" : cellValue.trim();
                            hsData.put(ERROR_REASON, value);
                        }
                        if (!this.errDataWriter.containsFieldName(SEQ_KEY)) {
                            hsData.remove(SEQ_KEY);
                        }
                        this.errDataWriter.writeLine(hsData);
                    }
                } else {
                    int lastIndex = this.tl.getErrorDetailCount() - 1;
                    String cellValue = this.tl.getErrorDetail(lastIndex);
                    value.data = cellValue == null ? "" : cellValue.trim();
                    this.hsData.put(ERROR_REASON, value);
                    if (!this.errDataWriter.containsFieldName(SEQ_KEY)) {
                        this.hsData.remove(SEQ_KEY);
                    }
                    this.errDataWriter.writeLine(this.hsData);
                }
            }
            catch (TaskRunnerException e) {
                logger.error((Object)e);
            }
        }
    }
}

