/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.eas.tools.datatask.export.Excel2007SheetErrorManager;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReaderTask;
import com.kingdee.eas.tools.datatask.runtime.IDataReader;
import com.kingdee.eas.tools.datatask.task.ITaskRunner;
import com.kingdee.eas.tools.datatask.task.MultitaskExcelSchedule;
import com.kingdee.eas.tools.datatask.task.util.ExcelParam;
import com.kingdee.eas.tools.datatask.task.util.TaskEnum;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class WriterToExcelFile
implements ITaskRunner {
    private static Logger logger = SysLog.getLogger(WriterToExcelFile.class);
    private IDataReader dataReader;
    private IRecord curRec = null;
    private Excel2007SheetErrorManager errExcelSheetManager;
    private String taskRsKey;
    private Future<TaskResult> fReader;
    private boolean hasNext = true;
    private Set<Integer> importedIds = new HashSet<Integer>();
    private Set<Integer> notImported = new HashSet<Integer>();
    private ExcelParam exp;
    BlockingQueue<TaskResult> interruptTaskRs;

    public WriterToExcelFile(ExcelParam exp, BlockingQueue<TaskResult> interruptTaskRs) {
        this.dataReader = new ExternalExcelXDataReaderTask(exp);
        this.errExcelSheetManager = new Excel2007SheetErrorManager(exp);
        this.interruptTaskRs = interruptTaskRs;
        this.exp = exp;
        this.notImported = exp.getTaskParam().getSheetIdAndName().keySet();
    }

    private boolean hasNextRecord() throws TaskRunnerException {
        return this.dataReader.hasNextRecord();
    }

    private IRecord getNextRecord() throws TaskRunnerException {
        return this.dataReader.getNextRecord();
    }

    @Override
    public TaskResult call() throws Exception {
        TaskResult rs = this.getTaskResult();
        try {
            this.onBeforeProcess();
            this.runningLoop();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            this.removeEmptySheet();
            if (!this.fReader.isDone()) {
                this.fReader.cancel(true);
            }
            try {
                this.interruptTaskRs.put(this.getTaskResult());
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        return rs;
    }

    private void onBeforeProcess() throws TaskRunnerException {
        try {
            this.dataReader.setTaskRsKey(this.getTaskRsKey());
            this.fReader = MultitaskExcelSchedule.getExec().submit(this.dataReader);
        }
        catch (Exception e) {
            throw new TaskRunnerException(4, (Throwable)e);
        }
    }

    private void runningLoop() throws TaskRunnerException {
        while (this.hasNext) {
            RecordCollection coll = this.getRecordToErr();
            if (coll.size() <= 0) continue;
            this.errExcelSheetManager.writeErrSheet(coll);
        }
    }

    private void removeEmptySheet() {
        HashSet<Integer> copyset = new HashSet<Integer>();
        copyset.addAll(this.notImported);
        copyset.removeAll(this.importedIds);
        this.exp.getExcelWriter().getNotImportSheets().removeAll(copyset);
    }

    private RecordCollection getRecordToErr() throws TaskRunnerException {
        RecordCollection coll = new RecordCollection();
        int count = 0;
        if (this.curRec != null) {
            coll.add(this.curRec);
            ++count;
        }
        while (this.hasNext = this.hasNextRecord()) {
            this.curRec = this.getNextRecord();
            if (this.curRec.getMap().isEmpty()) continue;
            this.importedIds.add(this.curRec.getSheetId());
            if (++count > 500) break;
            coll.add(this.curRec);
        }
        return coll;
    }

    @Override
    public TaskResult getTaskResult() {
        TaskResult rs = new TaskResult();
        rs.setKey(this.getTaskRsKey());
        rs.setTaskEnum(TaskEnum.exportTask);
        return rs;
    }

    public String getTaskRsKey() {
        return this.taskRsKey;
    }

    @Override
    public void setTaskRsKey(String key) {
        this.taskRsKey = key;
    }
}

