/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.IndustryFactory;
import com.kingdee.eas.basedata.assistant.IndustryInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.VersionManager;
import com.kingdee.eas.tools.datatask.task.util.CommonFileXMLUtil;
import com.kingdee.eas.tools.datatask.task.util.IAccountingDataInterface;
import com.kingdee.eas.tools.datatask.task.util.XMLElementAssembeler;
import com.kingdee.eas.tools.datatask.task.util.XMLGenerator;
import com.kingdee.eas.util.PropertiesUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class CommonFileXMLGenerator
extends XMLGenerator
implements IAccountingDataInterface {
    private String STANDARD_NUMBER = "GB/T 24589.1\u20142010";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tools.datatask.task.util.CommonFileXMLGenerator");
    private CtrlUnitInfo ctrlUnitInfo;
    private String companyInfoId;

    protected String _getEASOrBOSVersionFromServerAtProperties(Context ctx, Locale locale) throws BOSException, EASBizException {
        String version = null;
        String fullName = PropertiesUtil.getDefaultProFullName((String)"eas_version.data");
        String temploc = "";
        if ("L1".equalsIgnoreCase(locale.toString())) {
            temploc = "en_US";
        }
        if ("L2".equalsIgnoreCase(locale.toString())) {
            temploc = "zh_CN";
        }
        if ("L3".equalsIgnoreCase(locale.toString())) {
            temploc = "zh_TW";
        }
        SAXBuilder sax = new SAXBuilder();
        try {
            org.jdom2.Document doc = sax.build(fullName);
            Element root = doc.getRootElement();
            List fullNamelist = root.getChild("Information").getChildren();
            for (int i = 0; i < fullNamelist.size(); ++i) {
                Element elefullname = (Element)fullNamelist.get(i);
                String versionloc = elefullname.getAttributeValue("language");
                if (null == versionloc || !temploc.equalsIgnoreCase(versionloc)) continue;
                System.out.println("version===" + elefullname.getText());
                version = elefullname.getText().trim();
                return version;
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }

    private String getEASversion(Context ctx) {
        String version = null;
        try {
            version = this._getEASOrBOSVersionFromServerAtProperties(ctx, new Locale("l2"));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null == version) {
            VersionManager vmeas = new VersionManager();
            try {
                version = vmeas.getMetadataVersion();
            }
            catch (Exception e1) {
                version = "Unknown";
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCommonLibVersion() throws JDOMException, IOException {
        try (InputStream in = null;){
            SAXBuilder build = new SAXBuilder();
            in = CommonFileXMLGenerator.class.getResourceAsStream("/com/kingdee/eas/common/version.data");
            org.jdom2.Document doc = build.build(in);
            Element ele = doc.getRootElement().getChild("configitem");
            String string = "V" + ele.getChild("attribute").getAttributeValue("value");
            return string;
        }
    }

    @Override
    public Document generateXML(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        String type = this.getTypeName(ctx);
        org.dom4j.Element root = this.initHeadAndFileName(ctx, companyInfo, type);
        this.ctrlUnitInfo = this.getCtrlUnit(companyInfo, ctx);
        this.companyInfoId = companyInfo.getId().toString();
        this.generateEAccountBook(root, ctx, companyInfo, periodinfo);
        this.generatePeriod(root, ctx, companyInfo, periodinfo);
        this.generateVoucherType(root, ctx, companyInfo, periodinfo);
        this.generateExchangeRateType(root, ctx, companyInfo, periodinfo);
        this.generateCurrency(root, ctx, companyInfo, periodinfo);
        this.generateSettlementType(root, ctx, companyInfo, periodinfo);
        this.generateAdmin(root, ctx, companyInfo, periodinfo);
        this.generatePerson(root, ctx, companyInfo, periodinfo);
        this.generateSupplier(root, ctx, companyInfo, periodinfo);
        this.generateCustomer(root, ctx, companyInfo, periodinfo);
        this.generateCustomType(root, ctx, companyInfo, periodinfo);
        this.endElement();
        this.close();
        return this.file;
    }

    private void generateEAccountBook(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        String version = null;
        String aisName = null;
        try {
            DCRegister dcr = new DCRegister();
            ArrayList dcList = dcr.getDCList();
            DCInfo dci = null;
            int n = dcList.size();
            for (int i = 0; i < n; ++i) {
                dci = (DCInfo)dcList.get(i);
                if (!dci.getNumber().equals(ctx.getAIS())) continue;
                aisName = dci.getName("L2");
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        version = this.getEASversion(ctx);
        String industry = this.getIndustry(ctx, companyInfo);
        String orgCode = this.getOrgCode(ctx, companyInfo);
        Integer year = new Integer(periodinfo.getPeriodYear());
        org.dom4j.Element eAccountBook = this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"152_CommonFileXMLGenerator"));
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"153_CommonFileXMLGenerator"), ctx.getAIS(), 60, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"154_CommonFileXMLGenerator"), aisName, 200, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"155_CommonFileXMLGenerator"), companyInfo.getName(), 200, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"156_CommonFileXMLGenerator"), orgCode, 20, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"157_CommonFileXMLGenerator"), EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"158_CommonFileXMLGenerator"), 4, true);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"159_CommonFileXMLGenerator"), industry, 20, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"160_CommonFileXMLGenerator"), EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"161_CommonFileXMLGenerator"), 200, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"91_CommonFileXMLGenerator"), version, 20, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"92_CommonFileXMLGenerator"), this.getCurrencyInfo(ctx, companyInfo).getName(), 30, false);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"93_CommonFileXMLGenerator"), year.toString(), 4, true);
        this.addStringElement(eAccountBook, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"94_CommonFileXMLGenerator"), this.STANDARD_NUMBER, 30, false);
        this.endElement();
    }

    private void generatePeriod(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FPeriodYear = this.rowset.getString("FPeriodYear");
                        String FPeriodNumber = this.rowset.getString("FPeriodNumber");
                        Date FBeginDate = this.rowset.getDate("FBeginDate");
                        Date FEndDate = this.rowset.getDate("FEndDate");
                        org.dom4j.Element period = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"95_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"93_CommonFileXMLGenerator"), FPeriodYear, 4, true);
                        CommonFileXMLGenerator.this.addNumberElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"96_CommonFileXMLGenerator"), FPeriodNumber);
                        CommonFileXMLGenerator.this.addDateElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"97_CommonFileXMLGenerator"), FBeginDate);
                        CommonFileXMLGenerator.this.addDateElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"98_CommonFileXMLGenerator"), FEndDate);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element period = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"95_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"93_CommonFileXMLGenerator"), null, 4, true);
                    CommonFileXMLGenerator.this.addNumberElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"96_CommonFileXMLGenerator"), null);
                    CommonFileXMLGenerator.this.addDateElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"97_CommonFileXMLGenerator"), null);
                    CommonFileXMLGenerator.this.addDateElement(period, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"98_CommonFileXMLGenerator"), null);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select t_bd_period.fperiodYear FPeriodYear, t_bd_period.fbeginDate FBeginDate,t_bd_period.fendDate FEndDate, t_bd_period.fperiodnumber FPeriodNumber");
                sql.append("  from t_bd_period");
                sql.append(" where t_bd_period.fPeriodYear = ?");
                sql.append(" and fTypeid= ?  order by FPeriodNumber");
                this.setObjectList(new Object[]{new Integer(this.periodinfo.getPeriodYear()), this.periodinfo.getPeriodType().getId().toString()});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateVoucherType(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FName = this.rowset.getString("FName");
                        String FSimpleName = null;
                        FSimpleName = FName;
                        if (FName != null) {
                            FSimpleName = FName.substring(0, 1);
                        }
                        String FNumber = this.rowset.getString("FNumber");
                        org.dom4j.Element voucherType = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"99_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(voucherType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"100_CommonFileXMLGenerator"), FNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(voucherType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"101_CommonFileXMLGenerator"), FName, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(voucherType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"102_CommonFileXMLGenerator"), FSimpleName, 20, false);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element voucherType = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"99_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(voucherType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"100_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(voucherType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"101_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(voucherType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"102_CommonFileXMLGenerator"), null, 20, false);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select t_bd_vouchertypes.fnumber FNumber,t_bd_vouchertypes.fname_l2 FName,t_bd_vouchertypes.fsimplename FSimpleName");
                sql.append("  from t_bd_vouchertypes ");
                sql.append("where t_bd_vouchertypes.FControlUnitID =?");
                this.setObjectList(new Object[]{CommonFileXMLGenerator.this.ctrlUnitInfo.getId().toString()});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateExchangeRateType(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        Iterator iterator = ExchangeTypeEnum.iterator();
        while (iterator.hasNext()) {
            org.dom4j.Element ExchangeRateType = this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"103_CommonFileXMLGenerator"));
            ExchangeTypeEnum key = (ExchangeTypeEnum)iterator.next();
            String number = null;
            if (key != null) {
                if (key.getValue() == 0) {
                    number = "01";
                }
                if (key.getValue() == 1) {
                    number = "02";
                }
            }
            this.addStringElement(ExchangeRateType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"104_CommonFileXMLGenerator"), number, 60, false);
            this.addStringElement(ExchangeRateType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"105_CommonFileXMLGenerator"), key.toString(), 60, false);
            this.endElement();
        }
    }

    private void generateCurrency(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FNumber = this.rowset.getString("FNumber");
                        String FName = this.rowset.getString("FName");
                        org.dom4j.Element Currency = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"106_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(Currency, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"107_CommonFileXMLGenerator"), FNumber, 10, false);
                        CommonFileXMLGenerator.this.addStringElement(Currency, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"108_CommonFileXMLGenerator"), FName, 30, false);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element Currency = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"106_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(Currency, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"107_CommonFileXMLGenerator"), null, 10, false);
                    CommonFileXMLGenerator.this.addStringElement(Currency, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"108_CommonFileXMLGenerator"), null, 30, false);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select  t_bd_currency.fname_l2 FName,t_bd_currency.fnumber FNumber");
                sql.append("  from t_bd_currency");
                sql.append(" where t_bd_currency.fid <>'11111111-1111-1111-1111-111111111111DEB58FDC'");
                sql.append(" and t_bd_currency.fid <>'22222222-2222-2222-2222-222222222222DEB58FDC'");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateSettlementType(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FNumber = this.rowset.getString("FNumber");
                        String FName = this.rowset.getString("FName");
                        org.dom4j.Element settlementType = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"109_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(settlementType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"110_CommonFileXMLGenerator"), FNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(settlementType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"111_CommonFileXMLGenerator"), FName, 60, false);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element settlementType = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"109_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(settlementType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"110_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(settlementType, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"111_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select t_bd_settlementtype.fname_l2 FName,t_bd_settlementtype.fnumber FNumber");
                sql.append("  from t_bd_settlementtype");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateCustomer(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FNumber = this.rowset.getString("FNumber");
                        String FName = this.rowset.getString("FName");
                        String FSimpleName = this.rowset.getString("FSimpleName");
                        org.dom4j.Element customer = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"112_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(customer, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"113_CommonFileXMLGenerator"), FNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(customer, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"114_CommonFileXMLGenerator"), FName, 200, false);
                        CommonFileXMLGenerator.this.addStringElement(customer, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"115_CommonFileXMLGenerator"), FSimpleName, 60, false);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element customer = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"112_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(customer, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"113_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(customer, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"114_CommonFileXMLGenerator"), null, 200, false);
                    CommonFileXMLGenerator.this.addStringElement(customer, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"115_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select t_bd_customer.fname_l2 FName,t_bd_customer.fsimplename FSimpleName,t_bd_customer.fnumber FNumber");
                sql.append("  from t_bd_customer");
                sql.append("  left outer join t_bd_customercompanyinfo on t_bd_customercompanyinfo.FCustomerID = t_bd_customer.FID ");
                sql.append("  where t_bd_customercompanyinfo.FComOrgID=?");
                this.setObjectList(new Object[]{CommonFileXMLGenerator.this.companyInfoId});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateSupplier(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FNumber = this.rowset.getString("FNumber");
                        String FName = this.rowset.getString("FName");
                        String FSimpleName = this.rowset.getString("FSimpleName");
                        org.dom4j.Element supplier = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"116_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(supplier, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"117_CommonFileXMLGenerator"), FNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(supplier, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"118_CommonFileXMLGenerator"), FName, 200, false);
                        CommonFileXMLGenerator.this.addStringElement(supplier, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"119_CommonFileXMLGenerator"), FSimpleName, 60, false);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element supplier = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"116_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(supplier, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"117_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(supplier, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"118_CommonFileXMLGenerator"), null, 200, false);
                    CommonFileXMLGenerator.this.addStringElement(supplier, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"119_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select t_bd_supplier.fname_l2 FName,t_bd_supplier.fsimplename FSimpleName,t_bd_supplier.fnumber FNumber");
                sql.append("  from t_bd_supplier");
                sql.append("  left outer join t_bd_suppliercompanyinfo on t_bd_suppliercompanyinfo.FSupplierID = t_bd_supplier.FID ");
                sql.append("  where T_BD_SupplierCompanyInfo.FComOrgID=?");
                this.setObjectList(new Object[]{CommonFileXMLGenerator.this.companyInfoId});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generatePerson(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FNumber = this.rowset.getString("FNumber");
                        String FName = this.rowset.getString("FName");
                        String FIDCardNO = this.rowset.getString("FIDCardNO");
                        String FPassportNO = this.rowset.getString("FPassportNO");
                        String FGender = this.rowset.getString("FGender");
                        if (FGender != null) {
                            FGender = FGender + EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"120_CommonFileXMLGenerator");
                        }
                        String FAdminNumber = this.rowset.getString("FAdminNumber");
                        Date FBirthday = this.rowset.getDate("FBirthday");
                        Date FEnterDate = this.rowset.getDate("FEnterDate");
                        Date FLeftDate = this.rowset.getDate("FLeftDate");
                        String typeNo = null;
                        if (FIDCardNO != null) {
                            typeNo = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"121_CommonFileXMLGenerator");
                        } else if (FPassportNO != null) {
                            typeNo = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"122_CommonFileXMLGenerator");
                            FIDCardNO = FPassportNO;
                        }
                        org.dom4j.Element person = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"123_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"124_CommonFileXMLGenerator"), FNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"125_CommonFileXMLGenerator"), FName, 30, false);
                        CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"126_CommonFileXMLGenerator"), typeNo, 30, false);
                        CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"127_CommonFileXMLGenerator"), FIDCardNO, 30, false);
                        CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"128_CommonFileXMLGenerator"), FGender, 20, false);
                        CommonFileXMLGenerator.this.addDateElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"129_CommonFileXMLGenerator"), FBirthday);
                        CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"130_CommonFileXMLGenerator"), FAdminNumber, 60, false);
                        CommonFileXMLGenerator.this.addDateElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"131_CommonFileXMLGenerator"), FEnterDate);
                        if (FLeftDate != null) {
                            CommonFileXMLGenerator.this.addDateElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"132_CommonFileXMLGenerator"), FLeftDate);
                        }
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element person = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"123_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"124_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"125_CommonFileXMLGenerator"), null, 30, false);
                    CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"126_CommonFileXMLGenerator"), null, 30, false);
                    CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"127_CommonFileXMLGenerator"), null, 30, false);
                    CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"128_CommonFileXMLGenerator"), null, 20, false);
                    CommonFileXMLGenerator.this.addDateElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"129_CommonFileXMLGenerator"), null);
                    CommonFileXMLGenerator.this.addStringElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"130_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addDateElement(person, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"131_CommonFileXMLGenerator"), null);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append(" select ");
                sql.append("    t_bd_person.fnumber FNumber,");
                sql.append("    t_bd_person.fname_l2 FName,");
                sql.append("    t_bd_person.FIDCardNO FIDCardNO,");
                sql.append("    t_bd_person.FPassportNO FPassportNO,");
                sql.append("    CASE WHEN t_bd_person.FGender = 1 THEN '\u7537' ELSE '\u5973' END FGender,");
                sql.append("    t_bd_person.FBirthday FBirthday,");
                sql.append("    t_hr_personposition.FEnterDate FEnterDate,");
                sql.append("    t_hr_personposition.FLeftDate FLeftDate,");
                sql.append("    T_ORG_Admin.fnumber FAdminNumber");
                sql.append(" from ");
                sql.append("    t_bd_person,");
                sql.append("    t_hr_personposition,");
                sql.append("    T_ORG_Admin ");
                sql.append(" where ");
                sql.append("    t_bd_person.fid =t_hr_personposition.fpersonid ");
                sql.append("    and t_hr_personposition.FPersonDep=T_ORG_Admin.fid ");
                sql.append(" order by t_bd_person.fnumber");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateAdmin(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String FNumber = this.rowset.getString("FNumber");
                        String FName = this.rowset.getString("FName");
                        String FParentID = this.rowset.getString("FParentID");
                        String FLevel = this.rowset.getString("FLevel");
                        String FParentNumber = null;
                        if (FParentID != null) {
                            try {
                                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)AdminOrgUnitFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(FParentID));
                                FParentNumber = adminOrgUnitInfo.getNumber();
                            }
                            catch (EASBizException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            catch (BOSException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        org.dom4j.Element admin = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"134_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"130_CommonFileXMLGenerator"), FNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"135_CommonFileXMLGenerator"), FName, 200, false);
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"136_CommonFileXMLGenerator"), FParentNumber, 60, false);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element admin = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"134_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"130_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"135_CommonFileXMLGenerator"), null, 200, false);
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"136_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select t1.fname_l2 FName,t1.fnumber FNumber,t1.FParentID,t1.FLevel");
                sql.append("  from t_org_admin t1  where FLevel<>1  order by t1.fnumber");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateCustomType(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        GeneralAsstActTypeGroupCollection glAsstActTypeCols = CommonFileXMLUtil.getGlAsstActTypeCols(ctx);
        boolean hasRows = false;
        ArrayList<String> groupIds = new ArrayList<String>();
        if (glAsstActTypeCols != null && this.ctrlUnitInfo != null) {
            int count = glAsstActTypeCols.size();
            for (int i = 0; i < count; ++i) {
                hasRows = true;
                if (glAsstActTypeCols.get(i).getShareTactic().equals((Object)ShareTacticEnum.I)) {
                    if (!glAsstActTypeCols.get(i).getCU().getId().equals((Object)this.ctrlUnitInfo.getId())) continue;
                    this.addCustomItem(ctx, glAsstActTypeCols.get(i), root);
                    groupIds.add(glAsstActTypeCols.get(i).getId().toString());
                    continue;
                }
                if (glAsstActTypeCols.get(i).getShareTactic().equals((Object)ShareTacticEnum.B2)) {
                    String actGroupCULN = glAsstActTypeCols.get(i).getCU().getLongNumber();
                    String currentCULN = this.ctrlUnitInfo.getLongNumber();
                    if (currentCULN.indexOf(actGroupCULN) != 0) continue;
                    this.addCustomItem(ctx, glAsstActTypeCols.get(i), root);
                    groupIds.add(glAsstActTypeCols.get(i).getId().toString());
                    continue;
                }
                this.addCustomItem(ctx, glAsstActTypeCols.get(i), root);
                groupIds.add(glAsstActTypeCols.get(i).getId().toString());
            }
        }
        if (!hasRows) {
            org.dom4j.Element admin = this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"137_CommonFileXMLGenerator"));
            this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"138_CommonFileXMLGenerator"), null, 60, false);
            this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"139_CommonFileXMLGenerator"), null, 200, false);
            this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"140_CommonFileXMLGenerator"), null, 1000, false);
            this.addNumberElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"141_CommonFileXMLGenerator"), "1");
            this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"142_CommonFileXMLGenerator"), null, 200, false);
            this.endElement();
        }
        this.generateCustomItem(root, ctx, companyInfo, groupIds);
    }

    private void generateCustomItem(org.dom4j.Element root, Context ctx, CompanyOrgUnitInfo companyInfo, final List groupIds) {
        PeriodInfo periodInfo = null;
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodInfo){

            @Override
            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String fGroupid = this.rowset.getString("fGroupid");
                        String FLongNumber = this.rowset.getString("FLongNumber");
                        FLongNumber = FLongNumber.replace('!', '.');
                        String FName = this.rowset.getString("FName");
                        String FDescription = this.rowset.getString("FDescription");
                        String FLevel = this.rowset.getString("FLevel");
                        String FParentID = this.rowset.getString("FParentID");
                        String FNumber = null;
                        String FNumber2 = null;
                        if (FParentID != null && FParentID.trim().length() > 0) {
                            try {
                                GeneralAsstActTypeInfo generalAsstActTypeInfo = (GeneralAsstActTypeInfo)GeneralAsstActTypeFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(FParentID));
                                FNumber2 = generalAsstActTypeInfo.getNumber();
                            }
                            catch (EASBizException e) {
                                logger.error((Object)e.getStackTrace(), (Throwable)e);
                            }
                            catch (BOSException e) {
                                logger.error((Object)e.getStackTrace(), (Throwable)e);
                            }
                        }
                        if (fGroupid != null && fGroupid.trim().length() > 0) {
                            try {
                                GeneralAsstActTypeGroupInfo generalAsstActTypeGroupInfo = (GeneralAsstActTypeGroupInfo)GeneralAsstActTypeGroupFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(fGroupid));
                                FNumber = generalAsstActTypeGroupInfo.getNumber();
                            }
                            catch (EASBizException e) {
                                logger.error((Object)e.getStackTrace(), (Throwable)e);
                            }
                            catch (BOSException e) {
                                logger.error((Object)e.getStackTrace(), (Throwable)e);
                            }
                        }
                        org.dom4j.Element admin = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"143_CommonFileXMLGenerator"));
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"138_CommonFileXMLGenerator"), FNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"144_CommonFileXMLGenerator"), FLongNumber, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"145_CommonFileXMLGenerator"), FName, 200, false);
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"146_CommonFileXMLGenerator"), FDescription, 1000, false);
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"147_CommonFileXMLGenerator"), FNumber2, 60, false);
                        CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"148_CommonFileXMLGenerator"), FLevel, 2, false);
                        CommonFileXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    org.dom4j.Element admin = CommonFileXMLGenerator.this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"143_CommonFileXMLGenerator"));
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"138_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"144_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"145_CommonFileXMLGenerator"), null, 200, false);
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"146_CommonFileXMLGenerator"), null, 1000, false);
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"147_CommonFileXMLGenerator"), null, 60, false);
                    CommonFileXMLGenerator.this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"148_CommonFileXMLGenerator"), null, 2, false);
                    CommonFileXMLGenerator.this.endElement();
                }
            }

            @Override
            public String prePareSQL() {
                StringBuffer idList = new StringBuffer();
                for (int i = 0; i < groupIds.size(); ++i) {
                    if (i != 0) {
                        idList.append(",");
                    }
                    idList.append("'" + groupIds.get(i) + "'");
                }
                StringBuffer sql = new StringBuffer();
                sql.append("select t1.fgroupid fGroupid,t1.flongnumber FLongNumber,t1.fname_l2 FName,");
                sql.append("t1.fDescription_l2 FDescription,t1.flevel FLevel,t1.fparentid FParentID");
                sql.append("  from T_BD_GeneralAsstActType t1");
                sql.append("  where ");
                sql.append("t1.fgroupid in (" + idList + ")");
                sql.append(" and (t1.FCreatorCompanyID ='" + CommonFileXMLGenerator.this.companyInfoId + "' or t1.FCreatorCompanyID=null)");
                sql.toString();
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    @Override
    public String getTypeName(Context ctx) {
        return EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"149_CommonFileXMLGenerator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomItem(Context ctx, GeneralAsstActTypeGroupInfo generalAsstActTypeGroupInfo, org.dom4j.Element root) {
        ResultSet rowset;
        PreparedStatement pstmt;
        Connection conn;
        String Flevel;
        String FNumber;
        String FName;
        String FDescription;
        block5: {
            FDescription = generalAsstActTypeGroupInfo.getDescription();
            FName = generalAsstActTypeGroupInfo.getName();
            FNumber = generalAsstActTypeGroupInfo.getNumber();
            Flevel = "0";
            String sql = "select  max(flevel) FLevel from T_BD_GeneralAsstActType where fgroupid =?";
            conn = null;
            pstmt = null;
            rowset = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setObject(1, generalAsstActTypeGroupInfo.getId().toString());
                rowset = pstmt.executeQuery();
                if (rowset == null) break block5;
                while (rowset.next()) {
                    int FLevel = rowset.getInt("FLevel");
                    if (FLevel <= 1) continue;
                    Flevel = "1";
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getStackTrace(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rowset, pstmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rowset, (Statement)pstmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rowset, (Statement)pstmt, (Connection)conn);
        org.dom4j.Element admin = this.startElement(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"137_CommonFileXMLGenerator"));
        this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"138_CommonFileXMLGenerator"), FNumber, 60, false);
        this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"139_CommonFileXMLGenerator"), FName, 200, false);
        this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"140_CommonFileXMLGenerator"), FDescription, 1000, false);
        this.addNumberElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"141_CommonFileXMLGenerator"), Flevel);
        this.addStringElement(admin, EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"142_CommonFileXMLGenerator"), null, 200, false);
        this.endElement();
    }

    private String getOrgCode(Context ctx, CompanyOrgUnitInfo companyInfo) {
        if (companyInfo.isIsAdminOrgUnit()) {
            ObjectUuidPK adminInfoPK = new ObjectUuidPK(companyInfo.getId());
            try {
                AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)adminInfoPK);
                return adminInfo.getOrgCode();
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String getIndustry(Context ctx, CompanyOrgUnitInfo companyInfo) {
        String industry = null;
        if (companyInfo.isIsAdminOrgUnit()) {
            ObjectUuidPK adminInfoPK = new ObjectUuidPK(companyInfo.getId());
            try {
                AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)adminInfoPK);
                if (adminInfo.getIndustry() != null) {
                    ObjectUuidPK industryInfoPK = new ObjectUuidPK(adminInfo.getIndustry().getId());
                    IndustryInfo industryInfo = (IndustryInfo)IndustryFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)industryInfoPK);
                    industry = industryInfo.getName();
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return industry;
    }

    protected CurrencyInfo getCurrencyInfo(Context ctx, CompanyOrgUnitInfo companyInfo) {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)companyInfo.getBaseCurrency().getId().toString()));
        CurrencyInfo currencyInfo = null;
        try {
            currencyInfo = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return currencyInfo;
    }

    @Override
    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periodInfo) {
        if (periodInfo == null || periodInfo.size() < 1) {
            return this.file;
        }
        return this.generate(ctx, companyInfo, periodInfo.get(0));
    }
}

