/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IExecutionModeSupport;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessSqlBuilder;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.ProcessorClassNotFoundException;
import com.kingdee.eas.dynbusiness.app.monitor.IExecuteListener;
import com.kingdee.eas.dynbusiness.app.monitor.LogExecuteListener;
import com.kingdee.eas.dynbusiness.app.monitor.ProgressExecuteListener;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ActionListProcessor;
import com.kingdee.eas.dynbusiness.app.processor.BOTBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.GeneralBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessorChainSupport;
import com.kingdee.eas.dynbusiness.app.processor.NoBusinessProcessorChainSupport;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.app.processor.SubmitBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.WritebackBusinessProcessor;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractBusinessProcessorBuilder
implements IBusinessProcessorBuilder {
    protected IBusinessProcessor mainProcessor;
    protected BOSObjectType bosType;
    protected String billTypeID;
    protected BatchActionEnum batchAction;
    protected OrgType mainOrgType;
    protected ExecuteContext executeContext;
    private IBusinessProcessor nestedProcessorTail;
    protected IExecuteListener logListener;
    protected IExecuteListener prgressListener;

    @Override
    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public AbstractBusinessProcessorBuilder(ExecuteContext executeContext) {
        String jobId;
        this.executeContext = executeContext;
        this.bosType = executeContext.getBosType();
        this.batchAction = executeContext.getBatchAction();
        this.billTypeID = executeContext.getBillTypeID();
        this.mainOrgType = executeContext.getMainOrgType();
        if (executeContext.getLogger() != null) {
            this.logListener = new LogExecuteListener(executeContext.getLogger());
        }
        if ((jobId = executeContext.getJobId()) != null && jobId.length() > 0) {
            this.prgressListener = new ProgressExecuteListener(executeContext.getContext(), jobId);
        }
    }

    public AbstractBusinessProcessorBuilder() {
    }

    protected IBusinessProcessorChainSupport createBusinessProcessorChainSupport() {
        return new NoBusinessProcessorChainSupport();
    }

    protected IBusinessProcessor buildAProcessor(Context ctx, Class clzProcessor) throws BOSException {
        if (this.executeContext == null) {
            return this.buildAProcessorNoExeContext(ctx, clzProcessor);
        }
        IBusinessProcessor processor = null;
        try {
            Constructor constructor = clzProcessor.getConstructor(ProcessorConstructParam.class);
            ProcessorConstructParam pcp = new ProcessorConstructParam(this.executeContext, ProcessorExecutionModeEnum.ORDINAL);
            processor = (IBusinessProcessor)constructor.newInstance(pcp);
            processor.addExecuteListener(this.logListener);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            processor = this.buildAProcessorNoProcessorConstructParam(ctx, clzProcessor);
            ((AbstractBusinessProcessor)processor).setExecuteContext(this.executeContext);
            return processor;
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return processor;
    }

    private IBusinessProcessor buildAProcessorNoProcessorConstructParam(Context ctx, Class clzProcessor) throws BOSException {
        if (this.executeContext == null) {
            return this.buildAProcessorNoExeContext(ctx, clzProcessor);
        }
        IBusinessProcessor processor = null;
        try {
            Constructor constructor = clzProcessor.getConstructor(ExecuteContext.class);
            processor = (IBusinessProcessor)constructor.newInstance(this.executeContext);
            processor.addExecuteListener(this.logListener);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            processor = this.buildAProcessorNoExeContext(ctx, clzProcessor);
            ((AbstractBusinessProcessor)processor).setExecuteContext(this.executeContext);
            return processor;
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return processor;
    }

    protected IBusinessProcessor buildAProcessor(Context ctx, String processorClassName) throws BOSException {
        try {
            Class<?> clzProcessor = Class.forName(processorClassName);
            return this.buildAProcessor(ctx, clzProcessor);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessorClassNotFoundException("\u672a\u627e\u5230\u7c7b\u540d\u79f0\u4e3a" + processorClassName + "\u7684\u5904\u7406\u5668");
        }
    }

    protected IBusinessProcessor buildMainProcessor(Context ctx, String processorClassName) throws BOSException {
        this.mainProcessor = this.buildAProcessor(ctx, processorClassName);
        ((IExecutionModeSupport)((Object)this.mainProcessor)).setExecutionMode(ProcessorExecutionModeEnum.MAIN);
        return this.mainProcessor;
    }

    private IBusinessProcessor buildAProcessorNoExeContext(Context ctx, Class clzProcessor) throws BOSException {
        IBusinessProcessor processor = null;
        try {
            Constructor constructor = clzProcessor.getConstructor(Context.class, BOSObjectType.class, BatchActionEnum.class, String.class, OrgType.class);
            processor = (IBusinessProcessor)constructor.newInstance(ctx, this.bosType, this.batchAction, this.billTypeID, this.mainOrgType);
            processor.addExecuteListener(this.logListener);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return processor;
    }

    protected void buildMainProcessor(Context ctx) throws BOSException {
        this.mainOrgType = BusinessProcessUtil.getOrgTypeFromEntity(ctx, this.bosType);
        IBusinessProcessor actionListProcessor = this.buildActionListProcessor(ctx);
        IExecutionModeSupport support = (IExecutionModeSupport)((Object)actionListProcessor);
        if (this.batchAction.equals((Object)BatchActionEnum.SAVE) || this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            if (support == null || support.supportExecutionMode().equals(ProcessorExecutionMode.UNSUPPORT)) {
                this.mainProcessor = this.buildAProcessor(ctx, SubmitBusinessProcessor.class);
                this.mainProcessor.setBusinessChainSupport(this.createBusinessProcessorChainSupport());
            } else {
                this.mainProcessor = actionListProcessor;
            }
        } else {
            this.mainProcessor = this.buildAProcessor(ctx, GeneralBusinessProcessor.class);
            this.mainProcessor.setBusinessChainSupport(this.createBusinessProcessorChainSupport());
        }
        this.nestedProcessorTail = this.mainProcessor;
    }

    protected IBusinessProcessor buildWriteBackProcessor(Context ctx) throws BOSException {
        IBusinessProcessor wbProcessor = null;
        if (this.batchAction.equals((Object)BatchActionEnum.AUDIT) || this.batchAction.equals((Object)BatchActionEnum.UNAUDIT) || this.batchAction.equals((Object)BatchActionEnum.CLOSE)) {
            wbProcessor = this.buildAProcessor(ctx, WritebackBusinessProcessor.class);
        }
        return wbProcessor;
    }

    protected IBusinessProcessor buildBOTBusinessProcessor(Context ctx) throws BOSException {
        IBusinessProcessor botProcessor = null;
        if (this.batchAction.equals((Object)BatchActionEnum.AUDIT) || this.batchAction.equals((Object)BatchActionEnum.TRANSFORM) || this.batchAction.equals((Object)BatchActionEnum.RECEIVE) || this.batchAction.equals((Object)BatchActionEnum.PAY)) {
            botProcessor = this.buildAProcessor(ctx, BOTBusinessProcessor.class);
        }
        return botProcessor;
    }

    protected IBusinessProcessor buildActionListProcessor(Context ctx) throws BOSException {
        IBusinessProcessor processor = null;
        if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            processor = this.buildAProcessor(ctx, ActionListProcessor.class);
        }
        return processor;
    }

    @Override
    public IBusinessProcessor buildProcessor(Context ctx) throws BOSException, EASBizException {
        this.buildMainProcessor(ctx);
        this.assembleProcessor(this.buildWriteBackProcessor(ctx));
        this.assembleProcessor(this.buildBOTBusinessProcessor(ctx));
        return this.mainProcessor;
    }

    public void assembleProcessor(IBusinessProcessor processor) throws BOSException {
        if (processor == null) {
            return;
        }
        ((AbstractBusinessProcessor)processor).setExecuteContext(this.executeContext);
        IExecutionModeSupport support = (IExecutionModeSupport)((Object)processor);
        ProcessorExecutionMode mode = support.supportExecutionMode();
        if (mode.equals(ProcessorExecutionMode.UNSUPPORT)) {
            return;
        }
        if (mode.equals(ProcessorExecutionMode.NESTED)) {
            this.nestedProcessorTail.getBusinessChainSupport().setNestedBusinessProcessor(processor);
            this.nestedProcessorTail = processor;
        } else if (mode.equals(ProcessorExecutionMode.ORDINAL)) {
            this.mainProcessor.getBusinessChainSupport().addPostBusinessProcessor(processor);
        } else if (mode.equals(ProcessorExecutionMode.LOOPNEWTRANS)) {
            this.mainProcessor.getBusinessChainSupport().addPostBusinessProcessor(processor);
        }
        processor.setBusinessChainSupport(this.createBusinessProcessorChainSupport());
    }

    public AbstractBusinessProcessorBuilder(BatchActionEnum action, BOSObjectType type, String typeID) {
        this.batchAction = action;
        this.billTypeID = typeID;
        this.bosType = type;
    }

    public void pushXmlFile(String billTypeId, String xmlFileName) throws BOSException {
        BusinessProcessSqlBuilder.getInstance(null).pushXmlFile(billTypeId, xmlFileName);
    }

    @Override
    public void pushXmlFile(BOSObjectType bosType, String xmlFileName) throws BOSException {
        BusinessProcessSqlBuilder.getInstance(null).pushXmlFile(bosType, xmlFileName);
    }
}

