/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.GeneralBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public final class DynamicBusinessProcessHelper {
    public static BatchActionResults batchExecute(Context ctx, BizController caller, BOSObjectType bosType, String billType, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum, String xmlFileName) throws EASBizException, BOSException {
        IBusinessProcessor processor = DynamicBusinessProcessHelper.buildProcessor(ctx, caller, bosType, billType, batchActionEnum, xmlFileName);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        return processor.execute(batchResults);
    }

    public static void batchExecute(Context ctx, BizController caller, BOSObjectType bosType, String billType, Object[] bills, BatchActionEnum batchActionEnum, String xmlFileName) throws EASBizException, BOSException {
        IBusinessProcessor processor = DynamicBusinessProcessHelper.buildProcessor(ctx, caller, bosType, billType, batchActionEnum, xmlFileName);
        if (processor != null) {
            BatchActionResults batchResults = BatchActionResults.populateActionResults((Object[])bills);
            batchResults = processor.execute(batchResults);
            batchResults.throwExceptions();
        }
    }

    public static BatchActionResults batchExecute(Context ctx, BizController caller, IBusinessProcessorBuilder builder, BatchExecuteParamsEntry[] entries, String xmlFileName) throws EASBizException, BOSException {
        IBusinessProcessor processor = DynamicBusinessProcessHelper.buildProcessor(ctx, caller, builder, xmlFileName);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        return processor.execute(batchResults);
    }

    public static BatchActionResults batchExecute(ExecuteContext executeContext, IBusinessProcessorBuilder builder) throws EASBizException, BOSException {
        IBusinessProcessor processor = DynamicBusinessProcessHelper.buildProcessor(executeContext.getContext(), executeContext.getCaller(), builder, executeContext.getXmlFileName());
        BatchActionResults batchResults = executeContext.populateActionResults();
        batchResults.setAddedSelector(executeContext.getAddedSelector());
        return processor.execute(batchResults);
    }

    public static void batchExecute(Context ctx, BizController caller, IBusinessProcessorBuilder builder, Object[] bills, String xmlFileName) throws EASBizException, BOSException {
        DynamicBusinessProcessHelper.batchExecute(ctx, caller, builder, bills, xmlFileName, true);
    }

    public static BatchActionResults batchExecute(Context ctx, BizController caller, IBusinessProcessorBuilder builder, Object[] bills, String xmlFileName, boolean isThrowException) throws EASBizException, BOSException {
        IBusinessProcessor processor = DynamicBusinessProcessHelper.buildProcessor(ctx, caller, builder, xmlFileName);
        if (processor != null) {
            BatchActionResults batchResults = BatchActionResults.populateActionResults((Object[])bills);
            batchResults = processor.execute(batchResults);
            if (isThrowException) {
                batchResults.throwExceptions();
            }
            return batchResults;
        }
        return null;
    }

    public static void batchExecute(Context ctx, BizController caller, IBusinessProcessorBuilder builder, IObjectCollection collection, String xmlFileName) throws EASBizException, BOSException {
        IBusinessProcessor processor = DynamicBusinessProcessHelper.buildProcessor(ctx, caller, builder, xmlFileName);
        if (processor != null) {
            BatchActionResults batchResults = BatchActionResults.populateActionResults((Object[])collection.toArray());
            batchResults.setObjCollection(collection);
            batchResults = processor.execute(batchResults);
            batchResults.throwExceptions();
        }
    }

    public static BatchActionResults batchExecuteWithVOLoad(Context ctx, BizController caller, IBusinessProcessorBuilder builder, BatchExecuteParamsEntry[] entries, String xmlFileName) throws EASBizException, BOSException {
        IBusinessProcessor processor = DynamicBusinessProcessHelper.buildProcessor(ctx, caller, builder, xmlFileName);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        if (entries != null && entries.length > 0) {
            if (entries[0].get(0) instanceof IObjectValue) {
                IObjectCollection collection = BusinessProcessUtil.getCollectionInstance(ctx, builder.getBosType());
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    IObjectValue objValue = (IObjectValue)entries[i].get(0);
                    collection.addObject(objValue);
                }
                batchResults.setObjCollection(collection);
            }
            batchResults.setParamEntries(entries);
        }
        return processor.execute(batchResults);
    }

    public static BatchActionResults batchHandle(Context ctx, String bosType, IBusinessBatchHandle handler, Object[] bills) throws EASBizException, BOSException {
        if (bills == null || bills.length == 0) {
            return null;
        }
        BatchActionResults batchResults = BatchActionResults.populateActionResults((Object[])bills);
        IObjectCollection collection = BusinessProcessUtil.getCollectionInstance(ctx, BOSObjectType.create((String)bosType));
        int size = bills.length;
        for (int i = 0; i < size; ++i) {
            if (!(bills[i] instanceof IObjectValue)) continue;
            IObjectValue objValue = (IObjectValue)bills[i];
            collection.addObject(objValue);
        }
        batchResults.setObjCollection(collection);
        handler.handle(ctx, batchResults);
        batchResults.throwExceptions();
        return batchResults;
    }

    private static IBusinessProcessor buildProcessor(Context ctx, BizController caller, BOSObjectType bosType, String billType, BatchActionEnum batchActionEnum, String xmlFileName) throws BOSException, EASBizException {
        GeneralBusinessProcessorBuilder builder = new GeneralBusinessProcessorBuilder(batchActionEnum, bosType, billType);
        return DynamicBusinessProcessHelper.buildProcessor(ctx, caller, builder, xmlFileName);
    }

    private static IBusinessProcessor buildProcessor(Context ctx, BizController caller, IBusinessProcessorBuilder builder, String xmlFileName) throws BOSException, EASBizException {
        IBusinessProcessor processor;
        if (xmlFileName != null) {
            builder.pushXmlFile(builder.getBosType(), xmlFileName);
        }
        if ((processor = builder.buildProcessor(ctx)) != null && caller instanceof IBatchExecute) {
            processor.setBatchExecutor((IBatchExecute)caller);
        }
        return processor;
    }
}

