/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.config.BusinessResource;
import com.kingdee.eas.dynbusiness.config.ColumnPair;
import com.kingdee.eas.dynbusiness.config.OneToManyWriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.dynbusiness.util.ObjectListMap;
import com.kingdee.eas.dynbusiness.util.ResourceUtils;
import com.kingdee.eas.dynbusiness.util.SqlBuilderHelper;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OneToManyWriteBackHandler
implements IBusinessBatchHandle {
    private OneToManyWriteBackSubItem wbItem;

    public OneToManyWriteBackHandler(OneToManyWriteBackSubItem wbItem) {
        this.wbItem = wbItem;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        Object[] idsArray;
        if (this.wbItem.getSrcBosTypes() == null) {
            throw new IllegalArgumentException("\u8bf7\u5728\u53cd\u5199\u914d\u7f6e\u4e2d\u63d0\u4f9b\u6e90\u5355\u7684BOSType.");
        }
        String sql = null;
        Object[] dstEntryIds = null;
        IRowSet rsDst = null;
        String srcBillTypeId = (String)this.wbItem.getSrcBillIds().get(this.wbItem.getSrcBillIds().size() - 1);
        Object[] params = idsArray = batchResults.getToDoIdsArray();
        String bindMarks = DBUtil.getBindMarks(idsArray.length);
        sql = this.wbItem.getObtainSrcIdSql();
        sql = sql.replaceAll("\\?\\?\\?", bindMarks);
        Object[] thisParams = new Object[params.length + 1];
        System.arraycopy(params, 0, thisParams, 0, params.length);
        thisParams[thisParams.length - 1] = this.wbItem.getSrcBosTypes()[0];
        IRowSet rs = DBUtil.executeQuery(ctx, sql, thisParams);
        if (rs.size() == 0) {
            return;
        }
        try {
            Object[] srcEntryIds = rs.toCollection(1).toArray();
            dstEntryIds = rs.toCollection(2).toArray();
            SqlBuilderHelper.lockSrcBillEntryInWriteBack(ctx, this.wbItem.getLockSourceTableSql(), srcEntryIds, srcBillTypeId, this.wbItem.getDstBillTypeId());
            sql = this.wbItem.getObtainSrcTableDataSql();
            bindMarks = DBUtil.getBindMarks(srcEntryIds.length);
            sql = sql.replaceAll("\\?\\?\\?", bindMarks);
            IRowSet rsSrc = DBUtil.executeQuery(ctx, sql, srcEntryIds);
            sql = this.wbItem.getObtainDstTableDataSql();
            bindMarks = DBUtil.getBindMarks(dstEntryIds.length);
            sql = sql.replaceAll("\\?\\?\\?", bindMarks);
            rsDst = DBUtil.executeQuery(ctx, sql, dstEntryIds);
            ArrayList srcEntryIdList = new ArrayList(srcEntryIds.length);
            srcEntryIdList.addAll(rs.toCollection(1));
            Object[][] dataDistributed = this.handleSrcDataVerification(ctx, batchResults, rsSrc, rsDst, dstEntryIds, srcEntryIdList);
            IRowSet rsOld = null;
            if (BusinessProcessorHelper.isDebug() && this.wbItem.getDebugSql() != null) {
                sql = this.wbItem.getDebugSql();
                sql = sql.replaceAll("\\?\\?\\?", bindMarks);
                rsOld = DBUtil.executeQuery(ctx, sql, params);
            }
            this.handleSrcWriteBack(ctx, dataDistributed, rsSrc);
            HashSet set = new HashSet();
            set.addAll(rsSrc.toCollection(1));
            String[] srcIds = new String[set.size()];
            System.arraycopy(set.toArray(), 0, srcIds, 0, srcIds.length);
            String[] entryIds = new String[srcEntryIds.length];
            System.arraycopy(srcEntryIds, 0, entryIds, 0, entryIds.length);
            if (this.wbItem.getWritebackStatusItems() != null) {
                for (int i = 0; i < this.wbItem.getWritebackStatusItems().length; ++i) {
                    this.wbItem.getWritebackStatusItems()[i].getUpdateStatusHander(ctx, srcIds, entryIds).handle(ctx, batchResults);
                }
            }
            if (BusinessProcessorHelper.isDebug() && this.wbItem.getDebugSql() != null) {
                sql = this.wbItem.getDebugSql();
                sql = sql.replaceAll("\\?\\?\\?", bindMarks);
                IRowSet rsNew = DBUtil.executeQuery(ctx, sql, params);
                BusinessProcessorHelper.debugWriteBack(ctx, rsOld, rsNew, srcBillTypeId, this.wbItem.getDstBillTypeId());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void handleSrcWriteBack(Context ctx, Object[][] dataDistributed, IRowSet rsSrc) throws SQLException, BOSException {
        boolean hasRow = rsSrc.first();
        int size = this.wbItem.getColumnPairs().size();
        int[] idxColumns = new int[size];
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)this.wbItem.getColumnPairs().get(i);
            idxColumns[i] = rsSrc.findColumn(pair.getSrcColumn());
        }
        ArrayList<Object[]> batchParamList = new ArrayList<Object[]>();
        int idxOfRow = 0;
        while (hasRow) {
            if (!((Boolean)dataDistributed[idxOfRow][dataDistributed[idxOfRow].length - 1]).booleanValue()) {
                hasRow = rsSrc.next();
                continue;
            }
            Object[] aparam = new Object[size + 1];
            for (int i = 0; i < idxColumns.length; ++i) {
                aparam[i] = dataDistributed[idxOfRow][idxColumns[i] - 1];
            }
            aparam[size] = rsSrc.getString(2);
            batchParamList.add(aparam);
            ++idxOfRow;
            hasRow = rsSrc.next();
        }
        int count = batchParamList.size();
        Object[][] batchParams = new Object[count][size + 1];
        Iterator iter = batchParamList.iterator();
        int idx = 0;
        while (iter.hasNext()) {
            Object[] aparam = (Object[])iter.next();
            batchParams[idx++] = aparam;
        }
        DBUtil.executeBatch(ctx, this.wbItem.getWriteBackOneByOneSql(), batchParams);
    }

    private Object[][] handleSrcDataVerification(Context ctx, BatchActionResults batchResults, IRowSet rsSrc, IRowSet rsDst, Object[] dstEntryIds, List srcEntryIdList) throws SQLException {
        Object[][] dataDst;
        Object[][] dataSrc;
        ObjectListMap pairMap = this.wbItem.getVerificationPairs();
        String[] verifications = new String[pairMap.size()];
        pairMap.keySet().toArray(verifications);
        HashSet errorEntryIdSet = new HashSet();
        int[] idxVerifications = new int[verifications.length];
        for (int i = 0; i < verifications.length; ++i) {
            idxVerifications[i] = rsSrc.findColumn(verifications[i]);
        }
        do {
            dataSrc = this.populateRowSet(rsSrc);
            dataDst = this.populateRowSet(rsDst, errorEntryIdSet);
            this.distributeATurn(rsSrc, rsDst, srcEntryIdList, dstEntryIds, pairMap, verifications, dataSrc, dataDst, idxVerifications, false);
            this.distributeATurn(rsSrc, rsDst, srcEntryIdList, dstEntryIds, pairMap, verifications, dataSrc, dataDst, idxVerifications, true);
        } while (this.findViolateVerification(ctx, batchResults, rsDst, dataSrc, dataDst, verifications, pairMap, errorEntryIdSet));
        return dataSrc;
    }

    private void distributeATurn(IRowSet rsSrc, IRowSet rsDst, List srcEntryIdList, Object[] dstEntryIds, ObjectListMap pairMap, String[] verifications, Object[][] dataSrc, Object[][] dataDst, int[] idxVerifications, boolean isPositive) throws SQLException {
        for (int idxOfRow = 0; idxOfRow < dataSrc.length; ++idxOfRow) {
            for (int idxOfVf = 0; idxOfVf < idxVerifications.length; ++idxOfVf) {
                BigDecimal valVerification = (BigDecimal)dataSrc[idxOfRow][idxVerifications[idxOfVf] - 1];
                if (!isPositive) {
                    this.distributeARow(false, rsSrc, rsDst, srcEntryIdList, dstEntryIds, pairMap, verifications[idxOfVf], valVerification, dataSrc[idxOfRow], dataDst);
                    continue;
                }
                this.distributeARow(true, rsSrc, rsDst, srcEntryIdList, dstEntryIds, pairMap, verifications[idxOfVf], valVerification, dataSrc[idxOfRow], dataDst);
            }
        }
    }

    private Object[][] populateRowSet(IRowSet rs) throws SQLException {
        rs.last();
        int cntColumn = rs.getMetaData().getColumnCount();
        int idx = 0;
        Object[][] datas = new Object[rs.getRow()][cntColumn + 1];
        boolean hasRow = rs.first();
        while (hasRow) {
            for (int i = 1; i <= cntColumn; ++i) {
                datas[idx][i - 1] = rs.getObject(i);
            }
            datas[idx][cntColumn] = Boolean.FALSE;
            ++idx;
            hasRow = rs.next();
        }
        return datas;
    }

    private Object[][] populateRowSet(IRowSet rs, Set errorEntryIdSet) throws SQLException {
        rs.last();
        int cntColumn = rs.getMetaData().getColumnCount();
        int idx = 0;
        Object[][] datas = new Object[rs.getRow() - errorEntryIdSet.size()][cntColumn];
        boolean hasRow = rs.first();
        while (hasRow) {
            String id = rs.getString(2);
            if (errorEntryIdSet.contains(id)) {
                hasRow = rs.next();
                continue;
            }
            for (int i = 1; i <= cntColumn; ++i) {
                datas[idx][i - 1] = rs.getObject(i);
            }
            ++idx;
            hasRow = rs.next();
        }
        return datas;
    }

    private boolean findViolateVerification(Context ctx, BatchActionResults batchResults, IRowSet rsDst, Object[][] dataSrc, Object[][] dataDst, String[] verifications, ObjectListMap pairMap, Set errorEntryIdSet) throws SQLException {
        int idxOfRow;
        boolean result = false;
        HashSet<String> errorIdSet = new HashSet<String>();
        int[] idxDstColumns = new int[verifications.length];
        for (int i = 0; i < verifications.length; ++i) {
            ColumnPair pair = (ColumnPair)pairMap.get(verifications[i], 0);
            idxDstColumns[i] = rsDst.findColumn(pair.getDstColumn().getName()) - 1;
        }
        String msgEntry = ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", "ENTRY");
        block1: for (idxOfRow = 0; idxOfRow < dataDst.length; ++idxOfRow) {
            for (int idxOfCol = 0; idxOfCol < idxDstColumns.length; ++idxOfCol) {
                BigDecimal valWriteBack = (BigDecimal)dataDst[idxOfRow][idxDstColumns[idxOfCol]];
                if (this.isZero(valWriteBack)) continue;
                String id = (String)dataDst[idxOfRow][0];
                errorIdSet.add(id);
                result = true;
                ColumnPair pair = (ColumnPair)pairMap.get(verifications[idxOfCol], 0);
                BusinessResource resource = pair.getResource();
                batchResults.addError(id, resource.getMessage(ctx, msgEntry + dataDst[idxOfRow][2].toString()));
                continue block1;
            }
        }
        for (idxOfRow = 0; idxOfRow < dataDst.length; ++idxOfRow) {
            String id = (String)dataDst[idxOfRow][0];
            if (!errorIdSet.contains(id)) continue;
            String entryId = (String)dataDst[idxOfRow][1];
            errorEntryIdSet.add(entryId);
        }
        return result;
    }

    private void distributeARow(boolean isPositive, IRowSet rsSrc, IRowSet rsDst, List srcEntryIdList, Object[] dstEntryIds, ObjectListMap pairMap, String verification, BigDecimal valVerification, Object[] aRowSrc, Object[][] dataDst) throws SQLException {
        ColumnPair pair = (ColumnPair)pairMap.get(verification, 0);
        ColumnPair otherPair = (ColumnPair)pairMap.get(verification, 1);
        String sign = pair.getCalculation();
        int idxSrcColumn = rsSrc.findColumn(pair.getSrcColumn()) - 1;
        int idxDstColumn = rsDst.findColumn(pair.getDstColumn().getName()) - 1;
        int idxSrcOtherColumn = 0;
        int idxDstOtherColumn = 0;
        if (otherPair != null) {
            idxSrcOtherColumn = rsSrc.findColumn(otherPair.getSrcColumn()) - 1;
            idxDstOtherColumn = rsDst.findColumn(otherPair.getDstColumn().getName()) - 1;
        }
        boolean isPlus = sign.equals("+");
        BigDecimal valUnDistribute = valVerification.subtract((BigDecimal)aRowSrc[idxSrcColumn]);
        if (isPositive) {
            // empty if block
        }
        String srcEntryId = (String)aRowSrc[1];
        int idx = srcEntryIdList.indexOf(srcEntryId);
        String dstEntryId = (String)dstEntryIds[idx];
        for (int idxOfDst = 0; idxOfDst < dataDst.length; ++idxOfDst) {
            BigDecimal valRestDistribute;
            BigDecimal valWriteBack;
            if (!dataDst[idxOfDst][1].equals(dstEntryId) || this.isZero(valWriteBack = (BigDecimal)dataDst[idxOfDst][idxDstColumn])) continue;
            if (!isPlus) {
                valWriteBack = valWriteBack.negate();
            }
            if (this.isZero(valRestDistribute = valWriteBack.subtract(valUnDistribute))) {
                aRowSrc[idxSrcColumn] = valVerification;
                dataDst[idxOfDst][idxDstColumn] = SysConstant.BIGZERO;
                this.handleTransform(rsSrc, rsDst, otherPair, idxSrcOtherColumn, idxDstOtherColumn, valUnDistribute, false, isPlus, aRowSrc, dataDst[idxOfDst]);
                aRowSrc[aRowSrc.length - 1] = Boolean.TRUE;
                return;
            }
            if (this.isSameSign(valUnDistribute, valRestDistribute)) {
                aRowSrc[idxSrcColumn] = valVerification;
                dataDst[idxOfDst][idxDstColumn] = valRestDistribute;
                this.handleTransform(rsSrc, rsDst, otherPair, idxSrcOtherColumn, idxDstOtherColumn, valUnDistribute, true, isPlus, aRowSrc, dataDst[idxOfDst]);
            } else {
                aRowSrc[idxSrcColumn] = valWriteBack.add((BigDecimal)aRowSrc[idxSrcColumn]);
                dataDst[idxOfDst][idxDstColumn] = SysConstant.BIGZERO;
                this.handleTransform(rsSrc, rsDst, otherPair, idxSrcOtherColumn, idxDstOtherColumn, valUnDistribute, false, isPlus, aRowSrc, dataDst[idxOfDst]);
            }
            aRowSrc[aRowSrc.length - 1] = Boolean.TRUE;
        }
    }

    private void handleTransform(IRowSet rsSrc, IRowSet rsDst, ColumnPair otherPair, int idxSrcOtherColumn, int idxDstOtherColumn, BigDecimal valUnDistribute, boolean isPartial, boolean isPlus, Object[] aRowSrc, Object[] aRowDst) throws SQLException {
        if (otherPair == null) {
            return;
        }
        if (otherPair.getType().equals(ColumnDataType.AMOUNT)) {
            if (isPartial) {
                BigDecimal result;
                String columnRate = this.wbItem.getPolicy().getExchangeRate().getName();
                int idxColumnRate = rsSrc.findColumn(columnRate) - 1;
                BigDecimal exchangeRate = (BigDecimal)aRowSrc[idxColumnRate];
                String columnMode = this.wbItem.getPolicy().getConvertMode().getName();
                int idxColumnMode = rsSrc.findColumn(columnMode);
                int convertMode = (Integer)aRowSrc[idxColumnMode];
                int idxPrecision = rsSrc.findColumn("amountPrecision");
                int precision = (Integer)aRowSrc[idxPrecision];
                if (convertMode == 0) {
                    result = valUnDistribute.multiply(exchangeRate);
                    result = result.setScale(precision, 0);
                } else {
                    result = valUnDistribute.divide(exchangeRate, precision, 0);
                }
                aRowSrc[idxSrcOtherColumn] = result.add((BigDecimal)aRowSrc[idxSrcOtherColumn]);
                aRowDst[idxDstOtherColumn] = isPlus ? ((BigDecimal)aRowDst[idxDstOtherColumn]).subtract(result) : ((BigDecimal)aRowDst[idxDstOtherColumn]).add(result);
            } else {
                aRowSrc[idxSrcOtherColumn] = isPlus ? ((BigDecimal)aRowSrc[idxSrcOtherColumn]).add((BigDecimal)aRowDst[idxDstOtherColumn]) : ((BigDecimal)aRowSrc[idxSrcOtherColumn]).subtract((BigDecimal)aRowDst[idxDstOtherColumn]);
                aRowDst[idxDstOtherColumn] = SysConstant.BIGZERO;
            }
        }
    }

    private boolean isZeroOrPositive(BigDecimal value) {
        int result = value.compareTo(SysConstant.BIGZERO);
        return result == 0 || result == 1;
    }

    private boolean isZeroOrNegative(BigDecimal value) {
        int result = value.compareTo(SysConstant.BIGZERO);
        return result == 0 || result == -1;
    }

    private boolean isZero(BigDecimal value) {
        int result = value.compareTo(SysConstant.BIGZERO);
        return result == 0;
    }

    private boolean isSameSign(BigDecimal value1, BigDecimal value2) {
        return value1.signum() == value2.signum();
    }
}

