/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.config.OneToOneWriteBackSubItem;
import com.kingdee.eas.dynbusiness.config.TableCheckConfigItems;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class OneToOneWriteBackHandler
implements IBusinessBatchHandle {
    private OneToOneWriteBackSubItem wbItem;
    private String action;

    public OneToOneWriteBackHandler(OneToOneWriteBackSubItem wbItem, String action) {
        this.wbItem = wbItem;
        this.action = action;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String srcBillTypeId;
        String bindMarks;
        Object[] params;
        Object[] idsArray;
        IRowSet rsNew;
        IRowSet rsOld;
        String sql;
        String dstTableName;
        String idTableName2;
        String idTableName;
        String tablename;
        block16: {
            block15: {
                int row;
                block14: {
                    block13: {
                        tablename = null;
                        idTableName = null;
                        idTableName2 = null;
                        dstTableName = null;
                        sql = null;
                        rsOld = null;
                        rsNew = null;
                        idsArray = batchResults.getToDoIdsArray();
                        if (idsArray.length == 0) {
                            return;
                        }
                        params = idsArray;
                        bindMarks = DBUtil.getBindMarks(idsArray.length);
                        if (this.wbItem.getLevel() == 1) {
                            idTableName = DBUtil.createTempTable(ctx, "CREATE TABLE ID_TEMP_TABLE (FID VARCHAR(44),FEntryID VARCHAR(44), FDstID VARCHAR(44))");
                        } else {
                            idTableName = DBUtil.createTempTable(ctx, "CREATE TABLE ID_TEMP_TABLE (FID VARCHAR(44),FEntryID VARCHAR(44), FDstID VARCHAR(44), FSrc0EntryID VARCHAR(44))");
                            idTableName2 = DBUtil.createTempTable(ctx, this.wbItem.getIdTempTableSql2());
                        }
                        srcBillTypeId = (String)this.wbItem.getSrcBillIds().get(this.wbItem.getSrcBillIds().size() - 1);
                        row = this.obtainSourceIds(ctx, srcBillTypeId, bindMarks, params, idTableName, idTableName2);
                        if (BusinessProcessorHelper.isDebug()) {
                            String debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
                            BusinessProcessorHelper.outpurtDebug(debugString + "[\u83b7\u5f97\u6e90\u5355\u5206\u5f55]\u6210\u529f\u83b7\u5f97" + row + "\u884c");
                        }
                        if (row != 0) break block13;
                        DBUtil.releaseTempTable(ctx, idTableName);
                        DBUtil.releaseTempTable(ctx, tablename);
                        DBUtil.releaseTempTable(ctx, dstTableName);
                        DBUtil.releaseTempTable(ctx, idTableName2);
                        return;
                    }
                    IRowSet rs = DBUtil.executeQuery(ctx, "SELECT DISTINCT FID FROM @IDTABLE".replaceFirst("@IDTABLE", idTableName), null);
                    if (rs.size() != 0) break block14;
                    DBUtil.releaseTempTable(ctx, idTableName);
                    DBUtil.releaseTempTable(ctx, tablename);
                    DBUtil.releaseTempTable(ctx, dstTableName);
                    DBUtil.releaseTempTable(ctx, idTableName2);
                    return;
                }
                row = this.lockSrcBillEntryInWriteBack(ctx, srcBillTypeId, this.wbItem.getDstBillTypeId(), idTableName);
                if (row != 0) break block15;
                DBUtil.releaseTempTable(ctx, idTableName);
                DBUtil.releaseTempTable(ctx, tablename);
                DBUtil.releaseTempTable(ctx, dstTableName);
                DBUtil.releaseTempTable(ctx, idTableName2);
                return;
            }
            dstTableName = this.prepareDstData(ctx, srcBillTypeId, bindMarks, params, idTableName);
            tablename = this.prepareWriteBackData(ctx, srcBillTypeId, dstTableName);
            rsOld = this.fetchSourceData(ctx, srcBillTypeId, bindMarks, params);
            idsArray = this.checkBeforeWritingback(ctx, batchResults, (String[])idsArray, tablename);
            if (idsArray != null && idsArray.length != 0) break block16;
            DBUtil.releaseTempTable(ctx, idTableName);
            DBUtil.releaseTempTable(ctx, tablename);
            DBUtil.releaseTempTable(ctx, dstTableName);
            DBUtil.releaseTempTable(ctx, idTableName2);
            return;
        }
        try {
            this.doWritingback(ctx, srcBillTypeId, (String[])idsArray, tablename, idTableName);
            this.updateSrcBillStatus(ctx, batchResults, (String[])idsArray, idTableName);
            rsNew = this.fetchSourceData(ctx, srcBillTypeId, bindMarks, params);
            if (rsOld != null && rsNew != null) {
                BusinessProcessorHelper.debugWriteBack(ctx, rsOld, rsNew, srcBillTypeId, this.wbItem.getDstBillTypeId());
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage() + "\r\nThe SQL is:" + sql);
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable(ctx, idTableName);
                DBUtil.releaseTempTable(ctx, tablename);
                DBUtil.releaseTempTable(ctx, dstTableName);
                DBUtil.releaseTempTable(ctx, idTableName2);
                throw throwable;
            }
        }
        DBUtil.releaseTempTable(ctx, idTableName);
        DBUtil.releaseTempTable(ctx, tablename);
        DBUtil.releaseTempTable(ctx, dstTableName);
        DBUtil.releaseTempTable(ctx, idTableName2);
    }

    private IRowSet fetchSourceData(Context ctx, String srcBillTypeId, String bindMarks, Object[] params) throws BOSException {
        if (!BusinessProcessorHelper.isDebug()) {
            return null;
        }
        String sql = this.wbItem.getDebugSql();
        sql = sql.replaceAll("\\?\\?\\?", bindMarks);
        return DBUtil.executeQuery(ctx, sql, params);
    }

    private int obtainSourceIds(Context ctx, String srcBillTypeId, String bindMarks, Object[] params, String idTableName, String idTableName2) throws BOSException {
        String sql = null;
        int level = this.wbItem.getLevel();
        if (level > 1) {
            int row;
            sql = this.wbItem.getCreateObtain2SrcIdSql();
            sql = sql.replaceFirst("@IDTABLE", idTableName2);
            sql = sql.replaceAll("\\?\\?\\?", bindMarks);
            if (BusinessProcessorHelper.isDebug()) {
                String debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
                BusinessProcessorHelper.debugSql(debugString + "[\u83b7\u5f97\u6e90\u5355\u5206\u5f55:\u4e8c\u7ea7\u53cd\u5199\u4e2d\u95f4\u8868]", sql, params);
            }
            if ((row = DBUtil.executeUpdate(ctx, sql, params)) == 0) {
                return 0;
            }
        }
        sql = this.wbItem.getObtainSrcIdSql();
        sql = sql.replaceFirst("@IDTABLE", idTableName);
        if (level > 1) {
            sql = sql.replaceFirst("@IDTABLE", idTableName2);
            if (BusinessProcessorHelper.isDebug()) {
                String debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
                BusinessProcessorHelper.debugSql(debugString + "[\u83b7\u5f97\u6e90\u5355\u5206\u5f55]", sql, null);
            }
            return DBUtil.executeUpdate(ctx, sql, null);
        }
        sql = sql.replaceAll("\\?\\?\\?", bindMarks);
        boolean hasFSourceBillTypeIdColumn = false;
        if (level == 1) {
            hasFSourceBillTypeIdColumn = this.wbItem.getParent().getFldSrcTypeId() != null;
        }
        level = level > 1 || hasFSourceBillTypeIdColumn ? 1 : 0;
        Object[] thisParams = new Object[params.length + level];
        System.arraycopy(params, 0, thisParams, 0, params.length);
        if (level == 1) {
            thisParams[thisParams.length - 1] = srcBillTypeId;
        }
        if (BusinessProcessorHelper.isDebug()) {
            String debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
            BusinessProcessorHelper.debugSql(debugString + "[\u83b7\u5f97\u6e90\u5355\u5206\u5f55]", sql, thisParams);
        }
        return DBUtil.executeUpdate(ctx, sql, thisParams);
    }

    private int lockSrcBillEntryInWriteBack(Context ctx, String srcBillTypeId, String dstBillTypeId, String idTableName) throws BOSException {
        String debugString = null;
        String sql = this.wbItem.getLockSourceTableSql();
        sql = sql.replaceFirst("@IDTABLE", idTableName);
        int cntrow = DBUtil.executeUpdate(ctx, sql, null);
        if (BusinessProcessorHelper.isDebug()) {
            debugString = BusinessProcessorHelper.getBillName(ctx, dstBillTypeId) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
            BusinessProcessorHelper.debugSql(debugString + "[\u9501\u6e90\u5355]", sql, null);
            BusinessProcessorHelper.outpurtDebug("\u6210\u529f\u9501\u5b9a" + cntrow + "\u884c");
        }
        return cntrow;
    }

    private String prepareWriteBackData(Context ctx, String srcBillTypeId, String dstTableName) throws BOSException {
        String sql = this.wbItem.getCreateTempTableSql();
        String tablename = this.action + this.wbItem.getParent().getParent().getBosType();
        sql = sql.replaceFirst("@TABLE", tablename);
        tablename = DBUtil.createTempTable(ctx, sql);
        sql = this.wbItem.getInsertWriteBackDataSql();
        sql = sql.replaceFirst("@TABLE", tablename);
        sql = sql.replaceFirst("@TABLE", dstTableName);
        if (BusinessProcessorHelper.isDebug()) {
            String debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
            BusinessProcessorHelper.debugSql(debugString + "[\u63d2\u5165\u4e34\u65f6\u8868]", sql, null);
        }
        DBUtil.executeUpdate(ctx, sql, null);
        return tablename;
    }

    private String prepareDstData(Context ctx, String srcBillTypeId, String bindMarks, Object[] params, String idTableName2) throws BOSException {
        Object[] thisParams;
        String debugString;
        String sql = this.wbItem.getCreateDstDataTempTableSql();
        String tablename = this.action + this.wbItem.getParent().getParent().getBosType();
        sql = sql.replaceFirst("@TABLE", tablename);
        if (BusinessProcessorHelper.isDebug()) {
            debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
            BusinessProcessorHelper.debugSql(debugString + "[\u521b\u5efa\u76ee\u6807\u7edf\u8ba1\u6570\u636e\u4e34\u65f6\u8868]", sql, null);
        }
        tablename = DBUtil.createTempTable(ctx, sql);
        sql = this.wbItem.getInsertDstDataTempTableSql();
        sql = sql.replaceFirst("@TABLE", tablename);
        if (this.wbItem.getLevel() > 1) {
            sql = sql.replaceFirst("@IDTABLE", idTableName2);
            if (BusinessProcessorHelper.isDebug()) {
                debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
                BusinessProcessorHelper.debugSql(debugString + "[\u63d2\u5165\u76ee\u6807\u7edf\u8ba1\u6570\u636e\u4e34\u65f6\u8868]", sql, null);
            }
            DBUtil.executeUpdate(ctx, sql, null);
            return tablename;
        }
        sql = sql.replaceAll("\\?\\?\\?", bindMarks);
        if (!this.wbItem.isAlerting()) {
            thisParams = params;
        } else {
            thisParams = new Object[params.length * 2];
            System.arraycopy(params, 0, thisParams, 0, params.length);
            System.arraycopy(params, 0, thisParams, params.length, params.length);
        }
        if (BusinessProcessorHelper.isDebug()) {
            String debugString2 = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
            BusinessProcessorHelper.debugSql(debugString2 + "[\u63d2\u5165\u76ee\u6807\u7edf\u8ba1\u6570\u636e\u4e34\u65f6\u8868]", sql, thisParams);
        }
        DBUtil.executeUpdate(ctx, sql, thisParams);
        return tablename;
    }

    private String[] checkBeforeWritingback(Context ctx, BatchActionResults batchResults, String[] idsArray, String tablename) throws EASBizException, BOSException {
        if (this.wbItem.getCheckItems() == null) {
            return idsArray;
        }
        ((TableCheckConfigItems)this.wbItem.getCheckItems()).getBusinessCheckHandler(tablename).handle(ctx, batchResults);
        return batchResults.getToDoIdsArray();
    }

    private void doWritingback(Context ctx, String srcBillTypeId, String[] idsArray, String tablename, String idTableName) throws BOSException {
        String sql = this.wbItem.getWriteBackWithTempTableSql();
        sql = sql.replaceFirst("@TABLE", tablename);
        sql = sql.replaceFirst("@IDTABLE", idTableName);
        sql = sql.replaceAll("\\?\\?\\?", DBUtil.getBindMarks(idsArray.length));
        if (BusinessProcessorHelper.isDebug()) {
            String debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
            BusinessProcessorHelper.debugSql(debugString + "[\u53cd\u5199]", sql, idsArray);
        }
        int row = DBUtil.executeUpdate(ctx, sql, idsArray);
        if (BusinessProcessorHelper.isDebug()) {
            String debugString = BusinessProcessorHelper.getBillName(ctx, this.wbItem.getDstBillTypeId()) + "\u53cd\u5199" + BusinessProcessorHelper.getBillName(ctx, srcBillTypeId);
            BusinessProcessorHelper.outpurtDebug(debugString + "[\u53cd\u5199]\u6210\u529f\u53cd\u5199" + row + "\u884c");
        }
    }

    private void updateSrcBillStatus(Context ctx, BatchActionResults batchResults, String[] idsArray, String idTableName) throws EASBizException, BOSException {
        if (this.wbItem.getWritebackStatusItems() == null) {
            return;
        }
        for (int i = 0; i < this.wbItem.getWritebackStatusItems().length; ++i) {
            this.wbItem.getWritebackStatusItems()[i].getUpdateStatusHander(ctx, idsArray, null, idTableName).handle(ctx, batchResults);
        }
    }
}

