/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.IPreBatchFetch;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessResource;
import com.kingdee.eas.dynbusiness.config.Property;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ObjectListMap;
import com.kingdee.eas.dynbusiness.util.ResourceUtils;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PropertyCheckHandler
implements IBusinessBatchHandle {
    private final PropertyCheckConfigItems items;
    private BOSObjectType bosType;
    private String action;
    private String billTypeID;
    private static final String ENTRY = "_ENTRY.";

    public PropertyCheckHandler(PropertyCheckConfigItems items, BOSObjectType bosType, String action, String billTypeID) {
        this.items = items;
        this.bosType = bosType;
        this.action = action;
        this.billTypeID = billTypeID;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (this.items.getCheckItems() != null && this.items.getCheckItems().size() == 0) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null) {
            BusinessProcessConfigItem bpci;
            if (this.items.getParent() instanceof BusinessProcessConfigItem && (bpci = (BusinessProcessConfigItem)this.items.getParent()).getAddedSelector() != null) {
                batchResults.setAddedSelector(bpci.getAddedSelector());
            }
            BusinessProcessorHelper.batchLoadBizObjects(ctx, this.bosType, this.action, this.billTypeID, batchResults);
            collection = batchResults.getObjCollection();
        }
        if (collection == null || collection.size() == 0) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("_CTX", ctx);
        String entriesName = BusinessProcessUtil.getEntityEntriesName(ctx, this.bosType);
        paramMap.put("_ENTRISENAME", entriesName);
        List preConds = this.items.getPreConditions();
        if (preConds != null) {
            for (Conditions preCond : preConds) {
                paramMap.put(preCond.getId(), preCond);
            }
        }
        this.preBatchFetch(collection, this.items.getPreFetchItems(), paramMap);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.validation(collection.getObject(i), batchResults, this.items.getMapCheckItems(ctx), paramMap);
        }
    }

    private void preBatchFetch(IObjectCollection collection, List preFetchItems, Map paramMap) throws EASBizException, BOSException {
        if (preFetchItems == null) {
            return;
        }
        for (IPreBatchFetch fetchItem : preFetchItems) {
            fetchItem.preBatchFetch(collection, 0, paramMap);
        }
    }

    private void validation(IObjectValue vo, BatchActionResults batchResults, ObjectListMap mapCheckItems, Map paramMap) throws EASBizException, BOSException {
        IObjectValue objValue = vo;
        String objName = null;
        String id = this.getHeadId(vo);
        paramMap.put("_HEAD", vo);
        Context ctx = (Context)paramMap.get("_CTX");
        HashSet ignoreCheckItems = (HashSet)ctx.get((Object)"IGNORE_CHECKITEMID_SET");
        for (BusinessCheckConfigItem checkItem : this.items.getCheckItems().values()) {
            if (ignoreCheckItems != null && ignoreCheckItems.contains(checkItem.getId())) continue;
            Map mapProp = (Map)mapCheckItems.get(checkItem, 1);
            String validation = checkItem.getValidation();
            if (validation != null) {
                String[] propArray = (String[])mapCheckItems.get(checkItem, 0);
                this.loopValidation(objValue, propArray, mapProp, 0, objName, vo, batchResults, checkItem, 0, paramMap, 0, 0);
                this.handleEntryError(id, batchResults, checkItem, mapProp, paramMap);
                continue;
            }
            Conditions conds = checkItem.getConditions();
            if (conds == null) continue;
            StringBuilder sb = new StringBuilder();
            boolean[] results = conds.calculateResults(objValue, 0, paramMap, objName);
            boolean result = false;
            for (int i = 0; i < results.length; ++i) {
                result = result || results[i];
            }
            if (!result) continue;
            String entryName = conds.getEntryName();
            if (entryName != null) {
                sb.append(BusinessProcessUtil.getPropertyAlias(ctx, this.bosType, entryName));
                sb.append(ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", "ENTRY"));
                sb.append(ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", "ROW", new String[]{this.getEntryList(results)}));
            }
            this.handleError(ctx, id, batchResults, checkItem, sb.toString());
        }
    }

    private String getEntryList(boolean[] results) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < results.length; ++i) {
            if (!results[i]) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(i + 1);
        }
        return sb.toString();
    }

    protected void handleEntryError(String id, BatchActionResults batchResults, BusinessCheckConfigItem checkItem, Map mapProp, Map paramMap) {
        Context ctx = (Context)paramMap.get("_CTX");
        StringBuilder sb = new StringBuilder();
        for (Property prop : mapProp.values()) {
            String entryList = (String)paramMap.get(prop);
            if (entryList == null) continue;
            if (prop.getParent() == null || prop.getParent().getParent() == null) {
                String parent = prop.getParent() != null ? prop.getParent().getAlias() : "";
                String title = prop.getTitle();
                if (StringUtils.isEmpty((String)prop.getTitle())) {
                    title = prop.getAlias();
                }
                sb.append(ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", "REQUIRED_INFO", new String[]{parent, entryList, title}));
                this.addError(batchResults, checkItem, id, sb.toString(), prop);
            } else {
                HashMap<String, String> entryMap = new HashMap<String, String>();
                String[] entries = entryList.split("\\s*;\\s*");
                for (int i = 0; i < entries.length; ++i) {
                    String[] entry = entries[i].split("\\.");
                    if (entry.length < 2) continue;
                    StringBuilder sb2 = new StringBuilder();
                    if (entryMap.containsKey(entry[0])) {
                        sb2.append((String)entryMap.get(entry[0]));
                        sb2.append(",");
                    }
                    sb2.append(entry[1]);
                    entryMap.put(entry[0], sb2.toString());
                }
                for (Map.Entry seqEntry : entryMap.entrySet()) {
                    sb.append(prop.getParent().getParent().getAlias());
                    sb.append(ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", "ROW", new String[]{(String)seqEntry.getKey()}));
                    sb.append(prop.getParent().getAlias());
                    sb.append(ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", "ROW", new String[]{(String)seqEntry.getValue()}));
                    sb.append(prop.getAlias()).append(ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", checkItem.getValidation().toUpperCase()));
                    this.addError(batchResults, checkItem, id, sb.toString(), prop);
                }
            }
            sb.setLength(0);
            paramMap.remove(prop);
        }
    }

    private void handleError(Context ctx, String id, BatchActionResults batchResults, BusinessCheckConfigItem checkItem, String message) throws BOSException {
        BusinessResource resource = checkItem.getResource();
        if (resource == null) {
            return;
        }
        if (resource.isException()) {
            if (checkItem.isCanIgnore()) {
                batchResults.addError(id, resource.getException(message), checkItem.getId());
            } else {
                batchResults.addError(id, resource.getException(message));
            }
        } else if (checkItem.isCanIgnore()) {
            batchResults.addError(id, resource.getMessage(ctx, message), checkItem.getId());
        } else {
            batchResults.addError(id, resource.getMessage(ctx, message));
        }
    }

    private int loopValidation(IObjectValue objValue, String[] propArray, Map mapProp, int cursor, String objName, IObjectValue vo, BatchActionResults batchResults, BusinessCheckConfigItem checkItem, int level, Map paramMap, int entryno, int entrysize) throws EASBizException, BOSException {
        int pos = cursor;
        while (pos < propArray.length) {
            boolean isDiffEntry;
            String name = propArray[pos];
            String[] splits = name.split("\\.");
            int idxLevel = splits.length - 2;
            boolean bl = isDiffEntry = idxLevel >= 0 && !splits[idxLevel].equals(objName);
            if (isDiffEntry && entryno == entrysize) {
                Object entriesObj;
                IObjectValue parent;
                boolean isThisEntrysEntry = idxLevel > 0 && splits[idxLevel - 1].equals(objName);
                int thislevel = 0;
                if (isThisEntrysEntry) {
                    parent = objValue;
                    objName = splits[idxLevel];
                    thislevel = idxLevel;
                } else {
                    parent = (IObjectValue)paramMap.get("_HEAD");
                    objName = splits[0];
                }
                if (!((entriesObj = parent.get(objName)) instanceof IObjectCollection)) continue;
                IObjectCollection entries = (IObjectCollection)entriesObj;
                int nestedpos = pos++;
                int subsize = entries.size();
                if (subsize > 0) {
                    for (int idxSubObj = 0; idxSubObj < subsize; ++idxSubObj) {
                        nestedpos = pos;
                        IObjectValue entryValue = entries.getObject(idxSubObj);
                        String entryName = ENTRY + StringUtil.nameFromSplits(splits, splits.length - 1);
                        paramMap.put(entryName, new Integer(entryValue.getInt("seq")));
                        nestedpos = this.loopValidation(entryValue, propArray, mapProp, nestedpos, objName, vo, batchResults, checkItem, thislevel + 1, paramMap, idxSubObj + 1, subsize);
                    }
                    pos = nestedpos + 1;
                    continue;
                }
                while (pos < propArray.length && ((idxLevel = (splits = (name = propArray[pos]).split("\\.")).length - 2) < 0 || splits[idxLevel].equals(objName))) {
                    ++pos;
                }
                continue;
            }
            if (splits.length <= level) {
                return pos;
            }
            if (entryno < entrysize && isDiffEntry) {
                return propArray.length + 1;
            }
            Property property = (Property)mapProp.get(name);
            this.doValidation(objValue, splits, property, splits.length, vo, batchResults, checkItem, level, paramMap, entryno);
            ++pos;
        }
        return pos;
    }

    private void doValidation(IObjectValue objValue, String[] splits, Property prop, int length, IObjectValue vo, BatchActionResults batchResults, BusinessCheckConfigItem checkItem, int level, Map paramMap, int entryno) throws EASBizException, BOSException {
        Conditions preCond;
        if (prop == null) {
            return;
        }
        Object value = objValue.get(splits[splits.length - 1]);
        boolean precondition = true;
        if (prop.getPrecondition() != null && (preCond = (Conditions)paramMap.get(prop.getPrecondition())) != null) {
            precondition = preCond.calculateResult(objValue, level, paramMap, level > 0 ? splits[level - 1] : null);
        }
        if (!precondition) {
            return;
        }
        Context ctx = (Context)paramMap.get("_CTX");
        if (prop.validate(value, checkItem.getValidation())) {
            StringBuilder sb = new StringBuilder();
            String id = this.getHeadId(vo);
            if (level > 0) {
                String entryList;
                int seqno;
                int parentSeq = 0;
                if (level > 1) {
                    String entryName = ENTRY + StringUtil.nameFromSplits(splits, splits.length - 2);
                    parentSeq = (Integer)paramMap.get(entryName);
                }
                if ((seqno = objValue.getInt("seq")) == 0) {
                    seqno = entryno;
                }
                if ((entryList = (String)paramMap.get(prop)) != null) {
                    sb.append(entryList).append("\uff0c");
                }
                if (parentSeq > 0) {
                    sb.append(parentSeq).append("\u3002");
                }
                sb.append(seqno);
                paramMap.put(prop, sb.toString());
            } else {
                this.handleHeadError(ctx, batchResults, checkItem, id, prop);
            }
        }
    }

    protected void handleHeadError(Context ctx, BatchActionResults batchResults, BusinessCheckConfigItem checkItem, String id, Property prop) {
        String title = prop.getTitle();
        if (StringUtils.isEmpty((String)prop.getTitle())) {
            title = prop.getAlias();
        }
        String s = ResourceUtils.getMessage(ctx, "com.kingdee.eas.scm.common.ActionResource", "REQUIRED", new String[]{title});
        this.addError(batchResults, checkItem, id, s, prop);
    }

    private void addError(BatchActionResults batchResults, BusinessCheckConfigItem checkItem, String id, String msg, Property prop) {
        if (checkItem.isCanIgnore()) {
            this.addError(batchResults, id, msg, checkItem.getId(), prop);
        } else {
            this.addError(batchResults, id, msg, null, prop);
        }
    }

    protected void addError(BatchActionResults batchResults, String billId, String msg, String checkItemId, Property prop) {
        batchResults.addError(billId, msg, checkItemId);
    }

    private String getHeadId(IObjectValue vo) {
        BOSUuid pk = (BOSUuid)vo.get(vo.getPKField());
        String id = null;
        id = pk == null ? "NEWID" : pk.toString();
        return id;
    }
}

