/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.UpdateStatusItem;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.app.ContextUtil;

public class UpdateStatusHandler
implements IBusinessBatchHandle {
    private UpdateStatusItem usItem;
    private String[] headIds;
    private String[] entryIds;
    private String idTableName;

    public UpdateStatusHandler(UpdateStatusItem usItem, String[] headIds, String[] entryIds) {
        this.usItem = usItem;
        this.headIds = headIds;
        this.entryIds = entryIds;
    }

    public UpdateStatusHandler(UpdateStatusItem usItem, String[] headIds, String[] entryIds, String idTableName) {
        this(usItem, headIds, entryIds);
        this.idTableName = idTableName;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException {
        Object[] params;
        String bindSrcMarks;
        String[] idArray;
        if (this.usItem.getUpdateFirstStatusSql() == null) {
            return;
        }
        if (this.usItem.getParent() instanceof WriteBackSubItem) {
            idArray = this.headIds;
        } else {
            String[] stringArray = idArray = "head".equalsIgnoreCase(this.usItem.getThisTable()) ? this.headIds : this.entryIds;
        }
        if (idArray != null && idArray.length > 0) {
            boolean isWriteback = this.usItem.getParent() instanceof WriteBackSubItem;
            bindSrcMarks = DBUtil.getBindMarks(idArray.length);
            params = this.buildParams(ctx, idArray, this.usItem.getFirstParamMarks(), this.usItem.getThisAction(), batchResults, !isWriteback);
            if (isWriteback) {
                this.handleUpdate1stEntryForWritebakc(ctx, idArray, this.usItem.getUpdateFirstStatusSql(), params, bindSrcMarks);
            } else {
                this.handleUpdateStatus(ctx, this.usItem.getUpdateFirstStatusSql(), params, bindSrcMarks);
            }
        }
        if (this.usItem.getParent() instanceof BusinessProcessConfigItem && this.headIds == null) {
            this.headIds = idArray;
        }
        if (this.usItem.getUpdateSecondStatusSql() != null && this.headIds != null && this.headIds.length > 0) {
            bindSrcMarks = DBUtil.getBindMarks(this.headIds.length);
            params = this.buildParams(ctx, this.headIds, this.usItem.getSecondParamMarks(), this.usItem.getInfectionAction(), batchResults, true);
            this.handleUpdateStatus(ctx, this.usItem.getUpdateSecondStatusSql(), params, bindSrcMarks);
        }
    }

    private Object[] buildParams(Context ctx, String[] idsArray, String[] paramMarks, String actionName, BatchActionResults batchResults, boolean includeIdMarks) {
        int idxParams = 0;
        Object[] params = new Object[(includeIdMarks ? idsArray.length : 0) + paramMarks.length - 1];
        for (int i = 0; i < paramMarks.length; ++i) {
            if (paramMarks[i].equals("@STATUS")) {
                params[idxParams++] = BusinessProcessUtil.actionNameToStatus(actionName);
                continue;
            }
            if (paramMarks[i].equals("@USER")) {
                params[idxParams++] = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                continue;
            }
            if (paramMarks[i].equals("???")) {
                if (!includeIdMarks) continue;
                System.arraycopy(idsArray, 0, params, idxParams, idsArray.length);
                idxParams += idsArray.length;
                continue;
            }
            if (paramMarks[i].equals("@STATUS_REVERSE")) {
                params[idxParams++] = BusinessProcessUtil.actionNameToStatus(this.usItem.getThisReversedAction());
                continue;
            }
            if (paramMarks[i].startsWith("#")) {
                int index = Integer.parseInt(paramMarks[i].substring(1));
                params[idxParams++] = batchResults.getParamEntryValue((Object)idsArray[0], index);
                continue;
            }
            throw new IllegalArgumentException("The parameter mark isn't identified.");
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdate1stEntryForWritebakc(Context ctx, String[] idsArray, String updSql, Object[] params, String bindSrcMarks) throws BOSException {
        int cntrow;
        String idDstIDTableName;
        block4: {
            idDstIDTableName = null;
            cntrow = 0;
            try {
                idDstIDTableName = DBUtil.createTempTable(ctx, this.usItem.idTempTableSql);
                String istSql = this.usItem.getInsertIdTableForWritebackSql();
                istSql = istSql.replaceFirst("@IDTABLE", idDstIDTableName);
                istSql = istSql.replaceFirst("@IDTABLE", this.idTableName);
                istSql = istSql.replaceAll("\\?\\?\\?", bindSrcMarks);
                BusinessProcessorHelper.debugSql("\u63d2\u5165\u6e90\u5355\u636e\u5206\u5f55ID\u5230\u4e34\u65f6\u8868", istSql, idsArray);
                cntrow = DBUtil.executeUpdate(ctx, istSql, idsArray);
                if (cntrow != 0) break block4;
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable(ctx, idDstIDTableName);
                throw throwable;
            }
            DBUtil.releaseTempTable(ctx, idDstIDTableName);
            return;
        }
        String sql = updSql.replaceFirst("@IDTABLE", idDstIDTableName);
        BusinessProcessorHelper.debugSql("\u66f4\u65b0\u5355\u636e\u72b6\u6001", sql, params);
        cntrow = DBUtil.executeUpdate(ctx, sql, params);
        if (BusinessProcessorHelper.isDebug()) {
            BusinessProcessorHelper.outpurtDebug("\u6210\u529f\u66f4\u65b0" + cntrow + "\u884c");
        }
        DBUtil.releaseTempTable(ctx, idDstIDTableName);
    }

    private void handleUpdateStatus(Context ctx, String updSql, Object[] params, String bindSrcMarks) throws BOSException {
        int cntrow = 0;
        String sql = this.idTableName != null ? updSql.replaceFirst("@IDTABLE", this.idTableName) : updSql;
        sql = sql.replaceAll("\\?\\?\\?", bindSrcMarks);
        BusinessProcessorHelper.debugSql("\u66f4\u65b0\u5355\u636e\u72b6\u6001", sql, params);
        cntrow = DBUtil.executeUpdate(ctx, sql, params);
        if (BusinessProcessorHelper.isDebug()) {
            BusinessProcessorHelper.outpurtDebug("\u6210\u529f\u66f4\u65b0" + cntrow + "\u884c");
        }
    }
}

