/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.monitor;

import com.kingdee.eas.dynbusiness.adv.chain.app.BizChainLogger;
import com.kingdee.eas.dynbusiness.app.monitor.ExecuteAdapter;
import com.kingdee.eas.dynbusiness.app.monitor.ExecuteEvent;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;

public class LogExecuteListener
extends ExecuteAdapter {
    private BizChainLogger logger;
    private IBusinessProcessor currentProcessor;

    public LogExecuteListener(BizChainLogger logger) {
        this.logger = logger;
    }

    @Override
    public void beginCheck(ExecuteEvent e) {
        this.logger.resetTimer();
        this.currentProcessor = e.getSource();
    }

    @Override
    public void beginDoProcess(ExecuteEvent e) {
        this.logger.resetTimer();
        this.currentProcessor = e.getSource();
    }

    @Override
    public void endCheck(ExecuteEvent e) {
        if (this.currentProcessor != e.getSource()) {
            this.logger.info("processor doChecking: " + e.getSource().getClass().getSimpleName() + " end, but not record spend times");
        }
        if (this.logger.getTimes() > 10L) {
            this.logger.info("processor doChecking: " + this.currentProcessor.getClass().getSimpleName() + ", spend times: " + this.logger.getTimes());
        }
    }

    @Override
    public void endDoProcess(ExecuteEvent e) {
        if (this.currentProcessor != e.getSource()) {
            this.logger.info("processor doProcessing: " + e.getSource().getClass().getSimpleName() + " end, but not record spend times");
        }
        this.logger.info("processor doProcessing: " + this.currentProcessor.getClass().getSimpleName() + ", spend times: " + this.logger.getTimes());
    }

    @Override
    public void failCheck(ExecuteEvent e) {
        String errorMessage = "No record exception";
        if (e.getException() != null) {
            errorMessage = e.getException().getMessage();
        }
        this.logger.error("processor doChecking: " + e.getSource().getClass().getSimpleName() + "\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a\n" + errorMessage);
    }

    @Override
    public void failDoProcess(ExecuteEvent e) {
        String errorMessage = "No record exception";
        if (e.getException() != null) {
            errorMessage = e.getException().getMessage();
        }
        this.logger.error("processor doProcessing: " + e.getSource().getClass().getSimpleName() + "\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a\n" + errorMessage);
    }
}

