/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.IBusinessConfigParser;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import com.kingdee.eas.dynbusiness.config.BusinessResource;
import com.kingdee.eas.dynbusiness.config.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom2.Element;

public abstract class AbstractXmlConfigParser
implements IBusinessConfigParser {
    protected EntityItem getEntityFromDefinition(String key) {
        return BusinessConfigurationCache.getCache().getEntityFromDefinition(key);
    }

    protected boolean isInherited(String bosType) {
        if (bosType == null) {
            return false;
        }
        return bosType.startsWith("@");
    }

    protected String getKey(String billTypeId, String action) {
        return billTypeId + action;
    }

    protected String getKey(BOSObjectType bosType, String action) {
        return bosType.toString() + action;
    }

    protected List parseSrcBillIds(String srcBillIds) {
        ArrayList<String> srcBillIdList = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(srcBillIds);
        while (stk.hasMoreTokens()) {
            srcBillIdList.add(stk.nextToken());
        }
        return srcBillIdList;
    }

    protected BusinessResource parseResource(Element elementMessage) {
        if (elementMessage == null) {
            return null;
        }
        BusinessResource resource = new BusinessResource(elementMessage.getAttributeValue("resource"), elementMessage.getAttributeValue("name"));
        resource.setException(elementMessage.getName().equalsIgnoreCase("exception"));
        resource.setMessage(elementMessage.getText());
        return resource;
    }

    protected List parseProperties(Element elementProps) {
        if (elementProps == null || elementProps.getChildren() == null || elementProps.getChildren().size() == 0) {
            return null;
        }
        int size = elementProps.getChildren().size();
        ArrayList<Property> properties = new ArrayList<Property>(size);
        for (int i = 0; i < size; ++i) {
            Element elementProp = (Element)elementProps.getChildren().get(i);
            Property property = new Property(elementProp.getText().trim());
            property.setPrecondition(elementProp.getAttributeValue("precondition"));
            property.setComparison(elementProp.getAttributeValue("comparison"));
            properties.add(property);
        }
        return properties;
    }
}

