/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigProxy;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import com.kingdee.eas.dynbusiness.condition.InterfaceItem;
import com.kingdee.eas.dynbusiness.config.BusinessObjectStructure;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.dynbusiness.util.ListMap;
import com.kingdee.eas.dynbusiness.util.ObjectListMap;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class BusinessConfigurationCache {
    private static final Logger logger = Logger.getLogger(BusinessConfigurationCache.class);
    static BusinessConfigurationCache cache = new BusinessConfigurationCache();
    private static boolean initialized = false;
    private static HashMap entityMap = new HashMap();
    private static ListMap tableNameMapping = null;
    private FastHashMap processMap = new FastHashMap();
    private FastHashMap mergedMap = new FastHashMap();
    private HashMap interfaceMap = new HashMap();
    HashMap industryMap = new HashMap();
    HashMap spMap = new HashMap();

    public static BusinessConfigurationCache getCache() {
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConfigItem(String bosType, String action) {
        if (StringUtils.isEmpty((String)bosType)) {
            return;
        }
        String key = this.getKey(BOSObjectType.create((String)bosType), action);
        FastHashMap fastHashMap = this.processMap;
        synchronized (fastHashMap) {
            this.processMap.remove((Object)key);
        }
    }

    private BusinessConfigurationCache() {
        this.processMap.setFast(true);
        this.mergedMap.setFast(true);
    }

    void putConfigItemInCache(String key, BusinessProcessConfigItem item) {
        this.processMap.put((Object)key, (Object)item);
    }

    void putConfigItemInCache(Map items) {
        this.processMap.putAll(items);
    }

    public boolean containsInMerged(String key) {
        return this.mergedMap.containsKey((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessProcessConfigItem getBusinessProcessConfigItem(String key) {
        FastHashMap fastHashMap = this.mergedMap;
        synchronized (fastHashMap) {
            return (BusinessProcessConfigItem)this.mergedMap.get((Object)key);
        }
    }

    public BusinessObjectStructure.EntityStructure createEntityStructureByBillType(Context ctx, String billType) throws BOSException {
        if (StringUtil.isEmpty(billType)) {
            logger.error((Object)"\u8c03\u7528createEntityStructureByBillType\u7684\u53c2\u6570billType\u4e3anull");
            return null;
        }
        List list = this.getBillTypeInfo(ctx, billType);
        if (list == null) {
            return null;
        }
        BusinessObjectStructure.EntityStructure es = new BusinessObjectStructure.EntityStructure();
        es.setBosType((String)list.get(3));
        es.setAlias((String)list.get(2));
        es.setTableName((String)list.get(0));
        BusinessObjectStructure.EntityStructure[] entries = new BusinessObjectStructure.EntityStructure[]{new BusinessObjectStructure.EntityStructure()};
        entries[0].setTableName((String)list.get(1));
        es.setEntries(entries);
        return es;
    }

    private List getBillTypeInfo(Context ctx, String billType) throws BOSException {
        List list;
        if (!initialized) {
            BusinessConfigurationCache.initiate(ctx);
        }
        if ((list = (List)tableNameMapping.get(billType)) == null) {
            logger.error((Object)("\u53d6\u5355\u636e\u7c7b\u578b" + billType + "\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5f53\u524d\u5355\u636e\u7c7b\u578b\u7f13\u5b58\u4e2d\u7684size=" + tableNameMapping.size()));
        }
        return list;
    }

    private static HashMap initTableNameMapping(Context ctx) throws BOSException {
        IRowSet rs = DBUtil.executeQuery(ctx, "SELECT FID, FHEADTABLE, FENTRYTABLE, FNAME_L2, FBOSTYPE FROM T_SCM_BILLTYPE", null);
        tableNameMapping = new ObjectListMap(4);
        HashMap<String, String> bosTypeMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String billType = rs.getString(1);
                String bosType = rs.getString(5);
                tableNameMapping.put(billType, new String[]{rs.getString(2), rs.getString(3), rs.getString(4), bosType});
                if (bosType == null || billType == null) continue;
                bosTypeMap.put(bosType, billType);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return bosTypeMap;
    }

    private static void initDefination(Context ctx) throws BOSException {
        String[] prefPackage = new String[]{"com.kingdee.eas.scm%", "com.kingdee.eas.fi.ar.%", "com.kingdee.eas.fi.ap.%", "com.kingdee.eas.fi.cas%"};
        HashMap bosTypeMap = BusinessConfigurationCache.initTableNameMapping(ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FName,FBOSType,FTableName,FFullName FROM T_PF_BosObject");
        sb.append("\r\n");
        for (int i = 0; i < prefPackage.length; ++i) {
            sb.append(i == 0 ? "WHERE (" : " OR ");
            sb.append("FFullName LIKE '");
            sb.append(prefPackage[i]);
            sb.append("'");
        }
        sb.append(") AND FTableName IS NOT NULL");
        HashMap savedMap = new HashMap();
        savedMap.putAll(entityMap);
        entityMap.clear();
        IRowSet rs = DBUtil.executeQuery(ctx, sb.toString(), null);
        try {
            while (rs.next()) {
                String name = rs.getString("FName");
                String bosType = rs.getString("FBOSType");
                if (entityMap.containsKey(name)) {
                    entityMap.remove(name);
                    name = rs.getString("FFullName");
                }
                BusinessConfigurationCache.putEntityInCache(name, bosType, bosTypeMap, rs.getString("FTableName"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        entityMap.putAll(savedMap);
        for (Map.Entry entry : bosTypeMap.entrySet()) {
            Object billType = entry.getValue();
            Object bosType = entry.getKey();
            ArrayList value = (ArrayList)tableNameMapping.get(billType);
            value.set(3, billType);
            tableNameMapping.put(bosType, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putEntityInCache(String name, String bosType, HashMap bosTypeMap, String tableName) {
        EntityItem item = new EntityItem(null, bosType);
        if (bosTypeMap.containsKey(bosType)) {
            item.setBillTypeId((String)bosTypeMap.get(bosType));
        }
        item.setTableName(tableName);
        HashMap hashMap = entityMap;
        synchronized (hashMap) {
            entityMap.put(name, item);
            entityMap.put(bosType, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDefinitionInCache(String name, ConditionItem item) {
        if (item instanceof EntityItem) {
            HashMap hashMap = entityMap;
            synchronized (hashMap) {
                entityMap.put(name, item);
            }
        }
        if (item instanceof InterfaceItem) {
            HashMap hashMap = this.interfaceMap;
            synchronized (hashMap) {
                this.interfaceMap.put(name, item);
            }
        }
    }

    public static synchronized void initiate(Context ctx) throws BOSException {
        if (initialized) {
            return;
        }
        if (ctx != null && tableNameMapping == null) {
            BusinessConfigurationCache.initDefination(ctx);
            initialized = true;
        }
    }

    public static String getTableName(Context ctx, String billTypeID, TableTypeEnum tableType) throws BOSException {
        if (!initialized) {
            BusinessConfigurationCache.initiate(ctx);
        }
        return (String)tableNameMapping.get(billTypeID, tableType.equals(TableTypeEnum.HEAD) ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableNameByBosType(Context ctx, String bosType, TableTypeEnum tableType) throws BOSException {
        if (!initialized) {
            BusinessConfigurationCache.initiate(ctx);
        }
        EntityItem item = null;
        HashMap hashMap = entityMap;
        synchronized (hashMap) {
            item = (EntityItem)entityMap.get(bosType);
        }
        if (item == null) {
            return (String)tableNameMapping.get(bosType, tableType.equals(TableTypeEnum.HEAD) ? 0 : 1);
        }
        return item.getTableName();
    }

    public static String getBillName(Context ctx, String billTypeID) throws BOSException {
        if (billTypeID == null) {
            return null;
        }
        if (!initialized) {
            BusinessConfigurationCache.initiate(ctx);
            if (tableNameMapping == null) {
                return null;
            }
        }
        return (String)tableNameMapping.get(billTypeID, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityItem getEntityFromDefinition(String key) {
        if (key == null) {
            return null;
        }
        HashMap hashMap = entityMap;
        synchronized (hashMap) {
            return (EntityItem)entityMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceItem getInterfaceFromDefinition(String key) {
        if (key == null) {
            return null;
        }
        HashMap hashMap = this.interfaceMap;
        synchronized (hashMap) {
            return (InterfaceItem)this.interfaceMap.get(key);
        }
    }

    synchronized void mergeConfigItem(Context ctx, String billTypeId, String key) throws BOSException {
        BusinessProcessConfigItem bpConfigItem = (BusinessProcessConfigItem)this.processMap.get((Object)key);
        this.mergePlugin(ctx, billTypeId, key, bpConfigItem, this.industryMap);
        this.mergePlugin(ctx, billTypeId, key, bpConfigItem, this.spMap);
        if (this.processMap.containsKey((Object)key)) {
            this.processMap.remove((Object)key);
        }
    }

    private void mergePlugin(Context ctx, String billTypeId, String key, BusinessProcessConfigItem bpConfigItem, Map toMergeMap) throws BOSException {
        if (toMergeMap.containsKey(key)) {
            BusinessProcessConfigItem pluginItem = (BusinessProcessConfigItem)toMergeMap.get(key);
            if (BusinessProcessorHelper.isDebug()) {
                BusinessProcessorHelper.outpurtDebug("\u627e\u5230\u5355\u636e[" + BusinessProcessorHelper.getBillName(ctx, billTypeId) + "]\u7684\u914d\u7f6e\u63d2\u4ef6\uff1aKEY[" + key + "]");
            }
            if (bpConfigItem != null) {
                bpConfigItem.merge(pluginItem);
                if (BusinessProcessorHelper.isDebug()) {
                    BusinessProcessorHelper.outpurtDebug("\u5904\u7406\u5355\u636e[" + BusinessProcessorHelper.getBillName(ctx, billTypeId) + "]\u7684\u914d\u7f6e\u63d2\u4ef6\u5408\u5e76\uff1aKEY[" + key + "]");
                }
                this.mergedMap.put((Object)key, (Object)bpConfigItem);
            } else {
                this.mergedMap.put((Object)key, (Object)pluginItem);
            }
            toMergeMap.remove(key);
        } else if (bpConfigItem == null) {
            bpConfigItem = BusinessProcessConfigItem.NULL_CONFIG_ITEM;
            this.processMap.put((Object)key, (Object)bpConfigItem);
        } else {
            this.mergedMap.put((Object)key, (Object)bpConfigItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessProcessConfigItem getBusinessProcessConfigItem(ExecuteContext executeContext) throws BOSException {
        String key = this.getKey(executeContext.getBosType(), executeContext.getBatchAction().getBizAction());
        if (!this.containsInMerged(key) || executeContext.isForceToParseEveryTime()) {
            FastHashMap fastHashMap = this.mergedMap;
            synchronized (fastHashMap) {
                XmlConfigProxy.xmlConfigProxy.parseProcessXml(executeContext);
                this.mergeConfigItem(executeContext.getContext(), null, key);
            }
        }
        BusinessProcessConfigItem bpConfigItem = this.getBusinessProcessConfigItem(key);
        return bpConfigItem;
    }

    private String getKey(BOSObjectType bosType, String action) {
        return bosType.toString() + action;
    }
}

