/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BOTProcessSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessProcessConfigItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.IXmlConfigItemVisitor;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.WriteBackSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.XmlActionListConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionItemConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BOTProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BOTProcessConfigItems;
import com.kingdee.eas.dynbusiness.config.BOTProcessSubItem;
import com.kingdee.eas.dynbusiness.config.BOTSourceItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.ValueMappingItem;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class XmlBOTConfigItemsParser
extends AbstractXmlConfigParser
implements IXmlConfigItemVisitor {
    private XmlParserContext parserContext;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        return null;
    }

    private BOTProcessConfigItems parseBOTConfigItems(Element elementBOTItems, BusinessProcessConfigItem bpitem) throws XmlConfigParseException {
        if (elementBOTItems == null || !elementBOTItems.getName().equals("botitems")) {
            return null;
        }
        List botItems = elementBOTItems.getChildren();
        if (botItems == null || botItems.size() == 0) {
            return null;
        }
        BOTProcessConfigItems items = new BOTProcessConfigItems(ProcessorExecutionMode.getProcessorExecutionMode(elementBOTItems.getAttributeValue("execution")));
        XmlConditionsConfigParser parser = new XmlConditionsConfigParser();
        int size = botItems.size();
        for (int i = 0; i < size; ++i) {
            Element elementItem = (Element)botItems.get(i);
            BOTProcessConfigItem item = new BOTProcessConfigItem(elementItem.getAttributeValue("id"), bpitem, elementItem.getAttributeValue("name"));
            List subItems = elementItem.getChildren();
            int idx = 0;
            int subSize = subItems.size();
            if (subSize == 0) continue;
            Element nextElement = (Element)subItems.get(idx++);
            this.parserContext.setRoot(nextElement);
            item.setPreCondition((Conditions)parser.parse(this.parserContext));
            ArrayList<BOTProcessSubItem> subBOTItems = new ArrayList<BOTProcessSubItem>();
            while (idx < subSize) {
                subBOTItems.add(this.parseBOTSubItem((Element)subItems.get(idx++), item));
            }
            item.setSubBOTItems(subBOTItems);
            items.add(item);
        }
        return items;
    }

    private BOTProcessSubItem parseBOTSubItem(Element elementSubItem, BOTProcessConfigItem item) throws XmlConfigParseException {
        String transform;
        String dstBosType = elementSubItem.getAttributeValue("dstbostype");
        BOTProcessSubItem subItem = new BOTProcessSubItem(item, elementSubItem.getAttributeValue("id"), elementSubItem.getAttributeValue("mapid"), dstBosType != null ? BOSObjectType.create((String)dstBosType) : null);
        String checkFirst = elementSubItem.getAttributeValue("checkfirst");
        if (checkFirst != null) {
            subItem.setCheckFirst(Boolean.valueOf(checkFirst));
        }
        if ((transform = elementSubItem.getAttributeValue("transform")) != null) {
            subItem.setTransform(Boolean.valueOf(transform));
        }
        subItem.setBotResultCondition(elementSubItem.getAttributeValue("botresult"));
        List subItems = elementSubItem.getChildren();
        int size = subItems.size();
        int idx = 0;
        if (size == idx) {
            return subItem;
        }
        Element nextElement = (Element)subItems.get(idx++);
        subItem.setSourceItem(this.parseBOTSourceItem(nextElement, subItem));
        nextElement = (Element)subItems.get(idx++);
        XmlConditionsConfigParser parser = new XmlConditionsConfigParser();
        this.parserContext.setRoot(nextElement);
        subItem.setPreCondition((Conditions)parser.parse(this.parserContext));
        if (size == idx) {
            return subItem;
        }
        Element elementMapping = (Element)subItems.get(idx++);
        subItem.setMappingItem(this.parseValueMappingItem(elementMapping, subItem));
        if (size == idx) {
            return subItem;
        }
        Element elementActions = (Element)subItems.get(idx++);
        this.parserContext.setRoot(elementActions);
        XmlActionListConfigParser visitor = new XmlActionListConfigParser();
        BOTProcessSubItemVisitable visitable = new BOTProcessSubItemVisitable(this.parserContext, subItem);
        visitable.accept(visitor);
        return subItem;
    }

    private BOTSourceItem parseBOTSourceItem(Element sourceElement, BOTProcessSubItem parent) throws XmlConfigParseException {
        BOTSourceItem sourceItem = new BOTSourceItem(parent, sourceElement.getAttributeValue("type"));
        sourceItem.setKey(sourceElement.getAttributeValue("key"));
        String reload = sourceElement.getAttributeValue("reload");
        if (reload != null) {
            sourceItem.setReload(Boolean.valueOf(reload));
        }
        List listSource = sourceElement.getChildren();
        int idx = 0;
        if (listSource == null || listSource.size() == 0) {
            return sourceItem;
        }
        Element nextElement = (Element)listSource.get(idx++);
        sourceItem.setSourceSql(nextElement.getText());
        sourceItem.setIdxGroupby(this.parseColumnIdx(nextElement, "groupby"));
        sourceItem.setIdxBillId(this.parseColumnIdx(nextElement, "id"));
        sourceItem.setIdxEntryId(this.parseColumnIdx(nextElement, "entryid"));
        nextElement = (Element)listSource.get(idx++);
        sourceItem.setMappingItem(this.parseValueMappingItem(nextElement, sourceItem));
        return sourceItem;
    }

    private int parseColumnIdx(Element element, String name) {
        int result = 0;
        String value = element.getAttributeValue(name);
        if (value != null) {
            result = Integer.parseInt(value);
        }
        return result;
    }

    private ValueMappingItem parseValueMappingItem(Element elementMapping, Object parent) throws XmlConfigParseException {
        if (elementMapping == null) {
            return null;
        }
        List listMapping = elementMapping.getChildren();
        if (listMapping == null || listMapping.size() == 0) {
            return null;
        }
        XmlConditionItemConfigParser parser = new XmlConditionItemConfigParser();
        List properties = this.parseProperties((Element)listMapping.get(0));
        Element elementValues = (Element)listMapping.get(1);
        List listValues = elementValues.getChildren();
        ArrayList<IBusinessConfigItem> values = new ArrayList<IBusinessConfigItem>();
        int size = listValues.size();
        for (int i = 0; i < size; ++i) {
            Element elementValue = (Element)listValues.get(i);
            this.parserContext.setRoot(elementValue);
            this.parserContext.setItemType(elementValue.getAttributeValue("type"));
            values.add(parser.parse(this.parserContext));
        }
        return new ValueMappingItem(parent, properties, values);
    }

    @Override
    public void visitBOTConfigItems(BOTProcessSubItemVisitable visitable) throws XmlConfigParseException {
    }

    @Override
    public void visitBusinessProcessConfigItem(BusinessProcessConfigItemVisitable visitable) throws XmlConfigParseException {
        XmlParserContext pc = visitable.getParserContext();
        Element nextElement = pc.getRoot();
        BusinessProcessConfigItem bpitem = visitable.getItem();
        this.parserContext = pc;
        BOTProcessConfigItems botItems = this.parseBOTConfigItems(nextElement, bpitem);
        if (botItems == null) {
            return;
        }
        bpitem.setBotConfigItems(botItems);
    }

    @Override
    public void visitWriteBackSubItem(WriteBackSubItemVisitable visitable) throws XmlConfigParseException {
    }
}

