/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessProcessConfigItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.IXmlConfigItemVisitor;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlActionListConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlBOTConfigItemsParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlCheckItemsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlUpdateStatusConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlWriteBackConfigParser;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class XmlBusinessProcessConfigItemParser
extends AbstractXmlConfigParser {
    private XmlParserContext parserContext;
    private List parserList;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        this.parserContext = (XmlParserContext)parserContext;
        Element elementItem = this.parserContext.getRoot();
        return this.parseBusinessProcessConfigItem(elementItem, this.parserContext.getBillTypeId(), this.parserContext.getBosType());
    }

    private BusinessProcessConfigItem parseBusinessProcessConfigItem(Element elementItem, String billTypeId, String bosType) throws XmlConfigParseException {
        String refKey;
        boolean isRef = false;
        if (!elementItem.getName().equals("processitem")) {
            return null;
        }
        String action = elementItem.getAttributeValue("action").toUpperCase();
        String ref = elementItem.getAttributeValue("ref");
        BusinessProcessConfigItem bpitem = null;
        BusinessProcessConfigItem refConfigItem = null;
        if (ref != null && ref.length() > 0 && (refConfigItem = BusinessConfigurationCache.cache.getBusinessProcessConfigItem(refKey = this.getKey(ref, action))) != null) {
            try {
                bpitem = (BusinessProcessConfigItem)refConfigItem.clone();
                isRef = true;
            }
            catch (CloneNotSupportedException e) {
                throw new XmlConfigParseException(e);
            }
        }
        if (bpitem == null) {
            bpitem = new BusinessProcessConfigItem();
        }
        bpitem.setBillTypeId(billTypeId);
        bpitem.setAction(action);
        bpitem.setBosType(bosType);
        bpitem.setActionLevel(BatchActionEnum.getDefaultLevel((String)action));
        List listItem = elementItem.getChildren();
        int sizeItem = listItem.size();
        int idx = 0;
        Element nextElement = null;
        if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equalsIgnoreCase("preconditions")) {
            XmlConditionsConfigParser parser = new XmlConditionsConfigParser();
            List conditions = nextElement.getChildren();
            if (conditions != null && conditions.size() > 0) {
                int condSize = conditions.size();
                ArrayList<IBusinessConfigItem> preConditions = new ArrayList<IBusinessConfigItem>(condSize);
                for (int idxOfConds = 0; idxOfConds < condSize; ++idxOfConds) {
                    this.parserContext.setRoot((Element)conditions.get(idxOfConds));
                    preConditions.add(parser.parse(this.parserContext));
                }
                bpitem.setPreConditions(preConditions);
            }
            ++idx;
        }
        if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equals("selector")) {
            String selector = nextElement.getText();
            if (selector != null) {
                String[] sels = selector.split("\\s*;\\s*");
                bpitem.setAddedSelector(sels);
            }
            ++idx;
        }
        while (sizeItem > idx) {
            nextElement = (Element)listItem.get(idx++);
            this.parseAElement(bpitem, nextElement);
        }
        if (isRef) {
            try {
                bpitem = (BusinessProcessConfigItem)bpitem.deepedCloned(refConfigItem);
            }
            catch (CloneNotSupportedException e) {
                throw new XmlConfigParseException(e);
            }
        }
        return bpitem;
    }

    private void parseAElement(BusinessProcessConfigItem bpitem, Element nextElement) throws XmlConfigParseException {
        this.parserContext.setRoot(nextElement);
        BusinessProcessConfigItemVisitable visitable = new BusinessProcessConfigItemVisitable(this.parserContext, bpitem);
        for (IXmlConfigItemVisitor visitor : this.getParserVistors()) {
            visitable.accept(visitor);
        }
    }

    private List getParserVistors() {
        if (this.parserList != null) {
            return this.parserList;
        }
        this.parserList = new ArrayList();
        this.parserList.add(new XmlCheckItemsConfigParser());
        this.parserList.add(new XmlUpdateStatusConfigParser());
        this.parserList.add(new XmlWriteBackConfigParser());
        this.parserList.add(new XmlBOTConfigItemsParser());
        this.parserList.add(new XmlActionListConfigParser());
        return this.parserList;
    }
}

