/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.condition.CompositeItem;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import com.kingdee.eas.dynbusiness.condition.IFItem;
import com.kingdee.eas.dynbusiness.condition.InterfaceItem;
import com.kingdee.eas.dynbusiness.condition.ListItem;
import com.kingdee.eas.dynbusiness.condition.ParameterItem;
import com.kingdee.eas.dynbusiness.condition.PropertyItem;
import com.kingdee.eas.dynbusiness.condition.StateItem;
import com.kingdee.eas.dynbusiness.condition.TextItem;
import com.kingdee.eas.dynbusiness.util.ResourceUtils;
import java.util.List;
import org.jdom2.Element;

public class XmlConditionItemConfigParser
extends AbstractXmlConfigParser {
    XmlParserContext pc;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        this.pc = (XmlParserContext)parserContext;
        return this.parseConditionItem(this.pc.getRoot(), this.pc.getItemType());
    }

    private ConditionItem parseConditionItem(Element elementItem, String itemType) throws XmlConfigParseException {
        if (elementItem == null) {
            return null;
        }
        ConditionItem item = null;
        if (itemType == null) {
            item = new TextItem(elementItem.getText());
        } else if (itemType.equals("status")) {
            item = new StateItem(elementItem.getText());
        } else if (itemType.equals("column")) {
            ColumnItem cvalue = new ColumnItem(elementItem.getText());
            cvalue.setTable(TableTypeEnum.getTableType(elementItem.getAttributeValue("table")));
            String levelFrom = elementItem.getAttributeValue("levelfrom");
            if (levelFrom != null) {
                cvalue.setLevelFrom(Integer.valueOf(levelFrom));
            }
            String dataType = elementItem.getAttributeValue("datatype");
            cvalue.setDataType(ColumnDataType.getType(dataType));
            String relation = elementItem.getAttributeValue("relation");
            if (relation != null) {
                String[] relations = relation.split("=");
                cvalue.setRelationField(relations[0]);
                cvalue.setRelationTable(relations[1]);
            }
            String convertto = elementItem.getAttributeValue("covertto");
            cvalue.setConvertTo(convertto);
            item = cvalue;
        } else if (itemType.equals("property")) {
            PropertyItem pitem = new PropertyItem(elementItem.getText());
            pitem.setDataType(elementItem.getAttributeValue("datatype"));
            String bosType = elementItem.getAttributeValue("bostype");
            if (bosType != null) {
                pitem.setBosType(BOSObjectType.create((String)bosType));
            }
            item = pitem;
        } else if (itemType.equals("parameter")) {
            String langProfix = ResourceUtils.getLanguage(this.pc.getContext());
            ParameterItem pitem = new ParameterItem(elementItem.getText());
            pitem.setBizOrgProperty(elementItem.getAttributeValue("orgproperty"));
            pitem.setBizOrgColumn(elementItem.getAttributeValue("orgcolumn"));
            pitem.setTable(TableTypeEnum.getTableType(elementItem.getAttributeValue("table")));
            pitem.setLangProfix(langProfix);
            item = pitem;
        } else if (itemType.equals("entity")) {
            EntityItem entity;
            String key = elementItem.getAttributeValue("entity");
            EntityItem eitem = null;
            if (key != null && (entity = this.getEntityFromDefinition(key)) != null) {
                try {
                    eitem = (EntityItem)entity.clone();
                    eitem.setName(elementItem.getText());
                }
                catch (CloneNotSupportedException e) {
                    throw new XmlConfigParseException(e);
                }
            }
            if (eitem == null) {
                eitem = new EntityItem(elementItem.getText(), elementItem.getAttributeValue("bostype"));
                eitem.setBillTypeId(elementItem.getAttributeValue("billtypeid"));
            }
            String link = elementItem.getAttributeValue("link");
            eitem.setLink(link);
            eitem.setFilter(elementItem.getAttributeValue("filter"));
            item = eitem;
        } else if (itemType.equals("list")) {
            ListItem litem = new ListItem(null);
            List subElementList = elementItem.getChildren();
            int size = subElementList.size();
            for (int i = 0; i < size; ++i) {
                Element subElement = (Element)subElementList.get(i);
                litem.addSubValue(this.parseConditionItem(subElement, subElement.getAttributeValue("type")));
            }
            item = litem;
        } else if (itemType.equals("interface")) {
            InterfaceItem inf;
            String key = elementItem.getAttributeValue("interface");
            String paramsValue = elementItem.getAttributeValue("paramsvalue");
            InterfaceItem iitem = null;
            if (key != null && (inf = BusinessConfigurationCache.getCache().getInterfaceFromDefinition(key)) != null) {
                try {
                    iitem = (InterfaceItem)inf.clone();
                    iitem.setName(elementItem.getText());
                    iitem.setParamsValue(paramsValue.split("\\s*;\\s*"));
                }
                catch (CloneNotSupportedException e) {
                    throw new XmlConfigParseException(e);
                }
            }
            if (iitem == null) {
                String paramsType = elementItem.getAttributeValue("paramstype");
                iitem = new InterfaceItem(elementItem.getText(), elementItem.getAttributeValue("bostype"), elementItem.getAttributeValue("method"), elementItem.getAttributeValue("objtype"), paramsType.split(";"), paramsValue != null ? paramsValue.split("\\s*;\\s*") : null, elementItem.getAttributeValue("returntype"));
            }
            item = iitem;
        } else if (itemType.equals("composite")) {
            item = new CompositeItem(elementItem.getText());
            List subElementList = elementItem.getChildren();
            int size = subElementList.size();
            for (int i = 0; i < size; ++i) {
                Element subElement = (Element)subElementList.get(i);
                ((CompositeItem)item).addSubValue(this.parseConditionItem(subElement, subElement.getAttributeValue("type")));
            }
        } else if (itemType.equals("if")) {
            item = new IFItem(elementItem.getText());
            IFItem ifValue = (IFItem)item;
            List ifElementList = elementItem.getChildren();
            int size = ifElementList.size();
            if (size < 2) {
                throw new IllegalArgumentException("The if in subValue must be contains 2 elements in xml");
            }
            Element ifElement = (Element)ifElementList.get(0);
            List inIfElementList = ifElement.getChildren();
            size = inIfElementList.size();
            if (size < 2) {
                throw new IllegalArgumentException("The if in subValue must be contains 2 elements in xml");
            }
            XmlConditionsConfigParser parser = new XmlConditionsConfigParser();
            XmlParserContext parserContext = this.pc;
            parserContext.setRoot((Element)inIfElementList.get(0));
            ifValue.setIfConditions((Conditions)parser.parse(parserContext));
            Element subValue = (Element)inIfElementList.get(1);
            ifValue.setIfValue(this.parseConditionItem(subValue, subValue.getAttributeValue("type")));
            Element elseElement = (Element)ifElementList.get(1);
            List elseElementList = elseElement.getChildren();
            size = elseElementList.size();
            if (size < 1) {
                throw new IllegalArgumentException("The else in subValue must be contains 1 element in xml");
            }
            subValue = (Element)elseElementList.get(0);
            ifValue.setElseValue(this.parseConditionItem(subValue, subValue.getAttributeValue("type")));
        }
        if (item != null) {
            item.setCalculate(elementItem.getAttributeValue("calculate"));
        }
        return item;
    }
}

