/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigProxy;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItems;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class XmlPluginConfigParser
extends AbstractXmlConfigParser {
    private static final String SPPATH = "com/kingdee/eas/scm/common/app/cfgfile/plugin/";
    private static final String INDUSTRYPATH = "com/kingdee/eas/config/app/cfgfile/industry/";
    private static final String FILE_URL_PREFIX = "file:";
    private static final String JAR_URL_SEPARATOR = "!/";

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        this.parseIndustryXmls(parserContext.getContext());
        this.parseSpXmls(parserContext.getContext());
        return null;
    }

    private void parseIndustryXmls(Context ctx) throws XmlConfigParseException {
        this.parsePlugInXmls(ctx, BusinessConfigurationCache.cache.industryMap, INDUSTRYPATH);
    }

    private void parseSpXmls(Context ctx) throws XmlConfigParseException {
        this.parsePlugInXmls(ctx, BusinessConfigurationCache.cache.spMap, SPPATH);
    }

    private void parsePlugInXmls(Context ctx, Map cacheMap, String path) throws XmlConfigParseException {
        ZipFile jarFile = null;
        try {
            Enumeration<Object> enumeration = this.getClass().getClassLoader().getResources(path);
            String jarName = null;
            while (enumeration.hasMoreElements()) {
                int separatorIndex;
                URL url = enumeration.nextElement();
                String urlFile = url.getFile();
                if (urlFile == null || !urlFile.startsWith(FILE_URL_PREFIX) || (separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR)) <= 0) continue;
                jarName = urlFile.substring(FILE_URL_PREFIX.length(), separatorIndex);
                break;
            }
            if (jarName == null) {
                return;
            }
            jarFile = new JarFile(jarName);
            enumeration = ((JarFile)jarFile).entries();
            while (enumeration.hasMoreElements()) {
                JarEntry entry = (JarEntry)enumeration.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path) || !name.endsWith(".xml")) continue;
                if (BusinessProcessorHelper.isDebug()) {
                    BusinessProcessorHelper.outpurtDebug("\u627e\u5230\u914d\u7f6e\u63d2\u4ef6\u6587\u4ef6\uff1a" + name);
                }
                BusinessProcessConfigItems bpcis = XmlConfigProxy.xmlConfigProxy.parseProcessXml(ctx, name);
                Iterator iter = bpcis.iterator();
                while (iter.hasNext()) {
                    BusinessProcessConfigItem bpci = (BusinessProcessConfigItem)iter.next();
                    cacheMap.put(this.getKey(bpci.getBosType(), bpci.getAction()), bpci);
                }
            }
        }
        catch (Exception e) {
            throw new XmlConfigParseException(e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

