/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.IBusinessConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlBOStructureParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlBusinessProcessConfigItemParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionItemConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import com.kingdee.eas.dynbusiness.config.BusinessObjectStructure;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class XmlWholeConfigParser
extends AbstractXmlConfigParser {
    private static final String BILLTYPEID = "billtypeid";
    private static final Logger logger = Logger.getLogger(XmlWholeConfigParser.class);
    private XmlParserContext parserContext;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        Element root = ((XmlParserContext)parserContext).getRoot();
        if (root == null) {
            return null;
        }
        this.parserContext = (XmlParserContext)parserContext;
        BusinessProcessConfigItems items = this.parseProcessXml(root);
        String bosType = this.parserContext.getBosType();
        Iterator iter = items.iterator();
        try {
            while (iter.hasNext()) {
                BusinessProcessConfigItem bpci = (BusinessProcessConfigItem)iter.next();
                if (!this.isInherited(bpci.getBosType())) continue;
                if (bosType != null) {
                    bpci = (BusinessProcessConfigItem)bpci.deepedCloned(bpci);
                    bpci.setBosType(bosType.toString());
                    continue;
                }
                BusinessConfigurationCache.getCache().putConfigItemInCache(this.getKey(bpci.getBosType(), bpci.getAction()), bpci);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new XmlConfigParseException(e);
        }
        return items;
    }

    private BusinessObjectStructure parseBusinessObjectStructure(Element root) throws XmlConfigParseException {
        XmlBOStructureParser parser = new XmlBOStructureParser();
        this.parserContext.setRoot(root);
        return (BusinessObjectStructure)parser.parse(this.parserContext);
    }

    private BusinessProcessConfigItems parseProcessXml(Element root) throws XmlConfigParseException {
        BusinessObjectStructure boStructure = null;
        List childrens = root.getChildren();
        ArrayList<BusinessProcessConfigItem> bpciList = new ArrayList<BusinessProcessConfigItem>();
        String billTypeId = null;
        int size = childrens.size();
        for (int i = 0; i < size; ++i) {
            EntityItem eitem;
            Element elementItems = (Element)childrens.get(i);
            if (elementItems.getName().equals("definition")) {
                this.parseDefinition(elementItems);
                continue;
            }
            if (elementItems.getName().equals("structure")) {
                boStructure = this.parseBusinessObjectStructure(elementItems);
                continue;
            }
            billTypeId = elementItems.getAttributeValue(BILLTYPEID);
            String bill = elementItems.getAttributeValue("bill");
            String bosType = elementItems.getAttributeValue("bostype");
            if (bill != null && (eitem = this.getEntityFromDefinition(bill)) != null) {
                if (billTypeId == null) {
                    billTypeId = eitem.getBillTypeId();
                }
                if (bosType == null) {
                    bosType = eitem.getBosType();
                }
            }
            if (bosType == null) {
                throw new IllegalArgumentException("Item processitems must be contain attribute 'bostype' in XML file.");
            }
            if (BusinessProcessorHelper.isDebug() && billTypeId != null) {
                String billName = null;
                try {
                    billName = BusinessProcessorHelper.getBillName(null, billTypeId);
                }
                catch (BOSException e) {
                    throw new XmlConfigParseException(e);
                }
                if (billName == null) {
                    billName = bill;
                }
                BusinessProcessorHelper.outpurtDebug("\u89e3\u6790\u5355\u636e" + billName + "\u7684\u914d\u7f6e\u6587\u4ef6\uff1a\u5355\u636e\u7c7b\u578b[" + billTypeId + "] BOSType[" + bosType + "]");
            }
            List listItems = elementItems.getChildren();
            int itemsSize = listItems.size();
            for (int idxOfItems = 0; idxOfItems < itemsSize; ++idxOfItems) {
                Element elementItem = (Element)listItems.get(idxOfItems);
                XmlBusinessProcessConfigItemParser parser = new XmlBusinessProcessConfigItemParser();
                this.parserContext.setRoot(elementItem);
                this.parserContext.setBillTypeId(billTypeId);
                this.parserContext.setBosType(bosType);
                BusinessProcessConfigItem bpitem = (BusinessProcessConfigItem)parser.parse(this.parserContext);
                if (bpitem == null) continue;
                bpciList.add(bpitem);
            }
        }
        BusinessProcessConfigItems items = new BusinessProcessConfigItems(bpciList);
        if (billTypeId != null && boStructure == null && !this.isInherited(billTypeId)) {
            boStructure = this.createDefaultBOStructure(billTypeId);
        }
        items.setBoStructure(boStructure);
        return items;
    }

    private BusinessObjectStructure createDefaultBOStructure(String billTypeId) throws XmlConfigParseException {
        BusinessObjectStructure.EntityStructure es;
        BusinessObjectStructure.LevelStructure[] structures = new BusinessObjectStructure.LevelStructure[3];
        BusinessObjectStructure.LevelStructure ls = new BusinessObjectStructure.LevelStructure();
        try {
            es = BusinessConfigurationCache.cache.createEntityStructureByBillType(this.parserContext.getContext(), billTypeId);
        }
        catch (BOSException e) {
            throw new XmlConfigParseException(e);
        }
        es.getEntries()[0].setLinkToParent("FParentID");
        ls.setEntity(es);
        ls.setBillTypeId(billTypeId);
        structures[0] = ls;
        BusinessObjectStructure boStructure = new BusinessObjectStructure(structures);
        return boStructure;
    }

    private synchronized void parseDefinition(Element elementDefinition) throws XmlConfigParseException {
        XmlConditionItemConfigParser parser = new XmlConditionItemConfigParser();
        List listItems = elementDefinition.getChildren();
        int size = listItems.size();
        for (int i = 0; i < size; ++i) {
            Element elementItems = (Element)listItems.get(i);
            List listItem = elementItems.getChildren();
            if (elementItems.getName().equals("entities")) {
                this.parseDefinition(parser, listItem, "entity");
                continue;
            }
            if (!elementItems.getName().equals("interfaces")) continue;
            this.parseDefinition(parser, listItem, "interface");
        }
    }

    private void parseDefinition(IBusinessConfigParser parser, List listItem, String type) throws XmlConfigParseException {
        int subsize = listItem.size();
        for (int j = 0; j < subsize; ++j) {
            Element elementItem = (Element)listItem.get(j);
            String id = elementItem.getAttributeValue("id");
            logger.debug((Object)("\u89e3\u6790\u9700\u8981\u7f13\u5b58\u7684\u9884\u5b9a\u4e49\u914d\u7f6e\u9879, Type:" + type + ", ID:" + id));
            this.parserContext.setRoot(elementItem);
            this.parserContext.setItemType(type);
            ConditionItem item = (ConditionItem)parser.parse(this.parserContext);
            BusinessConfigurationCache.getCache().putDefinitionInCache(id, item);
        }
    }
}

