/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.IExecutionModeSupport;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessSqlBuilder;
import com.kingdee.eas.dynbusiness.app.monitor.ExecuteEvent;
import com.kingdee.eas.dynbusiness.app.monitor.IExecuteListener;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigFactory;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigProxy;
import com.kingdee.eas.dynbusiness.app.processor.BillsExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.DefaultBusinessProcessorChainSupport;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessorChainSupport;
import com.kingdee.eas.dynbusiness.app.processor.NoBusinessProcessorChainSupport;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.app.processor.TransactionInvokeUtil;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class AbstractBusinessProcessor
implements IBusinessProcessor,
IExecutionModeSupport {
    private static final long serialVersionUID = 1L;
    protected Context ctx;
    protected BatchActionEnum batchAction;
    protected String billTypeID;
    protected OrgType mainOrgType;
    protected IBatchExecute batchExecutor;
    protected BOSObjectType bosType;
    protected Conditions conditions;
    protected String conditionExpression;
    protected ProcessorExecutionModeEnum executeMode = ProcessorExecutionModeEnum.ORDINAL;
    protected IBusinessProcessorChainSupport businessChainSupport;
    protected TransactionModeEnum transactionMode;
    private ExecuteContext executeContext;
    protected String processorDescription;
    protected List<IExecuteListener> listenerList = new ArrayList<IExecuteListener>();

    @Override
    public void setExecutionMode(ProcessorExecutionModeEnum executionMode) {
        this.executeMode = executionMode;
    }

    @Override
    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    public void setExecuteContext(ExecuteContext executeContext) {
        this.executeContext = executeContext;
    }

    @Override
    public void addExecuteListener(IExecuteListener listener) {
        if (listener != null && this.listenerList.indexOf(listener) < 0) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public BatchActionResults execute(BatchActionResults batchResults) throws BOSException, EASBizException {
        IBusinessProcessorChainSupport businessChainSupport = this.getBusinessChainSupport();
        return businessChainSupport.execute(batchResults);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return true;
    }

    protected final boolean innerCheck(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean result = false;
        try {
            this.fireBeginCheckEvent();
            result = this.check(batchResults);
            this.fireEndCheckEvent();
        }
        catch (EASBizException e1) {
            this.fireFailCheckEvent((Exception)((Object)e1));
            throw e1;
        }
        catch (BOSException e2) {
            this.fireFailCheckEvent((Exception)((Object)e2));
            throw e2;
        }
        return result;
    }

    protected abstract void doProcessing(BatchActionResults var1) throws BOSException, EASBizException;

    protected final void innerDoProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        try {
            this.fireBeginDoProcessEvent();
            this.doProcessing(batchResults);
            this.fireEndDoProcessEvent();
        }
        catch (EASBizException e1) {
            this.fireFailDoProcessEvent((Exception)((Object)e1));
            throw e1;
        }
        catch (BOSException e2) {
            this.fireFailDoProcessEvent((Exception)((Object)e2));
            throw e2;
        }
    }

    private void fireBeginCheckEvent() {
        ExecuteEvent e = new ExecuteEvent(this);
        for (IExecuteListener listener : this.listenerList) {
            listener.beginCheck(e);
        }
    }

    private void fireEndCheckEvent() {
        ExecuteEvent e = new ExecuteEvent(this);
        for (IExecuteListener listener : this.listenerList) {
            listener.endCheck(e);
        }
    }

    private void fireFailCheckEvent(Exception ex) {
        ExecuteEvent e = new ExecuteEvent(this);
        e.setException(ex);
        for (IExecuteListener listener : this.listenerList) {
            listener.failCheck(e);
        }
    }

    private void fireBeginDoProcessEvent() {
        ExecuteEvent e = new ExecuteEvent(this);
        for (IExecuteListener listener : this.listenerList) {
            listener.beginDoProcess(e);
        }
    }

    private void fireEndDoProcessEvent() {
        ExecuteEvent e = new ExecuteEvent(this);
        for (IExecuteListener listener : this.listenerList) {
            listener.endDoProcess(e);
        }
    }

    private void fireFailDoProcessEvent(Exception ex) {
        ExecuteEvent e = new ExecuteEvent(this);
        e.setException(ex);
        for (IExecuteListener listener : this.listenerList) {
            listener.failDoProcess(e);
        }
    }

    public AbstractBusinessProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        this.ctx = ctx;
        this.bosType = bosType;
        this.batchAction = batchAction;
        this.billTypeID = billTypeID;
        this.mainOrgType = mainOrgType;
    }

    public AbstractBusinessProcessor(ExecuteContext executeContext) {
        this.executeContext = executeContext;
        this.ctx = executeContext.context;
        this.bosType = executeContext.bosType;
        this.batchAction = executeContext.batchAction;
        this.mainOrgType = executeContext.mainOrgType;
        this.billTypeID = executeContext.billTypeID;
        this.processorDescription = (String)executeContext.getApplicationContext().getData(this.getClass().getName());
    }

    public AbstractBusinessProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        this.executeContext = executeContext;
        this.executeMode = executeMode;
        this.conditions = conditions;
        this.transactionMode = transactionMode;
        this.init(executeContext);
    }

    private void init(ExecuteContext executeContext) {
        this.ctx = executeContext.context;
        this.bosType = executeContext.bosType;
        this.batchAction = executeContext.batchAction;
        this.mainOrgType = executeContext.mainOrgType;
        this.setBusinessChainSupport(new DefaultBusinessProcessorChainSupport());
    }

    public AbstractBusinessProcessor(ProcessorConstructParam param) {
        this.executeContext = param.executeContext;
        this.executeMode = param.executeMode;
        this.conditionExpression = param.conditionExpression;
        this.transactionMode = param.transactionMode;
        this.init(this.executeContext);
    }

    @Override
    public void setBatchExecutor(IBatchExecute batchExecutor) {
        this.batchExecutor = batchExecutor;
    }

    protected BusinessProcessConfigItem getBusinessProcessConfigItem() throws BOSException {
        BusinessProcessConfigItem configItem = null;
        ExecuteContext executeContext = this.createExecuteContext();
        configItem = (BusinessProcessConfigItem)BusinessConfigFactory.getInstance(this.ctx).getBusinessProcessConfig(executeContext);
        return configItem;
    }

    private ExecuteContext createExecuteContext() throws BOSException {
        if (this.executeContext == null) {
            this.executeContext = new BillsExecuteContext(this.ctx, this.bosType, this.batchAction, null, new Object[0]);
            String xmlFileName = BusinessProcessSqlBuilder.getInstance(this.ctx).getXmlFileInCache(this.bosType.toString());
            if (xmlFileName == null) {
                xmlFileName = XmlConfigProxy.xmlConfigProxy.getBizFilePath(this.bosType.toString());
            }
            this.executeContext.setXmlFileName(xmlFileName);
        }
        return this.executeContext;
    }

    private void executeLoopNewTrans(IBusinessBatchHandle handler, BatchActionResults batchResults) throws BOSException {
        try {
            IObjectCollection objCollection = batchResults.getObjCollection();
            if (objCollection == null) {
                return;
            }
            Set idSet = batchResults.getToDoIdsSet();
            if (idSet.size() == 0) {
                return;
            }
            int size = objCollection.size();
            for (int i = 0; i < size; ++i) {
                String id;
                IObjectValue vo = objCollection.getObject(i);
                BOSUuid pk = (BOSUuid)vo.get(vo.getPKField());
                String string = id = pk == null ? "NEWID" : pk.toString();
                if (!batchResults.isToDo(id)) continue;
                IObjectCollection col = BusinessProcessUtil.getCollectionInstance(this.ctx, this.bosType);
                col.addObject(vo);
                batchResults.setObjCollection(col);
                try {
                    TransactionInvokeUtil.invokeRequiresNew(handler, "handle", new Object[]{this.ctx, batchResults}, null);
                    continue;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof InvocationTargetException && ((InvocationTargetException)e.getCause()).getTargetException() != null) {
                        batchResults.addError(id, ((InvocationTargetException)e.getCause()).getTargetException().getMessage());
                        continue;
                    }
                    batchResults.addError(id, e);
                }
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    protected void executeHandler(IBusinessBatchHandle handler, BatchActionResults batchResults) throws BOSException, EASBizException {
        ProcessorExecutionMode mode = this.supportExecutionMode();
        if (mode.equals(ProcessorExecutionMode.LOOPNEWTRANS)) {
            this.executeLoopNewTrans(handler, batchResults);
        } else {
            handler.handle(this.ctx, batchResults);
        }
    }

    protected void outputLog(String message) {
        this.outputLog(message, null);
    }

    protected void outputLog(String message, String[] ids) {
        StringBuffer sb = new StringBuffer();
        sb.append("[HostName:").append(this.ctx.getClientHostName()).append("] ").append("[UerID:").append(this.ctx.getCaller().toString()).append("] ").append("[Processor:").append(this.getClass().getName()).append("] ");
        if (this.batchAction != null) {
            String name = this.batchAction.getName();
            if (name == null) {
                name = this.batchAction.getBizAction();
            }
            sb.append("[Action:").append(name).append("] ");
        }
        if (ids != null) {
            sb.append("[BillID:");
            for (int i = 0; i < ids.length; ++i) {
                sb.append(ids[i]).append(",");
            }
            if (ids.length > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("]");
            sb.append("\r\n");
        }
        sb.append(message);
        this.executeContext.getLogger().debug(sb.toString());
    }

    @Override
    public IBusinessProcessorChainSupport getBusinessChainSupport() {
        if (this.businessChainSupport == null) {
            this.setBusinessChainSupport(new NoBusinessProcessorChainSupport());
        }
        return this.businessChainSupport;
    }

    @Override
    public void setBusinessChainSupport(IBusinessProcessorChainSupport businessChainSupport) {
        this.businessChainSupport = businessChainSupport;
        this.businessChainSupport.setOwnProcessor(this);
    }

    protected ExecuteContext getExecuteContext() {
        return this.executeContext;
    }
}

