/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class ActionListProcessor
extends AbstractBusinessProcessor {
    public ActionListProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public ActionListProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public ActionListProcessor(ProcessorConstructParam param) {
        super(param);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BusinessProcessConfigItem configItem = this.getBusinessProcessConfigItem();
        if (configItem.getActionList() != null) {
            int paramSize;
            IObjectCollection objCollection = batchResults.getObjCollection();
            BatchExecuteParamsEntry[] parameters = batchResults.getParamEntries();
            if (parameters != null && objCollection != null && objCollection.size() > 0 && (paramSize = parameters[0].getParamTypes().length) > 1) {
                int size = objCollection.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue vo = objCollection.getObject(i);
                    if (parameters.length <= i) break;
                    for (int j = 1; j < paramSize; ++j) {
                        vo.put("parameter." + (j + 1), parameters[i].get(j));
                    }
                }
            }
            this.executeHandler(configItem.getActionList(), batchResults);
        }
    }

    @Override
    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        ProcessorExecutionMode mode;
        BusinessProcessConfigItem configItem = this.getBusinessProcessConfigItem();
        if (configItem != null && configItem.getActionList() != null && (mode = configItem.getActionList().supportExecutionMode()) != null) {
            return mode;
        }
        return ProcessorExecutionMode.UNSUPPORT;
    }
}

