/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.lang.reflect.Method;
import java.util.List;

public class SubmitBusinessProcessor
extends AbstractBusinessProcessor {
    private static final String SUBMIT_METHOD = "submitRelations";
    private static final String SAVE_METHOD = "saveRelations";

    public SubmitBusinessProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SubmitBusinessProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SubmitBusinessProcessor(ProcessorConstructParam param) {
        super(param);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IBTPManager iBiz = null;
        Method mSubmit = null;
        iBiz = BTPManagerFactory.getLocalInstance((Context)this.ctx);
        mSubmit = BusinessProcessUtil.getLocBizMethod((IBizCtrl)iBiz, this.batchAction.equals((Object)BatchActionEnum.SUBMIT) ? SUBMIT_METHOD : SAVE_METHOD, new Class[]{CoreBillBaseInfo.class, BOTRelationCollection.class});
        IObjectCollection collection = batchResults.getObjCollection();
        List toList = batchResults.getToDoIdsList();
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)this.ctx);
        boolean hasRelation = batchResults.getParamEntries().length > 0 && batchResults.getParamEntries()[0].getParamTypes().length > 1 && BOTRelationCollection.class.equals((Object)batchResults.getParamEntries()[0].getParamTypes()[1]);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            String id;
            IObjectValue vo = collection.getObject(i);
            BOSUuid pk = (BOSUuid)vo.get(vo.getPKField());
            String string = id = pk == null ? "NEWID" : pk.toString();
            if (toList.indexOf(id) <= -1) continue;
            try {
                BOTRelationCollection relations = null;
                if (hasRelation) {
                    relations = (IObjectCollection)batchResults.getParamEntries()[i].get(1);
                }
                if (relations == null) {
                    relations = iBTPManager.getRelationCollection(id);
                }
                Object result = BusinessProcessUtil.invokeBizMethod((IBizCtrl)iBiz, mSubmit, new Object[]{vo, relations});
                if (!id.equals("NEWID") || result == null || !(result instanceof IObjectPK)) continue;
                batchResults.replaceNewId(((IObjectPK)result).toString());
                continue;
            }
            catch (EASBizException e) {
                batchResults.addError(id, (Exception)((Object)e));
                throw e;
            }
        }
    }

    @Override
    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        BusinessProcessConfigItem configItem;
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        if (entries != null && entries.length > 0) {
            if (entries[0].get(0) instanceof IObjectValue) {
                IObjectCollection collection = BusinessProcessUtil.getCollectionInstance(this.ctx, this.bosType);
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    IObjectValue objValue = (IObjectValue)entries[i].get(0);
                    collection.addObject(objValue);
                }
                batchResults.setObjCollection(collection);
            }
            batchResults.setParamEntries(entries);
        }
        if ((configItem = this.getBusinessProcessConfigItem()) != null && configItem.getCheckItems() != null) {
            configItem.getCheckItems().getBusinessCheckHandler(this.ctx).handle(this.ctx, batchResults);
        }
        return batchResults.hasToDos();
    }

    @Override
    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.MAIN;
    }
}

