/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.util.LowTimer;
import org.apache.log4j.Logger;

public class WritebackBusinessProcessor
extends AbstractBusinessProcessor {
    private static Logger logger = Logger.getLogger(WritebackBusinessProcessor.class);

    public WritebackBusinessProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public WritebackBusinessProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public WritebackBusinessProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        LowTimer timer = new LowTimer();
        BusinessProcessConfigItem configItem = this.getBusinessProcessConfigItem();
        if (configItem != null && configItem.getWritebackItem() != null) {
            configItem.getWritebackItem().handle(this.ctx, batchResults);
        }
        logger.info((Object)new StringBuffer().append(this.getClass().getName()).append("--Common WriteBack resume time: ").append(timer.msValue()).toString());
        timer.reset();
    }

    @Override
    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        ProcessorExecutionMode mode;
        BusinessProcessConfigItem configItem = this.getBusinessProcessConfigItem();
        if (configItem != null && configItem.getWritebackItem() != null && (mode = configItem.getWritebackItem().supportExecutionMode()) != null) {
            return mode;
        }
        return ProcessorExecutionMode.UNSUPPORT;
    }
}

