/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchBuild;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BOTProcessSubItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.InitializationHelper;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BOTProcessConfigItem
implements IBusinessBatchHandle,
IBusinessBatchBuild {
    static final Logger logger = Logger.getLogger(BOTProcessConfigItem.class);
    private String id;
    private String name;
    private List subBOTItems;
    private BusinessProcessConfigItem parent;
    private Conditions preCondition;
    private boolean isInitialized = false;
    private List selectorList;

    public void setPreCondition(Conditions preCondition) {
        this.preCondition = preCondition;
    }

    public BOSObjectType getDstBosType(String sourceId) {
        if (sourceId == null) {
            return BOSObjectType.create((String)this.parent.getBosType());
        }
        int size = this.subBOTItems.size();
        for (int i = 0; i < size; ++i) {
            BOTProcessSubItem item = (BOTProcessSubItem)this.subBOTItems.get(i);
            if (!sourceId.equals(item.getId())) continue;
            return item.getDstBosType();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public BOTProcessConfigItem(String id, BusinessProcessConfigItem parent, String name) {
        this.id = id;
        this.parent = parent;
        this.name = name;
    }

    public List getSubBOTItems() {
        return this.subBOTItems;
    }

    public void setSubBOTItems(List subBOTItems) {
        this.subBOTItems = subBOTItems;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (this.subBOTItems.size() == 0) {
            return;
        }
        if (!this.isInitialized) {
            this.build(ctx);
        }
        int size = this.subBOTItems.size();
        for (int i = 0; i < size; ++i) {
            BOTProcessSubItem firstItem = (BOTProcessSubItem)this.subBOTItems.get(i);
            if (firstItem.getSeq() != 0) continue;
            firstItem.handle(ctx, batchResults);
        }
    }

    boolean preCondition(Context ctx, BOTProcessSubItem subItem, IObjectCollection dataSources) throws EASBizException, BOSException {
        if (this.preCondition == null) {
            return true;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("_CTX", ctx);
        paramMap.put("_ENTRISENAME", BusinessProcessUtil.getEntityEntriesName(ctx, BOSObjectType.create((String)this.parent.getBosType())));
        Iterator iter = dataSources.iterator();
        if (iter.hasNext()) {
            IObjectValue objValue = (IObjectValue)iter.next();
            boolean result = this.preCondition.calculateResult(objValue, 0, paramMap, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("BOT\u914d\u7f6e\u9879[" + this.name + "]\u7684\u524d\u7f6e\u6761\u4ef6[" + this.preCondition.toString() + "]\u7684\u503c\u4e3a" + result));
            }
            return result;
        }
        return true;
    }

    public BusinessProcessConfigItem getParent() {
        return this.parent;
    }

    @Override
    public synchronized void build(Context ctx) throws BOSException {
        if (this.isInitialized) {
            return;
        }
        BOTProcessSubItem prevousItem = null;
        int seq = 0;
        int size = this.subBOTItems.size();
        for (int i = 0; i < size; ++i) {
            BOTProcessSubItem subItem = (BOTProcessSubItem)this.subBOTItems.get(i);
            if (subItem.getSourceKey() == null) {
                seq = 0;
            }
            if (seq > 0) {
                prevousItem.setNextSubItem(subItem);
            }
            subItem.setSeq(seq++);
            prevousItem = subItem;
        }
        HashMap subEntities = new HashMap();
        this.selectorList = new ArrayList();
        BOSObjectType srcBosType = BOSObjectType.create((String)this.parent.getBosType());
        EntityObjectInfo srcEo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(srcBosType);
        InitializationHelper.preTreatingConds(ctx, this.preCondition, srcEo, subEntities, this.selectorList);
        this.isInitialized = true;
    }

    public List getSelectorList() {
        return this.selectorList;
    }

    public String getId() {
        return this.id;
    }
}

