/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.handler.TableCheckHandler;
import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.condition.Condition;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.SqlBuilderHelper;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;

public class TableCheckConfigItems
extends BusinessCheckConfigItems {
    boolean isInitialized = false;
    String checkSql = null;

    public TableCheckConfigItems(Object parent) {
        super(parent);
    }

    public String getCheckSql() {
        return this.checkSql;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public Object deepedCloned(BusinessProcessConfigItem bpcItem) throws CloneNotSupportedException {
        TableCheckConfigItems cci = (TableCheckConfigItems)super.deepedCloned(bpcItem);
        cci.isInitialized = false;
        return cci;
    }

    @Override
    public synchronized void build(Context ctx) throws BOSException {
        if (this.isInitialized) {
            return;
        }
        this.checkSql = this.getParent() instanceof WriteBackSubItem ? ((WriteBackSubItem)this.getParent()).buildWriteBackCheckSql(ctx) : this.buildBizCheckSql(ctx);
        this.isInitialized = true;
    }

    private String buildBizCheckSql(Context ctx) throws BOSException {
        BusinessProcessConfigItem configItem = (BusinessProcessConfigItem)this.getParent();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        boolean hasEntry = false;
        boolean isHead = true;
        if (this.getParent() instanceof BusinessProcessConfigItem && ((BusinessProcessConfigItem)this.getParent()).getActionLevel().equals((Object)ActionLevelEnum.ENTRY)) {
            isHead = false;
        }
        for (BusinessCheckConfigItem checkItem : this.getCheckItems().values()) {
            if (i > 0) {
                sb.append("UNION ALL");
                sb.append("\r\n");
            }
            ++i;
            int levelFrom = 0;
            hasEntry = false;
            boolean hasEntry1 = false;
            boolean hasHead1 = false;
            int condsize = checkItem.getConditions().getConditions().size();
            for (int j = 0; j < condsize; ++j) {
                Condition condition = (Condition)checkItem.getConditions().getConditions().get(j);
                ColumnItem item = (ColumnItem)condition.getItem();
                if (!hasEntry) {
                    hasEntry = item.getTable().equals(TableTypeEnum.ENTRY);
                }
                if (levelFrom < item.getLevelFrom()) {
                    levelFrom = item.getLevelFrom();
                }
                if (condition.getValue() instanceof ColumnItem && levelFrom < ((ColumnItem)condition.getValue()).getLevelFrom()) {
                    levelFrom = ((ColumnItem)condition.getValue()).getLevelFrom();
                }
                if (!hasEntry1) {
                    hasEntry1 = condition.hasLevelGreaterZero("entry");
                }
                if (hasHead1) continue;
                hasHead1 = condition.hasLevelGreaterZero("head");
            }
            sb.append("SELECT ");
            if (hasEntry || levelFrom > 0) {
                sb.append("DISTINCT ");
            }
            sb.append("head");
            sb.append(".FID, '");
            sb.append(checkItem.getId());
            sb.append("' AS FErrID");
            if (!isHead) {
                sb.append(", ");
                sb.append("entry");
                sb.append(".FID AS FEntryID");
            }
            sb.append("\r\n");
            sb.append(SqlBuilderHelper.buildConjunctionClause(configItem.getBillTypeId(), ctx, levelFrom, checkItem.getSrcBillIds(), hasEntry, hasEntry1, hasHead1, "FSourceBillEntryId", configItem.getBosType()));
            sb.append(checkItem.getConditions().buildJoin());
            sb.append(SqlBuilderHelper.buildWhereClause(checkItem.getConditions(), isHead));
        }
        return sb.toString();
    }

    @Override
    public IBusinessBatchHandle getBusinessCheckHandler(Context ctx) throws BOSException {
        return new TableCheckHandler(this);
    }

    public IBusinessBatchHandle getBusinessCheckHandler(String tempTableName) {
        return new TableCheckHandler(this, tempTableName);
    }
}

