/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.BusinessObjectStructure;
import com.kingdee.eas.dynbusiness.config.ColumnPair;
import com.kingdee.eas.dynbusiness.config.UpdateStatusItem;
import com.kingdee.eas.dynbusiness.config.WriteBackConfigItem;
import com.kingdee.eas.dynbusiness.config.WriteBackPolicy;
import java.util.Collection;
import java.util.List;

public abstract class WriteBackSubItem
implements IBusinessConfigItem {
    protected List srcBillIds;
    protected Conditions conditions;
    protected List columnPairs;
    private UpdateStatusItem[] writebackStatusItems;
    protected BusinessCheckConfigItems checkItems;
    private String[] writeTo;
    protected String status = null;
    protected String dstBillTypeId;
    private WriteBackConfigItem parent;
    private String obtainSrcIdSql;
    private String lockSourceTableSql;
    private String debugSql;
    private WriteBackPolicy policy;
    private String[] srcBosTypes;
    protected String dstBosType;
    protected String oldIdField = "FOldID";
    protected BusinessObjectStructure boStructure;

    public void setOldIdField(String oldIdField) {
        this.oldIdField = oldIdField;
    }

    public String[] getSrcBosTypes() {
        return this.srcBosTypes;
    }

    public String getDstBosType() {
        return this.dstBosType;
    }

    public String getRelationHeadField() {
        return this.boStructure.getRelationField(TableTypeEnum.HEAD);
    }

    public void setBoStructure(BusinessObjectStructure boStructure) {
        this.boStructure = boStructure;
    }

    public String getRelationHeadField(int level) {
        return this.boStructure.getRelationField(level, TableTypeEnum.HEAD);
    }

    public String getRelationEntryField() {
        return this.boStructure.getRelationField(TableTypeEnum.ENTRY);
    }

    public String getRelationEntryField(int level) {
        return this.boStructure.getRelationField(level, TableTypeEnum.ENTRY);
    }

    public WriteBackSubItem(WriteBackConfigItem parent, String id) {
        this.dstBillTypeId = id;
        this.parent = parent;
    }

    public void setDstBosType(String dstBosType) {
        this.dstBosType = dstBosType;
    }

    public abstract String buildWriteBackCheckSql(Context var1) throws BOSException;

    protected void buildWriteBackSqls(Context ctx) throws BOSException {
        BusinessObjectStructure dstStructure = this.parent.getParent().parent.getBoStructure();
        this.boStructure.mergeStructure(dstStructure);
        if (BusinessProcessorHelper.isDebug()) {
            this.debugSql = this.buildDebugWriteBackDataSql(ctx);
        }
        this.obtainSrcIdSql = this.buildObtainSrcIdSql(ctx);
        this.lockSourceTableSql = this.buildLockSourceTableSql(ctx);
    }

    protected abstract String buildDebugWriteBackDataSql(Context var1) throws BOSException;

    protected abstract String buildObtainSrcIdSql(Context var1) throws BOSException;

    protected boolean isWriteToSrc() {
        return this.writeTo[0].equalsIgnoreCase("SOURCE");
    }

    public boolean isWriteToSrc(int level) {
        if (level > this.boStructure.getLevel()) {
            level = this.boStructure.getLevel();
        } else if (level == 0) {
            level = 1;
        }
        String type = this.getWriteTo()[level - 1];
        return type.equalsIgnoreCase("SOURCE");
    }

    protected String getUpdColConditionList(List columnPairList) {
        StringBuffer sb = new StringBuffer();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (pair.getConditions() != null) {
                sb.append(pair.getConditions().buildUpdColList());
            }
            if (pair.getIfConditions() == null) continue;
            sb.append(pair.getIfConditions().buildUpdColList());
        }
        return sb.toString();
    }

    protected String buildLockSourceTableSql(Context ctx) throws BOSException {
        return this.boStructure.buildLockSourceTableSql();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BusinessCheckConfigItems getCheckItems() {
        return this.checkItems;
    }

    public void setCheckItems(BusinessCheckConfigItems checkItems) {
        this.checkItems = checkItems;
    }

    public List getColumnPairs() {
        return this.columnPairs;
    }

    public void setColumnPairs(List columnPairs) {
        this.columnPairs = columnPairs;
    }

    public int getLevel() {
        return this.boStructure.getLevel();
    }

    public void setLevel(int level) {
        if (this.writeTo == null) {
            this.writeTo = new String[level];
            for (int i = 0; i < level; ++i) {
                this.writeTo[i] = "SOURCE";
            }
        }
    }

    public List getSrcBillIds() {
        return this.srcBillIds;
    }

    public void setSrcBillIds(List srcBillIds) {
        this.srcBillIds = srcBillIds;
    }

    public String[] getWriteTo() {
        return this.writeTo;
    }

    public void setWriteTo(String writeTo, int level) {
        if (writeTo != null) {
            String[] wts = writeTo.split("\\s*[,;\\s]{1}\\s*");
            if (wts.length == level) {
                this.writeTo = wts;
            } else {
                this.writeTo = new String[level];
                for (int i = 0; i < level; ++i) {
                    this.writeTo[i] = i < wts.length ? wts[i] : "SOURCE";
                }
            }
        }
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public void setSrcBosTypes(String[] srcBosTypes) {
        this.srcBosTypes = srcBosTypes;
    }

    public WriteBackConfigItem getParent() {
        return this.parent;
    }

    public String getObtainSrcIdSql() {
        return this.obtainSrcIdSql;
    }

    public String getLockSourceTableSql() {
        return this.lockSourceTableSql;
    }

    public String getDstBillTypeId() {
        return this.dstBillTypeId;
    }

    public String getDebugSql() {
        return this.debugSql;
    }

    public UpdateStatusItem[] getWritebackStatusItems() {
        return this.writebackStatusItems;
    }

    public WriteBackPolicy getPolicy() {
        return this.policy;
    }

    public void setUpdStatusItem(UpdateStatusItem[] writebackStatusItems) {
        this.writebackStatusItems = writebackStatusItems;
    }

    private String getFirstSrcBillType() {
        if (this.srcBillIds != null && this.srcBillIds.size() > 0) {
            return (String)this.srcBillIds.get(0);
        }
        return "";
    }

    public boolean containsFirstSrcOrCoreBillType(Collection colSrcTypes, Collection colCoreTypes) {
        String firstBillType = this.getFirstSrcBillType();
        return this.isWriteToSrc() ? colSrcTypes.contains(firstBillType) : colCoreTypes.contains(firstBillType);
    }
}

