/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.expression.format;

import com.kingdee.eas.dynbusiness.expression.ExpressionToken;
import com.kingdee.eas.dynbusiness.expression.datameta.BaseDataMeta;
import com.kingdee.eas.dynbusiness.expression.format.Element;
import com.kingdee.eas.dynbusiness.expression.format.ExpressionReader;
import com.kingdee.eas.dynbusiness.expression.format.FormatException;
import com.kingdee.eas.dynbusiness.expression.op.Operator;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class ExpressionParser {
    static final Logger logger = Logger.getLogger(ExpressionParser.class);
    private static Map operators = new HashMap();
    private Stack parenthesis = new Stack();

    public Operator getOperator(String name) {
        return (Operator)operators.get(name);
    }

    public List getExpressionTokens(String expression) throws FormatException {
        ExpressionReader eReader = new ExpressionReader(expression);
        ArrayList<ExpressionToken> list = new ArrayList<ExpressionToken>();
        ExpressionToken expressionToken = null;
        Element ele = null;
        try {
            while ((ele = eReader.readToken()) != null) {
                expressionToken = this.changeToToken(expressionToken, ele);
                this.pushParenthesis(ele);
                list.add(expressionToken);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (ParseException e) {
            throw new FormatException("\u8868\u8fbe\u5f0f\u8bcd\u5143\u683c\u5f0f\u5f02\u5e38");
        }
        if (!this.parenthesis.isEmpty()) {
            throw new FormatException("\u62ec\u53f7\u5339\u914d\u51fa\u9519");
        }
        return list;
    }

    public void pushParenthesis(Element ele) throws FormatException {
        if (Element.ElementType.SPLITOR.equals(ele.getType())) {
            if (ele.getText().equals("(")) {
                this.parenthesis.push("(");
            } else if (ele.getText().equals(")")) {
                if (this.parenthesis.isEmpty() || !this.parenthesis.peek().equals("(")) {
                    throw new FormatException("\u62ec\u53f7\u5339\u914d\u51fa\u9519");
                }
                this.parenthesis.pop();
            }
        }
    }

    public ExpressionToken changeToToken(ExpressionToken previousToken, Element ele) throws ParseException {
        if (ele == null) {
            throw new IllegalArgumentException();
        }
        ExpressionToken token = null;
        if (Element.ElementType.NULL.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_NULL, null);
        } else if (Element.ElementType.STRING.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_STRING, ele.getText());
        } else if (Element.ElementType.BOOLEAN.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_BOOLEAN, Boolean.valueOf(ele.getText()));
        } else if (Element.ElementType.INT.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_INT, Integer.valueOf(ele.getText()));
        } else if (Element.ElementType.BIGDECIMAL.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_BIGDECIMAL, new BigDecimal(ele.getText()));
        } else if (Element.ElementType.LONG.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_LONG, Long.valueOf(ele.getText()));
        } else if (Element.ElementType.FLOAT.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_FLOAT, Float.valueOf(ele.getText()));
        } else if (Element.ElementType.DOUBLE.equals(ele.getType())) {
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_DOUBLE, Double.valueOf(ele.getText()));
        } else if (Element.ElementType.DATE.equals(ele.getType())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            token = ExpressionToken.createConstantToken(BaseDataMeta.DataType.DATATYPE_DATE, sdf.parse(ele.getText()));
        } else if (Element.ElementType.VARIABLE.equals(ele.getType())) {
            token = ExpressionToken.createVariableToken(ele.getText());
        } else if (Element.ElementType.OPERATOR.equals(ele.getType())) {
            token = ele.getText().equals("-") && (previousToken == null || previousToken.getTokenType().equals(ExpressionToken.ETokenType.ETOKEN_TYPE_OPERATOR) || previousToken.getTokenType().equals(ExpressionToken.ETokenType.ETOKEN_TYPE_SPLITOR) && !")".equals(previousToken.getSplitor())) ? ExpressionToken.createOperatorToken(Operator.NG) : ExpressionToken.createOperatorToken(this.getOperator(ele.getText()));
        } else if (Element.ElementType.FUNCTION.equals(ele.getType())) {
            token = ExpressionToken.createFunctionToken(ele.getText());
        } else if (Element.ElementType.SPLITOR.equals(ele.getType())) {
            token = ExpressionToken.createSplitorToken(ele.getText());
        }
        token.setStartPosition(ele.getIndex());
        return token;
    }

    public static void main(String[] s) {
        String expression = "$CALCDATE($SYSDATE() ,0,0 , 7,0 ,0,aa ) > [2008-10-01]";
        ExpressionParser ep = new ExpressionParser();
        try {
            List list = ep.getExpressionTokens(expression);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ExpressionToken expressionToken = (ExpressionToken)list.get(i);
            }
        }
        catch (FormatException e) {
            logger.error((Object)e);
        }
    }

    static {
        operators.put(Operator.NOT.getToken(), Operator.NOT);
        operators.put(Operator.MUTI.getToken(), Operator.MUTI);
        operators.put(Operator.DIV.getToken(), Operator.DIV);
        operators.put(Operator.MOD.getToken(), Operator.MOD);
        operators.put(Operator.PLUS.getToken(), Operator.PLUS);
        operators.put(Operator.MINUS.getToken(), Operator.MINUS);
        operators.put(Operator.LT.getToken(), Operator.LT);
        operators.put(Operator.LE.getToken(), Operator.LE);
        operators.put(Operator.GT.getToken(), Operator.GT);
        operators.put(Operator.GE.getToken(), Operator.GE);
        operators.put(Operator.EQ.getToken(), Operator.EQ);
        operators.put(Operator.NEQ.getToken(), Operator.NEQ);
        operators.put(Operator.AND.getToken(), Operator.AND);
        operators.put(Operator.OR.getToken(), Operator.OR);
        operators.put(Operator.APPEND.getToken(), Operator.APPEND);
        operators.put(Operator.SELECT.getToken(), Operator.SELECT);
        operators.put(Operator.QUES.getToken(), Operator.QUES);
        operators.put(Operator.COLON.getToken(), Operator.COLON);
    }
}

