/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.expression.format.reader;

import com.kingdee.eas.dynbusiness.expression.format.Element;
import com.kingdee.eas.dynbusiness.expression.format.ExpressionReader;
import com.kingdee.eas.dynbusiness.expression.format.FormatException;
import com.kingdee.eas.dynbusiness.expression.format.reader.ElementReader;
import java.io.IOException;

public class VariableTypeReader
implements ElementReader {
    public static final String STOP_CHAR = "+-*/%^<>=&|!?:#$(),[]'\" \r\n\t";
    public static final String TRUE_WORD = "true";
    public static final String FALSE_WORD = "false";
    public static final String NULL_WORD = "null";

    private String readWord(ExpressionReader sr) throws FormatException, IOException {
        StringBuffer sb = new StringBuffer();
        boolean readStart = true;
        int b = -1;
        while ((b = sr.read()) != -1) {
            char c = (char)b;
            if (STOP_CHAR.indexOf(c) >= 0 && !readStart) {
                int blank = 0;
                while (c == ' ') {
                    ++blank;
                    b = sr.read();
                    if (b == -1) break;
                    c = (char)b;
                }
                sr.back(blank);
                if (c == '(') {
                    sb.insert(0, '$');
                }
                sr.reset();
                return sb.toString();
            }
            if (!Character.isJavaIdentifierPart(c)) {
                throw new FormatException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u975e\u6cd5\u5b57\u7b26\uff1a" + c);
            }
            if (readStart) {
                if (!Character.isJavaIdentifierStart(c)) {
                    throw new FormatException("\u540d\u79f0\u5f00\u5934\u4e0d\u80fd\u4e3a\u5b57\u7b26\uff1a" + c);
                }
                readStart = false;
            }
            sb.append(c);
            sr.mark(0);
        }
        return sb.toString();
    }

    @Override
    public Element read(ExpressionReader sr) throws FormatException, IOException {
        int index = sr.getCruuentIndex();
        String word = this.readWord(sr);
        if (TRUE_WORD.equals(word) || FALSE_WORD.equals(word)) {
            return new Element(word, index, Element.ElementType.BOOLEAN);
        }
        if (NULL_WORD.equals(word)) {
            return new Element(word, index, Element.ElementType.NULL);
        }
        if (word.charAt(0) == '$') {
            return new Element(word.substring(1), index, Element.ElementType.FUNCTION);
        }
        return new Element(word, index, Element.ElementType.VARIABLE);
    }
}

