/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.expression.op;

import com.kingdee.eas.dynbusiness.expression.IllegalExpressionException;
import com.kingdee.eas.dynbusiness.expression.datameta.BaseDataMeta;
import com.kingdee.eas.dynbusiness.expression.datameta.Constant;
import com.kingdee.eas.dynbusiness.expression.op.IOperatorExecution;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_AND;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_APPEND;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_COLON;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_DIV;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_EQ;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_GE;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_GT;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_LE;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_LT;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_MINUS;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_MOD;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_MUTI;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_NEQ;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_NG;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_NOT;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_OR;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_PLUS;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_QUES;
import com.kingdee.eas.dynbusiness.expression.op.define.Op_SELECT;
import java.util.HashMap;

public final class Operator {
    public static final Operator NOT = new Operator("!", 80, 1, "NOT");
    public static final Operator NG = new Operator("-", 80, 1, "NG");
    public static final Operator MUTI = new Operator("*", 70, 2, "NUTI");
    public static final Operator DIV = new Operator("/", 70, 2, "DIV");
    public static final Operator MOD = new Operator("%", 70, 2, "MOD");
    public static final Operator PLUS = new Operator("+", 60, 2, "PLUS");
    public static final Operator MINUS = new Operator("-", 60, 2, "MINUS");
    public static final Operator LT = new Operator("<", 50, 2, "LT");
    public static final Operator LE = new Operator("<=", 50, 2, "LE");
    public static final Operator GT = new Operator(">", 50, 2, "GT");
    public static final Operator GE = new Operator(">=", 50, 2, "GE");
    public static final Operator EQ = new Operator("==", 40, 2, "EQ");
    public static final Operator NEQ = new Operator("!=", 40, 2, "NEQ");
    public static final Operator AND = new Operator("&&", 30, 2, "AND");
    public static final Operator OR = new Operator("||", 20, 2, "OR");
    public static final Operator APPEND = new Operator("#", 10, 2, "APPEND");
    public static final Operator QUES = new Operator("?", 0, 0, "QUES");
    public static final Operator COLON = new Operator(":", 0, 0, "COLON");
    public static final Operator SELECT = new Operator("?:", 0, 3, "SELECT");
    private static final HashMap OP_RESERVE_WORD = new HashMap();
    private static final HashMap OP_EXEC_MAP;
    private static final HashMap OP_VALUE_MAP;
    private String token;
    private int priority;
    private int opType;
    private String name;

    public static boolean isLegalOperatorToken(String tokenText) {
        return OP_RESERVE_WORD.containsKey(tokenText);
    }

    Operator(String token, int priority, int opType, String name) {
        this.token = token;
        this.priority = priority;
        this.opType = opType;
        this.name = name;
    }

    public String getToken() {
        return this.token;
    }

    public int getPiority() {
        return this.priority;
    }

    public int getOpType() {
        return this.opType;
    }

    public Constant execute(Constant[] args) throws IllegalExpressionException {
        IOperatorExecution opExec = (IOperatorExecution)OP_EXEC_MAP.get(this);
        if (opExec == null) {
            throw new IllegalStateException("\u7cfb\u7edf\u5185\u90e8\u9519\u8bef\uff1a\u627e\u4e0d\u5230\u64cd\u4f5c\u7b26\u5bf9\u5e94\u7684\u6267\u884c\u5b9a\u4e49");
        }
        return opExec.execute(args);
    }

    public Constant verify(int opPositin, BaseDataMeta[] args) throws IllegalExpressionException {
        IOperatorExecution opExec = (IOperatorExecution)OP_EXEC_MAP.get(this);
        if (opExec == null) {
            throw new IllegalStateException("\u7cfb\u7edf\u5185\u90e8\u9519\u8bef\uff1a\u627e\u4e0d\u5230\u64cd\u4f5c\u7b26\u5bf9\u5e94\u7684\u6267\u884c\u5b9a\u4e49");
        }
        return opExec.verify(opPositin, args);
    }

    public static Operator valueOf(String tokenString) {
        if (OP_VALUE_MAP.containsKey(tokenString)) {
            return (Operator)OP_VALUE_MAP.get(tokenString);
        }
        throw new IllegalArgumentException("The Oprator " + tokenString + "is Illegal.");
    }

    public String toString() {
        return this.name;
    }

    static {
        OP_RESERVE_WORD.put(NOT.getToken(), NOT);
        OP_RESERVE_WORD.put(NG.getToken(), NG);
        OP_RESERVE_WORD.put(MUTI.getToken(), MUTI);
        OP_RESERVE_WORD.put(DIV.getToken(), DIV);
        OP_RESERVE_WORD.put(MOD.getToken(), MOD);
        OP_RESERVE_WORD.put(PLUS.getToken(), PLUS);
        OP_RESERVE_WORD.put(MINUS.getToken(), MINUS);
        OP_RESERVE_WORD.put(LT.getToken(), LT);
        OP_RESERVE_WORD.put(LE.getToken(), LE);
        OP_RESERVE_WORD.put(GT.getToken(), GT);
        OP_RESERVE_WORD.put(GE.getToken(), GE);
        OP_RESERVE_WORD.put(EQ.getToken(), EQ);
        OP_RESERVE_WORD.put(NEQ.getToken(), NEQ);
        OP_RESERVE_WORD.put(AND.getToken(), AND);
        OP_RESERVE_WORD.put(OR.getToken(), OR);
        OP_RESERVE_WORD.put(APPEND.getToken(), APPEND);
        OP_RESERVE_WORD.put(SELECT.getToken(), SELECT);
        OP_RESERVE_WORD.put(QUES.getToken(), QUES);
        OP_RESERVE_WORD.put(COLON.getToken(), COLON);
        OP_EXEC_MAP = new HashMap();
        OP_EXEC_MAP.put(NOT, new Op_NOT());
        OP_EXEC_MAP.put(NG, new Op_NG());
        OP_EXEC_MAP.put(MUTI, new Op_MUTI());
        OP_EXEC_MAP.put(DIV, new Op_DIV());
        OP_EXEC_MAP.put(MOD, new Op_MOD());
        OP_EXEC_MAP.put(PLUS, new Op_PLUS());
        OP_EXEC_MAP.put(MINUS, new Op_MINUS());
        OP_EXEC_MAP.put(LT, new Op_LT());
        OP_EXEC_MAP.put(LE, new Op_LE());
        OP_EXEC_MAP.put(GT, new Op_GT());
        OP_EXEC_MAP.put(GE, new Op_GE());
        OP_EXEC_MAP.put(EQ, new Op_EQ());
        OP_EXEC_MAP.put(NEQ, new Op_NEQ());
        OP_EXEC_MAP.put(AND, new Op_AND());
        OP_EXEC_MAP.put(OR, new Op_OR());
        OP_EXEC_MAP.put(APPEND, new Op_APPEND());
        OP_EXEC_MAP.put(SELECT, new Op_SELECT());
        OP_EXEC_MAP.put(QUES, new Op_QUES());
        OP_EXEC_MAP.put(COLON, new Op_COLON());
        OP_VALUE_MAP = new HashMap();
        OP_VALUE_MAP.put(Operator.NOT.name, NOT);
        OP_VALUE_MAP.put(Operator.NG.name, NG);
        OP_VALUE_MAP.put(Operator.MUTI.name, MUTI);
        OP_VALUE_MAP.put(Operator.DIV.name, DIV);
        OP_VALUE_MAP.put(Operator.MOD.name, MOD);
        OP_VALUE_MAP.put(Operator.PLUS.name, PLUS);
        OP_VALUE_MAP.put(Operator.MINUS.name, MINUS);
        OP_VALUE_MAP.put(Operator.LT.name, LT);
        OP_VALUE_MAP.put(Operator.LE.name, LE);
        OP_VALUE_MAP.put(Operator.GT.name, GT);
        OP_VALUE_MAP.put(Operator.GE.name, GE);
        OP_VALUE_MAP.put(Operator.EQ.name, EQ);
        OP_VALUE_MAP.put(Operator.NEQ.name, NEQ);
        OP_VALUE_MAP.put(Operator.AND.name, AND);
        OP_VALUE_MAP.put(Operator.OR.name, OR);
        OP_VALUE_MAP.put(Operator.APPEND.name, APPEND);
        OP_VALUE_MAP.put(Operator.SELECT.name, SELECT);
        OP_VALUE_MAP.put(Operator.QUES.name, QUES);
        OP_VALUE_MAP.put(Operator.COLON.name, COLON);
    }
}

