/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.function.Function;
import com.kingdee.eas.dynbusiness.function.IFunction;
import com.kingdee.eas.dynbusiness.function.IFunctionLoader;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FunctionLoader
implements IFunctionLoader {
    static final Logger logger = Logger.getLogger(FunctionLoader.class);
    public static final String FUNC_BOSTYPE = "bostype";
    public static final String FUNC_ABS = "abs";
    public static final String FUNC_MAINORGTYPE = "mainOrgType";
    public static final String FUNC_DATE = "date";
    public static final String FUNC_GETDATE = "getDate";
    private static final String FUNC_GETBILLNUMBER = "getBillNumber";
    private static final String FUNC_GETUSER = "getUser";
    private static final String FUNC_GETORGUNIT = "getOrgUnit";
    private static final String FUNC_GETPOSITION = "getPosition";
    private static final String FUNC_DATEADD = "dateAdd";
    private static final String FUNC_DATESET = "dateSet";
    private static final String FUNC_SUM = "sum";
    private static final String FUNC_ISNULL = "isNull";
    private static final String FUNC_FORMAT = "format";
    private static List functions = new ArrayList();

    public static boolean isFunction(String cal) {
        return cal != null && functions.contains(cal.toUpperCase());
    }

    public static Object calculateFunction(Object value, String cal, Map paramMap) throws EASBizException, BOSException {
        if (cal == null) {
            return value;
        }
        if (cal.equalsIgnoreCase(FUNC_BOSTYPE)) {
            if (value instanceof String) {
                return BOSUuid.read((String)((String)value)).getType().toString();
            }
            if (value instanceof BOSUuid) {
                return ((BOSUuid)value).getType().toString();
            }
        } else {
            if (cal.equalsIgnoreCase(FUNC_ABS)) {
                int iValue;
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).abs();
                }
                if (value instanceof Integer && (iValue = ((Integer)value).intValue()) < 0) {
                    return new Integer(-1 * iValue);
                }
                return value;
            }
            if (cal.equalsIgnoreCase(FUNC_MAINORGTYPE)) {
                Context ctx = null;
                if (paramMap.get("is_caller_websvr") == null) {
                    ctx = (Context)paramMap.get("_CTX");
                }
                if (value instanceof IObjectValue) {
                    return BusinessProcessUtil.getOrgTypeFromEntity(ctx, ((IObjectValue)value).getBOSType());
                }
                if (value instanceof BOSObjectType) {
                    return BusinessProcessUtil.getOrgTypeFromEntity(ctx, (BOSObjectType)value);
                }
                if (value instanceof String && ((String)value).length() == 6) {
                    BOSObjectType bosType = BOSObjectType.create((String)((String)value));
                    return BusinessProcessUtil.getOrgTypeFromEntity(ctx, bosType);
                }
            } else if (cal.equalsIgnoreCase(FUNC_DATE)) {
                if (value instanceof Date) {
                    return value;
                }
                if (value instanceof Timestamp) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(((Timestamp)value).getTime());
                    return FunctionLoader.truncateTime(calendar);
                }
            } else if (cal.equalsIgnoreCase(FUNC_GETDATE)) {
                Calendar calendar = Calendar.getInstance();
                return FunctionLoader.truncateTime(calendar);
            }
        }
        return null;
    }

    private static Object truncateTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @Override
    public IFunction parseFunction(String expr) {
        String[] funcs = ExpressionParser.getInstance().parseFunction(expr);
        if (funcs.length == 0) {
            return null;
        }
        String cal = funcs[0];
        String[] parameters = new String[funcs.length - 1];
        System.arraycopy(funcs, 1, parameters, 0, parameters.length);
        if (cal.equalsIgnoreCase(FUNC_GETDATE)) {
            return new Function.GetDateFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_GETBILLNUMBER)) {
            return new Function.GetBillNumberFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_GETUSER)) {
            return new Function.GetUserFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_GETORGUNIT)) {
            return new Function.GetOrgUnitFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_DATEADD)) {
            return new Function.DateAddFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_DATESET)) {
            return new Function.DateSetFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_SUM)) {
            return new Function.SumFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_GETPOSITION)) {
            return new Function.GetPositionFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_ISNULL)) {
            return new Function.IsNullFunction(cal, parameters);
        }
        if (cal.equalsIgnoreCase(FUNC_FORMAT)) {
            return new Function.FormatFunction(cal, parameters);
        }
        return null;
    }

    public static IFunctionLoader getInstance() {
        return new FunctionLoader();
    }

    static {
        try {
            Field[] fields = FunctionLoader.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.getType().getName().equals("java.lang.String")) continue;
                String function = (String)field.get(field.getName());
                functions.add(function.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
    }
}

