/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.util;

import com.kingdee.bos.ctrl.data.modal.DataConvertHelper;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataConverter {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String STD_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Pattern ISO_DATE_FORMAT_PATTERN = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2}");
    private static final Pattern ISO_DATETIME_FORMAT_PATTERN = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}");
    private static final Pattern STD_DATETIME_FORMAT_PATTERN = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2}\\s\\d{2}:\\d{2}:\\d{2}");

    public static Object convertToRealType(Object obj, DataType dataType, String className) throws DataConvertException {
        block14: {
            if (obj == null) {
                return null;
            }
            if (dataType.equals((Object)DataType.ENUM)) {
                try {
                    Class<?> c = Class.forName(className);
                    if (IntEnum.class.isAssignableFrom(c)) {
                        Integer value = !(obj instanceof Integer) ? Integer.valueOf(obj.toString()) : (Integer)obj;
                        Method m = c.getMethod("getEnum", Integer.TYPE);
                        IntEnum e = (IntEnum)m.invoke(null, value);
                        return e;
                    }
                    if (StringEnum.class.isAssignableFrom(c)) {
                        Method m = c.getMethod("getEnum", String.class);
                        StringEnum e = (StringEnum)m.invoke(null, obj.toString());
                        return e;
                    }
                    break block14;
                }
                catch (ClassNotFoundException e) {
                    throw new DataConvertException("The datatype's className is not a valid Enum class.");
                }
                catch (SecurityException e) {
                    throw new DataConvertException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new DataConvertException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new DataConvertException(e);
                }
                catch (IllegalAccessException e) {
                    throw new DataConvertException(e);
                }
                catch (InvocationTargetException e) {
                    throw new DataConvertException(e);
                }
            }
            if (dataType.equals((Object)DataType.DECIMAL)) {
                return new BigDecimal(obj.toString());
            }
        }
        try {
            return DataConvertHelper.convertData((Object)obj, (com.kingdee.bos.ctrl.common.DataType)DataConverter.dataTypeAdapting(dataType));
        }
        catch (DataConvertHelper.DataConvertException e) {
            throw new DataConvertException(e);
        }
    }

    public static Object convert(Object obj, String val, DataType dataType, String className) {
        try {
            Object covertedValue = null;
            if (dataType.equals((Object)DataType.ENUM)) {
                if (obj instanceof Integer) {
                    covertedValue = DataConverter.stringConvert(val, DataType.INTEGER, className);
                }
            } else {
                if (dataType.equals((Object)DataType.BOSUUID)) {
                    return BOSUuid.read((String)val);
                }
                covertedValue = DataConverter.stringConvert(val, dataType, className);
            }
            return covertedValue;
        }
        catch (DataConvertException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Object stringConvert(String val, DataType dataType, String className) throws DataConvertException {
        DateFormat dateFormat;
        String str = val;
        if (dataType.equals((Object)DataType.STRING)) {
            return str;
        }
        if (StringUtil.isEmpty(val)) {
            return null;
        }
        if (dataType.equals((Object)DataType.ENUM)) {
            try {
                Class<?> clzEnum = Class.forName(className);
                return clzEnum.getField(val).get(val);
            }
            catch (ClassNotFoundException e) {
                throw new DataConvertException("The datatype's className is not a valid Enum class.");
            }
            catch (IllegalArgumentException e) {
                throw new DataConvertException(e);
            }
            catch (SecurityException e) {
                throw new DataConvertException(e);
            }
            catch (IllegalAccessException e) {
                throw new DataConvertException(e);
            }
            catch (NoSuchFieldException e) {
                throw new DataConvertException(e);
            }
        }
        if (dataType.equals((Object)DataType.OBJECTPK)) {
            return new ObjectStringPK(val);
        }
        if ((dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIMESTAMP) || dataType.equals((Object)DataType.TIME)) && (dateFormat = DataConverter.getMatchDateFormat(val)) != null) {
            try {
                return dateFormat.parse(val);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            return DataConvertHelper.convertData((Object)val, (com.kingdee.bos.ctrl.common.DataType)DataConverter.dataTypeAdapting(dataType));
        }
        catch (DataConvertHelper.DataConvertException e) {
            throw new DataConvertException(e);
        }
    }

    private static DateFormat getMatchDateFormat(String val) {
        Matcher matcher = ISO_DATETIME_FORMAT_PATTERN.matcher(val);
        if (matcher.matches()) {
            return new SimpleDateFormat(ISO_DATETIME_FORMAT);
        }
        matcher = ISO_DATE_FORMAT_PATTERN.matcher(val);
        if (matcher.matches()) {
            return new SimpleDateFormat(ISO_DATE_FORMAT);
        }
        matcher = STD_DATETIME_FORMAT_PATTERN.matcher(val);
        if (matcher.matches()) {
            return new SimpleDateFormat(STD_DATETIME_FORMAT);
        }
        return null;
    }

    static com.kingdee.bos.ctrl.common.DataType dataTypeAdapting(DataType dataType) throws DataConvertException {
        if (dataType.equals((Object)DataType.STRING)) {
            return com.kingdee.bos.ctrl.common.DataType.STRING;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return com.kingdee.bos.ctrl.common.DataType.BOOLEAN;
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            return com.kingdee.bos.ctrl.common.DataType.DECIMAL;
        }
        if (dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIMESTAMP) || dataType.equals((Object)DataType.TIME)) {
            return com.kingdee.bos.ctrl.common.DataType.DATETIME;
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            return com.kingdee.bos.ctrl.common.DataType.INTEGER;
        }
        if (dataType.equals((Object)DataType.SHORT)) {
            return com.kingdee.bos.ctrl.common.DataType.SHORT;
        }
        if (dataType.equals((Object)DataType.LONG)) {
            return com.kingdee.bos.ctrl.common.DataType.LONG;
        }
        if (dataType.equals((Object)DataType.FLOAT)) {
            return com.kingdee.bos.ctrl.common.DataType.FLOAT;
        }
        if (dataType.equals((Object)DataType.DOUBLE)) {
            return com.kingdee.bos.ctrl.common.DataType.DOUBLE;
        }
        if (dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.CHAR)) {
            return com.kingdee.bos.ctrl.common.DataType.BYTE;
        }
        throw new DataConvertException("does not support the dataType " + dataType);
    }

    public static class DataConvertException
    extends Exception {
        public DataConvertException(String arg0) {
            super(arg0);
        }

        public DataConvertException(Throwable cause) {
            super(cause);
        }
    }
}

