/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.eas.base.form.designer.IDesigner;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.SelectionManage;
import com.kingdee.eas.base.form.designer.ToolBarOperation;
import com.kingdee.eas.base.form.designer.command.ICommand;
import com.kingdee.eas.base.form.designer.listenner.DesignerEventsProxy;
import com.kingdee.eas.base.form.designer.listenner.IDesignerListener;
import com.kingdee.eas.base.form.designer.widget.WidgetItemBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class Designer
implements IDesigner {
    protected OverlayWindow overWnd;
    private DesignerEventsProxy eventsProxy;
    private ToolBarOperation toolbar;
    private int createType;
    private Object createData;
    private boolean lockEvent;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.designer.Designer");

    public Designer() {
        this.overWnd = new OverlayWindow(this);
        this.eventsProxy = new DesignerEventsProxy(this);
        this.toolbar = new ToolBarOperation(this.overWnd);
    }

    public Designer(JPanel panel) {
        this.overWnd = new OverlayWindow(this, panel);
        this.eventsProxy = new DesignerEventsProxy(this);
        this.toolbar = new ToolBarOperation(this.overWnd);
        Rectangle rc = new Rectangle(0, 0, panel.getWidth(), panel.getHeight());
        this.overWnd.putClientProperty("OriginalBounds", rc);
        panel.setEnabled(true);
        panel.add((Component)((Object)this.overWnd), new KDLayout.Constraints(325, rc), 0);
        this.overWnd.requestFocus();
        panel.repaint();
        this.overWnd.repaint();
    }

    public void setSize(Dimension d) {
        this.overWnd.setSize(d);
        this.overWnd.putClientProperty("OriginalBounds", new Rectangle(d));
        this.overWnd.putClientProperty("KDLayoutConstraints", new KDLayout.Constraints(0, this.overWnd.getBounds()));
    }

    public void addDesignerListener(IDesignerListener pl) {
        this.eventsProxy.addDesignerListener(pl);
    }

    public void clear() {
        this.overWnd.clear();
    }

    public void repaint() {
        this.overWnd.revalidate();
    }

    public void syncByControls() {
        try {
            this.overWnd.syncItemsWithControls();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DesignerEventsProxy getEventsProxy() {
        return this.eventsProxy;
    }

    private void addItem(WidgetItemBase item, Container parent) {
    }

    public void add(Component comp, Container parent) {
        this.overWnd.add(comp, parent);
    }

    public SelectionManage getSelection() {
        return this.overWnd.getSelection();
    }

    public boolean selectControl(Component c) {
        boolean rtv = false;
        WidgetItemBase item = this.overWnd.getItemFromControl(c);
        SelectionManage selection = this.overWnd.getSelection();
        if (item != null && !selection.isItemSelected(item)) {
            selection.clear();
            selection.selectItem(item);
            rtv = true;
            selection.endSelect();
        }
        return rtv;
    }

    public void setComponentParent(Component comp, Container parent) {
        this.overWnd.setComponentParent(comp, parent);
    }

    public ToolBarOperation getToolbar() {
        return this.toolbar;
    }

    public void registControlType(Class control, Class widgetItem) {
        this.overWnd.registControlType(control, widgetItem);
    }

    @Override
    public int getCreateType() {
        return this.createType;
    }

    public void setCreateType(int createType) {
        this.createType = createType;
    }

    @Override
    public Object getCreateData() {
        return this.createData;
    }

    public void setCreateData(Object createData) {
        this.createData = createData;
    }

    public boolean isLockEvent() {
        return this.lockEvent;
    }

    public void setLockEvent(boolean lockEvent) {
        this.lockEvent = lockEvent;
    }

    public void setLocked(boolean value) {
        this.overWnd.setLocked(value);
    }

    public void addCommand(ICommand cmd) {
        this.overWnd.getCommandList().addCommand(cmd);
    }

    public void setDesignTabIndexMode(boolean value) {
        this.overWnd.setDesignTabIndex(value);
        this.overWnd.repaint();
    }

    public boolean isDesignTabIndex() {
        return this.overWnd.isDesignTabIndex();
    }
}

