/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.form.client.ctrl.KDApproval;
import com.kingdee.eas.base.form.client.ctrl.KDRect;
import com.kingdee.eas.base.form.client.layout.Table.Cell;
import com.kingdee.eas.base.form.client.layout.Table.SizeAdjustor;
import com.kingdee.eas.base.form.client.layout.Table.TableLayout;
import com.kingdee.eas.base.form.designer.DragDropHandle;
import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.IDesigner;
import com.kingdee.eas.base.form.designer.KeyHandle;
import com.kingdee.eas.base.form.designer.MouseState;
import com.kingdee.eas.base.form.designer.SelectionManage;
import com.kingdee.eas.base.form.designer.SmartTag;
import com.kingdee.eas.base.form.designer.TabIndexManage;
import com.kingdee.eas.base.form.designer.command.CommandAdd;
import com.kingdee.eas.base.form.designer.command.CommandList;
import com.kingdee.eas.base.form.designer.listenner.DesignerEventsProxy;
import com.kingdee.eas.base.form.designer.widget.WidgetButton;
import com.kingdee.eas.base.form.designer.widget.WidgetContainer;
import com.kingdee.eas.base.form.designer.widget.WidgetItem;
import com.kingdee.eas.base.form.designer.widget.WidgetItemBase;
import com.kingdee.eas.base.form.designer.widget.WidgetLabel;
import com.kingdee.eas.base.form.designer.widget.WidgetLabelContainer;
import com.kingdee.eas.base.form.designer.widget.WidgetPanel;
import com.kingdee.eas.base.form.designer.widget.WidgetRect;
import com.kingdee.eas.base.form.designer.widget.WidgetSeparator;
import com.kingdee.eas.base.form.designer.widget.WidgetTabbedPane;
import com.kingdee.eas.base.form.designer.widget.WidgetTable;
import com.kingdee.eas.base.form.designer.widget.WidgetTableExt;
import com.kingdee.eas.base.form.designer.widget.WidgetTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OverlayWindow
extends KDPanel
implements MouseListener,
MouseMotionListener {
    private boolean bLocked;
    private static final long serialVersionUID = 1L;
    private JPanel designForm;
    private IDesigner designer;
    private SmartTag smartTag;
    private HashMap controlTypeMap;
    private HashMap controlMap;
    private LinkedList itemList;
    private List groupList;
    private List tabList;
    private boolean mouseDownFirstMove;
    private Point downPoint;
    private Point movePoint;
    private boolean isCreateType;
    private boolean designTabIndex;
    private boolean addToUndo = true;
    private HitResult hitResult;
    private SelectionManage selection;
    private WidgetItemBase optObject;
    private MouseState mouseState;
    private CommandList commandList;
    private Point oldOffset;
    private Point curOffset;
    private Point curPoint;
    private KDTextField inplaceEdit;
    private TabIndexManage tabIndex;
    private int dClkRes = 300;
    private long timeMouseDown = 0L;
    private Point lastPt = null;
    private boolean isControlBringTop;
    private Component bringTopControl;
    private Container controlParent;
    private int oldIndex;
    private int moveStep = 1;

    public OverlayWindow(IDesigner designer) {
        this.init(designer, (JPanel)((Object)this));
    }

    public OverlayWindow(IDesigner designer, JPanel form) {
        this.init(designer, form);
    }

    private void init(IDesigner designer, JPanel form) {
        this.setVisible(true);
        this.setFocusable(true);
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", this.getBounds());
        this.designForm = form;
        this.designer = designer;
        this.bLocked = false;
        this.isCreateType = false;
        this.designTabIndex = false;
        this.mouseDownFirstMove = false;
        this.setOpaque(false);
        this.controlMap = new HashMap();
        this.itemList = new LinkedList();
        this.groupList = new ArrayList();
        this.tabList = new ArrayList();
        this.selection = new SelectionManage(this);
        this.smartTag = new SmartTag(this);
        this.commandList = new CommandList(this);
        this.tabIndex = new TabIndexManage(this);
        this.hitResult = HitResult.None;
        this.mouseState = MouseState.None;
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(new KeyHandle(this));
        DropTarget dropTarget = new DropTarget((Component)((Object)this), new DragDropHandle(this));
        this.iniInplaceEdit(form);
        this.initControlTypeMap();
        form.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                OverlayWindow.this.setSize(e.getComponent().getSize());
                OverlayWindow.this.putClientProperty("KDLayoutConstraints", new KDLayout.Constraints(0, OverlayWindow.this.getBounds()));
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
    }

    private void iniInplaceEdit(JPanel form) {
        this.inplaceEdit = new KDTextField();
        this.inplaceEdit.setBounds(new Rectangle(0, 0, 20, 20));
        this.inplaceEdit.setVisible(false);
        this.inplaceEdit.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ((KDTextField)e.getSource()).setVisible(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.inplaceEdit.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                KDTextField txtEdit = (KDTextField)e.getSource();
                WidgetItemBase editItem = (WidgetItemBase)txtEdit.getClientProperty((Object)"EdtitItem");
                if (editItem != null) {
                    editItem.setText(OverlayWindow.this.inplaceEdit.getText());
                }
                OverlayWindow.this.inplaceEdit.setVisible(false);
            }
        });
        form.add((Component)this.inplaceEdit, new KDLayout.Constraints(0, new Rectangle(0, 0, 20, 20)), 0);
    }

    public void autoIndex() {
        this.tabIndex.autoIndex(this.designForm);
    }

    public boolean isLocked() {
        return this.bLocked;
    }

    public boolean isDesignTabIndex() {
        return this.designTabIndex;
    }

    public void setDesignTabIndex(boolean designTabIndex) {
        this.designTabIndex = designTabIndex;
    }

    public void setLocked(boolean value) {
        this.bLocked = value;
    }

    public DesignerEventsProxy getEventsProxy() {
        return this.designer.getEventsProxy();
    }

    public IDesigner getDesigner() {
        return this.designer;
    }

    public SmartTag getSmartTag() {
        return this.smartTag;
    }

    public LinkedList getItemContainer() {
        return this.itemList;
    }

    public WidgetItemBase getItemFromControl(Component control) {
        return (WidgetItemBase)this.controlMap.get(control);
    }

    public void add(Component comp, Container parent) {
        WidgetItemBase item = null;
        try {
            item = this.createWidgetItem(comp);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (item != null) {
            if (this.isAddToUndo()) {
                CommandAdd add = new CommandAdd(this, item, parent);
                this.getCommandList().addCommand(add);
                add.execute();
            } else {
                this.addItem(item, parent);
            }
        }
    }

    protected void syncItemsWithControls() throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.clearControlsMap();
        this.itemList.clear();
        this.clearRegistedContainers();
        Component[] coms = this.designForm.getComponents();
        for (int i = 1; i < coms.length; ++i) {
            if (coms[i].getName() == null) continue;
            this.addItemByControl(coms[i], null);
        }
    }

    public void clear() {
        this.clearControlsMap();
        this.itemList.clear();
        this.clearRegistedContainers();
    }

    public HashMap getControlsMap() {
        return this.controlMap;
    }

    private void clearControlsMap() {
        this.controlMap.clear();
    }

    private void clearRegistedContainers() {
        this.groupList.clear();
        this.tabList.clear();
    }

    private void initControlTypeMap() {
        if (this.controlTypeMap == null) {
            this.controlTypeMap = new HashMap();
        }
        this.controlTypeMap.put(JPanel.class, WidgetPanel.class);
        this.controlTypeMap.put(KDPanel.class, WidgetPanel.class);
        this.controlTypeMap.put(KDContainer.class, WidgetContainer.class);
        this.controlTypeMap.put(KDTabbedPane.class, WidgetTabbedPane.class);
        this.controlTypeMap.put(KDWorkButton.class, WidgetButton.class);
        this.controlTypeMap.put(KDTextArea.class, WidgetTextArea.class);
        this.controlTypeMap.put(KDTable.class, WidgetTable.class);
        this.controlTypeMap.put(KDLabel.class, WidgetLabel.class);
        this.controlTypeMap.put(KDLabelContainer.class, WidgetLabelContainer.class);
        this.controlTypeMap.put(KDRect.class, WidgetRect.class);
        this.controlTypeMap.put(KDSeparator.class, WidgetSeparator.class);
        this.controlTypeMap.put(KDApproval.class, WidgetTableExt.class);
    }

    public void registControlType(Class control, Class widgetItem) {
        if (this.controlTypeMap == null) {
            this.controlTypeMap = new HashMap();
        }
        this.controlTypeMap.put(control, widgetItem);
    }

    private Class getItemType(Component c) {
        Class<?> controlType = c.getClass();
        Class itemType = null;
        itemType = this.controlTypeMap.containsKey(controlType) ? (Class)this.controlTypeMap.get(controlType) : WidgetItem.class;
        return itemType;
    }

    private void addItemByControl(Component c, Object parentNode) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        WidgetItemBase item = this.createWidgetItem(c);
        if (item != null) {
            WidgetItemBase node = null;
            this.registerItem(item);
            if (parentNode == null) {
                this.itemList.addLast(item);
            } else {
                int index = this.itemList.indexOf(parentNode);
                this.itemList.add(index, item);
            }
            node = item;
            List coms = item.getChildrenControls();
            for (int i = 0; i < coms.size(); ++i) {
                this.addItemByControl((Component)coms.get(i), node);
            }
            if (c.getClass() == KDContainer.class) {
                this.groupList.add(c);
            } else if (c.getClass() == KDTabbedPane.class) {
                this.tabList.add(c);
            }
        }
    }

    private WidgetItemBase createWidgetItem(Component c) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class itemType = this.getItemType(c);
        WidgetItemBase item = null;
        if (itemType == WidgetItem.class) {
            item = new WidgetItem(this, c);
        } else if (itemType == WidgetTableExt.class) {
            item = new WidgetTableExt(this, (KDTable)c);
        } else {
            Class[] partypes = new Class[]{this.getClass(), c.getClass()};
            Constructor ct = itemType.getConstructor(partypes);
            Object[] arglist = new Object[]{this, c};
            item = (WidgetItemBase)ct.newInstance(arglist);
        }
        return item;
    }

    private void registerItem(WidgetItemBase item) {
        this.controlMap.put(item.getControl(), item);
    }

    public void addItem(WidgetItemBase item, Container parent) {
        this.itemList.addFirst(item);
        item.addControl(parent);
        List coms = item.getChildrenControls();
        for (int i = 0; i < coms.size(); ++i) {
            try {
                this.addItemByControl((Component)coms.get(i), item);
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.resetItemLayer(item);
    }

    public void removeItem(WidgetItemBase item, Container parent) {
        this.selection.unSelectItem(item);
        this.itemList.remove(item);
        item.removeControl(parent);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        block10: {
            block9: {
                this.mouseDownFirstMove = true;
                this.comeBackControl();
                long currentTime = e.getWhen();
                if (e.getPoint().equals(this.lastPt) && e.getWhen() - this.timeMouseDown < (long)this.dClkRes) {
                    HitResult hr;
                    this.smartTag.setExpand(false);
                    if (!(this.designTabIndex || (hr = this.HitTest(e.getPoint())) != HitResult.InObject && hr != HitResult.InDragMoveHandle)) {
                        this.optObject.mouseDoubleClick(e);
                    }
                    return;
                }
                this.lastPt = e.getPoint();
                this.timeMouseDown = e.getWhen();
                if (this.inplaceEdit.isVisible() && !this.inplaceEdit.getBounds().contains(e.getPoint())) {
                    this.inplaceEdit.setVisible(false);
                }
                if (this.designTabIndex) break block9;
                if (this.isCreateType) break block10;
                this.pointerToolMouseDown(true, e);
                break block10;
            }
            for (WidgetItemBase item : this.itemList) {
                HitResult hr = item.hitTest(e.getPoint());
                if (!item.isVisible() || hr != HitResult.InDragMoveHandle && hr != HitResult.InObject) continue;
                this.tabIndex.ClickInItem(item);
                break;
            }
        }
        this.selection.endSelect();
        this.repaint();
        if (!this.inplaceEdit.isVisible()) {
            this.requestFocus();
        } else {
            MouseListener[] ls = this.inplaceEdit.getMouseListeners();
            e.translatePoint(-this.inplaceEdit.getLocation().x, -this.inplaceEdit.getLocation().y);
            for (int i = 0; i < ls.length; ++i) {
                try {
                    ls[i].mousePressed(e);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private void pointerToolMouseDown(boolean down, MouseEvent e) {
        Point pt = new Point(e.getX(), e.getY());
        this.hitResult = this.HitTest(pt);
        if (this.hitResult == HitResult.InObject && this.optObject.getClientRect().contains(pt) && this.optObject.mouseDown(e)) {
            this.hitResult = HitResult.None;
            return;
        }
        if (e.isControlDown() && down) {
            return;
        }
        switch (this.hitResult.getValue()) {
            case 11: {
                this.smartTag.click();
                break;
            }
            case 0: {
                this.selection.clear();
                break;
            }
            case 1: 
            case 2: {
                if (!e.isControlDown()) {
                    if (!this.selection.isItemSelected(this.optObject)) {
                        this.selection.clear();
                    }
                    this.selection.selectItem(this.optObject);
                    break;
                }
                if (!this.selection.isItemSelected(this.optObject)) {
                    this.selection.selectItem(this.optObject);
                    break;
                }
                this.selection.unSelectItem(this.optObject);
                break;
            }
        }
    }

    private WidgetItemBase getTopSelectedParent(Container parent) {
        if (parent == this.designForm || parent == null) {
            return null;
        }
        WidgetItemBase itemParent = this.getItemFromControl(parent);
        if (itemParent == null) {
            return this.getTopSelectedParent(parent.getParent());
        }
        if (itemParent.isSelected()) {
            return itemParent;
        }
        return this.getTopSelectedParent(parent.getParent());
    }

    private boolean isHandle(HitResult ht) {
        return ht == HitResult.BottomHandle || ht == HitResult.BottomLeftHandle || ht == HitResult.BottomRightHandle || ht == HitResult.Control2Width || ht == HitResult.GridHLine || ht == HitResult.GridVLine || ht == HitResult.InDragMoveHandle || ht == HitResult.LabelWidth || ht == HitResult.LeftHandle || ht == HitResult.RightHandle || ht == HitResult.TopHandle || ht == HitResult.TopLeftHandle;
    }

    private HitResult HitTest(Point pt) {
        WidgetItemBase item;
        int i;
        Rectangle rc;
        HitResult hr = HitResult.None;
        if (this.smartTag.getBindObject() != null && this.smartTag.getBindObject().isVisible() && !this.isLocked() && (rc = this.smartTag.getBounds()).contains(pt)) {
            this.optObject = this.smartTag.getBindObject();
            return HitResult.SmartTag;
        }
        List lstSel = this.getSelection().getSelectList().getList();
        for (i = 0; i < lstSel.size(); ++i) {
            item = (WidgetItemBase)lstSel.get(i);
            if (item.isVisible()) {
                hr = item.hitTest(pt);
            }
            if (!this.isHandle(hr)) continue;
            this.optObject = item;
            return hr;
        }
        for (i = 0; i < this.itemList.size(); ++i) {
            HitResult hrNew;
            item = (WidgetItemBase)this.itemList.get(i);
            if (!item.isVisible() || (hr = item.hitTest(pt)) == HitResult.None) continue;
            WidgetItemBase itemParent = this.getTopSelectedParent(item.getControl().getParent());
            if (itemParent != null && ((hrNew = itemParent.hitTest(pt)) == HitResult.GridHLine || hrNew == HitResult.GridVLine)) {
                this.optObject = itemParent;
                return hrNew;
            }
            this.optObject = item;
            return hr;
        }
        this.optObject = null;
        return hr;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.designTabIndex) {
            if (!this.isCreateType) {
                if (e.isControlDown() && this.mouseState.getValue() != 3) {
                    this.pointerToolMouseDown(false, e);
                } else {
                    this.pointerToolMouseUp(e);
                }
            }
            this.mouseState = MouseState.None;
            this.hitResult = HitResult.None;
            this.optObject = null;
        }
        this.selection.endSelect();
        this.repaint();
    }

    private void pointerToolMouseUp(MouseEvent e) {
        Point pt = e.getPoint();
        switch (this.mouseState.getValue()) {
            case 1: {
                this.selection.selectRange(this.downPoint, pt, this.optObject == null ? this.designForm : this.optObject.getContainerControl());
                if (this.optObject == null || !this.selection.isItemSelected(this.optObject) || this.selection.getCount() <= 1) break;
                this.selection.unSelectItem(this.optObject);
                break;
            }
            case 2: 
            case 3: {
                Point offset = new Point(pt.x - this.downPoint.x, pt.y - this.downPoint.y);
                if (this.getBounds().contains(pt)) {
                    if (this.mouseState.getValue() == 3 && e.isControlDown()) {
                        this.selection.endDragCopy(this.hitResult, offset);
                    } else {
                        this.selection.endDrag(this.hitResult, offset);
                    }
                }
                this.setCursor(Cursor.getDefaultCursor());
                this.repaint();
                break;
            }
        }
    }

    public SelectionManage getSelection() {
        return this.selection;
    }

    public JPanel getDesignForm() {
        return this.designForm;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.designTabIndex) {
            return;
        }
        if (!this.isCreateType) {
            if (this.optObject != null) {
                if (e.isControlDown()) {
                    this.setCursor(this.getDragCopyCursor());
                } else {
                    this.setCursor(this.optObject.getCursor(this.hitResult));
                }
            }
            this.pointerToolMouseMove(e.getPoint());
        }
        this.movePoint = e.getPoint();
        this.mouseDownFirstMove = false;
    }

    private Cursor getDragCopyCursor() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/kingdee/eas/base/form/designer/res/DragCopy.gif");
            BufferedImage img = ImageIO.read(is);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            return toolkit.createCustomCursor(img, new Point(0, 2), "DRAGCOPY");
        }
        catch (Exception e) {
            return Cursor.getPredefinedCursor(0);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.designTabIndex) {
            return;
        }
        if (this.inplaceEdit.isVisible() && this.inplaceEdit.getBounds().contains(e.getPoint())) {
            MouseMotionListener[] ls = this.inplaceEdit.getMouseMotionListeners();
            e.translatePoint(-this.inplaceEdit.getLocation().x, -this.inplaceEdit.getLocation().y);
            for (int i = 0; i < ls.length; ++i) {
                ls[i].mouseMoved(e);
            }
            this.setCursor(Cursor.getPredefinedCursor(2));
            return;
        }
        if (e.getModifiers() != 16 && !this.isCreateType) {
            WidgetItemBase itemOld = this.optObject;
            HitResult hr = this.HitTest(e.getPoint());
            WidgetItemBase item = this.optObject;
            this.optObject = itemOld;
            if (hr != HitResult.None && !this.isLocked() && !this.inplaceEdit.isVisible()) {
                this.setCursor(item.getCursor(hr));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if ((hr == HitResult.SmartTag || this.hitResult == HitResult.SmartTag) && this.hitResult != hr) {
                this.smartTag.getBindObject().invalidate();
            }
            this.hitResult = hr;
        }
    }

    private void pointerToolMouseMove(Point pt) {
        if (this.mouseDownFirstMove) {
            this.pointerToolFirstMove(pt);
        }
        switch (this.mouseState.getValue()) {
            case 2: 
            case 3: {
                this.oldOffset = new Point(this.movePoint.x - this.downPoint.x, this.movePoint.y - this.downPoint.y);
                this.curOffset = new Point(pt.x - this.downPoint.x, pt.y - this.downPoint.y);
                this.curPoint = null;
                this.repaint();
                if (this.getBounds().contains(pt)) break;
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 1: {
                this.curPoint = pt;
                this.repaint();
                break;
            }
        }
    }

    private void InvalidateMoveFocusRect(Graphics g, Point e) {
        int x = Math.min(this.downPoint.x, e.x);
        int y = Math.min(this.downPoint.y, e.y);
        int width = Math.abs(e.x - this.downPoint.x);
        int height = Math.abs(e.y - this.downPoint.y);
        g.setColor(Color.GRAY);
        g.drawRect(x, y, width, height);
    }

    private void pointerToolFirstMove(Point pt) {
        this.movePoint = this.downPoint = pt;
        switch (this.hitResult.getValue()) {
            case 11: {
                break;
            }
            case 0: {
                this.mouseState = MouseState.SelectRange;
                break;
            }
            case 1: 
            case 2: {
                this.mouseState = this.hitResult == HitResult.InDragMoveHandle ? MouseState.DragObject : MouseState.SelectRange;
                break;
            }
            default: {
                this.mouseState = MouseState.DragHandle;
            }
        }
    }

    protected void drawDragRect(Graphics g, HitResult hr, Point oldOffset, Point curOffset) {
        if (!this.isLocked()) {
            List items = this.selection.getSelectList().getList();
            for (int i = 0; i < items.size(); ++i) {
                WidgetItemBase item = (WidgetItemBase)items.get(i);
                item.drawDragHandleRect(g, hr, curOffset);
            }
        }
    }

    protected void draw(Graphics g) {
        LinkedList items = this.itemList;
        for (int i = 0; i < items.size(); ++i) {
            WidgetItemBase item = (WidgetItemBase)items.get(i);
            item.draw(g);
        }
    }

    protected Container getContainerFromPoint(Point pt) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            WidgetItemBase item = (WidgetItemBase)this.itemList.get(i);
            if (!item.isVisible() || item.getContainerControl() == null || !item.getClientRect().contains(pt)) continue;
            return item.getContainerControl();
        }
        return this.designForm;
    }

    public Container getContainerFromPoint(Component control, Point pt) {
        for (WidgetItemBase item : this.itemList) {
            if (item instanceof WidgetTabbedPane || !item.isVisible() || item.getContainerControl() == null || !item.getClientRect().contains(pt) || control == item.getContainerControl() || this.isChild(control, item.getContainerControl())) continue;
            return item.getContainerControl();
        }
        return this.designForm;
    }

    protected boolean isChild(Component parent, Component child) {
        while (child.getParent() != this.designForm && child.getParent() != null) {
            if (parent == child.getParent()) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    public boolean isAddToUndo() {
        return this.addToUndo;
    }

    public void setAddToUndo(boolean addToUndo) {
        this.addToUndo = addToUndo;
    }

    public boolean isItemParentVisible(Container parent) {
        if (parent != null && !parent.isVisible()) {
            return false;
        }
        if (parent == this.designForm || parent == null) {
            return true;
        }
        return this.isItemParentVisible(parent.getParent());
    }

    public Rectangle DesignFormToParent(Container parent, Rectangle rect) {
        Rectangle rc = new Rectangle(rect);
        if (parent == this.designForm || parent == null) {
            return rc;
        }
        rc.x -= parent.getBounds().x;
        rc.y -= parent.getBounds().y;
        return this.DesignFormToParent(parent.getParent(), rc);
    }

    public Rectangle ParentToDesignForm(Container parent, Rectangle rect) {
        Rectangle rc = new Rectangle(rect);
        if (parent == this.designForm || parent == null) {
            return rc;
        }
        rc.x += parent.getBounds().x;
        rc.y += parent.getBounds().y;
        return this.ParentToDesignForm(parent.getParent(), rc);
    }

    public CommandList getCommandList() {
        return this.commandList;
    }

    public List getGroupList() {
        return this.groupList;
    }

    public void resetItemLayer(WidgetItemBase item) {
        if (item == null) {
            return;
        }
        WidgetItemBase prevItem = item.getPrevItem();
        if (prevItem == null) {
            WidgetItemBase parent = item.getParent();
            if (parent == null) {
                this.itemList.remove(item);
                this.itemList.addFirst(item);
            } else {
                this.itemList.remove(item);
                int nodeIndex = this.itemList.indexOf(parent);
                this.itemList.add(nodeIndex, item);
            }
        } else {
            this.itemList.remove(item);
            int prevNodeIndex = this.itemList.indexOf(prevItem);
            this.itemList.add(prevNodeIndex + 1, item);
        }
        Iterator iter = item.getChildrenControls().iterator();
        while (iter.hasNext()) {
            this.resetItemLayer(this.getItemFromControl((Component)iter.next()));
        }
    }

    public void setComponentParent(Component comp, Container parent) {
        if (comp.getParent() != parent || parent.getLayout() instanceof TableLayout) {
            int zorder = 0;
            if (parent == this.designForm) {
                zorder = 1;
            }
            if (parent instanceof KDTabbedPane) {
                String title = "";
                KDTabbedPane tab = (KDTabbedPane)parent;
                if (((JComponent)comp).getClientProperty("Text") != null) {
                    title = ((JComponent)comp).getClientProperty("Text").toString();
                }
                int index = 0;
                if (((JComponent)comp).getClientProperty("TabIndex") != null) {
                    index = (Integer)((JComponent)comp).getClientProperty("TabIndex");
                }
                int newindex = tab.getTabCount();
                for (int i = 0; i < tab.getTabCount(); ++i) {
                    JComponent tabPage = (JComponent)tab.getComponentAt(i);
                    int tempIndex = (Integer)tabPage.getClientProperty("TabIndex");
                    if (index >= tempIndex) continue;
                    newindex = i;
                    break;
                }
                tab.insertTab(title, null, comp, title, newindex);
                ((KDTabbedPane)parent).setSelectedComponent(comp);
            } else if (parent.getLayout() instanceof KDLayout) {
                parent.add(comp, new KDLayout.Constraints(0, comp.getBounds()), zorder);
            } else if (parent.getLayout() instanceof TableLayout) {
                Cell c = this.getTableLaoutCell((TableLayout)parent.getLayout(), comp.getLocation());
                if (c != null) {
                    parent.add(comp, c);
                    ((JComponent)parent).putClientProperty("Cell", c);
                    parent.doLayout();
                    this.getParent().repaint();
                } else {
                    this.setComponentParent(comp, this.designForm);
                    this.getEventsProxy().fireComponentPositionChanged(comp, parent, comp.getBounds());
                }
            } else {
                parent.add(comp, zorder);
            }
            WidgetItemBase item = this.getItemFromControl(comp);
            this.resetItemLayer(item);
        }
    }

    public Cell getTableLaoutCell(TableLayout tb, Point pt) {
        SizeAdjustor adjustorX = tb.getAdjustorX();
        SizeAdjustor adjustorY = tb.getAdjustorY();
        int y = 0;
        for (int i = 0; i < tb.getRowCount(); ++i) {
            int x = 0;
            for (int j = 0; j < tb.getColCount(); ++j) {
                Rectangle rc = new Rectangle(x, y, adjustorX.getOutAt(j), adjustorY.getOutAt(i));
                x += adjustorX.getOutAt(j);
                if (!rc.contains(pt) || tb.cell(i, j).getContent() != null) continue;
                return tb.cell(i, j);
            }
            y += adjustorY.getOutAt(i);
        }
        return null;
    }

    public List getTabList() {
        return this.tabList;
    }

    public KDTextField getInplaceEdit() {
        return this.inplaceEdit;
    }

    public boolean isControlBringTop() {
        return this.isControlBringTop;
    }

    public boolean queryCanAdded(Rectangle rect) {
        Component parent = null;
        for (WidgetItemBase item : this.itemList) {
            if (!item.isVisible() || !item.getClientRect().contains(rect.getLocation()) || (parent = item.getCreateParent()) == null) continue;
            if (!(item instanceof WidgetTableExt)) break;
            return false;
        }
        if (parent == null) {
            parent = this.designForm;
        }
        return this.designer.getEventsProxy().fireQueryCanAdded(this.designer.getCreateData(), rect, this.designer.getCreateType(), parent);
    }

    public void createObjectOnItems(Rectangle rect) {
        for (WidgetItemBase item : this.itemList) {
            if (!item.isVisible() || !item.getClientRect().contains(rect.getLocation()) || !item.handleCreateOnItem(this.designer.getCreateData(), this.designer.getCreateType(), rect)) continue;
            return;
        }
        this.designer.getEventsProxy().firePrepareAddControl(this.designer.getCreateData(), rect, this.designer.getCreateType(), this.designForm);
    }

    public void bringControlToTop(Component control) {
        this.isControlBringTop = true;
        control.setVisible(false);
        this.bringTopControl = control;
        this.controlParent = control.getParent();
        this.oldIndex = this.getComponentZOrder(this.controlParent, control);
        Rectangle rect = this.ParentToDesignForm(this.controlParent, control.getBounds());
        control.setBounds(rect);
        this.designForm.add(control, new KDLayout.Constraints(0, rect), 0);
        control.setVisible(true);
        KDTable grid = (KDTable)control;
        if (grid != null) {
            this.designer.getEventsProxy().fireGridActiveToDesign(grid, this.controlParent);
        }
    }

    public void comeBackControl() {
        if (this.isControlBringTop) {
            this.bringTopControl.setVisible(false);
            Rectangle rect = this.DesignFormToParent(this.controlParent, this.bringTopControl.getBounds());
            this.bringTopControl.setBounds(rect);
            if (this.controlParent.getLayout() instanceof KDLayout) {
                this.controlParent.add(this.bringTopControl, new KDLayout.Constraints(0, rect), this.oldIndex);
            } else {
                this.controlParent.add(this.bringTopControl, this.oldIndex);
            }
            this.bringTopControl.setVisible(true);
            this.isControlBringTop = false;
            WidgetItemBase item = this.getItemFromControl(this.bringTopControl);
            if (item != null) {
                item.invalidate();
            }
        }
        this.getParent().add((Component)((Object)this), 0);
    }

    public Component getBringTopControl() {
        return this.bringTopControl;
    }

    public int getMoveStep() {
        return this.moveStep;
    }

    public void setMoveStep(int moveStep) {
        this.moveStep = moveStep;
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.drawComponent(g);
    }

    private void drawComponent(Graphics g) {
        if (this.designTabIndex) {
            this.tabIndex.Draw(g, this.getBounds());
        } else {
            this.selection.Draw(g);
            if (this.smartTag.getBindObject() != null && this.smartTag.getBindObject().isVisible() && !this.isLocked()) {
                this.smartTag.Draw(g, this.hitResult == HitResult.SmartTag);
            }
        }
        switch (this.mouseState.getValue()) {
            case 2: 
            case 3: {
                if (this.oldOffset != null && this.curOffset != null) {
                    this.drawDragRect(g, this.hitResult, this.oldOffset, this.curOffset);
                }
            }
            case 1: {
                if (this.curPoint == null) break;
                this.InvalidateMoveFocusRect(g, this.curPoint);
            }
        }
        this.draw(g);
    }

    public int getComponentZOrder(Container parent, Component com) {
        Component[] component = parent.getComponents();
        int ncomponents = component.length;
        for (int i = 0; i < ncomponents; ++i) {
            if (component[i] != com) continue;
            return i;
        }
        return -1;
    }
}

