/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer;

import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.SortedArray;
import com.kingdee.eas.base.form.designer.command.CommandRemove;
import com.kingdee.eas.base.form.designer.compare.ControlCompare;
import com.kingdee.eas.base.form.designer.widget.WidgetItemBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class SelectionManage {
    private SortedArray selectList = new SortedArray();
    private WidgetItemBase primaryItem;
    private OverlayWindow overWnd;
    private boolean selectionChanged = false;
    private static final int MoveDirection_Left = 0;
    private static final int MoveDirection_Up = 1;
    private static final int MoveDirection_Right = 2;
    private static final int MoveDirection_Down = 3;

    public SelectionManage(OverlayWindow overWnd) {
        this.overWnd = overWnd;
    }

    public boolean isLocked() {
        return this.overWnd.isLocked();
    }

    public void setLocked(boolean value) {
        this.overWnd.setLocked(value);
    }

    public OverlayWindow getOverWnd() {
        return this.overWnd;
    }

    public void setOverWnd(OverlayWindow overWnd) {
        this.overWnd = overWnd;
    }

    public void endSelect() {
        if (this.selectionChanged) {
            this.overWnd.getDesigner().getEventsProxy().fireSelectionChanged();
        }
        this.selectionChanged = false;
    }

    public WidgetItemBase getPrimaryItem() {
        return this.primaryItem;
    }

    public Component getPrimaryControl() {
        if (this.primaryItem == null) {
            return null;
        }
        return this.primaryItem.getControl();
    }

    public int getCount() {
        return this.selectList.getCount();
    }

    public SortedArray getSelectList() {
        return this.selectList;
    }

    public List getSelectedControls() {
        ArrayList<Component> lst = new ArrayList<Component>();
        List lstSrc = this.selectList.getList();
        for (int i = 0; i < lstSrc.size(); ++i) {
            lst.add(((WidgetItemBase)lstSrc.get(i)).getControl());
        }
        return lst;
    }

    public boolean isItemSelected(WidgetItemBase item) {
        return this.selectList.find(item) >= 0;
    }

    protected void unSelectItem(WidgetItemBase item) {
        if (!this.isItemSelected(item)) {
            return;
        }
        item.invalidate();
        this.selectList.remove(item);
        if (this.primaryItem == item) {
            if (this.selectList.getCount() == 0) {
                this.primaryItem = null;
            } else {
                this.primaryItem = (WidgetItemBase)this.selectList.get(this.selectList.getCount() - 1);
                this.primaryItem.invalidate();
            }
        }
        this.overWnd.getSmartTag().setBindObject((WidgetItemBase)(this.selectList.getCount() == 1 ? this.selectList.get(0) : null));
        this.selectionChanged = true;
    }

    public void selectItem(WidgetItemBase item) {
        boolean changed = true;
        if (this.isItemSelected(item)) {
            boolean bl = changed = this.primaryItem != item;
            if (changed) {
                this.primaryItem.invalidate();
                this.primaryItem = item;
            }
        } else if (this.primaryItem == null) {
            this.primaryItem = item;
        }
        this.selectList.add(item);
        item.invalidate();
        this.overWnd.getSmartTag().setBindObject(this.selectList.getCount() == 1 ? (WidgetItemBase)this.selectList.get(0) : null);
        if (changed) {
            this.selectionChanged = true;
        }
    }

    public void clear() {
        if (this.selectList.getCount() == 0) {
            return;
        }
        List lstSrc = this.selectList.getList();
        for (int i = 0; i < lstSrc.size(); ++i) {
            ((WidgetItemBase)lstSrc.get(i)).invalidate();
        }
        this.selectList.clear();
        this.primaryItem = null;
        this.overWnd.getSmartTag().setBindObject(null);
        this.selectionChanged = true;
    }

    public void Draw(Graphics gis) {
        List lstSrc = this.selectList.getList();
        for (int i = 0; i < lstSrc.size(); ++i) {
            WidgetItemBase item = (WidgetItemBase)lstSrc.get(i);
            if (!item.isVisible()) continue;
            item.drawSelect(gis);
        }
    }

    public void selectRange(Point down, Point up, Container container) {
        if (container == null) {
            return;
        }
        Rectangle rect = new Rectangle();
        rect.x = Math.min(down.x, up.x);
        rect.y = Math.min(down.y, up.y);
        rect.width = Math.abs(down.x - up.x);
        rect.height = Math.abs(down.y - up.y);
        Component[] coms = container.getComponents();
        for (int i = 0; i < coms.length; ++i) {
            WidgetItemBase item = this.overWnd.getItemFromControl(coms[i]);
            if (item == null || !item.isVisible() || !rect.contains((item.getClientRect().x + item.getClientRect().x + item.getClientRect().width) / 2, (item.getClientRect().y + item.getClientRect().y + item.getClientRect().height) / 2)) continue;
            this.selectItem(item);
        }
    }

    protected void endDrag(HitResult hr, Point offset) {
        this.overWnd.getCommandList().PrepareMultiCommand();
        SortedArray listSrc = this.getOperatorObject();
        List items = listSrc.getList();
        for (int i = 0; i < items.size(); ++i) {
            WidgetItemBase item = (WidgetItemBase)items.get(i);
            if (this.overWnd.isLocked()) continue;
            item.endDrag(hr, offset);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    protected void endDragCopy(HitResult hr, Point offset) {
        this.overWnd.getCommandList().PrepareMultiCommand();
        SortedArray listSrc = this.getOperatorObject();
        List items = listSrc.getList();
        for (int i = 0; i < items.size(); ++i) {
            WidgetItemBase item = (WidgetItemBase)items.get(i);
            if (this.overWnd.isLocked()) continue;
            item.endDragCopy(hr, offset);
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    protected SortedArray getOperatorObject() {
        SortedArray list = new SortedArray();
        List items = this.selectList.getList();
        list.addRange(this.selectList.getList());
        Component c = null;
        block0: for (int i = 0; i < items.size(); ++i) {
            WidgetItemBase item = (WidgetItemBase)items.get(i);
            c = item.getControl();
            while (c.getParent() != this.overWnd.getDesignForm() && c.getParent() != null) {
                WidgetItemBase it = this.overWnd.getItemFromControl(c.getParent());
                if (it != null && list.contains(it)) {
                    list.remove(item);
                    continue block0;
                }
                c = c.getParent();
            }
        }
        return list;
    }

    public void changeWidth(int offsetSize) {
        this.endDrag(HitResult.RightHandle, new Point(offsetSize, 0));
    }

    public void changeHeight(int offsetSize) {
        this.endDrag(HitResult.BottomHandle, new Point(0, offsetSize));
    }

    private void move(int direction) {
        List list = this.getOperatorObject().getList();
        if (list.size() == 0) {
            return;
        }
        this.overWnd.getCommandList().PrepareMultiCommand();
        switch (direction) {
            case 0: 
            case 2: {
                boolean left = direction == 0;
                for (WidgetItemBase item : list) {
                    Rectangle rect = item.getClientRect();
                    rect.x = rect.x - (left ? this.overWnd.getMoveStep() : -this.overWnd.getMoveStep());
                    item.setClientRect(rect);
                }
                break;
            }
            case 1: 
            case 3: {
                boolean up = direction == 1;
                for (WidgetItemBase item : list) {
                    Rectangle rect = item.getClientRect();
                    rect.y = rect.y - (up ? this.overWnd.getMoveStep() : -this.overWnd.getMoveStep());
                    item.setClientRect(rect);
                }
                break;
            }
        }
        this.overWnd.getCommandList().EndMultiCommand();
    }

    public void moveLeft() {
        this.move(0);
    }

    public void moveUp() {
        this.move(1);
    }

    public void moveRight() {
        this.move(2);
    }

    public void moveDown() {
        this.move(3);
    }

    public boolean isFatherAndChildSelected() {
        SortedArray list = new SortedArray();
        list.addRange(this.selectList.getList());
        list.setComparer(new ControlCompare());
        Component c = null;
        for (WidgetItemBase item : this.selectList.getList()) {
            c = item.getControl();
            while (c.getParent() != this.overWnd.getDesignForm() && c.getParent() != null) {
                WidgetItemBase i = this.overWnd.getItemFromControl(c.getParent());
                if (i != null && list.contains(i)) {
                    return true;
                }
                c = c.getParent();
            }
        }
        return false;
    }

    public void deleteSelectItems() {
        if (this.selectList.getCount() <= 0) {
            return;
        }
        this.overWnd.getCommandList().PrepareMultiCommand();
        SortedArray list = this.getOperatorObject();
        for (WidgetItemBase item : list.getList()) {
            CommandRemove cmd = new CommandRemove(this.overWnd, item, item.getControl().getParent());
            cmd.execute();
            if (cmd.isCanceled()) continue;
            this.overWnd.getCommandList().addCommand(cmd);
        }
        this.overWnd.getCommandList().EndMultiCommand();
        this.endSelect();
    }
}

