/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.component;

import com.kingdee.eas.base.form.designer.component.FormContainerLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class FormContainer
extends JPanel {
    public static final int ACTIVESTYLE = 0;
    public static final int STATICSTYLE = 1;
    protected JPanel contentPane;
    protected String title = "";
    private TitleBar titleBar = new TitleBar();
    private URL iconURL;
    private Icon icon;

    public FormContainer() {
        this.add(this.titleBar);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setLayout(new FormContainerLayout());
    }

    public JPanel getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(new JPanel());
        }
        return this.contentPane;
    }

    public void setContentPane(Container pane) {
        if (!(pane instanceof JPanel)) {
            throw new IllegalArgumentException("contentPane must is javax.swing.JPanel or subclass.");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this) {
            this.remove(this.contentPane);
        }
        this.contentPane = (JPanel)pane;
        this.add(this.contentPane);
        this.contentPane.setOpaque(false);
    }

    public void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        if (newTitle.equals(this.title)) {
            return;
        }
        String oldTitle = this.title;
        this.title = newTitle;
        this.firePropertyChange("Title", oldTitle, this.title);
    }

    public String getTitle() {
        return this.title;
    }

    public URL getIconURL() {
        return this.iconURL;
    }

    public void setIconURL(URL iconURL) {
        Icon oldIcon = this.icon;
        this.icon = new ImageIcon(iconURL);
        this.firePropertyChange("icon", oldIcon, this.icon);
        this.iconURL = iconURL;
    }

    private class TitleBar
    extends JComponent {
        private TitleBar() {
            this.setLayout(null);
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void layoutContainer(Container parent) {
                    int width = parent.getWidth();
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return new Dimension(0, 0);
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, 0);
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, UIManager.getColor("MenuBar.fourthShadowColor"), this.getWidth(), 0.0f, UIManager.getColor("MenuBar.firstShadowColor"));
            g2d.setPaint(gp);
            g2d.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            g2d.setPaint(Color.white);
            g2d.setFont(new Font("simsun", 1, 12));
            g2d.drawString(FormContainer.this.getTitle(), 25, 15 - g2d.getFontMetrics().getDescent() + g2d.getFontMetrics().getLeading());
            FormContainer.this.icon.paintIcon(this, g2d, 3, 3);
        }
    }
}

