/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.component;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.MouseState;
import com.kingdee.eas.base.form.designer.component.FormContainer;
import com.kingdee.eas.base.form.designer.widget.WidgetForm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class FormDesignerPanel
extends KDPanel
implements MouseListener,
MouseMotionListener {
    private WidgetForm item;
    private MouseState mouseState;
    private Point oldOffset;
    private Point curOffset;
    private Point curPoint;
    private Point downPoint;
    private HitResult hitResult = HitResult.None;
    private Point movePoint;
    private boolean mouseDownFirstMove = false;
    private boolean designTabIndex = false;
    private boolean selected = false;

    public FormDesignerPanel() {
        this.mouseState = MouseState.None;
        this.setBackground(Color.WHITE);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        if (comp instanceof FormContainer) {
            this.item = new WidgetForm(comp);
        }
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.selected) {
            this.item.drawSelect(g);
            switch (this.mouseState.getValue()) {
                case 2: 
                case 3: {
                    if (this.oldOffset == null || this.curOffset == null) break;
                    this.drawDragRect(g, this.hitResult, this.oldOffset, this.curOffset);
                }
            }
        }
    }

    protected void drawDragRect(Graphics g, HitResult hr, Point oldOffset, Point curOffset) {
        Rectangle rect;
        Rectangle rc = rect = this.item.getDragHandleRect(hr, curOffset);
        g.setColor(Color.GRAY);
        g.drawRect(rc.x, rc.y, rc.width, rc.height);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.selected) {
            this.mouseDownFirstMove = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pointerToolMouseUp(e.getPoint());
        this.mouseState = MouseState.None;
        this.hitResult = HitResult.None;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setCursor(this.item.getCursor(this.hitResult));
        this.pointerToolMouseMove(e.getPoint());
        this.movePoint = e.getPoint();
        this.mouseDownFirstMove = false;
    }

    private void pointerToolMouseMove(Point pt) {
        System.out.println(pt.getX() + "," + pt.getY());
        if (this.mouseDownFirstMove) {
            this.pointerToolFirstMove(pt);
        }
        switch (this.mouseState.getValue()) {
            case 2: 
            case 3: {
                this.oldOffset = new Point(this.movePoint.x - this.downPoint.x, this.movePoint.y - this.downPoint.y);
                this.curOffset = new Point(pt.x - this.downPoint.x, pt.y - this.downPoint.y);
                this.curPoint = null;
                this.repaint();
                if (this.getBounds().contains(pt)) break;
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 1: {
                this.curPoint = pt;
                this.repaint();
                break;
            }
        }
    }

    private void pointerToolFirstMove(Point pt) {
        this.movePoint = this.downPoint = pt;
        switch (this.hitResult.getValue()) {
            case 1: 
            case 2: {
                this.mouseState = this.hitResult == HitResult.InDragMoveHandle ? MouseState.DragObject : MouseState.SelectRange;
                break;
            }
            default: {
                this.mouseState = MouseState.DragHandle;
            }
        }
    }

    private void pointerToolMouseUp(Point pt) {
        switch (this.mouseState.getValue()) {
            case 2: {
                Point offset = new Point(pt.x - this.downPoint.x, pt.y - this.downPoint.y);
                this.item.endDrag(this.hitResult, offset);
                this.setCursor(Cursor.getDefaultCursor());
                this.repaint();
                break;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getModifiers() != 16 && this.selected) {
            HitResult hr = this.HitTest(e.getPoint());
            if (hr != HitResult.None) {
                this.setCursor(this.item.getCursor(hr));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.hitResult = hr;
        }
    }

    private HitResult HitTest(Point pt) {
        HitResult hr = HitResult.None;
        if (this.item.isVisible() && (hr = this.item.HitTest(pt)) != HitResult.None) {
            return hr;
        }
        return hr;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
        this.repaint();
    }

    public void setFormSize(Dimension d) {
        this.item.setSize(d);
    }
}

