/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.entityrelation;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.form.designer.entityrelation.ColumnCollection;
import com.kingdee.eas.base.form.designer.entityrelation.PKCollection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;

public class EntityTable
extends KDPanel {
    public static final int sideLeft = 3;
    public static final int titleHeight = 30;
    public static final int FixcolWidth = 20;
    public static final int rowHeight = 20;
    protected Cursor currentCursor;
    public JLabel _title;
    private String aliasName;
    private ColumnCollection columns;
    private ColumnCollection pks;
    protected boolean _bDraging;
    protected int _handle = 0;
    int _tableid;
    private KDTable table;

    public ColumnCollection getPKs() {
        return this.pks;
    }

    public EntityTable() {
        this.initializeComponent();
        this.columns = new ColumnCollection(this);
        this.pks = new PKCollection(this);
    }

    private void initializeComponent() {
        this.table = new KDTable();
        this._title = new JLabel();
        this._title.setSize(1, 31);
        this._title.setBackground(Color.LIGHT_GRAY);
        this._title.setOpaque(true);
        this._title.setHorizontalAlignment(0);
        this.table.getIndexColumn().getStyleAttributes().setHided(true);
        IColumn col = this.table.addColumn();
        col.getStyleAttributes().setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        col.getStyleAttributes().setBorderColor(Styles.Position.RIGHT, Color.WHITE);
        col.setWidth(20);
        col = this.table.addColumn();
        col.getStyleAttributes().setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        col.getStyleAttributes().setBorderColor(Styles.Position.RIGHT, Color.WHITE);
        this.table.setColumnsAutoResizeMode(3);
        this.table.setBackground(Color.WHITE);
        this.table.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                int w = 2;
                if (EntityTable.this.table.getRowCount() > 0 && EntityTable.this.table.getHeight() < EntityTable.this.table.getRow(0).getHeight() * EntityTable.this.table.getRowCount()) {
                    w = 20;
                }
                EntityTable.this.table.getColumn(1).setWidth(EntityTable.this.table.getWidth() - EntityTable.this.table.getColumn(0).getWidth() - w);
                EntityTable.this.table.revalidate();
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this._title, "North");
        this.add((Component)this.table, "Center");
    }

    public ColumnCollection getColumns() {
        return this.columns;
    }

    public int getTableID() {
        return this._tableid;
    }

    public void setTableID(int value) {
        this._tableid = value;
    }

    public KDTable getTable() {
        return this.table;
    }

    public void setTitle(String caption) {
        if (caption == null || caption.length() == 0) {
            caption = "  ";
        }
        this._title.setText(caption);
    }

    public Point getItemPoint(int originIndex, boolean isSrc) {
        Rectangle rect = this.table.getBounds();
        rect.x += this.getX();
        rect.y += this.getY();
        rect.height = this.table.getRow(0).getHeight();
        int x = isSrc ? rect.x + rect.width : rect.x;
        if (rect.isEmpty()) {
            return new Point(x, rect.y);
        }
        int y = rect.y + rect.height * originIndex + rect.height / 2;
        return new Point(x, y);
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        Rectangle rc = this.getBounds();
        rc.x = 0;
        rc.y = 0;
        g.drawRect(rc.x, rc.y, rc.width - 1, rc.height - 1);
        int y = this.getTable().getY();
        g.drawLine(rc.x + 20, y, rc.x + 20, rc.height);
        g.drawLine(rc.x, y, rc.width, y);
    }
}

