/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.widget;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.component.FormContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WidgetForm {
    public static final int SelectFocusWidth = 5;
    protected boolean locked;
    protected Component control;

    public WidgetForm(Component control) {
        this.control = control;
        this.locked = false;
    }

    public Cursor getCursor(HitResult hr) {
        switch (hr.getValue()) {
            case 11: {
                return Cursor.getPredefinedCursor(12);
            }
            case 3: 
            case 7: {
                return Cursor.getPredefinedCursor(6);
            }
            case 4: 
            case 8: {
                return Cursor.getPredefinedCursor(9);
            }
            case 5: 
            case 9: {
                return Cursor.getPredefinedCursor(4);
            }
            case 6: 
            case 10: {
                return Cursor.getPredefinedCursor(10);
            }
            case 2: {
                return Cursor.getPredefinedCursor(13);
            }
        }
        return Cursor.getDefaultCursor();
    }

    public Component getControl() {
        return this.control;
    }

    public Rectangle getDragHandleRect(HitResult hr, Point offset) {
        Rectangle rect = new Rectangle();
        Rectangle ClientRect = this.getClientRect();
        if (hr == HitResult.InDragMoveHandle) {
            rect = ClientRect;
            rect.translate(offset.x, offset.y);
            return rect;
        }
        double left = ClientRect.getX();
        double top = ClientRect.getY();
        double right = left + ClientRect.getWidth();
        double bottom = top + ClientRect.getHeight();
        switch (hr.getValue()) {
            case 3: {
                left = Math.min(left + (double)offset.x, right - 5.0);
                top = Math.min(top + (double)offset.y, bottom - 5.0);
                break;
            }
            case 4: {
                top = Math.min(top + (double)offset.y, bottom - 5.0);
                break;
            }
            case 5: {
                right = Math.max(left + 5.0, right + (double)offset.x);
                top = Math.min(top + (double)offset.y, bottom - 5.0);
                break;
            }
            case 6: {
                right = Math.max(left + 5.0, right + (double)offset.x);
                break;
            }
            case 7: {
                right = Math.max(left + 5.0, right + (double)offset.x);
                bottom = Math.max(top + 5.0, bottom + (double)offset.y);
                break;
            }
            case 8: {
                bottom = Math.max(top + 5.0, bottom + (double)offset.y);
                break;
            }
            case 9: {
                left = Math.min(left + (double)offset.x, right - 5.0);
                bottom = Math.max(top + 5.0, bottom + (double)offset.y);
                break;
            }
            case 10: {
                left = Math.min(left + (double)offset.x, right - 5.0);
                break;
            }
        }
        rect.setBounds((int)left, (int)top, (int)(right - left), (int)(bottom - top));
        return rect;
    }

    public void endDrag(HitResult hr, Point offset) {
        Rectangle rect = this.getDragHandleRect(hr, offset);
        this.setClientRect(rect);
    }

    public void drawSelect(Graphics gis) {
        this.drawSelectFrame(gis);
        Color brushColor = Color.WHITE;
        Color penColor = Color.BLACK;
        this.drawHandles(gis, brushColor, penColor);
    }

    public HitResult HitTest(Point pt) {
        Rectangle bound = this.getClientRect();
        bound.grow(6, 6);
        Rectangle rc = this.getClientRect();
        if (!bound.contains(pt)) {
            return HitResult.None;
        }
        Rectangle handle = new Rectangle(this.getClientRect().x - 5, this.getClientRect().y - 5, 5, 5);
        handle.x = rc.x + rc.width / 2 - 2;
        handle.x = rc.x + rc.width + 1;
        handle.y = rc.y + rc.height / 2 - 2;
        if (handle.contains(pt)) {
            return HitResult.RightHandle;
        }
        handle.y = rc.y + rc.height + 1;
        if (handle.contains(pt)) {
            return HitResult.BottomRightHandle;
        }
        handle.x = rc.x + rc.width / 2 - 2;
        if (handle.contains(pt)) {
            return HitResult.BottomHandle;
        }
        handle.x = rc.x - 5;
        handle.y = rc.y + rc.height / 2 - 2;
        if (rc.contains(pt)) {
            return HitResult.InDragMoveHandle;
        }
        return HitResult.None;
    }

    public void drawSelectFrame(Graphics g) {
        Graphics2D gis = (Graphics2D)g;
        BufferedImage buffImage = new BufferedImage(5, 5, 1);
        Graphics2D gImg = buffImage.createGraphics();
        gImg.setColor(Color.WHITE);
        gImg.fill(new Rectangle(0, 0, 5, 5));
        gImg.setColor(Color.GRAY);
        gImg.drawLine(2, 0, 2, 0);
        gImg.drawLine(0, 1, 0, 1);
        gImg.drawLine(4, 1, 4, 1);
        gImg.drawLine(2, 2, 2, 2);
        gImg.drawLine(0, 3, 0, 3);
        gImg.drawLine(4, 3, 4, 3);
        gImg.drawLine(2, 4, 2, 4);
        TexturePaint paintf = new TexturePaint(buffImage, new Rectangle(5, 5));
        gis.setPaint(paintf);
        Rectangle bound = this.getClientRect();
        Rectangle rect = new Rectangle(bound.x, bound.y - 5, bound.width + 5, 5);
        gis.fillRect(rect.x, rect.y, rect.width, rect.height);
        rect.x = bound.x + bound.width;
        rect.y = bound.y;
        rect.width = 5;
        rect.height = bound.height + 5;
        gis.fillRect(rect.x, rect.y, rect.width, rect.height);
        rect.x = bound.x - 5;
        rect.y = bound.y + bound.height;
        rect.width = bound.width + 5;
        rect.height = 5;
        gis.fillRect(rect.x, rect.y, rect.width, rect.height);
        rect.x = bound.x - 5;
        rect.y = bound.y - 5;
        rect.width = 5;
        rect.height = bound.height + 5;
        gis.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawHandles(Graphics gis, Color brushColor, Color penColor) {
        Rectangle ClientRect = this.getClientRect();
        if (!this.locked) {
            Rectangle handle = new Rectangle(ClientRect.x - 5 - 1, ClientRect.y - 5 - 1, 5, 5);
            this.drawHandle(gis, penColor, brushColor, handle);
            handle.x = ClientRect.x + ClientRect.width / 2 - 2;
            this.drawHandle(gis, penColor, brushColor, handle);
            handle.x = ClientRect.x + ClientRect.width + 1;
            this.drawHandle(gis, penColor, brushColor, handle);
            handle.y = ClientRect.y + ClientRect.height / 2 - 2;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.y = ClientRect.y + ClientRect.height + 1;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.x = ClientRect.x + ClientRect.width / 2 - 2;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.x = ClientRect.x - 5 - 1;
            this.drawHandle(gis, penColor, brushColor, handle);
            handle.y = ClientRect.y + ClientRect.height / 2 - 2;
            this.drawHandle(gis, penColor, brushColor, handle);
        } else {
            Color blackPen = Color.BLACK;
            Rectangle rect = new Rectangle(ClientRect.x + 5, ClientRect.y - 7 - 1, 5, 5);
            gis.setColor(blackPen);
            gis.drawArc(rect.x, rect.y, rect.width, rect.height, 180, 360);
            rect.y += 3;
            this.drawHandle(gis, brushColor, blackPen, rect);
        }
    }

    public void drawHandle(Graphics gis, Color brushColor, Color penColor, Rectangle handle) {
        gis.setColor(brushColor);
        gis.fillRect(handle.x, handle.y, handle.width, handle.height);
        gis.setColor(penColor);
        gis.drawRect(handle.x, handle.y, handle.width, handle.height);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean value) {
        this.locked = value;
    }

    public boolean isVisible() {
        return this.control.isVisible();
    }

    public Rectangle getClientRect() {
        Rectangle rect = this.control.getBounds();
        return rect;
    }

    public void setClientRect(Rectangle value) {
        if (this.locked) {
            return;
        }
        this.control.setBounds(value);
        ((JComponent)this.control).putClientProperty("KDLayoutConstraints", new KDLayout.Constraints(0, value));
        ((JPanel)((FormContainer)this.control).getParent()).setPreferredSize(new Dimension((int)value.getWidth() + 100, (int)value.getHeight() + 100));
        ((FormContainer)this.control).revalidate();
    }

    public void setSize(Dimension d) {
        this.setClientRect(new Rectangle(this.control.getLocation(), d));
    }
}

