/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.designer.widget;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.form.client.layout.Table.Cell;
import com.kingdee.eas.base.form.client.layout.Table.TableLayout;
import com.kingdee.eas.base.form.designer.HitResult;
import com.kingdee.eas.base.form.designer.ItemPosition;
import com.kingdee.eas.base.form.designer.OverlayWindow;
import com.kingdee.eas.base.form.designer.PropertyType;
import com.kingdee.eas.base.form.designer.command.CommandModify;
import com.kingdee.eas.base.form.designer.command.CommandRemove;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class WidgetItemBase {
    private static int currentObjectID = 0;
    public static final int SelectFocusWidth = 5;
    protected OverlayWindow overWnd;
    protected boolean supportSmartTag;
    protected boolean locked;
    private int uniqueID;
    protected Component control;
    protected String typeName;
    protected boolean autoHeight = false;

    public WidgetItemBase(OverlayWindow wnd) {
        this.overWnd = wnd;
        this.supportSmartTag = true;
        this.locked = false;
        this.uniqueID = currentObjectID++;
        this.typeName = "";
    }

    public int getHashCode() {
        return this.control.hashCode();
    }

    public Container getContainerControl() {
        return null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Component getCreateParent() {
        return this.getContainerControl();
    }

    public boolean isSelected() {
        return this.overWnd.getSelection().isItemSelected(this);
    }

    public boolean handleCreateOnItem(Object data, int createType, Rectangle rect) {
        boolean bRtv = false;
        Container parent = this.getContainerControl();
        if (parent != null) {
            rect = this.overWnd.DesignFormToParent(parent, rect);
            if (parent.getLayout() instanceof TableLayout) {
                Cell c = this.overWnd.getTableLaoutCell((TableLayout)parent.getLayout(), rect.getLocation());
                ((JComponent)parent).putClientProperty("Cell", c);
            }
            this.overWnd.getEventsProxy().firePrepareAddControl(data, rect, createType, parent);
            bRtv = true;
        }
        return bRtv;
    }

    public int getTabIndex() {
        JComponent c = (JComponent)this.control;
        if (c.getClientProperty("TabIndex") == null) {
            int index = this.overWnd.getComponentZOrder(c.getParent(), c);
            if (c.getParent() == this.overWnd.getDesignForm()) {
                index -= 2;
            }
            return index;
        }
        return Integer.parseInt(c.getClientProperty("TabIndex").toString());
    }

    public void setTabIndex(int value) {
        int oldIndex = this.getTabIndex();
        if (this.getTabIndex() == value) {
            return;
        }
        JComponent c = (JComponent)this.control;
        c.putClientProperty("TabIndex", new Integer(value));
        this.overWnd.getEventsProxy().fireComponentTabIndexChanged(c, oldIndex, value);
    }

    public String getTabPath() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (JComponent c = (JComponent)this.control; c != this.overWnd.getDesignForm() && c != null; c = (JComponent)c.getParent()) {
            WidgetItemBase item = this.overWnd.getItemFromControl(c);
            if (item == null) continue;
            list.add(new Integer(item.getTabIndex()));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = list.size() - 1; i > 0; --i) {
            sb.append(list.get(i));
            sb.append('.');
        }
        sb.append(list.get(0));
        return sb.toString();
    }

    public List getChildrenControls() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (this.control instanceof Container) {
            Component[] coms = ((Container)this.control).getComponents();
            for (int i = 0; i < coms.length; ++i) {
                if (coms[i].getName() == null) continue;
                list.add(coms[i]);
            }
        }
        return list;
    }

    public WidgetItemBase getPrevItem() {
        WidgetItemBase prevItem = null;
        int index = this.overWnd.getComponentZOrder(this.control.getParent(), this.control);
        while (index > 0 && (prevItem = this.overWnd.getItemFromControl(this.control.getParent().getComponent(--index))) == null) {
        }
        return prevItem;
    }

    public void removeControl(Container parent) {
        this.removeChildren();
        this.overWnd.getControlsMap().remove(this.control);
        parent.remove(this.control);
    }

    public void addControl(Container parent) {
        this.overWnd.setComponentParent(this.control, parent);
        this.overWnd.getControlsMap().put(this.control, this);
        this.invalidate();
    }

    protected void removeChildren() {
        List lst = this.getChildrenControls();
        for (int i = lst.size() - 1; i >= 0; --i) {
            Component c = (Component)lst.get(i);
            WidgetItemBase item = this.overWnd.getItemFromControl(c);
            if (item == null || !this.overWnd.isAddToUndo()) continue;
            CommandRemove cmd = new CommandRemove(this.overWnd, item, c.getParent());
            cmd.execute();
            if (cmd.isCanceled()) continue;
            this.overWnd.getCommandList().addCommand(cmd);
        }
    }

    public WidgetItemBase getParent() {
        WidgetItemBase item = null;
        for (Container c = this.control.getParent(); c != this.overWnd.getDesignForm() && c != null && (item = this.overWnd.getItemFromControl(c)) == null; c = c.getParent()) {
        }
        return item;
    }

    public boolean mouseDown(MouseEvent e) {
        return false;
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!this.overWnd.isLocked() && !this.getText().equalsIgnoreCase("")) {
            Rectangle bounds = this.getClientRect();
            bounds.y += this.overWnd.getBounds().y;
            if (bounds.width < 50) {
                bounds.width = 50;
            }
            KDTextField txtEdit = this.overWnd.getInplaceEdit();
            txtEdit.setBounds(bounds);
            txtEdit.putClientProperty((Object)"KDLayoutConstraints", (Object)new KDLayout.Constraints(0, bounds));
            txtEdit.setText(this.getText());
            txtEdit.setVisible(true);
            txtEdit.requestFocus();
            txtEdit.putClientProperty((Object)"EdtitItem", (Object)this);
        }
    }

    public Cursor getCursor(HitResult hr) {
        switch (hr.getValue()) {
            case 11: {
                return Cursor.getPredefinedCursor(12);
            }
            case 3: 
            case 7: {
                return Cursor.getPredefinedCursor(6);
            }
            case 4: 
            case 8: {
                return Cursor.getPredefinedCursor(9);
            }
            case 5: 
            case 9: {
                return Cursor.getPredefinedCursor(4);
            }
            case 6: 
            case 10: {
                return Cursor.getPredefinedCursor(10);
            }
            case 2: {
                return Cursor.getPredefinedCursor(13);
            }
        }
        return Cursor.getDefaultCursor();
    }

    public void onPropertyChanged(PropertyType pt, Object oldValue, Object newValue) {
        CommandModify modify = new CommandModify(this.overWnd, this);
        modify.setValue(pt, oldValue, newValue);
        modify.execute();
        this.overWnd.getCommandList().addCommand(modify);
    }

    public void invalidate() {
        Rectangle rect = this.getClientRect();
        if (!this.overWnd.getSelection().isItemSelected(this)) {
            rect.grow(1, 1);
        } else {
            rect.grow(8, 8);
            if (this.overWnd.isLocked()) {
                rect.x -= 2;
                rect.height += 2;
            }
        }
        if (this.control.getParent() != null && this.control.getParent() != this.overWnd.getDesignForm()) {
            Rectangle rc = this.control.getParent().getBounds();
            rect = rc.union(rect);
        }
        this.overWnd.repaint(rect);
    }

    public Component getControl() {
        return this.control;
    }

    public void drawDragHandleRect(Graphics g, HitResult hr, Point offset) {
        Rectangle rc = this.getDragHandleRect(hr, offset);
        g.setColor(Color.GRAY);
        g.drawRect(rc.x, rc.y, rc.width - 1, rc.height - 1);
        if (hr == HitResult.RightHandle) {
            g.drawLine(rc.x + rc.width - 1, rc.y - 100, rc.x + rc.width - 1, rc.y + rc.height + 100);
        }
        if (hr == HitResult.LeftHandle) {
            g.drawLine(rc.x, rc.y - 100, rc.x, rc.y + rc.height + 100);
        }
        if (hr == HitResult.TopHandle) {
            g.drawLine(rc.x - 100, rc.y, rc.x + rc.width + 100, rc.y);
        }
        if (hr == HitResult.BottomHandle) {
            g.drawLine(rc.x - 100, rc.y + rc.height - 1, rc.x + rc.width + 100, rc.y + rc.height - 1);
        }
    }

    public Rectangle getDragHandleRect(HitResult hr, Point offset) {
        Rectangle rect = new Rectangle();
        Rectangle ClientRect = this.getClientRect();
        if (hr == HitResult.InDragMoveHandle) {
            rect = ClientRect;
            rect.translate(offset.x, offset.y);
            return rect;
        }
        double left = ClientRect.getX();
        double top = ClientRect.getY();
        double right = left + ClientRect.getWidth();
        double bottom = top + ClientRect.getHeight();
        switch (hr.getValue()) {
            case 3: {
                left = Math.min(left + (double)offset.x, right - 5.0);
                top = Math.min(top + (double)offset.y, bottom - 5.0);
                break;
            }
            case 4: {
                top = Math.min(top + (double)offset.y, bottom - 5.0);
                break;
            }
            case 5: {
                right = Math.max(left + 5.0, right + (double)offset.x);
                top = Math.min(top + (double)offset.y, bottom - 5.0);
                break;
            }
            case 6: {
                right = Math.max(left + 5.0, right + (double)offset.x);
                break;
            }
            case 7: {
                right = Math.max(left + 5.0, right + (double)offset.x);
                bottom = Math.max(top + 5.0, bottom + (double)offset.y);
                break;
            }
            case 8: {
                bottom = Math.max(top + 5.0, bottom + (double)offset.y);
                break;
            }
            case 9: {
                left = Math.min(left + (double)offset.x, right - 5.0);
                bottom = Math.max(top + 5.0, bottom + (double)offset.y);
                break;
            }
            case 10: {
                left = Math.min(left + (double)offset.x, right - 5.0);
                break;
            }
        }
        rect.setBounds((int)left, (int)top, (int)(right - left), (int)(bottom - top));
        return rect;
    }

    public void endDrag(HitResult hr, Point offset) {
        Rectangle rect = this.getDragHandleRect(hr, offset);
        this.setClientRect(rect);
    }

    public Component endDragCopy(HitResult hr, Point offset) {
        Rectangle rect = this.getDragHandleRect(hr, offset);
        Container parent = this.overWnd.getContainerFromPoint(this.control, rect.getLocation());
        rect = this.overWnd.DesignFormToParent(parent, rect);
        return this.overWnd.getEventsProxy().firePrepareCopyControl(rect, this.control, parent);
    }

    public void drawSelect(Graphics gis) {
        this.drawSelectFrame(gis);
        Color brushColor = this == this.overWnd.getSelection().getPrimaryItem() ? Color.WHITE : Color.BLACK;
        Color penColor = this == this.overWnd.getSelection().getPrimaryItem() ? Color.BLACK : Color.WHITE;
        this.drawHandles(gis, brushColor, penColor);
    }

    protected boolean hasDragHandle() {
        return !(this.control.getParent().getLayout() instanceof TableLayout);
    }

    public HitResult hitTest(Point pt) {
        if (this.control.getParent() == null || !this.overWnd.isItemParentVisible(this.control.getParent())) {
            return HitResult.None;
        }
        WidgetItemBase item = this.overWnd.getItemFromControl(this.control.getParent());
        if (item != null && !item.getClientRect().contains(pt)) {
            return HitResult.None;
        }
        if (!this.overWnd.getSelection().isItemSelected(this)) {
            if (this.getClientRect().contains(pt)) {
                return HitResult.InDragMoveHandle;
            }
        } else {
            Rectangle bound = this.getClientRect();
            bound.grow(6, 6);
            Rectangle rc = this.getClientRect();
            if (!bound.contains(pt)) {
                return HitResult.None;
            }
            Rectangle handle = new Rectangle(this.getClientRect().x - 5, this.getClientRect().y - 5, 5, 5);
            if (this.hasDragHandle()) {
                if (handle.contains(pt)) {
                    return HitResult.TopLeftHandle;
                }
                handle.x = rc.x + rc.width / 2 - 2;
                if (handle.contains(pt)) {
                    return HitResult.TopHandle;
                }
                handle.x = rc.x + rc.width + 1;
                if (handle.contains(pt)) {
                    return HitResult.TopRightHandle;
                }
                handle.y = rc.y + rc.height / 2 - 2;
                if (handle.contains(pt)) {
                    return HitResult.RightHandle;
                }
                handle.y = rc.y + rc.height + 1;
                if (handle.contains(pt)) {
                    return HitResult.BottomRightHandle;
                }
                handle.x = rc.x + rc.width / 2 - 2;
                if (handle.contains(pt)) {
                    return HitResult.BottomHandle;
                }
                handle.x = rc.x - 5;
                if (handle.contains(pt)) {
                    return HitResult.BottomLeftHandle;
                }
                handle.y = rc.y + rc.height / 2 - 2;
                if (handle.contains(pt)) {
                    return HitResult.LeftHandle;
                }
            }
            if (rc.contains(pt)) {
                return HitResult.InDragMoveHandle;
            }
        }
        return HitResult.None;
    }

    public void drawSelectFrame(Graphics g) {
        Rectangle bound = this.getClientRect();
        g.setColor(Color.GRAY);
        g.drawRect(bound.x, bound.y, bound.width - 1, bound.height - 1);
    }

    public void drawHandles(Graphics gis, Color brushColor, Color penColor) {
        Rectangle ClientRect = this.getClientRect();
        if (!this.overWnd.isLocked() && this.hasDragHandle()) {
            Rectangle handle = new Rectangle(ClientRect.x - 5 - 1, ClientRect.y - 5 - 1, 5, 5);
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.x = ClientRect.x + ClientRect.width / 2 - 2;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.x = ClientRect.x + ClientRect.width + 1;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.y = ClientRect.y + ClientRect.height / 2 - 2;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.y = ClientRect.y + ClientRect.height + 1;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.x = ClientRect.x + ClientRect.width / 2 - 2;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.x = ClientRect.x - 5 - 1;
            this.drawHandle(gis, brushColor, penColor, handle);
            handle.y = ClientRect.y + ClientRect.height / 2 - 2;
            this.drawHandle(gis, brushColor, penColor, handle);
        } else {
            Color blackPen = Color.BLACK;
            Rectangle rect = new Rectangle(ClientRect.x + 5, ClientRect.y - 7 - 1, 5, 5);
            gis.setColor(blackPen);
            gis.drawArc(rect.x, rect.y, rect.width, rect.height, 180, 360);
            rect.y += 3;
            this.drawHandle(gis, brushColor, blackPen, rect);
        }
    }

    public void drawHandle(Graphics gis, Color brushColor, Color penColor, Rectangle handle) {
        gis.setColor(brushColor);
        gis.fillRect(handle.x, handle.y, handle.width, handle.height);
        gis.setColor(penColor);
        gis.drawRect(handle.x, handle.y, handle.width, handle.height);
    }

    public void setProperty(PropertyType pt, Object value) {
        switch (pt.getValue()) {
            case 2: {
                this.setBackColor((Color)value);
                break;
            }
            case 0: {
                ItemPosition position = (ItemPosition)value;
                Rectangle rc = position.getRect();
                this.setClientRect(rc);
                break;
            }
            case 1: {
                this.setFont((Font)value);
                break;
            }
            case 3: {
                this.setForeColor((Color)value);
                break;
            }
            case 4: {
                this.setText((String)value);
                break;
            }
        }
    }

    public boolean isLocked() {
        return this.overWnd.isLocked() || this.locked;
    }

    public void setLocked(boolean value) {
        this.locked = value;
    }

    public boolean isVisible() {
        return this.control.isVisible() && this.control.getParent().isVisible();
    }

    public int getUniqueID() {
        return this.uniqueID;
    }

    public boolean isSupportSmartTag() {
        return this.supportSmartTag;
    }

    public Rectangle getClientRect() {
        Rectangle rect = this.control.getBounds();
        if (this.control.getParent() != this.overWnd) {
            rect.y -= this.overWnd.getBounds().y;
        }
        return this.overWnd.ParentToDesignForm(this.control.getParent(), rect);
    }

    public void setClientRect(Rectangle value) {
        if (this.overWnd.isLocked()) {
            return;
        }
        Container parent = this.control.getParent();
        if (!this.getClientRect().getLocation().equals(value.getLocation())) {
            parent = this.overWnd.getContainerFromPoint(this.control, value.getLocation());
        }
        if (this.overWnd.isAddToUndo()) {
            if (this.getClientRect().equals(value)) {
                return;
            }
            this.onPropertyChanged(PropertyType.ClientRect, new ItemPosition(this.getClientRect(), this.control.getParent()), new ItemPosition(value, parent));
        } else if (this.canMove(value, this.control, parent)) {
            if (parent != this.overWnd) {
                value.y += this.overWnd.getBounds().y;
            }
            value = this.overWnd.DesignFormToParent(parent, value);
            Rectangle oldPosition = this.control.getBounds();
            this.control.setBounds(value);
            this.overWnd.setComponentParent(this.control, parent);
            if (!(this.control.getParent().getLayout() instanceof TableLayout)) {
                ((JComponent)this.control).putClientProperty("KDLayoutConstraints", new KDLayout.Constraints(0, value));
            }
            this.overWnd.getEventsProxy().fireComponentPositionChanged(this.control, parent, oldPosition);
        }
    }

    private boolean canMove(Rectangle rc, Component comp, Container parent) {
        if (parent.getLayout() instanceof TableLayout) {
            Point pt = this.overWnd.DesignFormToParent(parent, rc).getLocation();
            Cell c = this.overWnd.getTableLaoutCell((TableLayout)parent.getLayout(), pt);
            if (c == null) {
                return false;
            }
        }
        return true;
    }

    public Font getFont() {
        return this.control.getFont();
    }

    public void setFont(Font value) {
        if (this.control.getFont().equals(value) || this.overWnd.isLocked()) {
            return;
        }
        if (this.overWnd.isAddToUndo()) {
            this.onPropertyChanged(PropertyType.Font, this.control.getFont(), value);
        } else {
            this.control.setFont(value);
        }
        this.invalidate();
    }

    public Color getBackColor() {
        return this.control.getBackground();
    }

    public void setBackColor(Color value) {
        if (this.control.getBackground() == value || this.overWnd.isLocked()) {
            return;
        }
        if (this.overWnd.isAddToUndo()) {
            this.onPropertyChanged(PropertyType.BackColor, this.control.getBackground(), value);
        } else {
            this.control.setBackground(value);
        }
        this.invalidate();
    }

    public Color getForeColor() {
        return this.control.getForeground();
    }

    public void setForeColor(Color value) {
        if (this.control.getForeground() == value || this.overWnd.isLocked()) {
            return;
        }
        if (this.overWnd.isAddToUndo()) {
            this.onPropertyChanged(PropertyType.ForeColor, this.control.getForeground(), value);
        } else {
            this.control.setForeground(value);
        }
        this.invalidate();
    }

    public String getText() {
        JComponent com = (JComponent)this.control;
        if (com != null && com.getClientProperty("Text") != null) {
            return com.getClientProperty("Text").toString();
        }
        return "";
    }

    public void setText(String value) {
        JComponent com = (JComponent)this.control;
        if (com != null) {
            if (com.getClientProperty("Text").equals(value) || this.overWnd.isLocked()) {
                return;
            }
            if (this.overWnd.isAddToUndo()) {
                this.onPropertyChanged(PropertyType.Text, com.getClientProperty("Text"), value);
            } else {
                com.putClientProperty("Text", value);
            }
            this.overWnd.getEventsProxy().firecomponentTextChanged(com);
            this.invalidate();
        }
    }

    public String getBindDataInfo() {
        return this.overWnd.getEventsProxy().fireGetComponentBindinfo(this.control);
    }

    public void draw(Graphics g) {
    }
}

