/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.BarDesigner;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.form.ide.BarDesigner.DragAndDrop.DragAndDropDragGestureListener;
import com.kingdee.eas.base.form.ide.BarDesigner.DragAndDrop.DragAndDropDropTargetListener;
import com.kingdee.eas.base.form.ide.BarDesigner.TreeNodeUserData;
import com.kingdee.eas.base.form.ide.icons.ResourceManager;
import com.kingdee.eas.base.form.ide.model.ElementPropertyAdpter;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.model.ObjectProperty;
import com.kingdee.eas.base.form.ide.model.PropertyAdpterListner;
import com.kingdee.eas.base.form.ide.view.IPropertyView;
import com.kingdee.eas.base.form.ide.view.PropertyView;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.ElementType;
import com.kingdee.eas.base.form.metadata.EnumBarItemStyle;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarTemplateManager;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Assert;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BarDesignerMain
extends JDialog {
    private static final Logger _logger = CoreUIObject.getLogger(BarDesignerMain.class);
    public static final String _RESOURCE = "com.kingdee.eas.base.form.ide.res.ExtToolbarManagerResource";
    private UIContext _ctx;
    private MetaDataDesinerModel _model;
    private BarDataManager _barDataManager;
    private BarTemplateManager _barTemplateManager;
    private Locale _locale;
    private KDPanel _mainPanel;
    private KDPanel _propertyPanel;
    private KDSplitPane _splitPane_LeftRight;
    private KDTreeView _barTreeView;
    private KDTree _barTree;
    private DefaultKingdeeTreeNode _treeNode_Categories;
    private DefaultKingdeeTreeNode _treeNode_Bands;
    private IPropertyView _propertyBox;
    private boolean _isBarDataLoading = false;
    private static String _Property_Caption = "Caption";
    private static String _localeSuffix_L1 = "_L1";
    private static String _localeSuffix_L2 = "_L2";
    private static String _localeSuffix_L3 = "_L3";
    private List _keysCache = null;

    private BarDesignerMain() {
        this.jbInit();
    }

    public BarDesignerMain(Frame owner, UIContext ctx) {
        super(owner);
        Assert.that((boolean)ctx.containsKey((Object)"metadata"));
        Assert.that((boolean)ctx.containsKey((Object)"locale"));
        this._ctx = ctx;
        this._model = (MetaDataDesinerModel)ctx.get((Object)"metadata");
        this._barDataManager = this._model.getFormMetaData().getBarDataManager();
        this._barTemplateManager = this._model.getFormMetaData().getBarTemplateManager();
        this._keysCache = this._model.getFormMetaData().getBarKeysCache();
        this._locale = (Locale)ctx.get((Object)"locale");
        this.jbInit();
        try {
            this._isBarDataLoading = true;
            this.loadTemplate(this._treeNode_Categories);
            this.loadBarItems(this._barDataManager, this._treeNode_Bands, false);
        }
        finally {
            this._isBarDataLoading = false;
        }
    }

    private void jbInit() {
        this.setLocale(this._locale);
        this.setDefaultCloseOperation(2);
        this.setSize(690, 560);
        this.setLocationRelativeTo(null);
        this.setTitle(EASResource.getString((String)_RESOURCE, (String)"BarDesignerMain_Title"));
        this.getContentPane().setLayout(new BorderLayout());
        this._mainPanel = new KDPanel();
        this.getContentPane().add((Component)this._mainPanel, "Center");
        this._mainPanel.setLayout((LayoutManager)new KDLayout());
        this._mainPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 690, 560));
        this.initSplitPane();
        this.initBarTreePopmenu();
    }

    private void initTree() {
        this._barTreeView = new KDTreeView();
        this._barTreeView.setName("barTreeView");
        this._barTreeView.setShowButton(false);
        this._barTreeView.setShowControlPanel(false);
        this._barTree = new KDTree();
        this._barTree.setName("barTree");
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"bar");
        root.setUserObject((Object)new TreeNodeUserData(null, null));
        this._treeNode_Categories = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)_RESOURCE, (String)"BarDesignerMain_Category"));
        this._treeNode_Categories.setCustomIcon((Icon)ResourceManager.getImageIcon("category.gif"));
        this._treeNode_Categories.setUserObject((Object)new TreeNodeUserData(null));
        this._treeNode_Bands = new DefaultKingdeeTreeNode((Object)"Bands");
        this._treeNode_Bands.setCustomIcon((Icon)ResourceManager.getImageIcon("bands.gif"));
        this._treeNode_Bands.setUserObject((Object)new TreeNodeUserData(null, null));
        root.add((MutableTreeNode)this._treeNode_Categories);
        root.add((MutableTreeNode)this._treeNode_Bands);
        this._barTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this._barTree.updateUI();
        this._barTree.setRootVisible(false);
        this._barTree.setSelectionRow(0);
        this._barTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BarDesignerMain.this.inner_TreeSelection_valueChanged(e);
            }
        });
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)this._barTree, 1, new DragAndDropDragGestureListener());
        DropTarget dropTarget = new DropTarget((Component)this._barTree, new DragAndDropDropTargetListener(this));
        this._barTreeView.setTree(this._barTree);
    }

    private void initSplitPane() {
        this.initTree();
        this._propertyPanel = new KDPanel();
        this._propertyPanel.setName("propertyPanel");
        this._propertyPanel.setLayout((LayoutManager)new GridLayout(1, 1));
        this._propertyBox = new PropertyView();
        this._splitPane_LeftRight = new KDSplitPane(1, true, (Component)this._barTreeView, (Component)((KDPanel)this._propertyBox));
        this._splitPane_LeftRight.setName("splitPane_LeftRight");
        this._splitPane_LeftRight.setResizeWeight(0.1);
        this._splitPane_LeftRight.setBounds(new Rectangle(5, 5, 680, 540));
        this._splitPane_LeftRight.setDividerLocation(300);
        this._mainPanel.add((Component)this._splitPane_LeftRight, (Object)new KDLayout.Constraints(5, 5, 680, 540, 77));
    }

    private void initBarTreePopmenu() {
        this._barTree.setShowPopMenuDefaultItem(false);
        this._barTree.setRootVisible(true);
        this._barTree.setShowsRootHandles(true);
        this._barTree.setEditable(false);
        this._barTree.getSelectionModel().setSelectionMode(1);
        this._barTree.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                return BarDesignerMain.this.inner_BarTree_PopMenu(event);
            }
        });
    }

    private void setupPopupMenu_Categories(boolean fromTreeNode_Categories) {
        JMenuItem mnItem_NewCategory = new JMenuItem(EASResource.getString((String)_RESOURCE, (String)"BarDesignerMain_SubCategory"));
        mnItem_NewCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarSubCategory);
            }
        });
        this._barTree.getPopupMenu().add(mnItem_NewCategory);
        this._barTree.getPopupMenu().addSeparator();
        if (!fromTreeNode_Categories) {
            this.setupPopupMenu_Blands(true);
            this._barTree.getPopupMenu().addSeparator();
            JMenuItem mnItem_Delete = new JMenuItem("\u5220\u9664");
            mnItem_Delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    BarDesignerMain.this.inner_PopupMenu_SubCategories_Delete_actionPerformed(event);
                }
            });
            this._barTree.getPopupMenu().add(mnItem_Delete);
        }
    }

    private void setupPopupMenu_Blands(final boolean isCategory) {
        JMenuItem mnItem_MenuBar = new JMenuItem("\u4e3b\u83dc\u5355");
        mnItem_MenuBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.MainMenu);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.MainMenu);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_MenuBar);
        JMenuItem mnItem_ToolBar = new JMenuItem("\u5de5\u5177\u680f");
        mnItem_ToolBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.ToolBar);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.ToolBar);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_ToolBar);
        JMenuItem mnItem_PopupMenu = new JMenuItem("\u53f3\u952e\u83dc\u5355");
        mnItem_PopupMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.PopupMenu);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.PopupMenu);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_PopupMenu);
        JMenuItem mnItem_StatusBar = new JMenuItem("\u72b6\u6001\u680f");
        mnItem_StatusBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.StatusBar);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.StatusBar);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_StatusBar);
    }

    private void setupPopupMenu_Categories_TopBarItem(boolean showSubMenu) {
        JMenuItem mnItem_NewCategory = new JMenuItem(EASResource.getString((String)_RESOURCE, (String)"BarDesignerMain_SubCategory"));
        mnItem_NewCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarSubItem);
            }
        });
        this._barTree.getPopupMenu().add(mnItem_NewCategory);
        this._barTree.getPopupMenu().addSeparator();
        this.setupPopupMenu_Blands_TopBarItem(showSubMenu, true);
    }

    private void setupPopupMenu_Blands_TopBarItem(boolean showSubMenu, final boolean isCategory) {
        if (showSubMenu) {
            JMenuItem mnItem_SubBar = new JMenuItem("\u5b50\u83dc\u5355");
            mnItem_SubBar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (isCategory) {
                        BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarSubItem);
                    } else {
                        BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.BarSubItem);
                    }
                }
            });
            this._barTree.getPopupMenu().add(mnItem_SubBar);
        }
        JMenuItem mnItem_Separator = new JMenuItem("\u5206\u9694\u7b26");
        mnItem_Separator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.Seperator);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.Seperator);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_Separator);
        this._barTree.getPopupMenu().addSeparator();
        JMenuItem mnItem_Button = new JMenuItem("\u6309\u94ae");
        mnItem_Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarButtonItem);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.BarButtonItem);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_Button);
        JMenuItem mnItem_Check = new JMenuItem("\u590d\u9009\u6846");
        mnItem_Check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarCheckItem);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.BarCheckItem);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_Check);
        JMenuItem mnItem_Combox = new JMenuItem("\u4e0b\u62c9\u6846");
        mnItem_Combox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarComboxItem);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.BarComboxItem);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_Combox);
        JMenuItem mnItem_DropDownButton = new JMenuItem("\u4e0b\u62c9\u6309\u94ae");
        mnItem_DropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarDropDownButtonItem);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.BarDropDownButtonItem);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_DropDownButton);
        JMenuItem mnItem_SubDropDownButton = new JMenuItem("\u5b50\u4e0b\u62c9\u6309\u94ae");
        mnItem_SubDropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarSubDropDownButtonItem);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.BarSubDropDownButtonItem);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_SubDropDownButton);
        JMenuItem mnItem_TextField = new JMenuItem("\u6587\u672c\u6846");
        mnItem_TextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_actionPerformed(event, EnumBarItemStyle.BarTextFieldItem);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_actionPerformed(event, EnumBarItemStyle.BarTextFieldItem);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_TextField);
        this._barTree.getPopupMenu().addSeparator();
        JMenuItem mnItem_Delete = new JMenuItem("\u5220\u9664");
        mnItem_Delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (isCategory) {
                    BarDesignerMain.this.inner_PopupMenu_Categories_Delete_actionPerformed(event);
                } else {
                    BarDesignerMain.this.inner_PopupMenu_Blands_Delete_actionPerformed(event);
                }
            }
        });
        this._barTree.getPopupMenu().add(mnItem_Delete);
    }

    private void setupPopupMenu_Categories_Item() {
        JMenuItem mnItem_Delete = new JMenuItem("\u5220\u9664");
        mnItem_Delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BarDesignerMain.this.inner_PopupMenu_Categories_Delete_actionPerformed(event);
            }
        });
        this._barTree.getPopupMenu().add(mnItem_Delete);
    }

    private void setupPopupMenu_Blands_Item() {
        JMenuItem mnItem_Delete = new JMenuItem("\u5220\u9664");
        mnItem_Delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BarDesignerMain.this.inner_PopupMenu_Blands_Delete_actionPerformed(event);
            }
        });
        this._barTree.getPopupMenu().add(mnItem_Delete);
    }

    private BarItem genDefaultBarItem(BarDataManager barDataManager, DefaultKingdeeTreeNode parentNode, BarItem parentBarItem, EnumBarItemStyle style, boolean isCategory) {
        if (this._isBarDataLoading) {
            return null;
        }
        BarItem barItem = null;
        String barNameStr = this.genBarNameStr(parentNode, parentBarItem, style);
        int barSeq = this.genBarSeq(parentNode, parentBarItem);
        switch (style.getValue()) {
            case 7: {
                barItem = barDataManager.addSubItem(barNameStr, "\u4e3b\u83dc\u5355", "MainMenu", "\u4e3b\u83dc\u55ae", EnumBarItemStyle.MainMenu, true, true, 2000, barSeq);
                break;
            }
            case 12: {
                barItem = barDataManager.addSubItem(barNameStr, "\u5de5\u5177\u6761", "ToolBar", "\u5de5\u5177\u689d", EnumBarItemStyle.ToolBar, true, true, 2001, barSeq);
                break;
            }
            case 9: {
                barItem = barDataManager.addSubItem(barNameStr, "\u53f3\u952e\u83dc\u5355", "PopupMenu", "\u53f3\u9375\u83dc\u55ae", EnumBarItemStyle.PopupMenu, true, true, 2002, barSeq);
                break;
            }
            case 10: {
                barItem = barDataManager.addSubItem(barNameStr, "\u72b6\u6001\u680f", "StatusBar", "\u72c0\u614b\u6b04", EnumBarItemStyle.StatusBar, true, true, 2003, barSeq);
                break;
            }
            case 1: {
                barItem = barDataManager.addSubItem(barNameStr, "\u5b50\u83dc\u5355", "SubItem", "\u5b50\u83dc\u5355", EnumBarItemStyle.BarSubItem, true, true, 2015, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
            case 11: {
                barItem = barDataManager.addBarItem(barNameStr, "\u5206\u9694\u7b26", "Seperator", "\u5206\u9694\u7b26", "", "", "", EnumBarItemStyle.Seperator, "", "", true, true, false, true, 2004, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
            case 0: {
                barItem = barDataManager.addBarItem(barNameStr, "\u6309\u94ae", "Button", "\u6309\u9215", "", "", "", EnumBarItemStyle.BarButtonItem, "", "", true, true, false, true, 2005, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
            case 2: {
                barItem = barDataManager.addBarItem(barNameStr, "\u590d\u9009\u6846", "Check", "\u590d\u9009\u6846", "", "", "", "", "", "", EnumBarItemStyle.BarCheckItem, "", "", true, true, true, true, 2006, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
            case 3: {
                barItem = barDataManager.addBarItem(barNameStr, "\u4e0b\u62c9\u6846", "Combox", "\u4e0b\u62c9\u6846", "", "", "", EnumBarItemStyle.BarComboxItem, "", "", true, true, false, true, 2007, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
            case 4: {
                barItem = barDataManager.addBarItem(barNameStr, "\u4e0b\u62c9\u6309\u94ae", "DropDownButton", "\u4e0b\u62c9\u6309\u94ae", "", "", "", EnumBarItemStyle.BarDropDownButtonItem, "", "", true, true, false, true, 2008, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
            case 5: {
                barItem = barDataManager.addBarItem(barNameStr, "\u5b50\u4e0b\u62c9\u6309\u94ae", "SubDropDownButton", "\u5b50\u4e0b\u62c9\u6309\u94ae", "", "", "", EnumBarItemStyle.BarSubDropDownButtonItem, "", "", true, true, false, true, 2009, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
            case 6: {
                barItem = barDataManager.addBarItem(barNameStr, "\u6587\u672c\u6846", "TextField", "\u6587\u672c\u6846", "", "", "", EnumBarItemStyle.BarTextFieldItem, "", "", true, true, false, true, 2010, barSeq);
                if (parentBarItem == null) break;
                barDataManager.addBarItemLink(parentBarItem.getName(), barItem.getName());
                break;
            }
        }
        return barItem;
    }

    private BarItem genSubCategoryItem(DefaultKingdeeTreeNode parentNode, BarItem parentBarItem) {
        if (this._isBarDataLoading) {
            return null;
        }
        BarItem barItem = null;
        String barNameStr = this.genBarNameStr(parentNode, parentBarItem, EnumBarItemStyle.BarSubCategory);
        int barSeq = this.genBarSeq(parentNode, parentBarItem);
        barItem = this._barTemplateManager.addSubCategory(barNameStr, "\u5b50\u5206\u7c7b", "SubCategory", "\u5b50\u5206\u985e", "\u5b50\u5206\u7c7b", "SubCategory", "\u5b50\u5206\u985e", 2016, barSeq);
        if (parentBarItem != null) {
            this._barTemplateManager.addSubCategoryLink(parentBarItem.getName(), barItem.getName());
        }
        return barItem;
    }

    private String genBarNamePrefix(EnumBarItemStyle style) {
        String barNameStr = null;
        switch (style.getValue()) {
            case 7: {
                barNameStr = "MainMenu";
                break;
            }
            case 12: {
                barNameStr = "ToolBar";
                break;
            }
            case 9: {
                barNameStr = "PopupMenu";
                break;
            }
            case 10: {
                barNameStr = "StatusBar";
                break;
            }
            case 1: {
                barNameStr = "SubMenu";
                break;
            }
            case 13: {
                barNameStr = "SubCategory";
                break;
            }
            case 11: {
                barNameStr = "Seperator";
                break;
            }
            case 0: {
                barNameStr = "tbButton";
                break;
            }
            case 2: {
                barNameStr = "tbCheck";
                break;
            }
            case 3: {
                barNameStr = "tbCombox";
                break;
            }
            case 4: {
                barNameStr = "tbDropDownButton";
                break;
            }
            case 5: {
                barNameStr = "tbDropDownButton";
                break;
            }
            case 6: {
                barNameStr = "tbTextField";
                break;
            }
        }
        return barNameStr;
    }

    private String genBarNameStr(DefaultKingdeeTreeNode parentNode, BarItem parentBarItem, EnumBarItemStyle style) {
        String barNameStr = null;
        barNameStr = this.genBarNamePrefix(style);
        if (parentBarItem != null) {
            int i = 0;
            String barName = barNameStr;
            while (parentBarItem.getName().compareTo(barName) == 0 || parentBarItem.containChild(barName) || this._keysCache.contains(barName)) {
                barName = barNameStr + "_" + ++i;
            }
            barNameStr = barName;
        } else {
            int i = 0;
            String barName = barNameStr;
            while (this._keysCache.contains(barName)) {
                barName = barNameStr + "_" + ++i;
            }
            barNameStr = barName;
        }
        return barNameStr;
    }

    private int genBarSeq(DefaultKingdeeTreeNode parentNode, BarItem parentBarItem) {
        int iSeq = 0;
        if (parentBarItem != null) {
            for (int i = 0; i < parentBarItem.getChildrenSize(); ++i) {
                BarItem item = (BarItem)parentBarItem.getChildren().get(i);
                if (item.getSeq() <= iSeq) continue;
                iSeq = item.getSeq();
            }
            ++iSeq;
        } else {
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                BarItem item;
                TreeNodeUserData data = (TreeNodeUserData)((DefaultKingdeeTreeNode)parentNode.getChildAt(i)).getUserObject();
                if (data == null || (item = data.getBarItem()) == null || item.getSeq() <= iSeq) continue;
                iSeq = item.getSeq();
            }
            ++iSeq;
        }
        return iSeq;
    }

    private DefaultKingdeeTreeNode addTreeNodeWithUserData(EnumBarItemStyle style, DefaultKingdeeTreeNode parentNode, BarItem barItem, boolean isCategory, BarDataManager refBarDataManager) {
        DefaultKingdeeTreeNode newNode = null;
        TreeNodeUserData userData = null;
        BarDataManager barDataManager = null;
        Icon icon = null;
        BarItem parentBarItem = null;
        boolean isTopBar = false;
        int ibarLevel = 0;
        barDataManager = refBarDataManager;
        TreeNodeUserData parentData = null;
        if (parentNode.getUserObject() != null && parentNode.getUserObject() instanceof TreeNodeUserData) {
            parentData = (TreeNodeUserData)parentNode.getUserObject();
            parentBarItem = parentData.getBarItem();
            if (barDataManager == null) {
                barDataManager = parentData.getRefBarDataManager();
            }
        }
        if (barDataManager == null) {
            return null;
        }
        if (barItem == null) {
            barItem = this.genDefaultBarItem(barDataManager, parentNode, parentBarItem, style, isCategory);
        }
        switch (style.getValue()) {
            case 1: {
                if (isCategory) {
                    icon = parentNode.getCustomIcon();
                    break;
                }
                icon = ResourceManager.getImageIcon("subMenu.gif");
                break;
            }
            case 7: {
                icon = ResourceManager.getImageIcon("menuBar.gif");
                isTopBar = true;
                ibarLevel = 1;
                break;
            }
            case 12: {
                icon = ResourceManager.getImageIcon("toolbar.gif");
                isTopBar = true;
                ibarLevel = 1;
                break;
            }
            case 9: {
                icon = ResourceManager.getImageIcon("popupMenu.gif");
                isTopBar = true;
                ibarLevel = 1;
                break;
            }
            case 10: {
                icon = ResourceManager.getImageIcon("statusBar.gif");
                isTopBar = true;
                ibarLevel = 1;
                break;
            }
            case 11: {
                icon = ResourceManager.getImageIcon("seperator.gif");
                ibarLevel = 2;
                break;
            }
            case 0: {
                icon = ResourceManager.getImageIcon("button.gif");
                ibarLevel = 2;
                break;
            }
            case 2: {
                icon = ResourceManager.getImageIcon("tbtn_close.gif");
                ibarLevel = 2;
                break;
            }
            case 3: {
                icon = ResourceManager.getImageIcon("combox.gif");
                ibarLevel = 2;
                break;
            }
            case 4: {
                icon = ResourceManager.getImageIcon("dropDownButton.gif");
                ibarLevel = 2;
                break;
            }
            case 5: {
                icon = ResourceManager.getImageIcon("range_selector.gif");
                ibarLevel = 2;
                break;
            }
            case 6: {
                icon = ResourceManager.getImageIcon("textField.gif");
                ibarLevel = 2;
                break;
            }
        }
        String caption = null;
        caption = this._locale.equals(Locale.SIMPLIFIED_CHINESE) ? barItem.getCaption_L2() : (this._locale.equals(Locale.TRADITIONAL_CHINESE) ? barItem.getCaption_L3() : barItem.getCaption_L1());
        newNode = new DefaultKingdeeTreeNode((Object)caption);
        if (isCategory && barItem.getTemplateName() == null) {
            if (parentData != null && parentData.isSubCategory()) {
                barItem.setTemplateName(parentBarItem.getName());
            } else if (parentBarItem != null) {
                barItem.setTemplateName(parentBarItem.getTemplateName());
            }
        }
        userData = new TreeNodeUserData(barItem, barDataManager);
        userData.setBarLevel(ibarLevel);
        userData.setIsTemplate(isCategory);
        newNode.setUserObject((Object)userData);
        newNode.setCustomIcon(icon);
        this._barTree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, parentNode.getChildCount());
        return newNode;
    }

    private DefaultKingdeeTreeNode addTreeNodeWithUserData_SubCategory(DefaultKingdeeTreeNode parentNode, BarItem barItem) {
        DefaultKingdeeTreeNode newNode = null;
        TreeNodeUserData userDate = null;
        Icon icon = null;
        BarItem parentBarItem = null;
        if (parentNode.getUserObject() != null && parentNode.getUserObject() instanceof TreeNodeUserData) {
            TreeNodeUserData data = (TreeNodeUserData)parentNode.getUserObject();
            parentBarItem = data.getBarItem();
        }
        if (barItem == null) {
            barItem = this.genSubCategoryItem(parentNode, parentBarItem);
        }
        icon = parentNode != null ? parentNode.getCustomIcon() : ResourceManager.getImageIcon("category.gif");
        String caption = null;
        caption = this._locale.equals(Locale.SIMPLIFIED_CHINESE) ? barItem.getCaption_L2() : (this._locale.equals(Locale.TRADITIONAL_CHINESE) ? barItem.getCaption_L3() : barItem.getCaption_L1());
        newNode = new DefaultKingdeeTreeNode((Object)caption);
        userDate = new TreeNodeUserData(barItem);
        userDate.setIsSubCategory(true);
        newNode.setUserObject((Object)userDate);
        newNode.setCustomIcon(icon);
        this._barTree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, parentNode.getChildCount());
        return newNode;
    }

    public boolean CopyTreeNode(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode sourceNode) {
        boolean ret = false;
        DefaultKingdeeTreeNode addedNode = null;
        if (parentNode == null || sourceNode == null) {
            return false;
        }
        TreeNodeUserData sourceNodeData = null;
        BarItem sourceBarItem = null;
        if (sourceNode.getUserObject() != null && sourceNode.getUserObject() instanceof TreeNodeUserData) {
            sourceNodeData = (TreeNodeUserData)sourceNode.getUserObject();
        }
        if (sourceNodeData == null) {
            return false;
        }
        sourceBarItem = sourceNodeData.getBarItem();
        if (sourceBarItem == null) {
            return false;
        }
        TreeNodeUserData targetNodeData = null;
        BarItem targetBarItem = null;
        if (parentNode.getUserObject() != null && parentNode.getUserObject() instanceof TreeNodeUserData) {
            targetNodeData = (TreeNodeUserData)parentNode.getUserObject();
        }
        if (targetNodeData == null) {
            return false;
        }
        targetBarItem = targetNodeData.getBarItem();
        if (sourceBarItem == null) {
            return false;
        }
        BarItem barItem = null;
        addedNode = this.addTreeNodeWithUserData(sourceBarItem.getStyle(), parentNode, null, false, this._barDataManager);
        if (addedNode.getUserObject() != null && addedNode.getUserObject() instanceof TreeNodeUserData) {
            TreeNodeUserData addedNodeData = (TreeNodeUserData)addedNode.getUserObject();
            barItem = addedNodeData.getBarItem();
        }
        if (barItem == null) {
            return false;
        }
        this.CopyBarItemProp(sourceBarItem, barItem);
        boolean bl = ret = addedNode != null;
        if (sourceNode.getChildCount() > 0) {
            for (int i = 0; i < sourceNode.getChildCount(); ++i) {
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)sourceNode.getChildAt(i);
                ret = this.CopyTreeNode(addedNode, subNode);
            }
        }
        return ret;
    }

    private void CopyBarItemProp(BarItem srcItem, BarItem targetItem) {
        targetItem.setCaption_L1(srcItem.getCaption_L1());
        targetItem.setCaption_L2(srcItem.getCaption_L2());
        targetItem.setCaption_L3(srcItem.getCaption_L3());
        targetItem.setCaption(srcItem.getCaption());
        targetItem.setDescription_L1(srcItem.getDescription_L1());
        targetItem.setDescription_L2(srcItem.getDescription_L2());
        targetItem.setDescription_L3(srcItem.getDescription_L3());
        targetItem.setToolTip_L1(srcItem.getToolTip_L1());
        targetItem.setToolTip_L2(srcItem.getToolTip_L2());
        targetItem.setToolTip_L3(srcItem.getToolTip_L3());
        targetItem.setImageKey(srcItem.getImageKey());
        targetItem.setShortcut(srcItem.getShortcut());
        targetItem.setEnabled(srcItem.getEnabled());
        targetItem.setVisible(srcItem.getVisible());
        targetItem.setChecked(srcItem.getChecked());
        targetItem.setBeginGroup(srcItem.isBeginGroup());
        targetItem.setElementType(srcItem.getElementType());
        ArrayList clickActions = srcItem.getClickActions();
        if (clickActions != null) {
            targetItem.setClickActions((ArrayList)clickActions.clone());
        }
        targetItem.setShowDescOnToolbar(srcItem.isShowDescOnToolbar());
    }

    private boolean inner_BarTree_PopMenu(TreePopupMenuEvent event) {
        this._barTree.getPopupMenu().removeAll();
        TreePath path = this._barTree.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null || node.getUserObject() == null || !(node.getUserObject() instanceof TreeNodeUserData)) {
            return false;
        }
        BarItem barItem = ((TreeNodeUserData)node.getUserObject()).getBarItem();
        boolean isCategory = node.equals(this._treeNode_Categories);
        DefaultKingdeeTreeNode pNode = (DefaultKingdeeTreeNode)node.getParent();
        boolean bl = isCategory = pNode != null && pNode.equals(this._treeNode_Categories);
        while (!isCategory && pNode != null && !pNode.equals(this._treeNode_Categories)) {
            if ((pNode = (DefaultKingdeeTreeNode)pNode.getParent()) == null || !pNode.equals(this._treeNode_Categories)) continue;
            isCategory = true;
        }
        if (node.equals(this._treeNode_Categories)) {
            this.setupPopupMenu_Categories(true);
        } else if (node.equals(this._treeNode_Bands)) {
            this.setupPopupMenu_Blands(false);
        } else if (barItem != null) {
            switch (barItem.getStyle().getValue()) {
                case 1: 
                case 7: {
                    if (isCategory) {
                        this.setupPopupMenu_Categories_TopBarItem(true);
                        break;
                    }
                    this.setupPopupMenu_Blands_TopBarItem(true, isCategory);
                    break;
                }
                case 9: 
                case 10: 
                case 12: {
                    if (isCategory) {
                        this.setupPopupMenu_Categories_TopBarItem(false);
                        break;
                    }
                    this.setupPopupMenu_Blands_TopBarItem(false, isCategory);
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    if (isCategory) {
                        this.setupPopupMenu_Categories_Item();
                        break;
                    }
                    this.setupPopupMenu_Blands_Item();
                    break;
                }
                case 13: {
                    this.setupPopupMenu_Categories(false);
                    break;
                }
            }
        }
        return true;
    }

    public void inner_PopupMenu_Categories_actionPerformed(ActionEvent event, EnumBarItemStyle style) {
        TreePath path = this._barTree.getSelectionPath();
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (parentNode == null) {
            return;
        }
        DefaultKingdeeTreeNode newNode = null;
        if (style == EnumBarItemStyle.BarSubCategory) {
            newNode = this.addTreeNodeWithUserData_SubCategory(parentNode, null);
        } else if (parentNode.getUserObject() != null && parentNode.getUserObject() instanceof TreeNodeUserData) {
            TreeNodeUserData data = (TreeNodeUserData)parentNode.getUserObject();
            BarItem parentBarItem = data.getBarItem();
            if (parentBarItem == null) {
                return;
            }
            BarDataManager barDataManager = null;
            if (data.getRefBarDataManager() != null) {
                barDataManager = data.getRefBarDataManager();
            }
            if (data.isSubCategory() && barDataManager == null) {
                barDataManager = this._barTemplateManager.getBarDataManagerOfSubCategory(parentBarItem);
            }
            newNode = this.addTreeNodeWithUserData(style, parentNode, null, true, barDataManager);
        }
        if (newNode != null) {
            this._barTree.setSelectionNode(newNode);
        }
    }

    public void inner_PopupMenu_Blands_actionPerformed(ActionEvent event, EnumBarItemStyle style) {
        TreePath path = this._barTree.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        DefaultKingdeeTreeNode newNode = this.addTreeNodeWithUserData(style, node, null, false, this._barDataManager);
        this._barTree.setSelectionNode(newNode);
    }

    public void inner_PopupMenu_Blands_Delete_actionPerformed(ActionEvent event) {
        String message = EASResource.getString((String)_RESOURCE, (String)"BarDesignerMain_DeleteConfirm");
        if (MsgBox.showConfirm2(null, (String)message) == 0) {
            TreePath path = this._barTree.getSelectionPath();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            TreeNodeUserData data = (TreeNodeUserData)node.getUserObject();
            BarItem barItem = data.getBarItem();
            BarDataManager barManager = data.getRefBarDataManager();
            if (barItem != null && barManager != null) {
                barManager.RemoveBarItem(barItem);
            }
            if (node.getChildCount() > 0) {
                this._barTree.removeAllChildrenFromParent((MutableTreeNode)node);
            }
            this._barTree.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public void inner_PopupMenu_Categories_Delete_actionPerformed(ActionEvent event) {
        String message = EASResource.getString((String)_RESOURCE, (String)"BarDesignerMain_DeleteConfirm");
        if (MsgBox.showConfirm2(null, (String)message) == 0) {
            TreePath path = this._barTree.getSelectionPath();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            TreeNodeUserData data = (TreeNodeUserData)node.getUserObject();
            BarItem barItem = data.getBarItem();
            BarDataManager barManager = data.getRefBarDataManager();
            if (barItem != null && barManager != null) {
                barManager.RemoveBarItem(barItem);
            }
            if (node.getChildCount() > 0) {
                this._barTree.removeAllChildrenFromParent((MutableTreeNode)node);
            }
            this._barTree.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public void inner_PopupMenu_SubCategories_Delete_actionPerformed(ActionEvent event) {
        String message = EASResource.getString((String)_RESOURCE, (String)"BarDesignerMain_DeleteConfirm");
        if (MsgBox.showConfirm2(null, (String)message) == 0) {
            TreePath path = this._barTree.getSelectionPath();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            TreeNodeUserData data = (TreeNodeUserData)node.getUserObject();
            BarItem barItem = data.getBarItem();
            if (barItem != null) {
                this._barTemplateManager.RemoveSubCategory(barItem);
            }
            if (node.getChildCount() > 0) {
                this._barTree.removeAllChildrenFromParent((MutableTreeNode)node);
            }
            this._barTree.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public void inner_PropertyAdpterListner_propertyChanged(ObjectProperty prop, Object newValue, Object oldValue) {
        if (prop.getName().compareTo(this.getPropertyCaptionName()) == 0) {
            if (newValue == null || newValue.equals(oldValue)) {
                return;
            }
            TreePath path = this._barTree.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            String newCaption = newValue == null ? "" : newValue.toString();
            this._barTree.setNodeText(node, newCaption);
        }
    }

    private void inner_TreeSelection_valueChanged(TreeSelectionEvent e) {
        TreePath path = this._barTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null || node.getUserObject() == null || !(node.getUserObject() instanceof TreeNodeUserData) || ((TreeNodeUserData)node.getUserObject()).getBarItem() == null) {
            this._propertyBox.clearObjectList();
            return;
        }
        BarItem barItem = ((TreeNodeUserData)node.getUserObject()).getBarItem();
        ElementType et = this._model.getElementType(barItem.getElementType());
        if (et == null) {
            return;
        }
        ElementPropertyAdpter elAdpter = new ElementPropertyAdpter(et, (Appearance)barItem, null, this._model);
        if (elAdpter == null) {
            return;
        }
        elAdpter.addPropertyAdpterListner(new PropertyAdpterListner(){

            @Override
            public void filterProperty(ObjectProperty prop) {
            }

            @Override
            public void propertyChanged(ObjectProperty prop, Object newValue, Object oldValue) {
                BarDesignerMain.this.inner_PropertyAdpterListner_propertyChanged(prop, newValue, oldValue);
            }

            @Override
            public void propertyChanging(ObjectProperty prop, Object newValue, Object oldValue) {
            }
        });
        this._propertyBox.selectObject(elAdpter);
    }

    private void loadTemplate(DefaultKingdeeTreeNode parentNode) {
        if (this._barTemplateManager == null) {
            return;
        }
        List topCategories = this._barTemplateManager.getTopCategories();
        for (int i = 0; i < topCategories.size(); ++i) {
            BarItem item = (BarItem)topCategories.get(i);
            DefaultKingdeeTreeNode node = this.addTreeNodeWithUserData_SubCategory(parentNode, item);
            this.loadCetegory(item, node);
        }
    }

    private void loadBarItems(BarDataManager barDataManager, DefaultKingdeeTreeNode parentNode, boolean isCategory) {
        Map topItems = barDataManager.getTopLevelBarItems();
        for (Map.Entry entry : topItems.entrySet()) {
            BarItem item = (BarItem)entry.getValue();
            this.loadBarFromTopLevel(barDataManager, parentNode, item, isCategory);
        }
    }

    private void loadCetegory(BarItem barItem, DefaultKingdeeTreeNode node) {
        if (barItem == null) {
            return;
        }
        if (barItem.getBarDataManagerOfSubCategory() != null) {
            this.loadBarItems(barItem.getBarDataManagerOfSubCategory(), node, true);
        }
        DefaultKingdeeTreeNode subNode = null;
        List children = barItem.getChildren();
        Collections.sort(children, new intComparator());
        for (BarItem item : children) {
            subNode = this.addTreeNodeWithUserData_SubCategory(node, item);
            if (item.getBarDataManagerOfSubCategory() != null) {
                this.loadBarItems(item.getBarDataManagerOfSubCategory(), subNode, true);
            }
            if (item.getChildrenSize() <= 0) continue;
            this.loadCetegory(item, subNode);
        }
    }

    private void loadBarFromTopLevel(BarDataManager barDataManager, DefaultKingdeeTreeNode parentNode, BarItem topBarItem, boolean isCategory) {
        if (topBarItem == null) {
            return;
        }
        parentNode = this.addTreeNodeWithUserData(topBarItem.getStyle(), parentNode, topBarItem, isCategory, barDataManager);
        switch (topBarItem.getStyle().getValue()) {
            case 7: {
                this.loadBar(barDataManager, topBarItem, parentNode, isCategory);
                break;
            }
            case 12: {
                this.loadBar(barDataManager, topBarItem, parentNode, isCategory);
                break;
            }
            case 9: {
                this.loadBar(barDataManager, topBarItem, parentNode, isCategory);
                break;
            }
            case 10: {
                this.loadBar(barDataManager, topBarItem, parentNode, isCategory);
                break;
            }
        }
    }

    private void loadBar(BarDataManager barDataManager, BarItem barItem, DefaultKingdeeTreeNode parentNode, boolean isCategory) {
        if (barItem == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        List children = barItem.getChildren();
        Collections.sort(children, new intComparator());
        for (BarItem item : children) {
            node = this.addTreeNodeWithUserData(item.getStyle(), parentNode, item, isCategory, barDataManager);
            if (item.getChildrenSize() <= 0) continue;
            this.loadBar(barDataManager, item, node, isCategory);
        }
    }

    private void ensureSaveEditing() {
        this._propertyBox.commitCurrentPropEditing();
    }

    private String getPropertyCaptionName() {
        String str = _Property_Caption;
        str = this._locale.equals(Locale.SIMPLIFIED_CHINESE) ? str + _localeSuffix_L2 : (this._locale.equals(Locale.TRADITIONAL_CHINESE) ? str + _localeSuffix_L3 : str + _localeSuffix_L1);
        return str;
    }

    public class intComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int i2;
            int i1 = ((BarItem)o1).getSeq();
            if (i1 > (i2 = ((BarItem)o2).getSeq())) {
                return 1;
            }
            if (i1 == i2) {
                return 0;
            }
            return -1;
        }
    }
}

