/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide.BarDesigner.DragAndDrop;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.base.form.ide.BarDesigner.BarDesignerMain;
import com.kingdee.eas.base.form.ide.BarDesigner.DragAndDrop.DragAndDropTransferable;
import com.kingdee.eas.base.form.ide.BarDesigner.TreeNodeUserData;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DragAndDropDropTargetListener
implements DropTargetListener {
    private BarDesignerMain mainUI;

    public DragAndDropDropTargetListener(BarDesignerMain mainUI) {
        this.mainUI = mainUI;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable transfer = e.getTransferable();
        DefaultKingdeeTreeNode dragSource = null;
        Map NodeUserDataMaping = null;
        if (transfer.isDataFlavorSupported(DragAndDropTransferable.TREENODE_FLAVOR)) {
            try {
                e.acceptDrop(2);
                dragSource = (DefaultKingdeeTreeNode)transfer.getTransferData(DragAndDropTransferable.TREENODE_FLAVOR);
                NodeUserDataMaping = (Map)transfer.getTransferData(DragAndDropTransferable.TREENODE_UserData_FLAVOR);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (dragSource == null || NodeUserDataMaping == null) {
            e.dropComplete(false);
            return;
        }
        this.FixupUserData(dragSource, NodeUserDataMaping);
        DropTarget dt = (DropTarget)e.getSource();
        Component comp = dt.getComponent();
        if (!(comp instanceof KDTree)) {
            e.dropComplete(false);
            return;
        }
        KDTree jtr = (KDTree)comp;
        TreePath treePath = jtr.getPathForLocation(e.getLocation().x, e.getLocation().y);
        if (treePath == null) {
            e.dropComplete(false);
            return;
        }
        DefaultKingdeeTreeNode dropTreeNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
        if (!this.isCanDrop(dragSource, dropTreeNode, jtr)) {
            e.dropComplete(false);
            return;
        }
        if (this.mainUI.CopyTreeNode(dropTreeNode, dragSource)) {
            ((DefaultTreeModel)jtr.getModel()).reload((TreeNode)dropTreeNode);
            e.dropComplete(true);
        } else {
            e.dropComplete(false);
        }
    }

    public boolean isCanDrop(DefaultKingdeeTreeNode dragTreeNode, DefaultKingdeeTreeNode dropTreeNode, KDTree jtr) {
        String subDragPath;
        if (dragTreeNode == null) {
            return false;
        }
        if (dropTreeNode == null) {
            return false;
        }
        if (dragTreeNode == dropTreeNode) {
            return false;
        }
        TreePath dragPath = new TreePath(((DefaultTreeModel)jtr.getModel()).getPathToRoot((TreeNode)dragTreeNode));
        TreePath dropPath = new TreePath(((DefaultTreeModel)jtr.getModel()).getPathToRoot((TreeNode)dropTreeNode));
        String strDragPath = dragPath.toString();
        String strDropPath = dropPath.toString();
        if (strDropPath.startsWith(subDragPath = strDragPath.substring(0, strDragPath.length() - 1))) {
            return false;
        }
        if (dragPath.getParentPath().toString().equals(strDropPath)) {
            return false;
        }
        if (dragTreeNode.getParent().equals(dropTreeNode)) {
            return false;
        }
        TreeNodeUserData dragSourceData = null;
        if (dragTreeNode.getUserObject() != null && dragTreeNode.getUserObject() instanceof TreeNodeUserData) {
            dragSourceData = (TreeNodeUserData)dragTreeNode.getUserObject();
        }
        if (dragSourceData == null) {
            return false;
        }
        TreeNodeUserData dropNodeData = null;
        if (dropTreeNode.getUserObject() != null && dropTreeNode.getUserObject() instanceof TreeNodeUserData) {
            dropNodeData = (TreeNodeUserData)dropTreeNode.getUserObject();
        }
        if (dropNodeData == null) {
            return false;
        }
        if (dragSourceData.getBarLevel() != dropNodeData.getBarLevel() + 1) {
            return false;
        }
        return !dropNodeData.isTemplate();
    }

    private void FixupUserData(DefaultKingdeeTreeNode treeNode, Map NodeUserDataMaping) {
        TreeNodeUserData data = (TreeNodeUserData)NodeUserDataMaping.get(treeNode.getParent().toString() + "_" + treeNode.toString());
        if (data != null) {
            treeNode.setUserObject((Object)data);
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
            this.FixupUserData(node, NodeUserDataMaping);
        }
    }
}

