/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.KDSlider;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.MemoryInspector;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ExtStatusBarManager
implements FacadeManager.IErrorMessageBox {
    public static final String KEY_MEM_STATUS = "memStatus";
    private static final BigDecimal BD = new BigDecimal("100000000000");
    private KDStatusBar statusBar;
    private KDSlider _sdScale;
    private boolean _syncing;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, ExtStatusBarManager.class, (String)defaultStr);
    }

    private SimpleStatusBarPart createStatusPart_State(KDStatusBar statusBar) {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setPreferredSize(new Dimension(300, 30));
        part.setHgrap(0);
        SimpleStatusBarRenderer render = new SimpleStatusBarRenderer();
        part.addRenderer((ISimpleStatusBarRenderer)render, (Object)"state");
        return part;
    }

    SimpleStatusBarPart createStatusPart_Scale(KDStatusBar statusBar) {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setPreferredSize(new Dimension(250, 30));
        part.setHgrap(0);
        this._sdScale = new KDSlider(1, 16, 4);
        this._sdScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ExtStatusBarManager.this._syncing) {
                    KDSlider s = (KDSlider)e.getSource();
                    int n = s.getValue() / 4;
                }
            }
        });
        String str = MultiLanguageKeys.getLocalText((String)"KEY_SCALE");
        SimpleStatusBarRenderer render = new SimpleStatusBarRenderer((JComponent)this._sdScale, str);
        render.getComponent(statusBar).setToolTipText(str);
        part.addRenderer((ISimpleStatusBarRenderer)render, (Object)"scale");
        return part;
    }

    SimpleStatusBarPart createStatusPart_Sum(KDStatusBar statusBar) {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setPreferredSize(new Dimension(124, 30));
        part.setHgrap(0);
        SimpleStatusBarRenderer render1 = new SimpleStatusBarRenderer();
        render1.getComponent(statusBar).setToolTipText(MultiLanguageKeys.getLocalText((String)"KEY_SUM"));
        part.addRenderer((ISimpleStatusBarRenderer)render1, (Object)"sum");
        return part;
    }

    private SimpleStatusBarPart createStatusPart_Memory(KDStatusBar statusBar) {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setPreferredSize(new Dimension(500, 30));
        part.setHgrap(0);
        String str = ExtStatusBarManager.getLocalText(KEY_MEM_STATUS, "\u5185\u5b58\u72b6\u6001");
        SimpleStatusBarRenderer render1 = new SimpleStatusBarRenderer((JComponent)new MemoryInspector(0L, 1000000), str);
        render1.getComponent(statusBar).setToolTipText(str);
        part.addRenderer((ISimpleStatusBarRenderer)render1, (Object)"memory");
        return part;
    }

    private KDStatusBar createDefaultStatusBar() {
        this.statusBar = new KDStatusBar();
        this.statusBar.addPart(this.createStatusPart_State(this.statusBar));
        return this.statusBar;
    }

    public KDStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = this.createDefaultStatusBar();
        }
        return this.statusBar;
    }

    void sync() {
        boolean hasNum = false;
        BigDecimal bd = BigDecimal.valueOf(0L);
        if (hasNum) {
            String str = bd.compareTo(BD) >= 0 ? Formats.getFormat((String)"#.00E#").format(new Variant((Object)bd), false).toString() : bd.toString();
            this.getStatusBar().getPart(2).setRendererText(MultiLanguageKeys.getLocalText((String)"KEY_SUM") + "=" + str, 0);
        } else {
            this.getStatusBar().getPart(2).setRendererText("", 0);
        }
        this.getStatusBar().getPart(2).repaint();
    }

    public void syncState() {
    }

    public boolean show(Component parent, String title, String msg, int msgType) {
        final JLabel barLabel = (JLabel)this.getStatusBar().getPart(0).getRenderer(0).getComponent(this.getStatusBar());
        final Color bg = msgType == 2 ? Color.yellow : Color.red;
        barLabel.setText(msg);
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 3; ++i) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setBackground(bg);
                                barLabel.setOpaque(true);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setOpaque(false);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        return true;
    }
}

