/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.ide;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidPathException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.core.PrintHelper;
import com.kingdee.eas.base.form.designer.listenner.CommandListChangedListener;
import com.kingdee.eas.base.form.extend.menu.client.FormSchemeListUI;
import com.kingdee.eas.base.form.ide.BarDesigner.BarDesignerMain;
import com.kingdee.eas.base.form.ide.FormPermission;
import com.kingdee.eas.base.form.ide.MainUI;
import com.kingdee.eas.base.form.ide.SQLScriptFactory;
import com.kingdee.eas.base.form.ide.client.DeployFlowUI;
import com.kingdee.eas.base.form.ide.client.DeployPublishUI;
import com.kingdee.eas.base.form.ide.client.DeploySchemeListUI;
import com.kingdee.eas.base.form.ide.client.DeployWizardUI;
import com.kingdee.eas.base.form.ide.client.FormCreateWizardUI;
import com.kingdee.eas.base.form.ide.client.FormExportDataUI;
import com.kingdee.eas.base.form.ide.client.FormImportDataUI;
import com.kingdee.eas.base.form.ide.client.IpSetUI;
import com.kingdee.eas.base.form.ide.client.ListFieldIndexSetUI;
import com.kingdee.eas.base.form.ide.client.util.IdeUtil;
import com.kingdee.eas.base.form.ide.designer.OperationConstant;
import com.kingdee.eas.base.form.ide.exception.FormIdeException;
import com.kingdee.eas.base.form.ide.icons.ResourceManager;
import com.kingdee.eas.base.form.ide.model.MetaDataDesinerModel;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.form.ide.view.DesignerView;
import com.kingdee.eas.base.form.ide.view.IDesignerContent;
import com.kingdee.eas.base.form.ide.view.IDesignerView;
import com.kingdee.eas.base.form.ide.workbench.persist.WorkbenchPersistence;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.SubSystem;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExtToolbarManager
implements CommandListChangedListener {
    public static final String RESOURCE = "com.kingdee.eas.base.form.ide.res.ExtToolbarManagerResource";
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.ide.ExtToolbarManager");
    private MainUI _ext;
    private KDToolBar toolbar;
    public static final int EXT_SAVE = 0;
    public static final int EXT_SAVE_AS = 1;
    public static final int EXT_SAVE_All = 2;
    public static final int EXT_CLOSE = 4;
    public static final int EXT_QUIT = 3;
    public static final int EXT_NEW = 5;
    public static final int EXT_TRIM_MANAGE = 6;
    public static final int EXT_DELETE_ELEMENT = 8;
    public static final int EXT_UNDO = 9;
    public static final int EXT_REDO = 10;
    public static final int EXT_ALIGN_LEFT = 11;
    public static final int EXT_ALIGN_RIGHT = 12;
    public static final int EXT_ALIGN_BOTTOM = 13;
    public static final int EXT_ALIGN_TOP = 14;
    public static final int EXT_ALIGN_CENTER = 15;
    public static final int EXT_ALIGN_MIDDLE = 16;
    public static final int EXT_HORI_SAME_LENTH = 17;
    public static final int EXT_ADD_HORI_LENTH = 18;
    public static final int EXT_REDUCE_HORI_LENTH = 19;
    public static final int EXT_VERTI_SAME_LENTH = 20;
    public static final int EXT_ADD_VERTI_LENTH = 21;
    public static final int EXT_REDUCE_VERTI_LENTH = 22;
    public static final int EXT_SAME_WIDTH = 23;
    public static final int EXT_SAME_HEIGHT = 24;
    public static final int EXT_SAME_WIDTH_AND_HEIGHT = 25;
    public static final int EXT_SAME_LABLE_WIDTH = 26;
    public static final int EXT_LAY_TOP = 27;
    public static final int EXT_LAY_BOTTOM = 28;
    public static final int EXT_LOCK = 29;
    public static final int EXT_TAB_SEQ = 30;
    public static final int EXT_LISTTAB_SEQ = 31;
    public static final int EXT_QKQUERYTAB_SEQ = 32;
    public static final int EXT_BARDESIGNER = 33;
    public static final int EXT_MENUSETTING = 34;
    public static final int EXT_RELOGIN = 100;
    public static final int EXT_CREATEPRINTMETA = 110;
    public static final int EXT_CREATE_APPROVE_PRINTMETA = 111;
    public static final int EXT_CREATE_SEALCTRL_PRINTMETA = 112;
    public static final int EXT_LISTFIELDINDEX = 120;
    public static final int EXT_AUTO_TAB_SEQ = 121;
    public static final int EXT_SQL_OUTER = 130;
    public static final int EXT_SELECT_SUBSYS = 140;
    public static final int EXT_DEPLOY_FLOW = 150;
    public static final int EXT_PREVIEW = 151;
    public static final int EXT_DEPLOY_WIZARD = 155;
    public static final int EXT_DEPLOY_SCHEMELIST = 156;
    public static final int EXT_DEPLOY_PUBLISH = 157;
    public static final int EXT_COLUMN_LAYOUT = 160;
    public static final int EXT_ISSUE_SQL = 170;
    public static final int EXT_IMPORT_DATA = 180;
    public static final int EXT_EXPORT_DATA = 181;
    private Action saveAction;
    private Action saveAsAction;
    private Action closeAction;
    private Action quitAction;
    private Action newAction;
    private Action trimManageAction;
    private Action saveAllAction;
    private Action deleteElementAction;
    private Action undoAction;
    private Action redoAction;
    private Action alignLeftAction;
    private Action alignRightAction;
    private Action alignBottomAction;
    private Action alignTopAction;
    private Action alignCenterAction;
    private Action alignMiddleAction;
    private Action horiSameLenthAction;
    private Action addHoriLenthAction;
    private Action reduceHoriLenthAction;
    private Action vertiSameLenthAction;
    private Action addVertiLenthAction;
    private Action reduceVertiLenthAction;
    private Action sameWidthAction;
    private Action sameHeightAction;
    private Action sameWidthAndHeightAction;
    private Action sameLableWidthAction;
    private Action layTopAction;
    private Action layBottomAction;
    private Action lockAction;
    private Action tabSeqAction;
    private Action listTabSeqAction;
    private Action qkQueryTabSeqAction;
    private Action barDesignerAction;
    private Action createPrintMetaAction;
    private Action createApprovePrintMetaAction;
    private Action createSealCtrlPrintMetaAction;
    private Action sqloutAction;
    private Action subsysSelectAction;
    private Action deployFlowAction;
    private Action deployWizardAction;
    private Action deploySchemeListAction;
    private Action deployPublishAction;
    private Action columnLayoutAction;
    private Action autoTabSeqAction;
    private Action previewAction;
    private Action menuSettingAction;
    private Action issueSqlAction;
    private Action importDataAction;
    private Action exportDataAction;
    public static String ip = null;
    public static String port = null;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, ExtToolbarManager.class, (String)defaultStr);
    }

    public ExtToolbarManager(MainUI ext) {
        this._ext = ext;
        this.initItems();
        this.initToolbarAction();
    }

    private void initAction(AbstractAction act, String resItemName) {
        String name = EASResource.getString((String)RESOURCE, (String)resItemName);
        act.putValue("Name", name);
        act.putValue("ShortDescription", name);
        act.putValue("LongDescription", name);
    }

    private void initItems() {
        this.initSaveAction();
        this.initSaveAsAction();
        this.initSaveAllAction();
        this.initUndoAndRedoAction();
        this.initCloseAction();
        this.initQuitAction();
        this.initNewAction();
        this.initDeleteElementAction();
        this.initAlignAction();
        this.initLayBottomAction();
        this.initLockAction();
        this.initTabSeqAction();
        this.initListTabSeqAction();
        this.initQkQueryTabSeqAction();
        this.initBarDesignerAction();
        this.initTrimManageAction();
        this.initCreatePrintMetaAction();
        this.initCreateApprovePrintMetaAction();
        this.initCreateSealCtrlPrintMetaAction();
        this.initSqloutAction();
        this.initSubsysSelectAction();
        this.initDeployFlowAction();
        this.initDeployWizardAction();
        this.initDeploySchemeListAction();
        this.initDeployPublishAction();
        this.initColumnLayoutAction();
        this.initAutoTabSeqAction();
        this.initPreviewAction();
        this.initMenuSettingAction();
        this.initIssueSqlAction();
        this.initImportAction();
        this.initExportAction();
    }

    private void initExportAction() {
        this.exportDataAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionExportData.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String bos_type;
                String className = FormExportDataUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                IDesignerView designView = ExtToolbarManager.this._ext.getDesignerView();
                MetaDataDesinerModel model = designView.getContent().getModel();
                if (model != null && !EntityObjectInfoHelp.isDynamicEntity(bos_type = model.getBusinessInfo().getEntity(0).getBosType())) {
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u4e0d\u80fd\u5bfc\u51fa\u5f15\u7528BIM\u521b\u5efa\u5b9e\u4f53\u7684\u5355\u636e\u6216\u5355\u636e\u7684\u5b9e\u4f53\u4e0d\u5b58\u5728");
                    return;
                }
                IUIWindow uiWindow = null;
                uiContext.put((Object)"model", (Object)model);
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
                catch (Exception e1) {
                    logger.error((Object)("\u6253\u5f00\u5355\u636e\u5bfc\u51faUI\u9519\u8bef\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
            }
        };
    }

    private void initImportAction() {
        this.importDataAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionImportData.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDFileChooser chooser = new KDFileChooser(System.getProperty("User.dir"));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String name = f.getName();
                        return name.matches(".*\\.(?i)zip$");
                    }

                    @Override
                    public String getDescription() {
                        return "\u538b\u7f29\u6587\u4ef6(.zip)";
                    }
                });
                int returnVal = chooser.showOpenDialog((Component)((Object)ExtToolbarManager.this._ext));
                if (returnVal == 0) {
                    String import_file_name = chooser.getSelectedFile().getPath();
                    String className = FormImportDataUI.class.getName();
                    UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                    uiContext.put((Object)"import_file_name", (Object)import_file_name);
                    IUIWindow uiWindow = null;
                    try {
                        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                        FormImportDataUI ui = (FormImportDataUI)uiWindow.getUIObject();
                        if (!ui.hasDataError()) {
                            uiWindow.show();
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)("\u6253\u5f00\u5355\u636e\u5bfc\u5165UI\u9519\u8bef\uff1a" + e1));
                        IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                        SysUtil.abort();
                    }
                }
            }
        };
    }

    private void initMenuSettingAction() {
        this.menuSettingAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "menuSetting.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_laytop.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = FormSchemeListUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.EDIT);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
            }
        };
    }

    public static boolean isConnected(String url) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("HEAD");
            int stateCode = con.getResponseCode();
            System.out.println("State Code:" + stateCode);
            if (stateCode < 500) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
            return false;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
        return false;
    }

    private void initPreviewAction() {
        this.previewAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionPreview.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_preview2.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaDataDesinerModel model = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel();
                String formid = model.getFormID();
                if (StringUtils.isEmpty((String)formid)) {
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff01");
                    return;
                }
                String url = "http://" + ip + ":" + port + "/easweb/servlet/BillServlet?formID=" + URLEncoder.encode(formid) + "&status=VIEWTEMPLATE";
                if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)port) || !ExtToolbarManager.isConnected(url)) {
                    String className = IpSetUI.class.getName();
                    UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                    uiContext.put((Object)"ip", (Object)ip);
                    uiContext.put((Object)"port", (Object)port);
                    uiContext.put((Object)"formId", (Object)formid);
                    IUIWindow uiWindow = null;
                    try {
                        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                    }
                    catch (Exception e1) {
                        logger.error((Object)("dyn bill designer\uff1a" + e1));
                        IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                        SysUtil.abort();
                    }
                    ip = ((IpSetUI)uiWindow.getUIObject()).getIp();
                    port = ((IpSetUI)uiWindow.getUIObject()).getPort();
                }
                if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)port)) {
                    return;
                }
                try {
                    url = "cmd /c start http:\"//" + ip + ":" + port + "/easweb/servlet/BillServlet?formID=" + URLEncoder.encode(formid) + "&status=VIEWTEMPLATE\"";
                    Runtime.getRuntime().exec(url);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        };
    }

    private void initAutoTabSeqAction() {
        this.autoTabSeqAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAutoTabSeq.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_autoarrange.gif"));
                this.putValue("ActionCommandKey", OperationConstant.OP_AUTO_TAB_SEQ);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this._ext.getDesignerView().getContent().getToolBarOperation().autoIndex();
            }
        };
    }

    private void initColumnLayoutAction() {
        this.columnLayoutAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionColumnLayout.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_singlecolumn.gif"));
                this.putValue("ActionCommandKey", OperationConstant.OP_MAKE_GRID);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
    }

    private void initAlignAction() {
        this.alignLeftAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAlignLeft.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_left.gif"));
                this.putValue("ActionCommandKey", "OP_ALIGN_LEFT");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.alignRightAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAlignRight.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_right.gif"));
                this.putValue("ActionCommandKey", "OP_ALIGN_RIGHT");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.alignBottomAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAlignBottom.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_bottom.gif"));
                this.putValue("ActionCommandKey", "OP_ALIGN_BOTTOM");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.alignTopAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAlignTop.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_top.gif"));
                this.putValue("ActionCommandKey", "OP_ALIGN_TOP");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.alignCenterAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAlignCenter.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_zxcenter.gif"));
                this.putValue("ActionCommandKey", "OP_ALIGN_CENTER");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.alignMiddleAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAlignMiddle.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_hxcenter.gif"));
                this.putValue("ActionCommandKey", "OP_ALIGN_MIDDLE");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.horiSameLenthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionHoriSameLenth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_hxspace.gif"));
                this.putValue("ActionCommandKey", "OP_HORI_SAME_LENTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.addHoriLenthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAddHoriLenth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_addhxspace.gif"));
                this.putValue("ActionCommandKey", "OP_ADD_HORI_LENTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.reduceHoriLenthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionReduceHoriLenth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_dechxspace.gif"));
                this.putValue("ActionCommandKey", "OP_REDUCE_HORI_LENTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.vertiSameLenthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionVertiSameLenth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_zxspace.gif"));
                this.putValue("ActionCommandKey", "OP_VERTI_SAME_LENTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.addVertiLenthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionAddVertiLenth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_addzxspace.gif"));
                this.putValue("ActionCommandKey", "OP_ADD_VERTI_LENTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.reduceVertiLenthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionReduceVertiLenth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_deczxspace.gif"));
                this.putValue("ActionCommandKey", "OP_REDUCE_VERTI_LENTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.sameWidthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSameWidth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_width.gif"));
                this.putValue("ActionCommandKey", "OP_SAME_WIDTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.sameHeightAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSameHeight.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_hight.gif"));
                this.putValue("ActionCommandKey", "OP_SAME_HEIGHT");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.sameWidthAndHeightAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSameWidthAndHeight.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_dx.gif"));
                this.putValue("ActionCommandKey", "OP_SAME_WIDTH_AND_HEIGHT");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.sameLableWidthAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSameLableWidth.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_lablewidth.gif"));
                this.putValue("ActionCommandKey", "OP_SAME_LABLE_WIDTH");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.layTopAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionLayTop.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_laytop.gif"));
                this.putValue("ActionCommandKey", "OP_LAY_TOP");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
    }

    private void initDeleteElementAction() {
        this.deleteElementAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionDeleteElement.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Delete.gif"));
                this.putValue("ActionCommandKey", "OP_DELETE_ELEMENT");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl d"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
    }

    private void initNewAction() {
        this.newAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionNew.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_New.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SubSystem sys;
                PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
                if (person == null) {
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u60a8\u4e0d\u662f\u804c\u5458\u7528\u6237\uff0c\u4e0d\u80fd\u521b\u5efa\u5355\u636e\uff01");
                    SysUtil.abort();
                }
                if ((sys = ExtToolbarManager.this._ext.getSolutionView().getCurrentSubsys()) == null) {
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u8bf7\u9009\u62e9\u5b50\u7cfb\u7edf\uff01");
                    SysUtil.abort();
                }
                String className = FormCreateWizardUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                uiContext.put((Object)"subsysid", (Object)sys.getId());
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
            }
        };
    }

    private void initQuitAction() {
        this.quitAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionQuit.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_quit.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = EASResource.getString((String)ExtToolbarManager.RESOURCE, (String)"confirmQuit");
                if (MsgBox.showConfirm2((Component)((Object)ExtToolbarManager.this._ext), (String)message) == 0) {
                    ExtToolbarManager.this._ext.close();
                }
            }
        };
    }

    private void initCloseAction() {
        this.closeAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionClose.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_close.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = EASResource.getString((String)ExtToolbarManager.RESOURCE, (String)"confirmClose");
                if (MsgBox.showConfirm2((Component)((Object)ExtToolbarManager.this._ext), (String)message) == 0) {
                    ExtToolbarManager.this._ext.getDesignerView().close();
                }
            }
        };
    }

    private void initSaveAsAction() {
        this.saveAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExtToolbarManager.this._ext == null) {
                    return;
                }
                try {
                    ExtToolbarManager.this._ext.getPropertyBox().commitCurrentPropEditing();
                    ExtToolbarManager.this._ext.getDesignerView().getContent().save();
                    ExtToolbarManager.this._ext.getDesignerView().clearCurrentContentCommandList();
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
                }
            }
        };
    }

    private void initUndoAndRedoAction() {
        this.undoAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionUndo.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_undo.gif"));
                this.setEnabled(false);
                this.putValue("ActionCommandKey", "OP_UNDO");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
        this.redoAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionRedo.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_redo.gif"));
                this.setEnabled(false);
                this.putValue("ActionCommandKey", "OP_REDO");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
    }

    private void initDeployFlowAction() {
        this.deployFlowAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionDeployFlow.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_saveall.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = DeployFlowUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                MetaDataDesinerModel model = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel();
                if (model == null || StringUtils.isEmpty((String)model.getFormID())) {
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u6a21\u677f\u4fe1\u606f\uff01");
                    return;
                }
                String no_edit_msg = "\u60a8\u6ca1\u6709\u90e8\u7f72\u5355\u636e\u7684\u6743\u9650\uff01";
                FormPermission.FormPermisoionType perm_type = FormPermission.newInstance().getCurrentUserFormPermission(model.getFormID());
                if (!perm_type.canEditable()) {
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)no_edit_msg);
                    return;
                }
                uiContext.put((Object)"metadata", (Object)model);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
            }
        };
    }

    private void initDeployWizardAction() {
        this.deployWizardAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionDeployWizard.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_saveall.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = DeployWizardUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
            }
        };
    }

    private void initDeploySchemeListAction() {
        this.deploySchemeListAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionDeploySchemeList.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_saveall.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = DeploySchemeListUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
            }
        };
    }

    private void initDeployPublishAction() {
        this.deployPublishAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionDeployPublish.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_saveall.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = DeployPublishUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
            }
        };
    }

    private void initSaveAllAction() {
        this.saveAllAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSaveAll.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_saveall.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExtToolbarManager.this._ext.getDesignerView() instanceof DesignerView) {
                    Map map = ((DesignerView)ExtToolbarManager.this._ext.getDesignerView()).getCacheContentMap();
                    for (Object key : map.keySet()) {
                        IDesignerContent content = (IDesignerContent)map.get(key);
                        try {
                            if (content == null || 2 != MetaDataFactory.getFormEditOrHide(null, (String)content.getModel().getFormID())) continue;
                            MsgBox.showWarning((String)(content.getTitle() + "\u662f\u7cfb\u7edf\u5185\u7f6e\u5355\u636e\uff0c\u4e0d\u80fd\u4fdd\u5b58\u4fee\u6539\uff01"));
                            return;
                        }
                        catch (BOSException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                if (ExtToolbarManager.this._ext.getDesignerView() != null) {
                    ExtToolbarManager.this._ext.getPropertyBox().commitCurrentPropEditing();
                    ExtToolbarManager.this._ext.getDesignerView().saveAll();
                    ExtToolbarManager.this._ext.getDesignerView().clearAllContentCommandList();
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u4fdd\u5b58\u6240\u6709\u6210\u529f\uff01");
                }
            }
        };
    }

    private void initSaveAction() {
        this.saveAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSave.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Save.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExtToolbarManager.this._ext == null) {
                    return;
                }
                MetaDataDesinerModel model = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel();
                try {
                    model.checkFormPermission();
                }
                catch (FormIdeException ex) {
                    MsgBox.showError((String)ex.getMessage());
                    return;
                }
                try {
                    String formId = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel().getFormID();
                    int formEditable = MetaDataFactory.getFormEditOrHide(null, (String)formId);
                    if (2 == formEditable) {
                        MsgBox.showWarning((String)"\u6b64\u5355\u636e\u662f\u7cfb\u7edf\u5185\u7f6e\u5355\u636e\uff0c\u4e0d\u80fd\u4fdd\u5b58\u4fee\u6539\uff01");
                        return;
                    }
                    ExtToolbarManager.this._ext.getPropertyBox().commitCurrentPropEditing();
                    ExtToolbarManager.this._ext.getDesignerView().getContent().save();
                    ExtToolbarManager.this._ext.getDesignerView().clearCurrentContentCommandList();
                    String[] sqls = ExtToolbarManager.this._ext.getEntityView().getIssueSqls();
                    SQLScriptFactory.exeSqls(null, sqls);
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    String ExMsg = e1.getMessage();
                    if (e1 instanceof InvocationTargetException && ExMsg == null) {
                        ExMsg = ((InvocationTargetException)e1).getTargetException().getMessage();
                    }
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    MsgBox.showDetailAndOK(null, (String)"\u4fdd\u5b58\u5931\u8d25", (String)ExMsg, (int)0);
                }
            }
        };
    }

    private void initIssueSqlAction() {
        this.issueSqlAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionIssueSql.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExtToolbarManager.this._ext == null) {
                    return;
                }
                try {
                    String[] sqls = ExtToolbarManager.this._ext.getEntityView().getIssueSqls();
                    SQLScriptFactory.exeSqls(null, sqls);
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u53d1\u5e03\u6210\u529f\uff01");
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)EASResource.getString((String)ExtToolbarManager.RESOURCE, (String)"saveErrMsg"));
                }
            }
        };
    }

    private void initLayBottomAction() {
        this.layBottomAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionLayBottom.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_laybottom.gif"));
                this.putValue("ActionCommandKey", "OP_LAY_BOTTOM");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
    }

    private void initLockAction() {
        this.lockAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionLock.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_lock.gif"));
                this.putValue("ActionCommandKey", "OP_LOCK");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
    }

    private void initTabSeqAction() {
        this.tabSeqAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionTabSeq.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
                this.putValue("ActionCommandKey", "OP_TAB_SEQ");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this.doOperation(e);
            }
        };
    }

    private void initTrimManageAction() {
        this.trimManageAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionTrimManage.name");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkbenchPersistence.getSharedInstance().showTrimList(ExtToolbarManager.this._ext.getPerspective());
            }
        };
    }

    private void initCreatePrintMetaAction() {
        this.createPrintMetaAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionCreatePrintMeta.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutInfo layoutInfo = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel().getFormMetaData().getLayoutInfo("_Default");
                BusinessInfo businessInfo = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel().getFormMetaData().getBusinessInfo();
                Form form = businessInfo.getForm();
                if (StringUtils.isEmpty((String)form.getTemplatePath())) {
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u5957\u6253\u6a21\u677f\u8def\u5f84\uff01");
                    SysUtil.abort();
                }
                String entityKey = "";
                for (Appearance ap : layoutInfo.getControls()) {
                    if (ap == null || !(ap instanceof EntityAppearance)) continue;
                    entityKey = entityKey + ap.getKey() + ".";
                }
                if (entityKey.length() > 0) {
                    entityKey = entityKey.substring(0, entityKey.length() - 1);
                }
                String fullPath = PathUtil.makeChildPath((String)form.getTemplatePath(), (String)(entityKey + ".bos-query"));
                try {
                    PrintHelper printHelper = new PrintHelper(businessInfo, layoutInfo, fullPath, layoutInfo.getCaption());
                    printHelper.writeToPrintMeta();
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u521b\u5efa\u6210\u529f\uff01");
                }
                catch (InvalidPathException e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + (Object)((Object)e1)));
                    MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u5957\u6253\u6a21\u677f\u8def\u5f84\uff01");
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u521b\u5efa\u5931\u8d25\uff01");
                }
            }
        };
    }

    private void initCreateApprovePrintMetaAction() {
        this.createApprovePrintMetaAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionCreateApprovePrintMeta.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutInfo layoutInfo = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel().getFormMetaData().getLayoutInfo("_Default");
                BusinessInfo businessInfo = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel().getFormMetaData().getBusinessInfo();
                Form form = businessInfo.getForm();
                try {
                    List approveTableList = layoutInfo.getMultiApproveControls();
                    if (layoutInfo == null || approveTableList.isEmpty()) {
                        String fullPath = PathUtil.makeChildPath((String)form.getTemplatePath(), (String)"MultiApprove.bos-query");
                        PrintHelper printHelper = new PrintHelper(businessInfo, layoutInfo, fullPath, layoutInfo.getCaption() + "_\u5ba1\u6279\u610f\u89c1");
                        printHelper.writeMultiApproveToPrintMeta();
                    } else {
                        for (int i = 0; i < approveTableList.size(); ++i) {
                            Appearance ap = (Appearance)approveTableList.get(i);
                            String fullPath = PathUtil.makeChildPath((String)form.getTemplatePath(), (String)("MultiApprove_" + ap.getKey() + ".bos-query"));
                            PrintHelper printHelper = new PrintHelper(businessInfo, layoutInfo, fullPath, layoutInfo.getCaption() + "_" + ap.getCaption());
                            printHelper.writeMultiApproveToPrintMeta();
                        }
                    }
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u521b\u5efa\u6210\u529f\uff01");
                }
                catch (KDRSException e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + (Object)((Object)e1)));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)((Object)e1), (String)"\u521b\u5efa\u5931\u8d25");
                }
            }
        };
    }

    private void initCreateSealCtrlPrintMetaAction() {
        this.createSealCtrlPrintMetaAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionCreateSealCtrlPrintMeta.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutInfo layoutInfo = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel().getFormMetaData().getLayoutInfo("_Default");
                BusinessInfo businessInfo = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel().getFormMetaData().getBusinessInfo();
                Form form = businessInfo.getForm();
                try {
                    List signControls = layoutInfo.getSignControls();
                    if (layoutInfo == null || signControls.isEmpty()) {
                        MsgBox.showError((Component)((Object)ExtToolbarManager.this._ext), (String)"\u6ca1\u6709\u7535\u5b50\u7b7e\u7ae0\u63a7\u4ef6\uff01");
                        return;
                    }
                    for (int i = 0; i < signControls.size(); ++i) {
                        Appearance ap = (Appearance)signControls.get(i);
                        String fullPath = PathUtil.makeChildPath((String)form.getTemplatePath(), (String)("SEALCTRL_" + ap.getKey() + ".bos-query"));
                        PrintHelper printHelper = new PrintHelper(businessInfo, layoutInfo, fullPath, layoutInfo.getCaption() + "_\u7535\u5b50\u7b7e\u7ae0_" + ap.getCaption());
                        printHelper.writeSealApproveToPrintMeta(ap.getKey());
                    }
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u521b\u5efa\u6210\u529f\uff01");
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u521b\u5efa\u5931\u8d25");
                }
            }
        };
    }

    private void initSubsysSelectAction() {
        this.subsysSelectAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSelectSubSystem.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtToolbarManager.this._ext.showSubsytemUI();
            }
        };
    }

    private void initSqloutAction() {
        this.sqloutAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionSqlout.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List billIds = ExtToolbarManager.this._ext.getDesignerView().getSelectedBills();
                if (billIds == null || billIds.isEmpty()) {
                    MsgBox.showWarning((Component)((Object)ExtToolbarManager.this._ext), (String)"\u8bf7\u5728\u5b50\u7cfb\u7edf\u7a97\u53e3\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u8bbe\u8ba1\u5355\u636e\uff01");
                    return;
                }
                String filePath = "c:\\tmp";
                String insertFileName = filePath + "\\sql.txt";
                String caption = "\u811a\u672c";
                String formid = null;
                try {
                    File f = new File(filePath);
                    File f1 = new File(insertFileName);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    if (!f1.exists()) {
                        f1.createNewFile();
                    }
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f1), "utf-8"));
                    PrintWriter fw = new PrintWriter((Writer)writer, false);
                    fw.write("/**Begin \u52a8\u6001Form\u5143\u6570\u636e\u811a\u672c\uff0c\u540d\u79f0 :" + caption + " **/");
                    for (int i = 0; i < billIds.size(); ++i) {
                        formid = billIds.get(i).toString();
                        this.out(formid, fw);
                        fw.println("\n\n");
                    }
                    ((Writer)writer).close();
                    fw.close();
                    MsgBox.showInfo((Component)((Object)ExtToolbarManager.this._ext), (String)"\u811a\u672c\u5df2\u5bfc\u51fa\u5230c:\\tmp\\sql.txt\uff01");
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u5bfc\u51fa\u811a\u672c\u5931\u8d25\uff01");
                }
            }

            private void out(String formid, PrintWriter fw) throws BOSException {
                String filter = "FID='" + formid + "'";
                String sql = SQLScriptFactory.getSQLScript(null, "T_BAS_Form", filter, "", "T_BAS_Form", "*", null);
                fw.println(sql);
                filter = "FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormEntity", filter, "FSEQ", "T_BAS_FormEntity", "*", null);
                fw.println(sql);
                filter = "FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormField", filter, "", "T_BAS_FormField", "*", null);
                fw.println(sql);
                filter = "FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormLayout", filter, "", "T_BAS_FormLayout", "*", null);
                fw.println(sql);
                filter = "FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormLayoutEntity", filter, "", "T_BAS_FormLayoutEntity", "*", null);
                fw.println(sql);
                filter = "FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormLayoutField", filter, "", "T_BAS_FormLayoutField", "*", null);
                fw.println(sql);
                filter = "FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormLayoutCtrl", filter, "", "T_BAS_FormLayoutCtrl", "*", null);
                fw.println(sql);
                filter = "FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormLayoutTabPage", filter, "", "T_BAS_FormLayoutTabPage", "*", null);
                fw.println(sql);
                filter = "FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormContainerLayout", filter, "", "T_BAS_FormContainerLayout", "*", null);
                fw.println(sql);
                filter = "FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormTableLayoutStyle", filter, "", "T_BAS_FormTableLayoutStyle", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormOperation", filter, "", "T_BAS_FormOperation", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormActionList", filter, "", "T_BAS_FormActionList", "*", null);
                fw.println(sql);
                filter = " FParentId in ( select fid from T_BAS_FormActionList where FFormID='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FCEntry", filter, "", "T_BAS_FCEntry", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormMenu", filter, "", "T_BAS_FormMenu", "*", null);
                fw.println(sql);
                filter = " fid in  ( select fmenuid from t_bas_formmenu where fformid='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormMenuScheme", filter, "", "T_BAS_FormMenuScheme", "*", null);
                fw.println(sql);
                filter = " FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_BarItem", filter, "", "T_BAS_BarItem", "*", null);
                fw.println(sql);
                filter = " FMenuId in ( select FMenuId from T_BAS_FormMenu where fformid='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_BarItemLink", filter, "", "T_BAS_BarItemLink", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormPlugin", filter, "", "T_BAS_FormPlugin", "*", null);
                fw.println(sql);
                filter = " fsubsysid in  ( select fsubsysid from t_bas_form where fid = '" + formid + "')  and fisdefault!=1 ";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormSubsystem", filter, "", "T_BAS_FormSubsystem", "*", null);
                fw.println(sql);
                filter = " ftopclassid in ( select ftopclassid from  t_bas_formsubsystem where fsubsysid in  ( select fsubsysid from t_bas_form where fid = '" + formid + "')  ) and fisdefault!=1 ";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormTopClass", filter, "", "T_BAS_FormTopClass", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormExtProperty", filter, "", "T_BAS_FormExtProperty", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormEventPm", filter, "", "T_BAS_FormEventPm", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FormCondition", filter, "", "T_BAS_FormCondition", "*", null);
                fw.println(sql);
                filter = " FParentId in ( select fid from T_BAS_FormCondition where FFormID='" + formid + "')";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_FCEntry", filter, "", "T_BAS_FCEntry", "*", null);
                fw.println(sql);
                filter = " FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_BaseTableInfo", filter, "", "T_BAS_BaseTableInfo", "*", null);
                fw.println(sql);
                filter = "FFormID='" + formid + "'";
                sql = SQLScriptFactory.getSQLScript(null, "T_BAS_ComPageSet", filter, "", "T_BAS_ComPageSet", "*", null);
                fw.println(sql);
            }
        };
    }

    private void initListTabSeqAction() {
        this.listTabSeqAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionListTabSeq.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
                this.putValue("ActionCommandKey", "OP_LISTTAB_SEQ");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = ListFieldIndexSetUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                MetaDataDesinerModel model = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel();
                uiContext.put((Object)"metadata", (Object)model);
                uiContext.put((Object)"tabSetType", (Object)new Integer(1));
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
                List result = ((ListFieldIndexSetUI)uiWindow.getUIObject()).getSetedFieldList();
                if (result != null && !result.isEmpty()) {
                    for (int i = 0; i < result.size(); ++i) {
                        Field field = (Field)result.get(i);
                        model.getBusinessInfo().getField(field.getKey()).setListTabIndex(field.getListTabIndex());
                    }
                }
            }
        };
    }

    private void initQkQueryTabSeqAction() {
        this.qkQueryTabSeqAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionQkQueryTabSeq.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_movedata.gif"));
                this.putValue("ActionCommandKey", "OP_QKQUERYTAB_SEQ");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String className = ListFieldIndexSetUI.class.getName();
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                MetaDataDesinerModel model = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel();
                uiContext.put((Object)"metadata", (Object)model);
                uiContext.put((Object)"tabSetType", (Object)new Integer(2));
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext, null, OprtState.VIEW);
                }
                catch (Exception e1) {
                    logger.error((Object)("dyn bill designer\uff1a" + e1));
                    IdeUtil.showErrorMsg((Component)((Object)ExtToolbarManager.this._ext), (Exception)e1, (String)"\u51fa\u9519\u4e86\uff01");
                    SysUtil.abort();
                }
                uiWindow.show();
                List result = ((ListFieldIndexSetUI)uiWindow.getUIObject()).getSetedFieldList();
                if (result != null && !result.isEmpty()) {
                    for (int i = 0; i < result.size(); ++i) {
                        Field field = (Field)result.get(i);
                        model.getBusinessInfo().getField(field.getKey()).setQkQueryTabIndex(field.getQkQueryTabIndex());
                    }
                }
            }
        };
    }

    private void initBarDesignerAction() {
        this.barDesignerAction = new AbstractAction(){
            {
                ExtToolbarManager.this.initAction(this, "ActionBarDesigner.name");
                this.putValue("SmallIcon", ResourceManager.getImageIcon("activeBar.gif"));
                this.putValue("ActionCommandKey", "OP_BARDESIGNER");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)ExtToolbarManager.this._ext);
                MetaDataDesinerModel model = ExtToolbarManager.this._ext.getDesignerView().getContent().getModel();
                uiContext.put((Object)"metadata", (Object)model);
                uiContext.put((Object)"locale", (Object)ExtToolbarManager.this._ext.getLocale());
                Window win = ComponentUtil.getCurrentActiveWindow();
                BarDesignerMain barDesigner = win instanceof Frame ? new BarDesignerMain((Frame)win, uiContext) : new BarDesignerMain(null, uiContext);
                barDesigner.setModal(true);
                barDesigner.show();
                barDesigner.dispose();
            }
        };
    }

    public void doOperation(ActionEvent e) {
        if (this._ext.getDesignerView().getContent() != null) {
            this._ext.getDesignerView().getContent().doOperation(e.getActionCommand());
        }
    }

    public Action getAction(int type) {
        switch (type) {
            case 5: {
                return this.newAction;
            }
            case 0: {
                return this.saveAction;
            }
            case 1: {
                return this.saveAsAction;
            }
            case 2: {
                return this.saveAllAction;
            }
            case 6: {
                return this.trimManageAction;
            }
            case 8: {
                return this.deleteElementAction;
            }
            case 10: {
                return this.redoAction;
            }
            case 9: {
                return this.undoAction;
            }
            case 11: {
                return this.alignLeftAction;
            }
            case 12: {
                return this.alignRightAction;
            }
            case 13: {
                return this.alignBottomAction;
            }
            case 14: {
                return this.alignTopAction;
            }
            case 15: {
                return this.alignCenterAction;
            }
            case 16: {
                return this.alignMiddleAction;
            }
            case 17: {
                return this.horiSameLenthAction;
            }
            case 18: {
                return this.addHoriLenthAction;
            }
            case 19: {
                return this.reduceHoriLenthAction;
            }
            case 20: {
                return this.vertiSameLenthAction;
            }
            case 21: {
                return this.addVertiLenthAction;
            }
            case 22: {
                return this.reduceVertiLenthAction;
            }
            case 23: {
                return this.sameWidthAction;
            }
            case 24: {
                return this.sameHeightAction;
            }
            case 25: {
                return this.sameWidthAndHeightAction;
            }
            case 26: {
                return this.sameLableWidthAction;
            }
            case 27: {
                return this.layTopAction;
            }
            case 28: {
                return this.layBottomAction;
            }
            case 29: {
                return this.lockAction;
            }
            case 30: {
                return this.tabSeqAction;
            }
            case 121: {
                return this.autoTabSeqAction;
            }
            case 31: {
                return this.listTabSeqAction;
            }
            case 32: {
                return this.qkQueryTabSeqAction;
            }
            case 33: {
                return this.barDesignerAction;
            }
            case 4: {
                return this.closeAction;
            }
            case 3: {
                return this.quitAction;
            }
            case 110: {
                return this.createPrintMetaAction;
            }
            case 111: {
                return this.createApprovePrintMetaAction;
            }
            case 112: {
                return this.createSealCtrlPrintMetaAction;
            }
            case 130: {
                return this.sqloutAction;
            }
            case 140: {
                return this.subsysSelectAction;
            }
            case 150: {
                return this.deployFlowAction;
            }
            case 155: {
                return this.deployWizardAction;
            }
            case 156: {
                return this.deploySchemeListAction;
            }
            case 157: {
                return this.deployPublishAction;
            }
            case 160: {
                return this.columnLayoutAction;
            }
            case 151: {
                return this.previewAction;
            }
            case 34: {
                return this.menuSettingAction;
            }
            case 170: {
                return this.issueSqlAction;
            }
            case 180: {
                return this.importDataAction;
            }
            case 181: {
                return this.exportDataAction;
            }
        }
        return null;
    }

    public KDToolBar getToolBar() {
        if (this.toolbar == null) {
            this.toolbar = new KDToolBar();
            KDToolBar.setTextIconDisStyleByParent((short)2);
            this.toolbar.add(this.getAction(5));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(151));
            this.toolbar.add(this.getAction(0));
            this.toolbar.add(this.getAction(2));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(9));
            this.toolbar.add(this.getAction(10));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(8));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(11));
            this.toolbar.add(this.getAction(12));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(16));
            this.toolbar.add(this.getAction(17));
            this.toolbar.add(this.getAction(18));
            this.toolbar.add(this.getAction(19));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(13));
            this.toolbar.add(this.getAction(14));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(15));
            this.toolbar.add(this.getAction(20));
            this.toolbar.add(this.getAction(21));
            this.toolbar.add(this.getAction(22));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(23));
            this.toolbar.add(this.getAction(24));
            this.toolbar.add(this.getAction(25));
            this.toolbar.add(this.getAction(26));
            this.toolbar.add(this.getAction(160));
            this.toolbar.addSeparator();
            this.toolbar.add(this.getAction(27));
            this.toolbar.add(this.getAction(28));
            this.toolbar.add(this.getAction(29));
            this.toolbar.add(this.getAction(121));
            this.toolbar.add(this.getAction(30));
            this.toolbar.add(this.getAction(31));
            this.toolbar.add(this.getAction(32));
            this.toolbar.add(this.getAction(33));
            this.toolbar.addSeparator();
        }
        return this.toolbar;
    }

    public void setUndoRedoAction(boolean canUndo, boolean canRedo) {
        if (canUndo) {
            this.undoAction.setEnabled(true);
        } else {
            this.undoAction.setEnabled(false);
        }
        if (canRedo) {
            this.redoAction.setEnabled(true);
        } else {
            this.redoAction.setEnabled(false);
        }
    }

    public void initToolbarAction() {
        this.getAction(9).setEnabled(false);
        this.getAction(10).setEnabled(false);
        this.getAction(8).setEnabled(false);
        this.getAction(11).setEnabled(false);
        this.getAction(12).setEnabled(false);
        this.getAction(16).setEnabled(false);
        this.getAction(17).setEnabled(false);
        this.getAction(18).setEnabled(false);
        this.getAction(19).setEnabled(false);
        this.getAction(13).setEnabled(false);
        this.getAction(14).setEnabled(false);
        this.getAction(15).setEnabled(false);
        this.getAction(20).setEnabled(false);
        this.getAction(21).setEnabled(false);
        this.getAction(22).setEnabled(false);
        this.getAction(23).setEnabled(false);
        this.getAction(24).setEnabled(false);
        this.getAction(25).setEnabled(false);
        this.getAction(26).setEnabled(false);
        this.getAction(160).setEnabled(false);
        this.getAction(27).setEnabled(false);
        this.getAction(28).setEnabled(false);
        this.getAction(29).setEnabled(false);
        this.getAction(121).setEnabled(false);
        this.getAction(30).setEnabled(false);
        this.getAction(31).setEnabled(false);
        this.getAction(0).setEnabled(false);
        this.getAction(2).setEnabled(false);
        this.getAction(170).setEnabled(false);
        this.getAction(151).setEnabled(false);
        this.getAction(110).setEnabled(false);
        this.getAction(111).setEnabled(false);
        this.getAction(112).setEnabled(false);
        this.getAction(130).setEnabled(true);
        this.getAction(4).setEnabled(false);
        this.getAction(150).setEnabled(false);
        this.getAction(32).setEnabled(false);
        this.getAction(33).setEnabled(false);
    }

    public void setToolbarLocateAction(int selectedCount) {
        this.getAction(121).setEnabled(true);
        this.getAction(30).setEnabled(true);
        this.getAction(31).setEnabled(true);
        this.getAction(0).setEnabled(true);
        this.getAction(2).setEnabled(true);
        this.getAction(170).setEnabled(true);
        this.getAction(151).setEnabled(true);
        this.getAction(110).setEnabled(true);
        this.getAction(111).setEnabled(true);
        this.getAction(112).setEnabled(true);
        this.getAction(130).setEnabled(true);
        this.getAction(4).setEnabled(true);
        this.getAction(150).setEnabled(true);
        this.getAction(32).setEnabled(true);
        this.getAction(33).setEnabled(true);
        if (selectedCount <= 0) {
            this.getAction(8).setEnabled(false);
            this.getAction(11).setEnabled(false);
            this.getAction(12).setEnabled(false);
            this.getAction(16).setEnabled(false);
            this.getAction(17).setEnabled(false);
            this.getAction(18).setEnabled(false);
            this.getAction(19).setEnabled(false);
            this.getAction(13).setEnabled(false);
            this.getAction(14).setEnabled(false);
            this.getAction(15).setEnabled(false);
            this.getAction(20).setEnabled(false);
            this.getAction(21).setEnabled(false);
            this.getAction(22).setEnabled(false);
            this.getAction(23).setEnabled(false);
            this.getAction(24).setEnabled(false);
            this.getAction(25).setEnabled(false);
            this.getAction(26).setEnabled(false);
            this.getAction(160).setEnabled(false);
            this.getAction(27).setEnabled(false);
            this.getAction(28).setEnabled(false);
            this.getAction(29).setEnabled(false);
        } else if (selectedCount == 1) {
            this.getAction(8).setEnabled(true);
            this.getAction(11).setEnabled(false);
            this.getAction(12).setEnabled(false);
            this.getAction(16).setEnabled(false);
            this.getAction(17).setEnabled(false);
            this.getAction(18).setEnabled(false);
            this.getAction(19).setEnabled(false);
            this.getAction(13).setEnabled(false);
            this.getAction(14).setEnabled(false);
            this.getAction(15).setEnabled(false);
            this.getAction(20).setEnabled(false);
            this.getAction(21).setEnabled(false);
            this.getAction(22).setEnabled(false);
            this.getAction(23).setEnabled(false);
            this.getAction(24).setEnabled(false);
            this.getAction(25).setEnabled(false);
            this.getAction(26).setEnabled(false);
            this.getAction(27).setEnabled(true);
            this.getAction(28).setEnabled(true);
            this.getAction(29).setEnabled(true);
        } else {
            this.getAction(8).setEnabled(true);
            this.getAction(11).setEnabled(true);
            this.getAction(12).setEnabled(true);
            this.getAction(16).setEnabled(true);
            this.getAction(17).setEnabled(true);
            this.getAction(18).setEnabled(true);
            this.getAction(19).setEnabled(true);
            this.getAction(13).setEnabled(true);
            this.getAction(14).setEnabled(true);
            this.getAction(15).setEnabled(true);
            this.getAction(20).setEnabled(true);
            this.getAction(21).setEnabled(true);
            this.getAction(22).setEnabled(true);
            this.getAction(23).setEnabled(true);
            this.getAction(24).setEnabled(true);
            this.getAction(25).setEnabled(true);
            this.getAction(26).setEnabled(true);
            this.getAction(160).setEnabled(true);
            this.getAction(27).setEnabled(true);
            this.getAction(28).setEnabled(true);
            this.getAction(29).setEnabled(true);
        }
    }
}

